/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSValidityState.h"

#include "ActiveDOMObject.h"
#include "Element.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSNodeCustom.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsValidityStateConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsValidityState_valueMissing);
static JSC_DECLARE_CUSTOM_GETTER(jsValidityState_typeMismatch);
static JSC_DECLARE_CUSTOM_GETTER(jsValidityState_patternMismatch);
static JSC_DECLARE_CUSTOM_GETTER(jsValidityState_tooShort);
static JSC_DECLARE_CUSTOM_GETTER(jsValidityState_tooLong);
static JSC_DECLARE_CUSTOM_GETTER(jsValidityState_rangeUnderflow);
static JSC_DECLARE_CUSTOM_GETTER(jsValidityState_rangeOverflow);
static JSC_DECLARE_CUSTOM_GETTER(jsValidityState_stepMismatch);
static JSC_DECLARE_CUSTOM_GETTER(jsValidityState_badInput);
static JSC_DECLARE_CUSTOM_GETTER(jsValidityState_customError);
static JSC_DECLARE_CUSTOM_GETTER(jsValidityState_valid);

class JSValidityStatePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSValidityStatePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSValidityStatePrototype* ptr = new (NotNull, JSC::allocateCell<JSValidityStatePrototype>(vm)) JSValidityStatePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSValidityStatePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSValidityStatePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSValidityStatePrototype, JSValidityStatePrototype::Base);

using JSValidityStateDOMConstructor = JSDOMConstructorNotConstructable<JSValidityState>;

template<> const ClassInfo JSValidityStateDOMConstructor::s_info = { "ValidityState"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSValidityStateDOMConstructor) };

template<> JSValue JSValidityStateDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSValidityStateDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ValidityState"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSValidityState::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSValidityStatePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsValidityStateConstructor, 0 } },
    { "valueMissing"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsValidityState_valueMissing, 0 } },
    { "typeMismatch"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsValidityState_typeMismatch, 0 } },
    { "patternMismatch"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsValidityState_patternMismatch, 0 } },
    { "tooShort"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsValidityState_tooShort, 0 } },
    { "tooLong"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsValidityState_tooLong, 0 } },
    { "rangeUnderflow"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsValidityState_rangeUnderflow, 0 } },
    { "rangeOverflow"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsValidityState_rangeOverflow, 0 } },
    { "stepMismatch"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsValidityState_stepMismatch, 0 } },
    { "badInput"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsValidityState_badInput, 0 } },
    { "customError"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsValidityState_customError, 0 } },
    { "valid"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsValidityState_valid, 0 } },
};

const ClassInfo JSValidityStatePrototype::s_info = { "ValidityState"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSValidityStatePrototype) };

void JSValidityStatePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSValidityState::info(), JSValidityStatePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSValidityState::s_info = { "ValidityState"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSValidityState) };

JSValidityState::JSValidityState(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ValidityState>&& impl)
    : JSDOMWrapper<ValidityState>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, ValidityState>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSValidityState::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSValidityStatePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSValidityStatePrototype::create(vm, &globalObject, structure);
}

JSObject* JSValidityState::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSValidityState>(vm, globalObject);
}

JSValue JSValidityState::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSValidityStateDOMConstructor, DOMConstructorID::ValidityState>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSValidityState::destroy(JSC::JSCell* cell)
{
    JSValidityState* thisObject = static_cast<JSValidityState*>(cell);
    thisObject->JSValidityState::~JSValidityState();
}

JSC_DEFINE_CUSTOM_GETTER(jsValidityStateConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSValidityStatePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSValidityState::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsValidityState_valueMissingGetter(JSGlobalObject& lexicalGlobalObject, JSValidityState& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.valueMissing())));
}

JSC_DEFINE_CUSTOM_GETTER(jsValidityState_valueMissing, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSValidityState>::get<jsValidityState_valueMissingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsValidityState_typeMismatchGetter(JSGlobalObject& lexicalGlobalObject, JSValidityState& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.typeMismatch())));
}

JSC_DEFINE_CUSTOM_GETTER(jsValidityState_typeMismatch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSValidityState>::get<jsValidityState_typeMismatchGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsValidityState_patternMismatchGetter(JSGlobalObject& lexicalGlobalObject, JSValidityState& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.patternMismatch())));
}

JSC_DEFINE_CUSTOM_GETTER(jsValidityState_patternMismatch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSValidityState>::get<jsValidityState_patternMismatchGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsValidityState_tooShortGetter(JSGlobalObject& lexicalGlobalObject, JSValidityState& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.tooShort())));
}

JSC_DEFINE_CUSTOM_GETTER(jsValidityState_tooShort, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSValidityState>::get<jsValidityState_tooShortGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsValidityState_tooLongGetter(JSGlobalObject& lexicalGlobalObject, JSValidityState& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.tooLong())));
}

JSC_DEFINE_CUSTOM_GETTER(jsValidityState_tooLong, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSValidityState>::get<jsValidityState_tooLongGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsValidityState_rangeUnderflowGetter(JSGlobalObject& lexicalGlobalObject, JSValidityState& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.rangeUnderflow())));
}

JSC_DEFINE_CUSTOM_GETTER(jsValidityState_rangeUnderflow, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSValidityState>::get<jsValidityState_rangeUnderflowGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsValidityState_rangeOverflowGetter(JSGlobalObject& lexicalGlobalObject, JSValidityState& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.rangeOverflow())));
}

JSC_DEFINE_CUSTOM_GETTER(jsValidityState_rangeOverflow, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSValidityState>::get<jsValidityState_rangeOverflowGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsValidityState_stepMismatchGetter(JSGlobalObject& lexicalGlobalObject, JSValidityState& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.stepMismatch())));
}

JSC_DEFINE_CUSTOM_GETTER(jsValidityState_stepMismatch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSValidityState>::get<jsValidityState_stepMismatchGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsValidityState_badInputGetter(JSGlobalObject& lexicalGlobalObject, JSValidityState& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.badInput())));
}

JSC_DEFINE_CUSTOM_GETTER(jsValidityState_badInput, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSValidityState>::get<jsValidityState_badInputGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsValidityState_customErrorGetter(JSGlobalObject& lexicalGlobalObject, JSValidityState& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.customError())));
}

JSC_DEFINE_CUSTOM_GETTER(jsValidityState_customError, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSValidityState>::get<jsValidityState_customErrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsValidityState_validGetter(JSGlobalObject& lexicalGlobalObject, JSValidityState& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.computeValidity())));
}

JSC_DEFINE_CUSTOM_GETTER(jsValidityState_valid, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSValidityState>::get<jsValidityState_validGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSValidityState::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSValidityState, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForValidityState.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForValidityState = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForValidityState.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForValidityState = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSValidityState::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSValidityState*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    addWebCoreOpaqueRoot(visitor, thisObject->wrapped().opaqueRootConcurrently());
}

DEFINE_VISIT_CHILDREN(JSValidityState);

void JSValidityState::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSValidityState*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSValidityStateOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsValidityState = jsCast<JSValidityState*>(handle.slot()->asCell());
    Element* owner = WTF::getPtr(jsValidityState->wrapped().element());
    if (!owner)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from ValidityStateOwner"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSValidityStateOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsValidityState = static_cast<JSValidityState*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsValidityState->protectedWrapped().ptr(), jsValidityState);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ValidityState>&& impl)
{
    return createWrapper<ValidityState>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ValidityState& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ValidityState* JSValidityState::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSValidityState*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
