/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSUserActivation.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "Navigator.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include "WorkerNavigator.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsUserActivationConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsUserActivation_hasBeenActive);
static JSC_DECLARE_CUSTOM_GETTER(jsUserActivation_isActive);

class JSUserActivationPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSUserActivationPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSUserActivationPrototype* ptr = new (NotNull, JSC::allocateCell<JSUserActivationPrototype>(vm)) JSUserActivationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSUserActivationPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSUserActivationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSUserActivationPrototype, JSUserActivationPrototype::Base);

using JSUserActivationDOMConstructor = JSDOMConstructorNotConstructable<JSUserActivation>;

template<> const ClassInfo JSUserActivationDOMConstructor::s_info = { "UserActivation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUserActivationDOMConstructor) };

template<> JSValue JSUserActivationDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSUserActivationDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "UserActivation"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSUserActivation::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSUserActivationPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsUserActivationConstructor, 0 } },
    { "hasBeenActive"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsUserActivation_hasBeenActive, 0 } },
    { "isActive"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsUserActivation_isActive, 0 } },
};

const ClassInfo JSUserActivationPrototype::s_info = { "UserActivation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUserActivationPrototype) };

void JSUserActivationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSUserActivation::info(), JSUserActivationPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSUserActivation::s_info = { "UserActivation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUserActivation) };

JSUserActivation::JSUserActivation(Structure* structure, JSDOMGlobalObject& globalObject, Ref<UserActivation>&& impl)
    : JSDOMWrapper<UserActivation>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, UserActivation>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSUserActivation::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSUserActivationPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSUserActivationPrototype::create(vm, &globalObject, structure);
}

JSObject* JSUserActivation::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSUserActivation>(vm, globalObject);
}

JSValue JSUserActivation::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSUserActivationDOMConstructor, DOMConstructorID::UserActivation>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSUserActivation::destroy(JSC::JSCell* cell)
{
    JSUserActivation* thisObject = static_cast<JSUserActivation*>(cell);
    thisObject->JSUserActivation::~JSUserActivation();
}

JSC_DEFINE_CUSTOM_GETTER(jsUserActivationConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSUserActivationPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSUserActivation::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsUserActivation_hasBeenActiveGetter(JSGlobalObject& lexicalGlobalObject, JSUserActivation& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasBeenActive())));
}

JSC_DEFINE_CUSTOM_GETTER(jsUserActivation_hasBeenActive, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSUserActivation>::get<jsUserActivation_hasBeenActiveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsUserActivation_isActiveGetter(JSGlobalObject& lexicalGlobalObject, JSUserActivation& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isActive())));
}

JSC_DEFINE_CUSTOM_GETTER(jsUserActivation_isActive, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSUserActivation>::get<jsUserActivation_isActiveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSUserActivation::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSUserActivation, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForUserActivation.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForUserActivation = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForUserActivation.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForUserActivation = std::forward<decltype(space)>(space); }
    );
}

void JSUserActivation::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSUserActivation*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSUserActivationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsUserActivation = jsCast<JSUserActivation*>(handle.slot()->asCell());
    NavigatorBase* owner = WTF::getPtr(jsUserActivation->wrapped().navigator());
    if (!owner)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from Navigator"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSUserActivationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsUserActivation = static_cast<JSUserActivation*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsUserActivation->protectedWrapped().ptr(), jsUserActivation);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7UserActivation@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14UserActivationE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, UserActivation>, void>> static inline void verifyVTable(UserActivation* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7UserActivation@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore14UserActivationE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // UserActivation has subclasses. If UserActivation has subclasses that get passed
        // to toJS() we currently require UserActivation you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<UserActivation>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<UserActivation>(impl.ptr());
#endif
    return createWrapper<UserActivation>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, UserActivation& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

UserActivation* JSUserActivation::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSUserActivation*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
