/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSStylePropertyMapReadOnly.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSCSSStyleValue.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMIterator.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/BuiltinNames.h>
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsStylePropertyMapReadOnlyPrototypeFunction_get);
static JSC_DECLARE_HOST_FUNCTION(jsStylePropertyMapReadOnlyPrototypeFunction_getAll);
static JSC_DECLARE_HOST_FUNCTION(jsStylePropertyMapReadOnlyPrototypeFunction_has);
static JSC_DECLARE_HOST_FUNCTION(jsStylePropertyMapReadOnlyPrototypeFunction_entries);
static JSC_DECLARE_HOST_FUNCTION(jsStylePropertyMapReadOnlyPrototypeFunction_keys);
static JSC_DECLARE_HOST_FUNCTION(jsStylePropertyMapReadOnlyPrototypeFunction_values);
static JSC_DECLARE_HOST_FUNCTION(jsStylePropertyMapReadOnlyPrototypeFunction_forEach);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsStylePropertyMapReadOnlyConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsStylePropertyMapReadOnly_size);

class JSStylePropertyMapReadOnlyPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSStylePropertyMapReadOnlyPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSStylePropertyMapReadOnlyPrototype* ptr = new (NotNull, JSC::allocateCell<JSStylePropertyMapReadOnlyPrototype>(vm)) JSStylePropertyMapReadOnlyPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSStylePropertyMapReadOnlyPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSStylePropertyMapReadOnlyPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSStylePropertyMapReadOnlyPrototype, JSStylePropertyMapReadOnlyPrototype::Base);

using JSStylePropertyMapReadOnlyDOMConstructor = JSDOMConstructorNotConstructable<JSStylePropertyMapReadOnly>;

template<> const ClassInfo JSStylePropertyMapReadOnlyDOMConstructor::s_info = { "StylePropertyMapReadOnly"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStylePropertyMapReadOnlyDOMConstructor) };

template<> JSValue JSStylePropertyMapReadOnlyDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSStylePropertyMapReadOnlyDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "StylePropertyMapReadOnly"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSStylePropertyMapReadOnly::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSStylePropertyMapReadOnlyPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsStylePropertyMapReadOnlyConstructor, 0 } },
    { "size"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsStylePropertyMapReadOnly_size, 0 } },
    { "get"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsStylePropertyMapReadOnlyPrototypeFunction_get, 1 } },
    { "getAll"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsStylePropertyMapReadOnlyPrototypeFunction_getAll, 1 } },
    { "has"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsStylePropertyMapReadOnlyPrototypeFunction_has, 1 } },
    { "entries"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsStylePropertyMapReadOnlyPrototypeFunction_entries, 0 } },
    { "keys"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsStylePropertyMapReadOnlyPrototypeFunction_keys, 0 } },
    { "values"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsStylePropertyMapReadOnlyPrototypeFunction_values, 0 } },
    { "forEach"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsStylePropertyMapReadOnlyPrototypeFunction_forEach, 1 } },
};

const ClassInfo JSStylePropertyMapReadOnlyPrototype::s_info = { "StylePropertyMapReadOnly"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStylePropertyMapReadOnlyPrototype) };

void JSStylePropertyMapReadOnlyPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSStylePropertyMapReadOnly::info(), JSStylePropertyMapReadOnlyPrototypeTableValues, *this);
    putDirect(vm, vm.propertyNames->iteratorSymbol, getDirect(vm, vm.propertyNames->builtinNames().entriesPublicName()), static_cast<unsigned>(JSC::PropertyAttribute::DontEnum));
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSStylePropertyMapReadOnly::s_info = { "StylePropertyMapReadOnly"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStylePropertyMapReadOnly) };

JSStylePropertyMapReadOnly::JSStylePropertyMapReadOnly(Structure* structure, JSDOMGlobalObject& globalObject, Ref<StylePropertyMapReadOnly>&& impl)
    : JSDOMWrapper<StylePropertyMapReadOnly>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, StylePropertyMapReadOnly>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSStylePropertyMapReadOnly::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSStylePropertyMapReadOnlyPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSStylePropertyMapReadOnlyPrototype::create(vm, &globalObject, structure);
}

JSObject* JSStylePropertyMapReadOnly::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSStylePropertyMapReadOnly>(vm, globalObject);
}

JSValue JSStylePropertyMapReadOnly::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSStylePropertyMapReadOnlyDOMConstructor, DOMConstructorID::StylePropertyMapReadOnly>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSStylePropertyMapReadOnly::destroy(JSC::JSCell* cell)
{
    JSStylePropertyMapReadOnly* thisObject = static_cast<JSStylePropertyMapReadOnly*>(cell);
    thisObject->JSStylePropertyMapReadOnly::~JSStylePropertyMapReadOnly();
}

JSC_DEFINE_CUSTOM_GETTER(jsStylePropertyMapReadOnlyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSStylePropertyMapReadOnlyPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSStylePropertyMapReadOnly::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsStylePropertyMapReadOnly_sizeGetter(JSGlobalObject& lexicalGlobalObject, JSStylePropertyMapReadOnly& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.size())));
}

JSC_DEFINE_CUSTOM_GETTER(jsStylePropertyMapReadOnly_size, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSStylePropertyMapReadOnly>::get<jsStylePropertyMapReadOnly_sizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsStylePropertyMapReadOnlyPrototypeFunction_getBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSStylePropertyMapReadOnly>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto propertyConversionResult = convert<IDLAtomStringAdaptor<IDLUSVString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(propertyConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<CSSStyleValue>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.get(*context, propertyConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsStylePropertyMapReadOnlyPrototypeFunction_get, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSStylePropertyMapReadOnly>::call<jsStylePropertyMapReadOnlyPrototypeFunction_getBody>(*lexicalGlobalObject, *callFrame, "get");
}

static inline JSC::EncodedJSValue jsStylePropertyMapReadOnlyPrototypeFunction_getAllBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSStylePropertyMapReadOnly>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto propertyConversionResult = convert<IDLAtomStringAdaptor<IDLUSVString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(propertyConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLSequence<IDLInterface<CSSStyleValue>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getAll(*context, propertyConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsStylePropertyMapReadOnlyPrototypeFunction_getAll, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSStylePropertyMapReadOnly>::call<jsStylePropertyMapReadOnlyPrototypeFunction_getAllBody>(*lexicalGlobalObject, *callFrame, "getAll");
}

static inline JSC::EncodedJSValue jsStylePropertyMapReadOnlyPrototypeFunction_hasBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSStylePropertyMapReadOnly>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto propertyConversionResult = convert<IDLAtomStringAdaptor<IDLUSVString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(propertyConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.has(*context, propertyConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsStylePropertyMapReadOnlyPrototypeFunction_has, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSStylePropertyMapReadOnly>::call<jsStylePropertyMapReadOnlyPrototypeFunction_hasBody>(*lexicalGlobalObject, *callFrame, "has");
}

struct StylePropertyMapReadOnlyIteratorTraits {
    static constexpr JSDOMIteratorType type = JSDOMIteratorType::Map;
    using KeyType = IDLUSVString;
    using ValueType = IDLSequence<IDLInterface<CSSStyleValue>>;
};

using StylePropertyMapReadOnlyIteratorBase = JSDOMIteratorBase<JSStylePropertyMapReadOnly, StylePropertyMapReadOnlyIteratorTraits>;
class StylePropertyMapReadOnlyIterator final : public StylePropertyMapReadOnlyIteratorBase {
public:
    using Base = StylePropertyMapReadOnlyIteratorBase;
    DECLARE_INFO;

    template<typename, SubspaceAccess mode> static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        if constexpr (mode == JSC::SubspaceAccess::Concurrently)
            return nullptr;
        return WebCore::subspaceForImpl<StylePropertyMapReadOnlyIterator, UseCustomHeapCellType::No>(vm,
            [] (auto& spaces) { return spaces.m_clientSubspaceForStylePropertyMapReadOnlyIterator.get(); },
            [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForStylePropertyMapReadOnlyIterator = std::forward<decltype(space)>(space); },
            [] (auto& spaces) { return spaces.m_subspaceForStylePropertyMapReadOnlyIterator.get(); },
            [] (auto& spaces, auto&& space) { spaces.m_subspaceForStylePropertyMapReadOnlyIterator = std::forward<decltype(space)>(space); }
        );
    }

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    static StylePropertyMapReadOnlyIterator* create(JSC::VM& vm, JSC::Structure* structure, JSStylePropertyMapReadOnly& iteratedObject, IterationKind kind)
    {
        auto* instance = new (NotNull, JSC::allocateCell<StylePropertyMapReadOnlyIterator>(vm)) StylePropertyMapReadOnlyIterator(structure, iteratedObject, kind);
        instance->finishCreation(vm);
        return instance;
    }
private:
    StylePropertyMapReadOnlyIterator(JSC::Structure* structure, JSStylePropertyMapReadOnly& iteratedObject, IterationKind kind)
        : Base(structure, iteratedObject, kind)
    {
    }
};

using StylePropertyMapReadOnlyIteratorPrototype = JSDOMIteratorPrototype<JSStylePropertyMapReadOnly, StylePropertyMapReadOnlyIteratorTraits>;
JSC_ANNOTATE_HOST_FUNCTION(StylePropertyMapReadOnlyIteratorPrototypeNext, StylePropertyMapReadOnlyIteratorPrototype::next);

template<>
const JSC::ClassInfo StylePropertyMapReadOnlyIteratorBase::s_info = { "StylePropertyMapReadOnlyBase Iterator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(StylePropertyMapReadOnlyIteratorBase) };
const JSC::ClassInfo StylePropertyMapReadOnlyIterator::s_info = { "StylePropertyMapReadOnly Iterator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(StylePropertyMapReadOnlyIterator) };

template<>
const JSC::ClassInfo StylePropertyMapReadOnlyIteratorPrototype::s_info = { "StylePropertyMapReadOnly Iterator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(StylePropertyMapReadOnlyIteratorPrototype) };

static inline EncodedJSValue jsStylePropertyMapReadOnlyPrototypeFunction_entriesCaller(JSGlobalObject*, CallFrame*, JSStylePropertyMapReadOnly* thisObject)
{
    return JSValue::encode(iteratorCreate<StylePropertyMapReadOnlyIterator>(*thisObject, IterationKind::Entries));
}

JSC_DEFINE_HOST_FUNCTION(jsStylePropertyMapReadOnlyPrototypeFunction_entries, (JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame))
{
    return IDLOperation<JSStylePropertyMapReadOnly>::call<jsStylePropertyMapReadOnlyPrototypeFunction_entriesCaller>(*lexicalGlobalObject, *callFrame, "entries");
}

static inline EncodedJSValue jsStylePropertyMapReadOnlyPrototypeFunction_keysCaller(JSGlobalObject*, CallFrame*, JSStylePropertyMapReadOnly* thisObject)
{
    return JSValue::encode(iteratorCreate<StylePropertyMapReadOnlyIterator>(*thisObject, IterationKind::Keys));
}

JSC_DEFINE_HOST_FUNCTION(jsStylePropertyMapReadOnlyPrototypeFunction_keys, (JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame))
{
    return IDLOperation<JSStylePropertyMapReadOnly>::call<jsStylePropertyMapReadOnlyPrototypeFunction_keysCaller>(*lexicalGlobalObject, *callFrame, "keys");
}

static inline EncodedJSValue jsStylePropertyMapReadOnlyPrototypeFunction_valuesCaller(JSGlobalObject*, CallFrame*, JSStylePropertyMapReadOnly* thisObject)
{
    return JSValue::encode(iteratorCreate<StylePropertyMapReadOnlyIterator>(*thisObject, IterationKind::Values));
}

JSC_DEFINE_HOST_FUNCTION(jsStylePropertyMapReadOnlyPrototypeFunction_values, (JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame))
{
    return IDLOperation<JSStylePropertyMapReadOnly>::call<jsStylePropertyMapReadOnlyPrototypeFunction_valuesCaller>(*lexicalGlobalObject, *callFrame, "values");
}

static inline EncodedJSValue jsStylePropertyMapReadOnlyPrototypeFunction_forEachCaller(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame, JSStylePropertyMapReadOnly* thisObject)
{
    return JSValue::encode(iteratorForEach<StylePropertyMapReadOnlyIterator>(*lexicalGlobalObject, *callFrame, *thisObject));
}

JSC_DEFINE_HOST_FUNCTION(jsStylePropertyMapReadOnlyPrototypeFunction_forEach, (JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame))
{
    return IDLOperation<JSStylePropertyMapReadOnly>::call<jsStylePropertyMapReadOnlyPrototypeFunction_forEachCaller>(*lexicalGlobalObject, *callFrame, "forEach");
}

JSC::GCClient::IsoSubspace* JSStylePropertyMapReadOnly::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSStylePropertyMapReadOnly, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForStylePropertyMapReadOnly.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForStylePropertyMapReadOnly = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForStylePropertyMapReadOnly.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForStylePropertyMapReadOnly = std::forward<decltype(space)>(space); }
    );
}

void JSStylePropertyMapReadOnly::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSStylePropertyMapReadOnly*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSStylePropertyMapReadOnlyOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSStylePropertyMapReadOnlyOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsStylePropertyMapReadOnly = static_cast<JSStylePropertyMapReadOnly*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsStylePropertyMapReadOnly->protectedWrapped().ptr(), jsStylePropertyMapReadOnly);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<StylePropertyMapReadOnly>&& impl)
{
    return createWrapper<StylePropertyMapReadOnly>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, StylePropertyMapReadOnly& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

StylePropertyMapReadOnly* JSStylePropertyMapReadOnly::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSStylePropertyMapReadOnly*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
