/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSStartViewTransitionOptions.h"

#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include "JSViewTransitionUpdateCallback.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<StartViewTransitionOptions>> convertDictionary<StartViewTransitionOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    StartViewTransitionOptions result;
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().viewTransitionTypesEnabled) {
        JSValue typesValue;
        if (isNullOrUndefined)
            typesValue = jsUndefined();
        else {
            typesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "types"_s));
            RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
        }
        auto typesConversionResult = convertOptionalWithDefault<IDLNullable<IDLSequence<IDLAtomStringAdaptor<IDLDOMString>>>>(lexicalGlobalObject, typesValue, [&]() -> ConversionResult<IDLNullable<IDLSequence<IDLAtomStringAdaptor<IDLDOMString>>>> { return typename Converter<IDLNullable<IDLSequence<IDLAtomStringAdaptor<IDLDOMString>>>>::ReturnType { std::nullopt }; });
        if (UNLIKELY(typesConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.types = typesConversionResult.releaseReturnValue();
    }
    JSValue updateValue;
    if (isNullOrUndefined)
        updateValue = jsUndefined();
    else {
        updateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "update"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto updateConversionResult = convertOptionalWithDefault<IDLNullable<IDLCallbackFunction<JSViewTransitionUpdateCallback>>>(lexicalGlobalObject, updateValue, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject), [&]() -> ConversionResult<IDLNullable<IDLCallbackFunction<JSViewTransitionUpdateCallback>>> { return typename Converter<IDLNullable<IDLCallbackFunction<JSViewTransitionUpdateCallback>>>::ReturnType { nullptr }; });
    if (UNLIKELY(updateConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.update = updateConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
