/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSScrollTimelineOptions.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertOptional.h"
#include "JSElement.h"
#include "JSScrollAxis.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<ScrollTimelineOptions>> convertDictionary<ScrollTimelineOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    ScrollTimelineOptions result;
    JSValue axisValue;
    if (isNullOrUndefined)
        axisValue = jsUndefined();
    else {
        axisValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "axis"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto axisConversionResult = convertOptionalWithDefault<IDLEnumeration<ScrollAxis>>(lexicalGlobalObject, axisValue, [&]() -> ConversionResult<IDLEnumeration<ScrollAxis>> { return Converter<IDLEnumeration<ScrollAxis>>::ReturnType { ScrollAxis::Block }; });
    if (UNLIKELY(axisConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.axis = axisConversionResult.releaseReturnValue();
    JSValue sourceValue;
    if (isNullOrUndefined)
        sourceValue = jsUndefined();
    else {
        sourceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "source"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!sourceValue.isUndefined()) {
        auto sourceConversionResult = convert<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, sourceValue);
        if (UNLIKELY(sourceConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.source = sourceConversionResult.releaseReturnValue();
    }
    return result;
}

} // namespace WebCore
