/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSResizeObserverEntry.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMRectReadOnly.h"
#include "JSDOMWrapperCache.h"
#include "JSElement.h"
#include "JSResizeObserverSize.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsResizeObserverEntryConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsResizeObserverEntry_target);
static JSC_DECLARE_CUSTOM_GETTER(jsResizeObserverEntry_contentRect);
static JSC_DECLARE_CUSTOM_GETTER(jsResizeObserverEntry_borderBoxSize);
static JSC_DECLARE_CUSTOM_GETTER(jsResizeObserverEntry_contentBoxSize);

class JSResizeObserverEntryPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSResizeObserverEntryPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSResizeObserverEntryPrototype* ptr = new (NotNull, JSC::allocateCell<JSResizeObserverEntryPrototype>(vm)) JSResizeObserverEntryPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSResizeObserverEntryPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSResizeObserverEntryPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSResizeObserverEntryPrototype, JSResizeObserverEntryPrototype::Base);

using JSResizeObserverEntryDOMConstructor = JSDOMConstructorNotConstructable<JSResizeObserverEntry>;

template<> const ClassInfo JSResizeObserverEntryDOMConstructor::s_info = { "ResizeObserverEntry"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSResizeObserverEntryDOMConstructor) };

template<> JSValue JSResizeObserverEntryDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSResizeObserverEntryDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ResizeObserverEntry"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSResizeObserverEntry::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSResizeObserverEntryPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsResizeObserverEntryConstructor, 0 } },
    { "target"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsResizeObserverEntry_target, 0 } },
    { "contentRect"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsResizeObserverEntry_contentRect, 0 } },
    { "borderBoxSize"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsResizeObserverEntry_borderBoxSize, 0 } },
    { "contentBoxSize"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsResizeObserverEntry_contentBoxSize, 0 } },
};

const ClassInfo JSResizeObserverEntryPrototype::s_info = { "ResizeObserverEntry"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSResizeObserverEntryPrototype) };

void JSResizeObserverEntryPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSResizeObserverEntry::info(), JSResizeObserverEntryPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSResizeObserverEntry::s_info = { "ResizeObserverEntry"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSResizeObserverEntry) };

JSResizeObserverEntry::JSResizeObserverEntry(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ResizeObserverEntry>&& impl)
    : JSDOMWrapper<ResizeObserverEntry>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, ResizeObserverEntry>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSResizeObserverEntry::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSResizeObserverEntryPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSResizeObserverEntryPrototype::create(vm, &globalObject, structure);
}

JSObject* JSResizeObserverEntry::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSResizeObserverEntry>(vm, globalObject);
}

JSValue JSResizeObserverEntry::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSResizeObserverEntryDOMConstructor, DOMConstructorID::ResizeObserverEntry>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSResizeObserverEntry::destroy(JSC::JSCell* cell)
{
    JSResizeObserverEntry* thisObject = static_cast<JSResizeObserverEntry*>(cell);
    thisObject->JSResizeObserverEntry::~JSResizeObserverEntry();
}

JSC_DEFINE_CUSTOM_GETTER(jsResizeObserverEntryConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSResizeObserverEntryPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSResizeObserverEntry::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsResizeObserverEntry_targetGetter(JSGlobalObject& lexicalGlobalObject, JSResizeObserverEntry& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<Element>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.target())));
}

JSC_DEFINE_CUSTOM_GETTER(jsResizeObserverEntry_target, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSResizeObserverEntry>::get<jsResizeObserverEntry_targetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsResizeObserverEntry_contentRectGetter(JSGlobalObject& lexicalGlobalObject, JSResizeObserverEntry& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DOMRectReadOnly>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.contentRect())));
}

JSC_DEFINE_CUSTOM_GETTER(jsResizeObserverEntry_contentRect, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSResizeObserverEntry>::get<jsResizeObserverEntry_contentRectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsResizeObserverEntry_borderBoxSizeGetter(JSGlobalObject& lexicalGlobalObject, JSResizeObserverEntry& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFrozenArray<IDLInterface<ResizeObserverSize>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.borderBoxSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsResizeObserverEntry_borderBoxSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSResizeObserverEntry>::get<jsResizeObserverEntry_borderBoxSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsResizeObserverEntry_contentBoxSizeGetter(JSGlobalObject& lexicalGlobalObject, JSResizeObserverEntry& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFrozenArray<IDLInterface<ResizeObserverSize>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.contentBoxSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsResizeObserverEntry_contentBoxSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSResizeObserverEntry>::get<jsResizeObserverEntry_contentBoxSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSResizeObserverEntry::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSResizeObserverEntry, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForResizeObserverEntry.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForResizeObserverEntry = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForResizeObserverEntry.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForResizeObserverEntry = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSResizeObserverEntry::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSResizeObserverEntry*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSResizeObserverEntry);

template<typename Visitor>
void JSResizeObserverEntry::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSResizeObserverEntry*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSResizeObserverEntry::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSResizeObserverEntry::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSResizeObserverEntry::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSResizeObserverEntry*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSResizeObserverEntryOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSResizeObserverEntryOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsResizeObserverEntry = static_cast<JSResizeObserverEntry*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsResizeObserverEntry->protectedWrapped().ptr(), jsResizeObserverEntry);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ResizeObserverEntry@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19ResizeObserverEntryE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, ResizeObserverEntry>, void>> static inline void verifyVTable(ResizeObserverEntry* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ResizeObserverEntry@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore19ResizeObserverEntryE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ResizeObserverEntry has subclasses. If ResizeObserverEntry has subclasses that get passed
        // to toJS() we currently require ResizeObserverEntry you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ResizeObserverEntry>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<ResizeObserverEntry>(impl.ptr());
#endif
    return createWrapper<ResizeObserverEntry>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ResizeObserverEntry& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ResizeObserverEntry* JSResizeObserverEntry::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSResizeObserverEntry*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
