/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPaintWorkletGlobalScope.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSAbortController.h"
#include "JSAbortSignal.h"
#include "JSByteLengthQueuingStrategy.h"
#include "JSCSSColor.h"
#include "JSCSSColorValue.h"
#include "JSCSSHSL.h"
#include "JSCSSHWB.h"
#include "JSCSSKeywordValue.h"
#include "JSCSSLCH.h"
#include "JSCSSLab.h"
#include "JSCSSMathClamp.h"
#include "JSCSSMathInvert.h"
#include "JSCSSMathMax.h"
#include "JSCSSMathMin.h"
#include "JSCSSMathNegate.h"
#include "JSCSSMathProduct.h"
#include "JSCSSMathSum.h"
#include "JSCSSMathValue.h"
#include "JSCSSMatrixComponent.h"
#include "JSCSSNumericArray.h"
#include "JSCSSNumericValue.h"
#include "JSCSSOKLCH.h"
#include "JSCSSOKLab.h"
#include "JSCSSOMVariableReferenceValue.h"
#include "JSCSSPaintSize.h"
#include "JSCSSPerspective.h"
#include "JSCSSRGB.h"
#include "JSCSSRotate.h"
#include "JSCSSScale.h"
#include "JSCSSSkew.h"
#include "JSCSSSkewX.h"
#include "JSCSSSkewY.h"
#include "JSCSSStyleImageValue.h"
#include "JSCSSStyleValue.h"
#include "JSCSSTransformComponent.h"
#include "JSCSSTransformValue.h"
#include "JSCSSTranslate.h"
#include "JSCSSUnitValue.h"
#include "JSCSSUnparsedValue.h"
#include "JSCompressionStream.h"
#include "JSCompressionStreamEncoder.h"
#include "JSCountQueuingStrategy.h"
#include "JSCustomEvent.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertObject.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMURL.h"
#include "JSDOMWrapperCache.h"
#include "JSDecompressionStream.h"
#include "JSDecompressionStreamDecoder.h"
#include "JSErrorEvent.h"
#include "JSEvent.h"
#include "JSEventTarget.h"
#include "JSPaintRenderingContext2D.h"
#include "JSPaintWorkletGlobalScope.h"
#include "JSPerformance.h"
#include "JSPerformanceEntry.h"
#include "JSPerformanceMark.h"
#include "JSPerformanceMeasure.h"
#include "JSPerformanceObserver.h"
#include "JSPerformanceObserverEntryList.h"
#include "JSPerformanceResourceTiming.h"
#include "JSPerformanceServerTiming.h"
#include "JSPromiseRejectionEvent.h"
#include "JSReadableByteStreamController.h"
#include "JSReadableStream.h"
#include "JSReadableStreamBYOBReader.h"
#include "JSReadableStreamBYOBRequest.h"
#include "JSReadableStreamDefaultController.h"
#include "JSReadableStreamDefaultReader.h"
#include "JSStylePropertyMapReadOnly.h"
#include "JSTextDecoder.h"
#include "JSTextDecoderStream.h"
#include "JSTextEncoder.h"
#include "JSTextEncoderStream.h"
#include "JSTransformStream.h"
#include "JSTransformStreamDefaultController.h"
#include "JSURLSearchParams.h"
#include "JSWritableStream.h"
#include "JSWritableStreamDefaultController.h"
#include "JSWritableStreamDefaultWriter.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsPaintWorkletGlobalScopeInstanceFunction_registerPaint);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScopeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_devicePixelRatio);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CompressionStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CompressionStreamEncoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_DecompressionStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_DecompressionStreamDecoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_ByteLengthQueuingStrategyConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CountQueuingStrategyConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_ReadableByteStreamControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_ReadableStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_ReadableStreamBYOBReaderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_ReadableStreamBYOBRequestConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_ReadableStreamDefaultControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_ReadableStreamDefaultReaderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_TransformStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_TransformStreamDefaultControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_WritableStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_WritableStreamDefaultControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_WritableStreamDefaultWriterConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSPaintSizeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSKeywordValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSNumericValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSVariableReferenceValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSImageValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSStyleValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSUnitValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSUnparsedValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_StylePropertyMapReadOnlyConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSColorConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSColorValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSHSLConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSHWBConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSLCHConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSLabConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSOKLCHConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSOKLabConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSRGBConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSMathClampConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSMathInvertConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSMathMaxConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSMathMinConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSMathNegateConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSMathProductConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSMathSumConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSMathValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSNumericArrayConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSMatrixComponentConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSPerspectiveConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSRotateConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSScaleConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSSkewConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSSkewXConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSSkewYConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSTransformComponentConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSTransformValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSTranslateConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_AbortControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_AbortSignalConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CustomEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_ErrorEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_EventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_EventTargetConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_PromiseRejectionEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_TextDecoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_TextDecoderStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_TextEncoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_TextEncoderStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_URLConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_URLSearchParamsConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_PaintRenderingContext2DConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_PerformanceConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_PerformanceEntryConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_PerformanceMarkConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_PerformanceMeasureConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_PerformanceObserverConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_PerformanceObserverEntryListConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_PerformanceResourceTimingConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_PerformanceServerTimingConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_PaintWorkletGlobalScopeConstructor);

using JSPaintWorkletGlobalScopeDOMConstructor = JSDOMConstructorNotConstructable<JSPaintWorkletGlobalScope>;

/* Hash table */

static const struct CompactHashIndex JSPaintWorkletGlobalScopeTableIndex[263] = {
    { -1, -1 },
    { -1, -1 },
    { 19, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 51, -1 },
    { 26, -1 },
    { -1, -1 },
    { 54, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 47, -1 },
    { 44, -1 },
    { -1, -1 },
    { 4, -1 },
    { 23, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 24, 260 },
    { -1, -1 },
    { 17, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 0, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 3, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 1, -1 },
    { 41, -1 },
    { -1, -1 },
    { -1, -1 },
    { 55, -1 },
    { -1, -1 },
    { 9, -1 },
    { -1, -1 },
    { -1, -1 },
    { 36, -1 },
    { -1, -1 },
    { -1, -1 },
    { 39, -1 },
    { -1, -1 },
    { -1, -1 },
    { 38, -1 },
    { 6, 256 },
    { -1, -1 },
    { 56, -1 },
    { -1, -1 },
    { -1, -1 },
    { 22, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 20, -1 },
    { 43, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 45, -1 },
    { -1, -1 },
    { 52, -1 },
    { -1, -1 },
    { -1, -1 },
    { 10, -1 },
    { -1, -1 },
    { 40, -1 },
    { -1, -1 },
    { 42, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 21, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 2, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 59, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 16, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 7, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 14, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 27, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 46, -1 },
    { -1, -1 },
    { -1, -1 },
    { 30, 258 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 15, 261 },
    { 5, -1 },
    { -1, -1 },
    { -1, -1 },
    { 37, -1 },
    { 49, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 8, 259 },
    { -1, -1 },
    { -1, -1 },
    { 28, 257 },
    { -1, -1 },
    { 57, -1 },
    { -1, -1 },
    { 25, -1 },
    { -1, -1 },
    { 13, 262 },
    { -1, -1 },
    { 11, -1 },
    { 18, -1 },
    { -1, -1 },
    { 33, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 35, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 50, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 12, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 29, -1 },
    { 31, -1 },
    { 32, -1 },
    { 34, -1 },
    { 48, -1 },
    { 53, -1 },
    { 58, -1 },
};


static const HashTableValue JSPaintWorkletGlobalScopeTableValues[] =
{
    { "devicePixelRatio"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_devicePixelRatio, 0 } },
    { "ByteLengthQueuingStrategy"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_ByteLengthQueuingStrategyConstructor, 0 } },
    { "CountQueuingStrategy"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CountQueuingStrategyConstructor, 0 } },
    { "ReadableStream"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_ReadableStreamConstructor, 0 } },
    { "ReadableStreamDefaultController"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_ReadableStreamDefaultControllerConstructor, 0 } },
    { "ReadableStreamDefaultReader"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_ReadableStreamDefaultReaderConstructor, 0 } },
    { "TransformStream"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_TransformStreamConstructor, 0 } },
    { "TransformStreamDefaultController"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_TransformStreamDefaultControllerConstructor, 0 } },
    { "WritableStream"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_WritableStreamConstructor, 0 } },
    { "WritableStreamDefaultController"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_WritableStreamDefaultControllerConstructor, 0 } },
    { "WritableStreamDefaultWriter"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_WritableStreamDefaultWriterConstructor, 0 } },
    { "CSSKeywordValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSKeywordValueConstructor, 0 } },
    { "CSSNumericValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSNumericValueConstructor, 0 } },
    { "CSSVariableReferenceValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSVariableReferenceValueConstructor, 0 } },
    { "CSSImageValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSImageValueConstructor, 0 } },
    { "CSSStyleValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSStyleValueConstructor, 0 } },
    { "CSSUnitValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSUnitValueConstructor, 0 } },
    { "CSSUnparsedValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSUnparsedValueConstructor, 0 } },
    { "StylePropertyMapReadOnly"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_StylePropertyMapReadOnlyConstructor, 0 } },
    { "CSSMathClamp"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSMathClampConstructor, 0 } },
    { "CSSMathInvert"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSMathInvertConstructor, 0 } },
    { "CSSMathMax"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSMathMaxConstructor, 0 } },
    { "CSSMathMin"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSMathMinConstructor, 0 } },
    { "CSSMathNegate"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSMathNegateConstructor, 0 } },
    { "CSSMathProduct"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSMathProductConstructor, 0 } },
    { "CSSMathSum"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSMathSumConstructor, 0 } },
    { "CSSMathValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSMathValueConstructor, 0 } },
    { "CSSNumericArray"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSNumericArrayConstructor, 0 } },
    { "CSSMatrixComponent"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSMatrixComponentConstructor, 0 } },
    { "CSSPerspective"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSPerspectiveConstructor, 0 } },
    { "CSSRotate"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSRotateConstructor, 0 } },
    { "CSSScale"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSScaleConstructor, 0 } },
    { "CSSSkew"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSSkewConstructor, 0 } },
    { "CSSSkewX"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSSkewXConstructor, 0 } },
    { "CSSSkewY"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSSkewYConstructor, 0 } },
    { "CSSTransformComponent"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSTransformComponentConstructor, 0 } },
    { "CSSTransformValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSTransformValueConstructor, 0 } },
    { "CSSTranslate"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CSSTranslateConstructor, 0 } },
    { "AbortController"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_AbortControllerConstructor, 0 } },
    { "AbortSignal"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_AbortSignalConstructor, 0 } },
    { "CustomEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_CustomEventConstructor, 0 } },
    { "ErrorEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_ErrorEventConstructor, 0 } },
    { "Event"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_EventConstructor, 0 } },
    { "EventTarget"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_EventTargetConstructor, 0 } },
    { "PromiseRejectionEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_PromiseRejectionEventConstructor, 0 } },
    { "TextDecoder"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_TextDecoderConstructor, 0 } },
    { "TextDecoderStream"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_TextDecoderStreamConstructor, 0 } },
    { "TextEncoder"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_TextEncoderConstructor, 0 } },
    { "TextEncoderStream"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_TextEncoderStreamConstructor, 0 } },
    { "URL"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_URLConstructor, 0 } },
    { "URLSearchParams"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_URLSearchParamsConstructor, 0 } },
    { "Performance"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_PerformanceConstructor, 0 } },
    { "PerformanceEntry"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_PerformanceEntryConstructor, 0 } },
    { "PerformanceMark"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_PerformanceMarkConstructor, 0 } },
    { "PerformanceMeasure"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_PerformanceMeasureConstructor, 0 } },
    { "PerformanceObserver"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_PerformanceObserverConstructor, 0 } },
    { "PerformanceObserverEntryList"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_PerformanceObserverEntryListConstructor, 0 } },
    { "PerformanceResourceTiming"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_PerformanceResourceTimingConstructor, 0 } },
    { "PerformanceServerTiming"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScope_PerformanceServerTimingConstructor, 0 } },
    { "registerPaint"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPaintWorkletGlobalScopeInstanceFunction_registerPaint, 2 } },
};

static const HashTable JSPaintWorkletGlobalScopeTable = { 60, 255, static_cast<uint8_t>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::Function | JSC::PropertyAttribute::ReadOnly), JSPaintWorkletGlobalScope::info(), JSPaintWorkletGlobalScopeTableValues, JSPaintWorkletGlobalScopeTableIndex };
template<> const ClassInfo JSPaintWorkletGlobalScopeDOMConstructor::s_info = { "PaintWorkletGlobalScope"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPaintWorkletGlobalScopeDOMConstructor) };

template<> JSValue JSPaintWorkletGlobalScopeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSWorkletGlobalScope::getConstructor(vm, &globalObject);
}

template<> void JSPaintWorkletGlobalScopeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "PaintWorkletGlobalScope"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, globalObject.getPrototypeDirect(), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const struct CompactHashIndex JSPaintWorkletGlobalScopePrototypeTableIndex[2] = {
    { -1, -1 },
    { 0, -1 },
};


static const HashTableValue JSPaintWorkletGlobalScopePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPaintWorkletGlobalScopeConstructor, 0 } },
};

static const HashTable JSPaintWorkletGlobalScopePrototypeTable = { 1, 1, static_cast<uint8_t>(static_cast<unsigned>(PropertyAttribute::DontEnum)), JSPaintWorkletGlobalScope::info(), JSPaintWorkletGlobalScopePrototypeTableValues, JSPaintWorkletGlobalScopePrototypeTableIndex };
const ClassInfo JSPaintWorkletGlobalScopePrototype::s_info = { "PaintWorkletGlobalScope"_s, &Base::s_info, &JSPaintWorkletGlobalScopePrototypeTable, nullptr, CREATE_METHOD_TABLE(JSPaintWorkletGlobalScopePrototype) };

void JSPaintWorkletGlobalScopePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSPaintWorkletGlobalScope::s_info = { "PaintWorkletGlobalScope"_s, &Base::s_info, &JSPaintWorkletGlobalScopeTable, nullptr, CREATE_METHOD_TABLE(JSPaintWorkletGlobalScope) };

JSPaintWorkletGlobalScope::JSPaintWorkletGlobalScope(VM& vm, Structure* structure, Ref<PaintWorkletGlobalScope>&& impl)
    : JSWorkletGlobalScope(vm, structure, WTFMove(impl))
{
}

Ref<PaintWorkletGlobalScope> JSPaintWorkletGlobalScope::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, PaintWorkletGlobalScope>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

void JSPaintWorkletGlobalScope::finishCreation(VM& vm, JSGlobalProxy* proxy)
{
    Base::finishCreation(vm, proxy);

    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().compressionStreamEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CompressionStreamPublicName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_CompressionStreamConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().compressionStreamEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CompressionStreamEncoderPrivateName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_CompressionStreamEncoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().compressionStreamEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).DecompressionStreamPublicName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_DecompressionStreamConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().compressionStreamEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).DecompressionStreamDecoderPrivateName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_DecompressionStreamDecoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssPaintingAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSPaintSizePublicName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_CSSPaintSizeConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMColorEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSColorPublicName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_CSSColorConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMColorEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSColorValuePublicName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_CSSColorValueConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMColorEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSHSLPublicName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_CSSHSLConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMColorEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSHWBPublicName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_CSSHWBConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMColorEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSLCHPublicName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_CSSLCHConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMColorEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSLabPublicName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_CSSLabConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMColorEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSOKLCHPublicName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_CSSOKLCHConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMColorEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSOKLabPublicName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_CSSOKLabConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssTypedOMColorEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CSSRGBPublicName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_CSSRGBConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssPaintingAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).PaintRenderingContext2DPublicName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_PaintRenderingContext2DConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssPaintingAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).PaintWorkletGlobalScopePublicName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_PaintWorkletGlobalScopeConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableByteStreamControllerPrivateName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_ReadableByteStreamControllerConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamPrivateName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_ReadableStreamConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamBYOBReaderPrivateName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_ReadableStreamBYOBReaderConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamBYOBRequestPrivateName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_ReadableStreamBYOBRequestConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamDefaultControllerPrivateName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_ReadableStreamDefaultControllerConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamDefaultReaderPrivateName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_ReadableStreamDefaultReaderConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).TransformStreamPrivateName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_TransformStreamConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).TransformStreamDefaultControllerPrivateName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_TransformStreamDefaultControllerConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).WritableStreamPrivateName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_WritableStreamConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).WritableStreamDefaultControllerPrivateName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_WritableStreamDefaultControllerConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).WritableStreamDefaultWriterPrivateName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_WritableStreamDefaultWriterConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).AbortSignalPrivateName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScope_AbortSignalConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
}

JSValue JSPaintWorkletGlobalScope::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPaintWorkletGlobalScopeDOMConstructor, DOMConstructorID::PaintWorkletGlobalScope>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScopeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPaintWorkletGlobalScopePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPaintWorkletGlobalScope::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsPaintWorkletGlobalScope_devicePixelRatioGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.devicePixelRatio())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_devicePixelRatio, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_devicePixelRatioGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CompressionStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCompressionStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CompressionStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CompressionStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CompressionStreamEncoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCompressionStreamEncoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CompressionStreamEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CompressionStreamEncoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_DecompressionStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDecompressionStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_DecompressionStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_DecompressionStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_DecompressionStreamDecoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDecompressionStreamDecoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_DecompressionStreamDecoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_DecompressionStreamDecoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_ByteLengthQueuingStrategyConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSByteLengthQueuingStrategy::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_ByteLengthQueuingStrategyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_ByteLengthQueuingStrategyConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CountQueuingStrategyConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCountQueuingStrategy::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CountQueuingStrategyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CountQueuingStrategyConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_ReadableByteStreamControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableByteStreamController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_ReadableByteStreamControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_ReadableByteStreamControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_ReadableStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_ReadableStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_ReadableStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_ReadableStreamBYOBReaderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStreamBYOBReader::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_ReadableStreamBYOBReaderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_ReadableStreamBYOBReaderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_ReadableStreamBYOBRequestConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStreamBYOBRequest::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_ReadableStreamBYOBRequestConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_ReadableStreamBYOBRequestConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_ReadableStreamDefaultControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStreamDefaultController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_ReadableStreamDefaultControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_ReadableStreamDefaultControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_ReadableStreamDefaultReaderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStreamDefaultReader::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_ReadableStreamDefaultReaderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_ReadableStreamDefaultReaderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_TransformStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTransformStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_TransformStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_TransformStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_TransformStreamDefaultControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTransformStreamDefaultController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_TransformStreamDefaultControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_TransformStreamDefaultControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_WritableStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWritableStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_WritableStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_WritableStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_WritableStreamDefaultControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWritableStreamDefaultController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_WritableStreamDefaultControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_WritableStreamDefaultControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_WritableStreamDefaultWriterConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWritableStreamDefaultWriter::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_WritableStreamDefaultWriterConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_WritableStreamDefaultWriterConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSPaintSizeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSPaintSize::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSPaintSizeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSPaintSizeConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSKeywordValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSKeywordValue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSKeywordValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSKeywordValueConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSNumericValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSNumericValue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSNumericValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSNumericValueConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSVariableReferenceValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSOMVariableReferenceValue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSVariableReferenceValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSVariableReferenceValueConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSImageValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSStyleImageValue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSImageValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSImageValueConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSStyleValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSStyleValue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSStyleValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSStyleValueConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSUnitValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSUnitValue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSUnitValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSUnitValueConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSUnparsedValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSUnparsedValue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSUnparsedValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSUnparsedValueConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_StylePropertyMapReadOnlyConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSStylePropertyMapReadOnly::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_StylePropertyMapReadOnlyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_StylePropertyMapReadOnlyConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSColorConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSColor::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSColorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSColorConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSColorValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSColorValue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSColorValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSColorValueConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSHSLConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSHSL::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSHSLConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSHSLConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSHWBConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSHWB::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSHWBConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSHWBConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSLCHConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSLCH::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSLCHConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSLCHConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSLabConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSLab::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSLabConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSLabConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSOKLCHConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSOKLCH::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSOKLCHConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSOKLCHConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSOKLabConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSOKLab::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSOKLabConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSOKLabConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSRGBConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSRGB::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSRGBConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSRGBConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSMathClampConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSMathClamp::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSMathClampConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSMathClampConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSMathInvertConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSMathInvert::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSMathInvertConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSMathInvertConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSMathMaxConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSMathMax::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSMathMaxConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSMathMaxConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSMathMinConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSMathMin::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSMathMinConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSMathMinConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSMathNegateConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSMathNegate::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSMathNegateConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSMathNegateConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSMathProductConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSMathProduct::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSMathProductConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSMathProductConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSMathSumConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSMathSum::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSMathSumConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSMathSumConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSMathValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSMathValue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSMathValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSMathValueConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSNumericArrayConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSNumericArray::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSNumericArrayConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSNumericArrayConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSMatrixComponentConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSMatrixComponent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSMatrixComponentConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSMatrixComponentConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSPerspectiveConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSPerspective::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSPerspectiveConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSPerspectiveConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSRotateConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSRotate::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSRotateConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSRotateConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSScaleConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSScale::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSScaleConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSScaleConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSSkewConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSSkew::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSSkewConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSSkewConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSSkewXConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSSkewX::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSSkewXConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSSkewXConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSSkewYConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSSkewY::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSSkewYConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSSkewYConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSTransformComponentConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSTransformComponent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSTransformComponentConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSTransformComponentConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSTransformValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSTransformValue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSTransformValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSTransformValueConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CSSTranslateConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSTranslate::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CSSTranslateConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CSSTranslateConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_AbortControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSAbortController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_AbortControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_AbortControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_AbortSignalConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSAbortSignal::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_AbortSignalConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_AbortSignalConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_CustomEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCustomEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_CustomEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_CustomEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_ErrorEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSErrorEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_ErrorEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_ErrorEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_EventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_EventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_EventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_EventTargetConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSEventTarget::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_EventTargetConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_EventTargetConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_PromiseRejectionEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPromiseRejectionEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_PromiseRejectionEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_PromiseRejectionEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_TextDecoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextDecoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_TextDecoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_TextDecoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_TextDecoderStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextDecoderStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_TextDecoderStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_TextDecoderStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_TextEncoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextEncoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_TextEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_TextEncoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_TextEncoderStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextEncoderStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_TextEncoderStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_TextEncoderStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_URLConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDOMURL::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_URLConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_URLConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_URLSearchParamsConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSURLSearchParams::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_URLSearchParamsConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_URLSearchParamsConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_PaintRenderingContext2DConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPaintRenderingContext2D::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_PaintRenderingContext2DConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_PaintRenderingContext2DConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_PerformanceConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformance::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_PerformanceConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_PerformanceConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_PerformanceEntryConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceEntry::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_PerformanceEntryConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_PerformanceEntryConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_PerformanceMarkConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceMark::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_PerformanceMarkConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_PerformanceMarkConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_PerformanceMeasureConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceMeasure::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_PerformanceMeasureConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_PerformanceMeasureConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_PerformanceObserverConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceObserver::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_PerformanceObserverConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_PerformanceObserverConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_PerformanceObserverEntryListConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceObserverEntryList::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_PerformanceObserverEntryListConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_PerformanceObserverEntryListConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_PerformanceResourceTimingConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceResourceTiming::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_PerformanceResourceTimingConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_PerformanceResourceTimingConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_PerformanceServerTimingConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceServerTiming::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_PerformanceServerTimingConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_PerformanceServerTimingConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPaintWorkletGlobalScope_PaintWorkletGlobalScopeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPaintWorkletGlobalScope::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsPaintWorkletGlobalScope_PaintWorkletGlobalScopeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScope_PaintWorkletGlobalScopeConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsPaintWorkletGlobalScopeInstanceFunction_registerPaintBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintWorkletGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto nameConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(nameConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto paintConstructorConversionResult = convert<IDLObject>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(paintConstructorConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.registerPaint(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), nameConversionResult.releaseReturnValue(), paintConstructorConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsPaintWorkletGlobalScopeInstanceFunction_registerPaint, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPaintWorkletGlobalScope>::call<jsPaintWorkletGlobalScopeInstanceFunction_registerPaintBody>(*lexicalGlobalObject, *callFrame, "registerPaint");
}

JSC::GCClient::IsoSubspace* JSPaintWorkletGlobalScope::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSPaintWorkletGlobalScope, UseCustomHeapCellType::Yes>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForPaintWorkletGlobalScope.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForPaintWorkletGlobalScope = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForPaintWorkletGlobalScope.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForPaintWorkletGlobalScope = std::forward<decltype(space)>(space); },
        [] (auto& server) -> JSC::HeapCellType& { return server.m_heapCellTypeForJSPaintWorkletGlobalScope; }
    );
}

template<typename Visitor>
void JSPaintWorkletGlobalScope::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSPaintWorkletGlobalScope*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSPaintWorkletGlobalScope);

template<typename Visitor>
void JSPaintWorkletGlobalScope::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSPaintWorkletGlobalScope*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSPaintWorkletGlobalScope::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSPaintWorkletGlobalScope::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSPaintWorkletGlobalScope::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPaintWorkletGlobalScope*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

PaintWorkletGlobalScope* JSPaintWorkletGlobalScope::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPaintWorkletGlobalScope*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
