/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MATHML)

#include "JSMathMLElement.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "Document.h"
#include "ElementInlines.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "HTMLNames.h"
#include "IDLTypes.h"
#include "JSCSSStyleDeclaration.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMStringMap.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSFocusOptions.h"
#include "JSStylePropertyMap.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsMathMLElementPrototypeFunction_focus);
static JSC_DECLARE_HOST_FUNCTION(jsMathMLElementPrototypeFunction_blur);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_style);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_style);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_attributeStyleMap);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onbeforecopy);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onbeforecopy);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onbeforecut);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onbeforecut);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onbeforeinput);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onbeforeinput);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onbeforepaste);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onbeforepaste);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onabort);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onabort);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onauxclick);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onauxclick);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onbeforetoggle);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onbeforetoggle);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onblur);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onblur);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_oncancel);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_oncancel);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_oncanplay);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_oncanplay);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_oncanplaythrough);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_oncanplaythrough);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onchange);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onclick);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onclick);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onclose);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onclose);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_oncontentvisibilityautostatechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_oncontentvisibilityautostatechange);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_oncontextmenu);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_oncontextmenu);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_oncopy);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_oncopy);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_oncuechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_oncuechange);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_oncut);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_oncut);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_ondblclick);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_ondblclick);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_ondrag);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_ondrag);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_ondragend);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_ondragend);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_ondragenter);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_ondragenter);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_ondragleave);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_ondragleave);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_ondragover);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_ondragover);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_ondragstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_ondragstart);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_ondrop);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_ondrop);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_ondurationchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_ondurationchange);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onemptied);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onemptied);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onended);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onended);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onerror);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onerror);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onfocus);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onfocus);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onformdata);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onformdata);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_oninput);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_oninput);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_oninvalid);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_oninvalid);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onkeydown);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onkeydown);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onkeypress);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onkeypress);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onkeyup);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onkeyup);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onload);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onload);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onloadeddata);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onloadeddata);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onloadedmetadata);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onloadedmetadata);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onloadstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onloadstart);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onmousedown);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onmousedown);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onmouseenter);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onmouseenter);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onmouseleave);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onmouseleave);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onmousemove);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onmousemove);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onmouseout);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onmouseout);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onmouseover);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onmouseover);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onmouseup);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onmouseup);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onpaste);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onpaste);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onpause);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onpause);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onplay);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onplay);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onplaying);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onplaying);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onprogress);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onprogress);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onratechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onratechange);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onreset);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onreset);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onresize);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onresize);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onscroll);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onscroll);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onsecuritypolicyviolation);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onsecuritypolicyviolation);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onseeked);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onseeked);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onseeking);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onseeking);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onselect);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onselect);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onslotchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onslotchange);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onstalled);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onstalled);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onsubmit);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onsubmit);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onsuspend);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onsuspend);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_ontimeupdate);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_ontimeupdate);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_ontoggle);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_ontoggle);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onvolumechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onvolumechange);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onwaiting);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onwaiting);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onwebkitanimationend);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onwebkitanimationend);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onwebkitanimationiteration);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onwebkitanimationiteration);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onwebkitanimationstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onwebkitanimationstart);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onwebkittransitionend);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onwebkittransitionend);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onwheel);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onwheel);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onmousewheel);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onmousewheel);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onsearch);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onsearch);
#if ENABLE(TOUCH_EVENTS)
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_ontouchcancel);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_ontouchcancel);
#endif
#if ENABLE(TOUCH_EVENTS)
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_ontouchend);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_ontouchend);
#endif
#if ENABLE(TOUCH_EVENTS)
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_ontouchmove);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_ontouchmove);
#endif
#if ENABLE(TOUCH_EVENTS)
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_ontouchstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_ontouchstart);
#endif
#if ENABLE(TOUCH_EVENTS)
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_ontouchforcechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_ontouchforcechange);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onwebkitmouseforcechanged);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onwebkitmouseforcechanged);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onwebkitmouseforcedown);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onwebkitmouseforcedown);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onwebkitmouseforcewillbegin);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onwebkitmouseforcewillbegin);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onwebkitmouseforceup);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onwebkitmouseforceup);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onanimationstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onanimationstart);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onanimationiteration);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onanimationiteration);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onanimationend);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onanimationend);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onanimationcancel);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onanimationcancel);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_ontransitionrun);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_ontransitionrun);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_ontransitionstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_ontransitionstart);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_ontransitionend);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_ontransitionend);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_ontransitioncancel);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_ontransitioncancel);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_ongotpointercapture);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_ongotpointercapture);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onlostpointercapture);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onlostpointercapture);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onpointerdown);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onpointerdown);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onpointermove);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onpointermove);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onpointerup);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onpointerup);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onpointercancel);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onpointercancel);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onpointerover);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onpointerover);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onpointerout);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onpointerout);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onpointerenter);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onpointerenter);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onpointerleave);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onpointerleave);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onselectstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onselectstart);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_onselectionchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_onselectionchange);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_dataset);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_nonce);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_nonce);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_autofocus);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_autofocus);
static JSC_DECLARE_CUSTOM_GETTER(jsMathMLElement_tabIndex);
static JSC_DECLARE_CUSTOM_SETTER(setJSMathMLElement_tabIndex);

class JSMathMLElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMathMLElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMathMLElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSMathMLElementPrototype>(vm)) JSMathMLElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMathMLElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMathMLElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMathMLElementPrototype, JSMathMLElementPrototype::Base);

using JSMathMLElementDOMConstructor = JSDOMConstructorNotConstructable<JSMathMLElement>;

template<> const ClassInfo JSMathMLElementDOMConstructor::s_info = { "MathMLElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMathMLElementDOMConstructor) };

template<> JSValue JSMathMLElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSElement::getConstructor(vm, &globalObject);
}

template<> void JSMathMLElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "MathMLElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSMathMLElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSMathMLElementPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElementConstructor, 0 } },
    { "style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_style, setJSMathMLElement_style } },
    { "attributeStyleMap"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_attributeStyleMap, 0 } },
    { "onbeforecopy"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onbeforecopy, setJSMathMLElement_onbeforecopy } },
    { "onbeforecut"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onbeforecut, setJSMathMLElement_onbeforecut } },
    { "onbeforeinput"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onbeforeinput, setJSMathMLElement_onbeforeinput } },
    { "onbeforepaste"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onbeforepaste, setJSMathMLElement_onbeforepaste } },
    { "onabort"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onabort, setJSMathMLElement_onabort } },
    { "onauxclick"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onauxclick, setJSMathMLElement_onauxclick } },
    { "onbeforetoggle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onbeforetoggle, setJSMathMLElement_onbeforetoggle } },
    { "onblur"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onblur, setJSMathMLElement_onblur } },
    { "oncancel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_oncancel, setJSMathMLElement_oncancel } },
    { "oncanplay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_oncanplay, setJSMathMLElement_oncanplay } },
    { "oncanplaythrough"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_oncanplaythrough, setJSMathMLElement_oncanplaythrough } },
    { "onchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onchange, setJSMathMLElement_onchange } },
    { "onclick"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onclick, setJSMathMLElement_onclick } },
    { "onclose"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onclose, setJSMathMLElement_onclose } },
    { "oncontentvisibilityautostatechange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_oncontentvisibilityautostatechange, setJSMathMLElement_oncontentvisibilityautostatechange } },
    { "oncontextmenu"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_oncontextmenu, setJSMathMLElement_oncontextmenu } },
    { "oncopy"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_oncopy, setJSMathMLElement_oncopy } },
    { "oncuechange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_oncuechange, setJSMathMLElement_oncuechange } },
    { "oncut"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_oncut, setJSMathMLElement_oncut } },
    { "ondblclick"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_ondblclick, setJSMathMLElement_ondblclick } },
    { "ondrag"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_ondrag, setJSMathMLElement_ondrag } },
    { "ondragend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_ondragend, setJSMathMLElement_ondragend } },
    { "ondragenter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_ondragenter, setJSMathMLElement_ondragenter } },
    { "ondragleave"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_ondragleave, setJSMathMLElement_ondragleave } },
    { "ondragover"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_ondragover, setJSMathMLElement_ondragover } },
    { "ondragstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_ondragstart, setJSMathMLElement_ondragstart } },
    { "ondrop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_ondrop, setJSMathMLElement_ondrop } },
    { "ondurationchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_ondurationchange, setJSMathMLElement_ondurationchange } },
    { "onemptied"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onemptied, setJSMathMLElement_onemptied } },
    { "onended"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onended, setJSMathMLElement_onended } },
    { "onerror"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onerror, setJSMathMLElement_onerror } },
    { "onfocus"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onfocus, setJSMathMLElement_onfocus } },
    { "onformdata"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onformdata, setJSMathMLElement_onformdata } },
    { "oninput"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_oninput, setJSMathMLElement_oninput } },
    { "oninvalid"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_oninvalid, setJSMathMLElement_oninvalid } },
    { "onkeydown"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onkeydown, setJSMathMLElement_onkeydown } },
    { "onkeypress"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onkeypress, setJSMathMLElement_onkeypress } },
    { "onkeyup"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onkeyup, setJSMathMLElement_onkeyup } },
    { "onload"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onload, setJSMathMLElement_onload } },
    { "onloadeddata"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onloadeddata, setJSMathMLElement_onloadeddata } },
    { "onloadedmetadata"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onloadedmetadata, setJSMathMLElement_onloadedmetadata } },
    { "onloadstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onloadstart, setJSMathMLElement_onloadstart } },
    { "onmousedown"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onmousedown, setJSMathMLElement_onmousedown } },
    { "onmouseenter"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onmouseenter, setJSMathMLElement_onmouseenter } },
    { "onmouseleave"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onmouseleave, setJSMathMLElement_onmouseleave } },
    { "onmousemove"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onmousemove, setJSMathMLElement_onmousemove } },
    { "onmouseout"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onmouseout, setJSMathMLElement_onmouseout } },
    { "onmouseover"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onmouseover, setJSMathMLElement_onmouseover } },
    { "onmouseup"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onmouseup, setJSMathMLElement_onmouseup } },
    { "onpaste"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onpaste, setJSMathMLElement_onpaste } },
    { "onpause"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onpause, setJSMathMLElement_onpause } },
    { "onplay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onplay, setJSMathMLElement_onplay } },
    { "onplaying"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onplaying, setJSMathMLElement_onplaying } },
    { "onprogress"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onprogress, setJSMathMLElement_onprogress } },
    { "onratechange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onratechange, setJSMathMLElement_onratechange } },
    { "onreset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onreset, setJSMathMLElement_onreset } },
    { "onresize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onresize, setJSMathMLElement_onresize } },
    { "onscroll"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onscroll, setJSMathMLElement_onscroll } },
    { "onsecuritypolicyviolation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onsecuritypolicyviolation, setJSMathMLElement_onsecuritypolicyviolation } },
    { "onseeked"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onseeked, setJSMathMLElement_onseeked } },
    { "onseeking"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onseeking, setJSMathMLElement_onseeking } },
    { "onselect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onselect, setJSMathMLElement_onselect } },
    { "onslotchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onslotchange, setJSMathMLElement_onslotchange } },
    { "onstalled"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onstalled, setJSMathMLElement_onstalled } },
    { "onsubmit"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onsubmit, setJSMathMLElement_onsubmit } },
    { "onsuspend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onsuspend, setJSMathMLElement_onsuspend } },
    { "ontimeupdate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_ontimeupdate, setJSMathMLElement_ontimeupdate } },
    { "ontoggle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_ontoggle, setJSMathMLElement_ontoggle } },
    { "onvolumechange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onvolumechange, setJSMathMLElement_onvolumechange } },
    { "onwaiting"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onwaiting, setJSMathMLElement_onwaiting } },
    { "onwebkitanimationend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onwebkitanimationend, setJSMathMLElement_onwebkitanimationend } },
    { "onwebkitanimationiteration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onwebkitanimationiteration, setJSMathMLElement_onwebkitanimationiteration } },
    { "onwebkitanimationstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onwebkitanimationstart, setJSMathMLElement_onwebkitanimationstart } },
    { "onwebkittransitionend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onwebkittransitionend, setJSMathMLElement_onwebkittransitionend } },
    { "onwheel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onwheel, setJSMathMLElement_onwheel } },
    { "onmousewheel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onmousewheel, setJSMathMLElement_onmousewheel } },
    { "onsearch"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onsearch, setJSMathMLElement_onsearch } },
#if ENABLE(TOUCH_EVENTS)
    { "ontouchcancel"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_ontouchcancel, setJSMathMLElement_ontouchcancel } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchend"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_ontouchend, setJSMathMLElement_ontouchend } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchmove"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_ontouchmove, setJSMathMLElement_ontouchmove } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchstart"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_ontouchstart, setJSMathMLElement_ontouchstart } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchforcechange"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_ontouchforcechange, setJSMathMLElement_ontouchforcechange } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "onwebkitmouseforcechanged"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onwebkitmouseforcechanged, setJSMathMLElement_onwebkitmouseforcechanged } },
    { "onwebkitmouseforcedown"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onwebkitmouseforcedown, setJSMathMLElement_onwebkitmouseforcedown } },
    { "onwebkitmouseforcewillbegin"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onwebkitmouseforcewillbegin, setJSMathMLElement_onwebkitmouseforcewillbegin } },
    { "onwebkitmouseforceup"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onwebkitmouseforceup, setJSMathMLElement_onwebkitmouseforceup } },
    { "onanimationstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onanimationstart, setJSMathMLElement_onanimationstart } },
    { "onanimationiteration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onanimationiteration, setJSMathMLElement_onanimationiteration } },
    { "onanimationend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onanimationend, setJSMathMLElement_onanimationend } },
    { "onanimationcancel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onanimationcancel, setJSMathMLElement_onanimationcancel } },
    { "ontransitionrun"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_ontransitionrun, setJSMathMLElement_ontransitionrun } },
    { "ontransitionstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_ontransitionstart, setJSMathMLElement_ontransitionstart } },
    { "ontransitionend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_ontransitionend, setJSMathMLElement_ontransitionend } },
    { "ontransitioncancel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_ontransitioncancel, setJSMathMLElement_ontransitioncancel } },
    { "ongotpointercapture"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_ongotpointercapture, setJSMathMLElement_ongotpointercapture } },
    { "onlostpointercapture"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onlostpointercapture, setJSMathMLElement_onlostpointercapture } },
    { "onpointerdown"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onpointerdown, setJSMathMLElement_onpointerdown } },
    { "onpointermove"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onpointermove, setJSMathMLElement_onpointermove } },
    { "onpointerup"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onpointerup, setJSMathMLElement_onpointerup } },
    { "onpointercancel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onpointercancel, setJSMathMLElement_onpointercancel } },
    { "onpointerover"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onpointerover, setJSMathMLElement_onpointerover } },
    { "onpointerout"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onpointerout, setJSMathMLElement_onpointerout } },
    { "onpointerenter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onpointerenter, setJSMathMLElement_onpointerenter } },
    { "onpointerleave"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onpointerleave, setJSMathMLElement_onpointerleave } },
    { "onselectstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onselectstart, setJSMathMLElement_onselectstart } },
    { "onselectionchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_onselectionchange, setJSMathMLElement_onselectionchange } },
    { "dataset"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_dataset, 0 } },
    { "nonce"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_nonce, setJSMathMLElement_nonce } },
    { "autofocus"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_autofocus, setJSMathMLElement_autofocus } },
    { "tabIndex"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLElement_tabIndex, setJSMathMLElement_tabIndex } },
    { "focus"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMathMLElementPrototypeFunction_focus, 0 } },
    { "blur"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMathMLElementPrototypeFunction_blur, 0 } },
};

const ClassInfo JSMathMLElementPrototype::s_info = { "MathMLElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMathMLElementPrototype) };

void JSMathMLElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMathMLElement::info(), JSMathMLElementPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().searchInputIncrementalAttributeAndSearchEventEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "onsearch"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#if ENABLE(TOUCH_EVENTS)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().touchEventsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "ontouchcancel"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().touchEventsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "ontouchend"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().touchEventsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "ontouchmove"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().touchEventsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "ontouchstart"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().touchEventsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "ontouchforcechange"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSMathMLElement::s_info = { "MathMLElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMathMLElement) };

JSMathMLElement::JSMathMLElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MathMLElement>&& impl)
    : JSElement(structure, globalObject, WTFMove(impl))
{
}

Ref<MathMLElement> JSMathMLElement::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSMathMLElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSMathMLElementPrototype::createStructure(vm, &globalObject, JSElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSMathMLElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSMathMLElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMathMLElement>(vm, globalObject);
}

JSValue JSMathMLElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMathMLElementDOMConstructor, DOMConstructorID::MathMLElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMathMLElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMathMLElement::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsMathMLElement_styleGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<CSSStyleDeclaration>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.cssomStyle())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_style, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_styleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_styleSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto id = Identifier::fromString(vm, "style"_s);
    auto valueToForwardTo = thisObject.get(&lexicalGlobalObject, id);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!valueToForwardTo.isObject())) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return false;
    }
    auto forwardId = Identifier::fromString(vm, "cssText"_s);
    PutPropertySlot slot(valueToForwardTo, false);
    asObject(valueToForwardTo)->methodTable()->put(asObject(valueToForwardTo), &lexicalGlobalObject, forwardId, value, slot);
    RETURN_IF_EXCEPTION(throwScope, false);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_style, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_styleSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_attributeStyleMapGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    if (JSValue cachedValue = thisObject.m_attributeStyleMap.get())
        return cachedValue;
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<StylePropertyMap>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ensureAttributeStyleMap());
    RETURN_IF_EXCEPTION(throwScope, { });
    thisObject.m_attributeStyleMap.set(JSC::getVM(&lexicalGlobalObject), &thisObject, result);
    return result;
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_attributeStyleMap, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_attributeStyleMapGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMathMLElement_onbeforecopyGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().beforecopyEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onbeforecopy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onbeforecopyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onbeforecopySetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().beforecopyEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onbeforecopy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onbeforecopySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onbeforecutGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().beforecutEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onbeforecut, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onbeforecutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onbeforecutSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().beforecutEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onbeforecut, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onbeforecutSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onbeforeinputGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().beforeinputEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onbeforeinput, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onbeforeinputGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onbeforeinputSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().beforeinputEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onbeforeinput, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onbeforeinputSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onbeforepasteGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().beforepasteEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onbeforepaste, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onbeforepasteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onbeforepasteSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().beforepasteEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onbeforepaste, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onbeforepasteSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onabortGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().abortEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onabort, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onabortGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onabortSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().abortEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onabort, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onabortSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onauxclickGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().auxclickEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onauxclick, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onauxclickGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onauxclickSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().auxclickEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onauxclick, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onauxclickSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onbeforetoggleGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().beforetoggleEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onbeforetoggle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onbeforetoggleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onbeforetoggleSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().beforetoggleEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onbeforetoggle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onbeforetoggleSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onblurGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().blurEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onblur, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onblurGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onblurSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().blurEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onblur, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onblurSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_oncancelGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().cancelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_oncancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_oncancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_oncancelSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().cancelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_oncancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_oncancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_oncanplayGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().canplayEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_oncanplay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_oncanplayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_oncanplaySetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().canplayEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_oncanplay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_oncanplaySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_oncanplaythroughGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().canplaythroughEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_oncanplaythrough, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_oncanplaythroughGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_oncanplaythroughSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().canplaythroughEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_oncanplaythrough, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_oncanplaythroughSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onchangeGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().changeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onchangeSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().changeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onclickGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().clickEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onclick, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onclickGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onclickSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().clickEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onclick, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onclickSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_oncloseGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().closeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onclose, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_oncloseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_oncloseSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().closeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onclose, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_oncloseSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_oncontentvisibilityautostatechangeGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().contentvisibilityautostatechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_oncontentvisibilityautostatechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_oncontentvisibilityautostatechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_oncontentvisibilityautostatechangeSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().contentvisibilityautostatechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_oncontentvisibilityautostatechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_oncontentvisibilityautostatechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_oncontextmenuGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().contextmenuEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_oncontextmenu, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_oncontextmenuGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_oncontextmenuSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().contextmenuEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_oncontextmenu, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_oncontextmenuSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_oncopyGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().copyEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_oncopy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_oncopyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_oncopySetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().copyEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_oncopy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_oncopySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_oncuechangeGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().cuechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_oncuechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_oncuechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_oncuechangeSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().cuechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_oncuechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_oncuechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_oncutGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().cutEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_oncut, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_oncutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_oncutSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().cutEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_oncut, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_oncutSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_ondblclickGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dblclickEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_ondblclick, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_ondblclickGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_ondblclickSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dblclickEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_ondblclick, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_ondblclickSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_ondragGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dragEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_ondrag, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_ondragGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_ondragSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dragEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_ondrag, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_ondragSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_ondragendGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dragendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_ondragend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_ondragendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_ondragendSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dragendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_ondragend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_ondragendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_ondragenterGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dragenterEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_ondragenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_ondragenterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_ondragenterSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dragenterEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_ondragenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_ondragenterSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_ondragleaveGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dragleaveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_ondragleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_ondragleaveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_ondragleaveSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dragleaveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_ondragleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_ondragleaveSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_ondragoverGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dragoverEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_ondragover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_ondragoverGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_ondragoverSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dragoverEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_ondragover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_ondragoverSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_ondragstartGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dragstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_ondragstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_ondragstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_ondragstartSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dragstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_ondragstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_ondragstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_ondropGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dropEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_ondrop, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_ondropGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_ondropSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dropEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_ondrop, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_ondropSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_ondurationchangeGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().durationchangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_ondurationchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_ondurationchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_ondurationchangeSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().durationchangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_ondurationchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_ondurationchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onemptiedGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().emptiedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onemptied, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onemptiedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onemptiedSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().emptiedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onemptied, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onemptiedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onendedGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().endedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onended, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onendedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onendedSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().endedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onended, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onendedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onerrorGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onerrorSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().errorEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onfocusGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().focusEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onfocus, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onfocusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onfocusSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().focusEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onfocus, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onfocusSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onformdataGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().formdataEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onformdata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onformdataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onformdataSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().formdataEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onformdata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onformdataSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_oninputGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().inputEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_oninput, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_oninputGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_oninputSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().inputEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_oninput, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_oninputSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_oninvalidGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().invalidEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_oninvalid, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_oninvalidGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_oninvalidSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().invalidEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_oninvalid, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_oninvalidSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onkeydownGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().keydownEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onkeydown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onkeydownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onkeydownSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().keydownEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onkeydown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onkeydownSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onkeypressGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().keypressEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onkeypress, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onkeypressGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onkeypressSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().keypressEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onkeypress, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onkeypressSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onkeyupGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().keyupEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onkeyup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onkeyupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onkeyupSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().keyupEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onkeyup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onkeyupSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onloadGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().loadEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onloadSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().loadEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onloadeddataGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().loadeddataEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onloadeddata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onloadeddataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onloadeddataSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().loadeddataEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onloadeddata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onloadeddataSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onloadedmetadataGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().loadedmetadataEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onloadedmetadata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onloadedmetadataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onloadedmetadataSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().loadedmetadataEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onloadedmetadata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onloadedmetadataSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onloadstartGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().loadstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onloadstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onloadstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onloadstartSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().loadstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onloadstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onloadstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onmousedownGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mousedownEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onmousedown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onmousedownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onmousedownSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mousedownEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onmousedown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onmousedownSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onmouseenterGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mouseenterEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onmouseenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onmouseenterGetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onmouseenterSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mouseenterEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onmouseenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onmouseenterSetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onmouseleaveGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mouseleaveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onmouseleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onmouseleaveGetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onmouseleaveSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mouseleaveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onmouseleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onmouseleaveSetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onmousemoveGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mousemoveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onmousemove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onmousemoveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onmousemoveSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mousemoveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onmousemove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onmousemoveSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onmouseoutGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mouseoutEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onmouseout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onmouseoutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onmouseoutSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mouseoutEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onmouseout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onmouseoutSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onmouseoverGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mouseoverEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onmouseover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onmouseoverGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onmouseoverSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mouseoverEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onmouseover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onmouseoverSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onmouseupGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mouseupEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onmouseup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onmouseupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onmouseupSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mouseupEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onmouseup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onmouseupSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onpasteGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pasteEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onpaste, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onpasteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onpasteSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pasteEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onpaste, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onpasteSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onpauseGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pauseEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onpause, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onpauseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onpauseSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pauseEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onpause, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onpauseSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onplayGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().playEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onplay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onplayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onplaySetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().playEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onplay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onplaySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onplayingGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().playingEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onplaying, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onplayingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onplayingSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().playingEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onplaying, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onplayingSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onprogressGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().progressEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onprogress, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onprogressGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onprogressSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().progressEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onprogress, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onprogressSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onratechangeGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().ratechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onratechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onratechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onratechangeSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().ratechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onratechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onratechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onresetGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().resetEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onreset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onresetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onresetSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().resetEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onreset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onresetSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onresizeGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().resizeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onresize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onresizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onresizeSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().resizeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onresize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onresizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onscrollGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().scrollEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onscroll, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onscrollGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onscrollSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().scrollEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onscroll, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onscrollSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onsecuritypolicyviolationGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().securitypolicyviolationEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onsecuritypolicyviolation, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onsecuritypolicyviolationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onsecuritypolicyviolationSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().securitypolicyviolationEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onsecuritypolicyviolation, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onsecuritypolicyviolationSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onseekedGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().seekedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onseeked, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onseekedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onseekedSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().seekedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onseeked, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onseekedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onseekingGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().seekingEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onseeking, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onseekingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onseekingSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().seekingEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onseeking, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onseekingSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onselectGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().selectEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onselect, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onselectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onselectSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().selectEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onselect, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onselectSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onslotchangeGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().slotchangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onslotchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onslotchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onslotchangeSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().slotchangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onslotchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onslotchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onstalledGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().stalledEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onstalled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onstalledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onstalledSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().stalledEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onstalled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onstalledSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onsubmitGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().submitEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onsubmit, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onsubmitGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onsubmitSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().submitEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onsubmit, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onsubmitSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onsuspendGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().suspendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onsuspend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onsuspendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onsuspendSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().suspendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onsuspend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onsuspendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_ontimeupdateGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().timeupdateEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_ontimeupdate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_ontimeupdateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_ontimeupdateSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().timeupdateEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_ontimeupdate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_ontimeupdateSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_ontoggleGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().toggleEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_ontoggle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_ontoggleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_ontoggleSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().toggleEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_ontoggle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_ontoggleSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onvolumechangeGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().volumechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onvolumechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onvolumechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onvolumechangeSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().volumechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onvolumechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onvolumechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onwaitingGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().waitingEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onwaiting, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onwaitingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onwaitingSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().waitingEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onwaiting, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onwaitingSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onwebkitanimationendGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitAnimationEndEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onwebkitanimationend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onwebkitanimationendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onwebkitanimationendSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitAnimationEndEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onwebkitanimationend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onwebkitanimationendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onwebkitanimationiterationGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitAnimationIterationEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onwebkitanimationiteration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onwebkitanimationiterationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onwebkitanimationiterationSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitAnimationIterationEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onwebkitanimationiteration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onwebkitanimationiterationSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onwebkitanimationstartGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitAnimationStartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onwebkitanimationstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onwebkitanimationstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onwebkitanimationstartSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitAnimationStartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onwebkitanimationstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onwebkitanimationstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onwebkittransitionendGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitTransitionEndEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onwebkittransitionend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onwebkittransitionendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onwebkittransitionendSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitTransitionEndEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onwebkittransitionend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onwebkittransitionendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onwheelGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().wheelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onwheel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onwheelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onwheelSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().wheelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onwheel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onwheelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onmousewheelGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mousewheelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onmousewheel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onmousewheelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onmousewheelSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mousewheelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onmousewheel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onmousewheelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onsearchGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().searchEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onsearch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onsearchGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onsearchSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().searchEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onsearch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onsearchSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsMathMLElement_ontouchcancelGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().touchcancelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_ontouchcancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_ontouchcancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSMathMLElement_ontouchcancelSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().touchcancelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_ontouchcancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_ontouchcancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsMathMLElement_ontouchendGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().touchendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_ontouchend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_ontouchendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSMathMLElement_ontouchendSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().touchendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_ontouchend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_ontouchendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsMathMLElement_ontouchmoveGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().touchmoveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_ontouchmove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_ontouchmoveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSMathMLElement_ontouchmoveSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().touchmoveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_ontouchmove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_ontouchmoveSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsMathMLElement_ontouchstartGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().touchstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_ontouchstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_ontouchstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSMathMLElement_ontouchstartSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().touchstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_ontouchstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_ontouchstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsMathMLElement_ontouchforcechangeGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().touchforcechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_ontouchforcechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_ontouchforcechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSMathMLElement_ontouchforcechangeSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().touchforcechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_ontouchforcechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_ontouchforcechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

static inline JSValue jsMathMLElement_onwebkitmouseforcechangedGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitmouseforcechangedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onwebkitmouseforcechanged, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onwebkitmouseforcechangedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onwebkitmouseforcechangedSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitmouseforcechangedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onwebkitmouseforcechanged, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onwebkitmouseforcechangedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onwebkitmouseforcedownGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitmouseforcedownEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onwebkitmouseforcedown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onwebkitmouseforcedownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onwebkitmouseforcedownSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitmouseforcedownEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onwebkitmouseforcedown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onwebkitmouseforcedownSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onwebkitmouseforcewillbeginGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitmouseforcewillbeginEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onwebkitmouseforcewillbegin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onwebkitmouseforcewillbeginGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onwebkitmouseforcewillbeginSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitmouseforcewillbeginEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onwebkitmouseforcewillbegin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onwebkitmouseforcewillbeginSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onwebkitmouseforceupGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitmouseforceupEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onwebkitmouseforceup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onwebkitmouseforceupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onwebkitmouseforceupSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitmouseforceupEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onwebkitmouseforceup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onwebkitmouseforceupSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onanimationstartGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().animationstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onanimationstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onanimationstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onanimationstartSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().animationstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onanimationstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onanimationstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onanimationiterationGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().animationiterationEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onanimationiteration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onanimationiterationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onanimationiterationSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().animationiterationEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onanimationiteration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onanimationiterationSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onanimationendGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().animationendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onanimationend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onanimationendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onanimationendSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().animationendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onanimationend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onanimationendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onanimationcancelGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().animationcancelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onanimationcancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onanimationcancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onanimationcancelSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().animationcancelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onanimationcancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onanimationcancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_ontransitionrunGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().transitionrunEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_ontransitionrun, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_ontransitionrunGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_ontransitionrunSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().transitionrunEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_ontransitionrun, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_ontransitionrunSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_ontransitionstartGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().transitionstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_ontransitionstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_ontransitionstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_ontransitionstartSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().transitionstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_ontransitionstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_ontransitionstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_ontransitionendGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().transitionendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_ontransitionend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_ontransitionendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_ontransitionendSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().transitionendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_ontransitionend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_ontransitionendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_ontransitioncancelGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().transitioncancelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_ontransitioncancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_ontransitioncancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_ontransitioncancelSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().transitioncancelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_ontransitioncancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_ontransitioncancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_ongotpointercaptureGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().gotpointercaptureEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_ongotpointercapture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_ongotpointercaptureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_ongotpointercaptureSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().gotpointercaptureEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_ongotpointercapture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_ongotpointercaptureSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onlostpointercaptureGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().lostpointercaptureEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onlostpointercapture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onlostpointercaptureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onlostpointercaptureSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().lostpointercaptureEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onlostpointercapture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onlostpointercaptureSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onpointerdownGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointerdownEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onpointerdown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onpointerdownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onpointerdownSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointerdownEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onpointerdown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onpointerdownSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onpointermoveGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointermoveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onpointermove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onpointermoveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onpointermoveSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointermoveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onpointermove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onpointermoveSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onpointerupGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointerupEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onpointerup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onpointerupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onpointerupSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointerupEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onpointerup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onpointerupSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onpointercancelGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointercancelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onpointercancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onpointercancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onpointercancelSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointercancelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onpointercancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onpointercancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onpointeroverGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointeroverEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onpointerover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onpointeroverGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onpointeroverSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointeroverEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onpointerover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onpointeroverSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onpointeroutGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointeroutEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onpointerout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onpointeroutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onpointeroutSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointeroutEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onpointerout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onpointeroutSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onpointerenterGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointerenterEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onpointerenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onpointerenterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onpointerenterSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointerenterEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onpointerenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onpointerenterSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onpointerleaveGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointerleaveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onpointerleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onpointerleaveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onpointerleaveSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointerleaveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onpointerleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onpointerleaveSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onselectstartGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().selectstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onselectstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onselectstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onselectstartSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().selectstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onselectstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onselectstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_onselectionchangeGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().selectionchangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_onselectionchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_onselectionchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_onselectionchangeSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().selectionchangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_onselectionchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_onselectionchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_datasetGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DOMStringMap>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.dataset())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_dataset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_datasetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMathMLElement_nonceGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.nonce())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_nonce, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_nonceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_nonceSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setNonce(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_nonce, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_nonceSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_autofocusGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::autofocusAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_autofocus, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_autofocusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_autofocusSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLBoolean>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::autofocusAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_autofocus, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_autofocusSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMathMLElement_tabIndexGetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.tabIndexForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLElement_tabIndex, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::get<jsMathMLElement_tabIndexGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMathMLElement_tabIndexSetter(JSGlobalObject& lexicalGlobalObject, JSMathMLElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLong>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setTabIndexForBindings(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMathMLElement_tabIndex, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMathMLElement>::set<setJSMathMLElement_tabIndexSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsMathMLElementPrototypeFunction_focusBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMathMLElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto optionsConversionResult = convert<IDLDictionary<FocusOptions>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(optionsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.focusForBindings(optionsConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMathMLElementPrototypeFunction_focus, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMathMLElement>::call<jsMathMLElementPrototypeFunction_focusBody>(*lexicalGlobalObject, *callFrame, "focus");
}

static inline JSC::EncodedJSValue jsMathMLElementPrototypeFunction_blurBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMathMLElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.blur(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMathMLElementPrototypeFunction_blur, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMathMLElement>::call<jsMathMLElementPrototypeFunction_blurBody>(*lexicalGlobalObject, *callFrame, "blur");
}

JSC::GCClient::IsoSubspace* JSMathMLElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSMathMLElement, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForMathMLElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForMathMLElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForMathMLElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForMathMLElement = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSMathMLElement::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSMathMLElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    visitor.append(thisObject->m_attributeStyleMap);
}

DEFINE_VISIT_CHILDREN(JSMathMLElement);

void JSMathMLElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMathMLElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

MathMLElement* JSMathMLElement::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMathMLElement*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MATHML)
