/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUSamplerDescriptor.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSGPUAddressMode.h"
#include "JSGPUCompareFunction.h"
#include "JSGPUFilterMode.h"
#include "JSGPUMipmapFilterMode.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUSamplerDescriptor>> convertDictionary<GPUSamplerDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUSamplerDescriptor result;
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!labelValue.isUndefined()) {
        auto labelConversionResult = convert<IDLUSVString>(lexicalGlobalObject, labelValue);
        if (UNLIKELY(labelConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.label = labelConversionResult.releaseReturnValue();
    }
    JSValue addressModeUValue;
    if (isNullOrUndefined)
        addressModeUValue = jsUndefined();
    else {
        addressModeUValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "addressModeU"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto addressModeUConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUAddressMode>>(lexicalGlobalObject, addressModeUValue, [&]() -> ConversionResult<IDLEnumeration<GPUAddressMode>> { return Converter<IDLEnumeration<GPUAddressMode>>::ReturnType { GPUAddressMode::ClampToEdge }; });
    if (UNLIKELY(addressModeUConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.addressModeU = addressModeUConversionResult.releaseReturnValue();
    JSValue addressModeVValue;
    if (isNullOrUndefined)
        addressModeVValue = jsUndefined();
    else {
        addressModeVValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "addressModeV"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto addressModeVConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUAddressMode>>(lexicalGlobalObject, addressModeVValue, [&]() -> ConversionResult<IDLEnumeration<GPUAddressMode>> { return Converter<IDLEnumeration<GPUAddressMode>>::ReturnType { GPUAddressMode::ClampToEdge }; });
    if (UNLIKELY(addressModeVConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.addressModeV = addressModeVConversionResult.releaseReturnValue();
    JSValue addressModeWValue;
    if (isNullOrUndefined)
        addressModeWValue = jsUndefined();
    else {
        addressModeWValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "addressModeW"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto addressModeWConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUAddressMode>>(lexicalGlobalObject, addressModeWValue, [&]() -> ConversionResult<IDLEnumeration<GPUAddressMode>> { return Converter<IDLEnumeration<GPUAddressMode>>::ReturnType { GPUAddressMode::ClampToEdge }; });
    if (UNLIKELY(addressModeWConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.addressModeW = addressModeWConversionResult.releaseReturnValue();
    JSValue compareValue;
    if (isNullOrUndefined)
        compareValue = jsUndefined();
    else {
        compareValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "compare"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!compareValue.isUndefined()) {
        auto compareConversionResult = convert<IDLEnumeration<GPUCompareFunction>>(lexicalGlobalObject, compareValue);
        if (UNLIKELY(compareConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.compare = compareConversionResult.releaseReturnValue();
    }
    JSValue lodMaxClampValue;
    if (isNullOrUndefined)
        lodMaxClampValue = jsUndefined();
    else {
        lodMaxClampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "lodMaxClamp"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto lodMaxClampConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, lodMaxClampValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 32 }; });
    if (UNLIKELY(lodMaxClampConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.lodMaxClamp = lodMaxClampConversionResult.releaseReturnValue();
    JSValue lodMinClampValue;
    if (isNullOrUndefined)
        lodMinClampValue = jsUndefined();
    else {
        lodMinClampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "lodMinClamp"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto lodMinClampConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, lodMinClampValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 0 }; });
    if (UNLIKELY(lodMinClampConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.lodMinClamp = lodMinClampConversionResult.releaseReturnValue();
    JSValue magFilterValue;
    if (isNullOrUndefined)
        magFilterValue = jsUndefined();
    else {
        magFilterValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "magFilter"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto magFilterConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUFilterMode>>(lexicalGlobalObject, magFilterValue, [&]() -> ConversionResult<IDLEnumeration<GPUFilterMode>> { return Converter<IDLEnumeration<GPUFilterMode>>::ReturnType { GPUFilterMode::Nearest }; });
    if (UNLIKELY(magFilterConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.magFilter = magFilterConversionResult.releaseReturnValue();
    JSValue maxAnisotropyValue;
    if (isNullOrUndefined)
        maxAnisotropyValue = jsUndefined();
    else {
        maxAnisotropyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "maxAnisotropy"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto maxAnisotropyConversionResult = convertOptionalWithDefault<IDLClampAdaptor<IDLUnsignedShort>>(lexicalGlobalObject, maxAnisotropyValue, [&]() -> ConversionResult<IDLClampAdaptor<IDLUnsignedShort>> { return Converter<IDLClampAdaptor<IDLUnsignedShort>>::ReturnType { 1 }; });
    if (UNLIKELY(maxAnisotropyConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.maxAnisotropy = maxAnisotropyConversionResult.releaseReturnValue();
    JSValue minFilterValue;
    if (isNullOrUndefined)
        minFilterValue = jsUndefined();
    else {
        minFilterValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "minFilter"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto minFilterConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUFilterMode>>(lexicalGlobalObject, minFilterValue, [&]() -> ConversionResult<IDLEnumeration<GPUFilterMode>> { return Converter<IDLEnumeration<GPUFilterMode>>::ReturnType { GPUFilterMode::Nearest }; });
    if (UNLIKELY(minFilterConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.minFilter = minFilterConversionResult.releaseReturnValue();
    JSValue mipmapFilterValue;
    if (isNullOrUndefined)
        mipmapFilterValue = jsUndefined();
    else {
        mipmapFilterValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mipmapFilter"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto mipmapFilterConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUMipmapFilterMode>>(lexicalGlobalObject, mipmapFilterValue, [&]() -> ConversionResult<IDLEnumeration<GPUMipmapFilterMode>> { return Converter<IDLEnumeration<GPUMipmapFilterMode>>::ReturnType { GPUMipmapFilterMode::Nearest }; });
    if (UNLIKELY(mipmapFilterConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.mipmapFilter = mipmapFilterConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
