/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPURequestAdapterOptions.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertOptional.h"
#include "JSGPUPowerPreference.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPURequestAdapterOptions>> convertDictionary<GPURequestAdapterOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPURequestAdapterOptions result;
    JSValue forceFallbackAdapterValue;
    if (isNullOrUndefined)
        forceFallbackAdapterValue = jsUndefined();
    else {
        forceFallbackAdapterValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "forceFallbackAdapter"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto forceFallbackAdapterConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, forceFallbackAdapterValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(forceFallbackAdapterConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.forceFallbackAdapter = forceFallbackAdapterConversionResult.releaseReturnValue();
    JSValue powerPreferenceValue;
    if (isNullOrUndefined)
        powerPreferenceValue = jsUndefined();
    else {
        powerPreferenceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "powerPreference"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!powerPreferenceValue.isUndefined()) {
        auto powerPreferenceConversionResult = convert<IDLEnumeration<GPUPowerPreference>>(lexicalGlobalObject, powerPreferenceValue);
        if (UNLIKELY(powerPreferenceConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.powerPreference = powerPreferenceConversionResult.releaseReturnValue();
    }
    JSValue xrCompatibleValue;
    if (isNullOrUndefined)
        xrCompatibleValue = jsUndefined();
    else {
        xrCompatibleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "xrCompatible"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto xrCompatibleConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, xrCompatibleValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(xrCompatibleConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.xrCompatible = xrCompatibleConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
