/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPURenderPassColorAttachment.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertUnion.h"
#include "JSGPUColorDict.h"
#include "JSGPULoadOp.h"
#include "JSGPUStoreOp.h"
#include "JSGPUTextureView.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <variant>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPURenderPassColorAttachment>> convertDictionary<GPURenderPassColorAttachment>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPURenderPassColorAttachment result;
    JSValue clearValueValue;
    if (isNullOrUndefined)
        clearValueValue = jsUndefined();
    else {
        clearValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clearValue"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!clearValueValue.isUndefined()) {
        auto clearValueConversionResult = convert<IDLUnion<IDLSequence<IDLDouble>, IDLDictionary<GPUColorDict>>>(lexicalGlobalObject, clearValueValue);
        if (UNLIKELY(clearValueConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.clearValue = clearValueConversionResult.releaseReturnValue();
    }
    JSValue depthSliceValue;
    if (isNullOrUndefined)
        depthSliceValue = jsUndefined();
    else {
        depthSliceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthSlice"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!depthSliceValue.isUndefined()) {
        auto depthSliceConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, depthSliceValue);
        if (UNLIKELY(depthSliceConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.depthSlice = depthSliceConversionResult.releaseReturnValue();
    }
    JSValue loadOpValue;
    if (isNullOrUndefined)
        loadOpValue = jsUndefined();
    else {
        loadOpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "loadOp"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (loadOpValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "loadOp"_s, "GPURenderPassColorAttachment"_s, "GPULoadOp"_s);
        return ConversionResultException { };
    }
    auto loadOpConversionResult = convert<IDLEnumeration<GPULoadOp>>(lexicalGlobalObject, loadOpValue);
    if (UNLIKELY(loadOpConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.loadOp = loadOpConversionResult.releaseReturnValue();
    JSValue resolveTargetValue;
    if (isNullOrUndefined)
        resolveTargetValue = jsUndefined();
    else {
        resolveTargetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "resolveTarget"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!resolveTargetValue.isUndefined()) {
        auto resolveTargetConversionResult = convert<IDLInterface<GPUTextureView>>(lexicalGlobalObject, resolveTargetValue);
        if (UNLIKELY(resolveTargetConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.resolveTarget = resolveTargetConversionResult.releaseReturnValue();
    }
    JSValue storeOpValue;
    if (isNullOrUndefined)
        storeOpValue = jsUndefined();
    else {
        storeOpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "storeOp"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (storeOpValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "storeOp"_s, "GPURenderPassColorAttachment"_s, "GPUStoreOp"_s);
        return ConversionResultException { };
    }
    auto storeOpConversionResult = convert<IDLEnumeration<GPUStoreOp>>(lexicalGlobalObject, storeOpValue);
    if (UNLIKELY(storeOpConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.storeOp = storeOpConversionResult.releaseReturnValue();
    JSValue viewValue;
    if (isNullOrUndefined)
        viewValue = jsUndefined();
    else {
        viewValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "view"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (viewValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "view"_s, "GPURenderPassColorAttachment"_s, "GPUTextureView"_s);
        return ConversionResultException { };
    }
    auto viewConversionResult = convert<IDLInterface<GPUTextureView>>(lexicalGlobalObject, viewValue);
    if (UNLIKELY(viewConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.view = viewConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
