/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFetchResponse.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSBlob.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertRecord.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMFormData.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSFetchHeaders.h"
#include "JSFetchResponse.h"
#include "JSReadableStream.h"
#include "JSURLSearchParams.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>
#include <wtf/Vector.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(FetchResponse::Type enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("basic"),
        MAKE_STATIC_STRING_IMPL("cors"),
        MAKE_STATIC_STRING_IMPL("default"),
        MAKE_STATIC_STRING_IMPL("error"),
        MAKE_STATIC_STRING_IMPL("opaque"),
        MAKE_STATIC_STRING_IMPL("opaqueredirect"),
    };
    static_assert(static_cast<size_t>(FetchResponse::Type::Basic) == 0, "FetchResponse::Type::Basic is not 0 as expected");
    static_assert(static_cast<size_t>(FetchResponse::Type::Cors) == 1, "FetchResponse::Type::Cors is not 1 as expected");
    static_assert(static_cast<size_t>(FetchResponse::Type::Default) == 2, "FetchResponse::Type::Default is not 2 as expected");
    static_assert(static_cast<size_t>(FetchResponse::Type::Error) == 3, "FetchResponse::Type::Error is not 3 as expected");
    static_assert(static_cast<size_t>(FetchResponse::Type::Opaque) == 4, "FetchResponse::Type::Opaque is not 4 as expected");
    static_assert(static_cast<size_t>(FetchResponse::Type::Opaqueredirect) == 5, "FetchResponse::Type::Opaqueredirect is not 5 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, FetchResponse::Type enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<FetchResponse::Type> parseEnumerationFromString<FetchResponse::Type>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, FetchResponse::Type> mappings[] = {
        { "basic", FetchResponse::Type::Basic },
        { "cors", FetchResponse::Type::Cors },
        { "default", FetchResponse::Type::Default },
        { "error", FetchResponse::Type::Error },
        { "opaque", FetchResponse::Type::Opaque },
        { "opaqueredirect", FetchResponse::Type::Opaqueredirect },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<FetchResponse::Type> parseEnumeration<FetchResponse::Type>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<FetchResponse::Type>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<FetchResponse::Type>()
{
    return "\"basic\", \"cors\", \"default\", \"error\", \"opaque\", \"opaqueredirect\""_s;
}

template<> ConversionResult<IDLDictionary<FetchResponse::Init>> convertDictionary<FetchResponse::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    FetchResponse::Init result;
    JSValue headersValue;
    if (isNullOrUndefined)
        headersValue = jsUndefined();
    else {
        headersValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "headers"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!headersValue.isUndefined()) {
        auto headersConversionResult = convert<IDLUnion<IDLSequence<IDLSequence<IDLByteString>>, IDLRecord<IDLByteString, IDLByteString>>>(lexicalGlobalObject, headersValue);
        if (UNLIKELY(headersConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.headers = headersConversionResult.releaseReturnValue();
    }
    JSValue statusValue;
    if (isNullOrUndefined)
        statusValue = jsUndefined();
    else {
        statusValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "status"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto statusConversionResult = convertOptionalWithDefault<IDLUnsignedShort>(lexicalGlobalObject, statusValue, [&]() -> ConversionResult<IDLUnsignedShort> { return Converter<IDLUnsignedShort>::ReturnType { 200 }; });
    if (UNLIKELY(statusConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.status = statusConversionResult.releaseReturnValue();
    JSValue statusTextValue;
    if (isNullOrUndefined)
        statusTextValue = jsUndefined();
    else {
        statusTextValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "statusText"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto statusTextConversionResult = convertOptionalWithDefault<IDLAtomStringAdaptor<IDLByteString>>(lexicalGlobalObject, statusTextValue, [&]() -> ConversionResult<IDLAtomStringAdaptor<IDLByteString>> { return Converter<IDLAtomStringAdaptor<IDLByteString>>::ReturnType { emptyAtom() }; });
    if (UNLIKELY(statusTextConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.statusText = statusTextConversionResult.releaseReturnValue();
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsFetchResponseConstructorFunction_error);
static JSC_DECLARE_HOST_FUNCTION(jsFetchResponseConstructorFunction_redirect);
static JSC_DECLARE_HOST_FUNCTION(jsFetchResponseConstructorFunction_json);
static JSC_DECLARE_HOST_FUNCTION(jsFetchResponsePrototypeFunction_clone);
static JSC_DECLARE_HOST_FUNCTION(jsFetchResponsePrototypeFunction_arrayBuffer);
static JSC_DECLARE_HOST_FUNCTION(jsFetchResponsePrototypeFunction_blob);
static JSC_DECLARE_HOST_FUNCTION(jsFetchResponsePrototypeFunction_bytes);
static JSC_DECLARE_HOST_FUNCTION(jsFetchResponsePrototypeFunction_formData);
static JSC_DECLARE_HOST_FUNCTION(jsFetchResponsePrototypeFunction_json);
static JSC_DECLARE_HOST_FUNCTION(jsFetchResponsePrototypeFunction_text);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsFetchResponseConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchResponse_type);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchResponse_url);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchResponse_redirected);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchResponse_status);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchResponse_ok);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchResponse_statusText);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchResponse_headers);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchResponse_body);
static JSC_DECLARE_CUSTOM_GETTER(jsFetchResponse_bodyUsed);

class JSFetchResponsePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFetchResponsePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFetchResponsePrototype* ptr = new (NotNull, JSC::allocateCell<JSFetchResponsePrototype>(vm)) JSFetchResponsePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFetchResponsePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFetchResponsePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFetchResponsePrototype, JSFetchResponsePrototype::Base);

using JSFetchResponseDOMConstructor = JSDOMConstructor<JSFetchResponse>;

/* Hash table for constructor */

static const HashTableValue JSFetchResponseConstructorTableValues[] =
{
    { "error"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFetchResponseConstructorFunction_error, 0 } },
    { "redirect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFetchResponseConstructorFunction_redirect, 1 } },
    { "json"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFetchResponseConstructorFunction_json, 1 } },
};

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSFetchResponseDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSFetchResponseDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "Response"_s);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto bodyConversionResult = convertOptionalWithDefault<IDLNullable<IDLUnion<IDLInterface<Blob>, IDLArrayBufferView, IDLArrayBuffer, IDLInterface<DOMFormData>, IDLInterface<URLSearchParams>, IDLInterface<ReadableStream>, IDLUSVString>>>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLNullable<IDLUnion<IDLInterface<Blob>, IDLArrayBufferView, IDLArrayBuffer, IDLInterface<DOMFormData>, IDLInterface<URLSearchParams>, IDLInterface<ReadableStream>, IDLUSVString>>> { return typename Converter<IDLNullable<IDLUnion<IDLInterface<Blob>, IDLArrayBufferView, IDLArrayBuffer, IDLInterface<DOMFormData>, IDLInterface<URLSearchParams>, IDLInterface<ReadableStream>, IDLUSVString>>>::ReturnType { std::nullopt }; });
    if (UNLIKELY(bodyConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto initConversionResult = convert<IDLDictionary<FetchResponse::Init>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(initConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = FetchResponse::create(*context, bodyConversionResult.releaseReturnValue(), initConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<FetchResponse>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<FetchResponse>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSFetchResponseDOMConstructorConstruct, JSFetchResponseDOMConstructor::construct);

template<> const ClassInfo JSFetchResponseDOMConstructor::s_info = { "Response"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFetchResponseDOMConstructor) };

template<> JSValue JSFetchResponseDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSFetchResponseDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "Response"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSFetchResponse::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSFetchResponse::info(), JSFetchResponseConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSFetchResponsePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchResponseConstructor, 0 } },
    { "type"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchResponse_type, 0 } },
    { "url"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchResponse_url, 0 } },
    { "redirected"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchResponse_redirected, 0 } },
    { "status"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchResponse_status, 0 } },
    { "ok"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchResponse_ok, 0 } },
    { "statusText"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchResponse_statusText, 0 } },
    { "headers"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchResponse_headers, 0 } },
    { "body"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchResponse_body, 0 } },
    { "bodyUsed"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFetchResponse_bodyUsed, 0 } },
    { "clone"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFetchResponsePrototypeFunction_clone, 0 } },
    { "arrayBuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFetchResponsePrototypeFunction_arrayBuffer, 0 } },
    { "blob"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFetchResponsePrototypeFunction_blob, 0 } },
    { "bytes"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFetchResponsePrototypeFunction_bytes, 0 } },
    { "formData"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFetchResponsePrototypeFunction_formData, 0 } },
    { "json"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFetchResponsePrototypeFunction_json, 0 } },
    { "text"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFetchResponsePrototypeFunction_text, 0 } },
};

const ClassInfo JSFetchResponsePrototype::s_info = { "Response"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFetchResponsePrototype) };

void JSFetchResponsePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFetchResponse::info(), JSFetchResponsePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSFetchResponse::s_info = { "Response"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFetchResponse) };

JSFetchResponse::JSFetchResponse(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FetchResponse>&& impl)
    : JSDOMWrapper<FetchResponse>(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, FetchResponse>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSFetchResponse::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSFetchResponsePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSFetchResponsePrototype::create(vm, &globalObject, structure);
}

JSObject* JSFetchResponse::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFetchResponse>(vm, globalObject);
}

JSValue JSFetchResponse::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFetchResponseDOMConstructor, DOMConstructorID::FetchResponse>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSFetchResponse::destroy(JSC::JSCell* cell)
{
    JSFetchResponse* thisObject = static_cast<JSFetchResponse*>(cell);
    thisObject->JSFetchResponse::~JSFetchResponse();
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchResponseConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFetchResponsePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFetchResponse::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsFetchResponse_typeGetter(JSGlobalObject& lexicalGlobalObject, JSFetchResponse& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<FetchResponse::Type>>(lexicalGlobalObject, throwScope, impl.type())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchResponse_type, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchResponse>::get<jsFetchResponse_typeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFetchResponse_urlGetter(JSGlobalObject& lexicalGlobalObject, JSFetchResponse& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.url())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchResponse_url, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchResponse>::get<jsFetchResponse_urlGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFetchResponse_redirectedGetter(JSGlobalObject& lexicalGlobalObject, JSFetchResponse& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.redirected())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchResponse_redirected, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchResponse>::get<jsFetchResponse_redirectedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFetchResponse_statusGetter(JSGlobalObject& lexicalGlobalObject, JSFetchResponse& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.status())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchResponse_status, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchResponse>::get<jsFetchResponse_statusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFetchResponse_okGetter(JSGlobalObject& lexicalGlobalObject, JSFetchResponse& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.ok())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchResponse_ok, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchResponse>::get<jsFetchResponse_okGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFetchResponse_statusTextGetter(JSGlobalObject& lexicalGlobalObject, JSFetchResponse& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLByteString>(lexicalGlobalObject, throwScope, impl.statusText())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchResponse_statusText, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchResponse>::get<jsFetchResponse_statusTextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFetchResponse_headersGetter(JSGlobalObject& lexicalGlobalObject, JSFetchResponse& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<FetchHeaders>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.headers())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchResponse_headers, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchResponse>::get<jsFetchResponse_headersGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFetchResponse_bodyGetter(JSGlobalObject& lexicalGlobalObject, JSFetchResponse& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<ReadableStream>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.readableStream(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)))));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchResponse_body, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchResponse>::get<jsFetchResponse_bodyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFetchResponse_bodyUsedGetter(JSGlobalObject& lexicalGlobalObject, JSFetchResponse& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.bodyUsed())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFetchResponse_bodyUsed, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFetchResponse>::get<jsFetchResponse_bodyUsedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsFetchResponseConstructorFunction_errorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<FetchResponse>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, FetchResponse::error(*context))));
}

JSC_DEFINE_HOST_FUNCTION(jsFetchResponseConstructorFunction_error, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFetchResponse>::callStatic<jsFetchResponseConstructorFunction_errorBody>(*lexicalGlobalObject, *callFrame, "error");
}

static inline JSC::EncodedJSValue jsFetchResponseConstructorFunction_redirectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto urlConversionResult = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(urlConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto statusConversionResult = convertOptionalWithDefault<IDLUnsignedShort>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLUnsignedShort> { return Converter<IDLUnsignedShort>::ReturnType { 302 }; });
    if (UNLIKELY(statusConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<FetchResponse>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, FetchResponse::redirect(*context, urlConversionResult.releaseReturnValue(), statusConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsFetchResponseConstructorFunction_redirect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFetchResponse>::callStatic<jsFetchResponseConstructorFunction_redirectBody>(*lexicalGlobalObject, *callFrame, "redirect");
}

static inline JSC::EncodedJSValue jsFetchResponseConstructorFunction_jsonBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto dataConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(dataConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto initConversionResult = convert<IDLDictionary<FetchResponse::Init>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(initConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<FetchResponse>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, FetchResponse::jsonForBindings(*context, dataConversionResult.releaseReturnValue(), initConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsFetchResponseConstructorFunction_json, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFetchResponse>::callStatic<jsFetchResponseConstructorFunction_jsonBody>(*lexicalGlobalObject, *callFrame, "json");
}

static inline JSC::EncodedJSValue jsFetchResponsePrototypeFunction_cloneBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFetchResponse>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<FetchResponse>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.clone())));
}

JSC_DEFINE_HOST_FUNCTION(jsFetchResponsePrototypeFunction_clone, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFetchResponse>::call<jsFetchResponsePrototypeFunction_cloneBody>(*lexicalGlobalObject, *callFrame, "clone");
}

static inline JSC::EncodedJSValue jsFetchResponsePrototypeFunction_arrayBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFetchResponse>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLArrayBuffer>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.arrayBuffer(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFetchResponsePrototypeFunction_arrayBuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFetchResponse>::call<jsFetchResponsePrototypeFunction_arrayBufferBody>(*lexicalGlobalObject, *callFrame, "arrayBuffer");
}

static inline JSC::EncodedJSValue jsFetchResponsePrototypeFunction_blobBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFetchResponse>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLInterface<Blob>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.blob(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFetchResponsePrototypeFunction_blob, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFetchResponse>::call<jsFetchResponsePrototypeFunction_blobBody>(*lexicalGlobalObject, *callFrame, "blob");
}

static inline JSC::EncodedJSValue jsFetchResponsePrototypeFunction_bytesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFetchResponse>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLUint8Array>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.bytes(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFetchResponsePrototypeFunction_bytes, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFetchResponse>::call<jsFetchResponsePrototypeFunction_bytesBody>(*lexicalGlobalObject, *callFrame, "bytes");
}

static inline JSC::EncodedJSValue jsFetchResponsePrototypeFunction_formDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFetchResponse>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLInterface<DOMFormData>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.formData(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFetchResponsePrototypeFunction_formData, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFetchResponse>::call<jsFetchResponsePrototypeFunction_formDataBody>(*lexicalGlobalObject, *callFrame, "formData");
}

static inline JSC::EncodedJSValue jsFetchResponsePrototypeFunction_jsonBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFetchResponse>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLAny>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.json(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFetchResponsePrototypeFunction_json, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFetchResponse>::call<jsFetchResponsePrototypeFunction_jsonBody>(*lexicalGlobalObject, *callFrame, "json");
}

static inline JSC::EncodedJSValue jsFetchResponsePrototypeFunction_textBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFetchResponse>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLUSVString>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.text(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFetchResponsePrototypeFunction_text, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFetchResponse>::call<jsFetchResponsePrototypeFunction_textBody>(*lexicalGlobalObject, *callFrame, "text");
}

JSC::GCClient::IsoSubspace* JSFetchResponse::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSFetchResponse, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForFetchResponse.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForFetchResponse = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForFetchResponse.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForFetchResponse = std::forward<decltype(space)>(space); }
    );
}

void JSFetchResponse::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFetchResponse*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSFetchResponseOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsFetchResponse = jsCast<JSFetchResponse*>(handle.slot()->asCell());
    auto& wrapped = jsFetchResponse->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSFetchResponseOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFetchResponse = static_cast<JSFetchResponse*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsFetchResponse->protectedWrapped().ptr(), jsFetchResponse);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7FetchResponse@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13FetchResponseE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, FetchResponse>, void>> static inline void verifyVTable(FetchResponse* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7FetchResponse@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore13FetchResponseE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // FetchResponse has subclasses. If FetchResponse has subclasses that get passed
        // to toJS() we currently require FetchResponse you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<FetchResponse>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<FetchResponse>(impl.ptr());
#endif
    return createWrapper<FetchResponse>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, FetchResponse& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

FetchResponse* JSFetchResponse::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFetchResponse*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
