/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSComputedEffectTiming.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMGlobalObject.h"
#include "JSFillMode.h"
#include "JSPlaybackDirection.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <variant>


namespace WebCore {
using namespace JSC;

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const ComputedEffectTiming& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto delayValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, dictionary.delay);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "delay"_s), delayValue);
    auto directionValue = toJS<IDLEnumeration<PlaybackDirection>>(lexicalGlobalObject, throwScope, dictionary.direction);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "direction"_s), directionValue);
    auto durationValue = toJS<IDLUnion<IDLUnrestrictedDouble, IDLDOMString>>(lexicalGlobalObject, globalObject, throwScope, dictionary.duration);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "duration"_s), durationValue);
    auto easingValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, dictionary.easing);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "easing"_s), easingValue);
    auto endDelayValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, dictionary.endDelay);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "endDelay"_s), endDelayValue);
    auto fillValue = toJS<IDLEnumeration<FillMode>>(lexicalGlobalObject, throwScope, dictionary.fill);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "fill"_s), fillValue);
    auto iterationStartValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, dictionary.iterationStart);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "iterationStart"_s), iterationStartValue);
    auto iterationsValue = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, dictionary.iterations);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "iterations"_s), iterationsValue);
    if (!IDLUnrestrictedDouble::isNullValue(dictionary.activeDuration)) {
        auto activeDurationValue = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, IDLUnrestrictedDouble::extractValueFromNullable(dictionary.activeDuration));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "activeDuration"_s), activeDurationValue);
    }
    auto currentIterationValue = toJS<IDLNullable<IDLUnrestrictedDouble>>(lexicalGlobalObject, throwScope, dictionary.currentIteration);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "currentIteration"_s), currentIterationValue);
    if (!IDLUnrestrictedDouble::isNullValue(dictionary.endTime)) {
        auto endTimeValue = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, IDLUnrestrictedDouble::extractValueFromNullable(dictionary.endTime));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "endTime"_s), endTimeValue);
    }
    auto localTimeValue = toJS<IDLNullable<IDLDouble>>(lexicalGlobalObject, throwScope, dictionary.localTime);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "localTime"_s), localTimeValue);
    auto progressValue = toJS<IDLNullable<IDLDouble>>(lexicalGlobalObject, throwScope, dictionary.progress);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "progress"_s), progressValue);
    return result;
}

} // namespace WebCore
