/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioNode.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSAudioNode.h"
#include "JSAudioParam.h"
#include "JSBaseAudioContext.h"
#include "JSChannelCountMode.h"
#include "JSChannelInterpretation.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsAudioNodePrototypeFunction_connect);
static JSC_DECLARE_HOST_FUNCTION(jsAudioNodePrototypeFunction_disconnect);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsAudioNodeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioNode_context);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioNode_numberOfInputs);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioNode_numberOfOutputs);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioNode_channelCount);
static JSC_DECLARE_CUSTOM_SETTER(setJSAudioNode_channelCount);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioNode_channelCountMode);
static JSC_DECLARE_CUSTOM_SETTER(setJSAudioNode_channelCountMode);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioNode_channelInterpretation);
static JSC_DECLARE_CUSTOM_SETTER(setJSAudioNode_channelInterpretation);

class JSAudioNodePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAudioNodePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAudioNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSAudioNodePrototype>(vm)) JSAudioNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioNodePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAudioNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioNodePrototype, JSAudioNodePrototype::Base);

using JSAudioNodeDOMConstructor = JSDOMConstructorNotConstructable<JSAudioNode>;

template<> const ClassInfo JSAudioNodeDOMConstructor::s_info = { "AudioNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioNodeDOMConstructor) };

template<> JSValue JSAudioNodeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSAudioNodeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "AudioNode"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSAudioNode::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSAudioNodePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioNodeConstructor, 0 } },
    { "context"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioNode_context, 0 } },
    { "numberOfInputs"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioNode_numberOfInputs, 0 } },
    { "numberOfOutputs"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioNode_numberOfOutputs, 0 } },
    { "channelCount"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioNode_channelCount, setJSAudioNode_channelCount } },
    { "channelCountMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioNode_channelCountMode, setJSAudioNode_channelCountMode } },
    { "channelInterpretation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioNode_channelInterpretation, setJSAudioNode_channelInterpretation } },
    { "connect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAudioNodePrototypeFunction_connect, 1 } },
    { "disconnect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAudioNodePrototypeFunction_disconnect, 0 } },
};

const ClassInfo JSAudioNodePrototype::s_info = { "AudioNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioNodePrototype) };

void JSAudioNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAudioNode::info(), JSAudioNodePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSAudioNode::s_info = { "AudioNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioNode) };

JSAudioNode::JSAudioNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AudioNode>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<AudioNode> JSAudioNode::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, AudioNode>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSAudioNode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSAudioNodePrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSAudioNodePrototype::create(vm, &globalObject, structure);
}

JSObject* JSAudioNode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAudioNode>(vm, globalObject);
}

JSValue JSAudioNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioNodeDOMConstructor, DOMConstructorID::AudioNode>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioNodeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAudioNodePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAudioNode::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsAudioNode_contextGetter(JSGlobalObject& lexicalGlobalObject, JSAudioNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<BaseAudioContext>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.context())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioNode_context, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioNode>::get<jsAudioNode_contextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAudioNode_numberOfInputsGetter(JSGlobalObject& lexicalGlobalObject, JSAudioNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.numberOfInputs())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioNode_numberOfInputs, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioNode>::get<jsAudioNode_numberOfInputsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAudioNode_numberOfOutputsGetter(JSGlobalObject& lexicalGlobalObject, JSAudioNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.numberOfOutputs())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioNode_numberOfOutputs, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioNode>::get<jsAudioNode_numberOfOutputsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAudioNode_channelCountGetter(JSGlobalObject& lexicalGlobalObject, JSAudioNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.channelCount())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioNode_channelCount, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioNode>::get<jsAudioNode_channelCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSAudioNode_channelCountSetter(JSGlobalObject& lexicalGlobalObject, JSAudioNode& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setChannelCount(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSAudioNode_channelCount, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioNode>::set<setJSAudioNode_channelCountSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsAudioNode_channelCountModeGetter(JSGlobalObject& lexicalGlobalObject, JSAudioNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<ChannelCountMode>>(lexicalGlobalObject, throwScope, impl.channelCountMode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioNode_channelCountMode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioNode>::get<jsAudioNode_channelCountModeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSAudioNode_channelCountModeSetter(JSGlobalObject& lexicalGlobalObject, JSAudioNode& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<ChannelCountMode>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setChannelCountMode(optionalNativeValue.value());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSAudioNode_channelCountMode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioNode>::set<setJSAudioNode_channelCountModeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsAudioNode_channelInterpretationGetter(JSGlobalObject& lexicalGlobalObject, JSAudioNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<ChannelInterpretation>>(lexicalGlobalObject, throwScope, impl.channelInterpretation())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioNode_channelInterpretation, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioNode>::get<jsAudioNode_channelInterpretationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSAudioNode_channelInterpretationSetter(JSGlobalObject& lexicalGlobalObject, JSAudioNode& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<ChannelInterpretation>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setChannelInterpretation(optionalNativeValue.value());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSAudioNode_channelInterpretation, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioNode>::set<setJSAudioNode_channelInterpretationSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsAudioNodePrototypeFunction_connect1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto destinationConversionResult = convert<IDLInterface<AudioNode>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "destination"_s, "AudioNode"_s, "connect"_s, "AudioNode"_s); });
    if (UNLIKELY(destinationConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto outputConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(outputConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto inputConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(inputConversionResult.hasException(throwScope)))
       return encodedJSValue();
    invokeFunctorPropagatingExceptionIfNecessary(*lexicalGlobalObject, throwScope, [&] { return impl.connect(*destinationConversionResult.releaseReturnValue(), outputConversionResult.releaseReturnValue(), inputConversionResult.releaseReturnValue()); });
    return JSValue::encode(argument0.value());
}

static inline JSC::EncodedJSValue jsAudioNodePrototypeFunction_connect2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto destinationConversionResult = convert<IDLInterface<AudioParam>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "destination"_s, "AudioNode"_s, "connect"_s, "AudioParam"_s); });
    if (UNLIKELY(destinationConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto outputConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(outputConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.connect(*destinationConversionResult.releaseReturnValue(), outputConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsAudioNodePrototypeFunction_connectOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(3, callFrame->argumentCount());
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSAudioNode>())
            RELEASE_AND_RETURN(throwScope, (jsAudioNodePrototypeFunction_connect1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSAudioParam>())
            RELEASE_AND_RETURN(throwScope, (jsAudioNodePrototypeFunction_connect2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSAudioNode>())
            RELEASE_AND_RETURN(throwScope, (jsAudioNodePrototypeFunction_connect1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSAudioParam>())
            RELEASE_AND_RETURN(throwScope, (jsAudioNodePrototypeFunction_connect2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 3) {
        RELEASE_AND_RETURN(throwScope, (jsAudioNodePrototypeFunction_connect1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsAudioNodePrototypeFunction_connect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSAudioNode>::call<jsAudioNodePrototypeFunction_connectOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "connect");
}

static inline JSC::EncodedJSValue jsAudioNodePrototypeFunction_disconnect1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.disconnect(); })));
}

static inline JSC::EncodedJSValue jsAudioNodePrototypeFunction_disconnect2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto outputConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(outputConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.disconnect(outputConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsAudioNodePrototypeFunction_disconnect3Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto destinationNodeConversionResult = convert<IDLInterface<AudioNode>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "destinationNode"_s, "AudioNode"_s, "disconnect"_s, "AudioNode"_s); });
    if (UNLIKELY(destinationNodeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.disconnect(*destinationNodeConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsAudioNodePrototypeFunction_disconnect4Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto destinationNodeConversionResult = convert<IDLInterface<AudioNode>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "destinationNode"_s, "AudioNode"_s, "disconnect"_s, "AudioNode"_s); });
    if (UNLIKELY(destinationNodeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto outputConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(outputConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.disconnect(*destinationNodeConversionResult.releaseReturnValue(), outputConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsAudioNodePrototypeFunction_disconnect5Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto destinationNodeConversionResult = convert<IDLInterface<AudioNode>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "destinationNode"_s, "AudioNode"_s, "disconnect"_s, "AudioNode"_s); });
    if (UNLIKELY(destinationNodeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto outputConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(outputConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto inputConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(inputConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.disconnect(*destinationNodeConversionResult.releaseReturnValue(), outputConversionResult.releaseReturnValue(), inputConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsAudioNodePrototypeFunction_disconnect6Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto destinationParamConversionResult = convert<IDLInterface<AudioParam>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "destinationParam"_s, "AudioNode"_s, "disconnect"_s, "AudioParam"_s); });
    if (UNLIKELY(destinationParamConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.disconnect(*destinationParamConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsAudioNodePrototypeFunction_disconnect7Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto destinationParamConversionResult = convert<IDLInterface<AudioParam>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "destinationParam"_s, "AudioNode"_s, "disconnect"_s, "AudioParam"_s); });
    if (UNLIKELY(destinationParamConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto outputConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(outputConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.disconnect(*destinationParamConversionResult.releaseReturnValue(), outputConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsAudioNodePrototypeFunction_disconnectOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(3, callFrame->argumentCount());
    if (argsCount == 0) {
        RELEASE_AND_RETURN(throwScope, (jsAudioNodePrototypeFunction_disconnect1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSAudioNode>())
            RELEASE_AND_RETURN(throwScope, (jsAudioNodePrototypeFunction_disconnect3Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSAudioParam>())
            RELEASE_AND_RETURN(throwScope, (jsAudioNodePrototypeFunction_disconnect6Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isNumber())
            RELEASE_AND_RETURN(throwScope, (jsAudioNodePrototypeFunction_disconnect2Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsAudioNodePrototypeFunction_disconnect2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSAudioNode>())
            RELEASE_AND_RETURN(throwScope, (jsAudioNodePrototypeFunction_disconnect4Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSAudioParam>())
            RELEASE_AND_RETURN(throwScope, (jsAudioNodePrototypeFunction_disconnect7Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 3) {
        RELEASE_AND_RETURN(throwScope, (jsAudioNodePrototypeFunction_disconnect5Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsAudioNodePrototypeFunction_disconnect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSAudioNode>::call<jsAudioNodePrototypeFunction_disconnectOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "disconnect");
}

JSC::GCClient::IsoSubspace* JSAudioNode::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSAudioNode, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForAudioNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForAudioNode = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForAudioNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForAudioNode = std::forward<decltype(space)>(space); }
    );
}

void JSAudioNode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAudioNode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

AudioNode* JSAudioNode::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSAudioNode*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_AUDIO)
