/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSAnimationTimeline.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsAnimationTimelineConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsAnimationTimeline_currentTime);

class JSAnimationTimelinePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAnimationTimelinePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAnimationTimelinePrototype* ptr = new (NotNull, JSC::allocateCell<JSAnimationTimelinePrototype>(vm)) JSAnimationTimelinePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAnimationTimelinePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAnimationTimelinePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAnimationTimelinePrototype, JSAnimationTimelinePrototype::Base);

using JSAnimationTimelineDOMConstructor = JSDOMConstructorNotConstructable<JSAnimationTimeline>;

template<> const ClassInfo JSAnimationTimelineDOMConstructor::s_info = { "AnimationTimeline"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnimationTimelineDOMConstructor) };

template<> JSValue JSAnimationTimelineDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSAnimationTimelineDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "AnimationTimeline"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSAnimationTimeline::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSAnimationTimelinePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsAnimationTimelineConstructor, 0 } },
    { "currentTime"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAnimationTimeline_currentTime, 0 } },
};

const ClassInfo JSAnimationTimelinePrototype::s_info = { "AnimationTimeline"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnimationTimelinePrototype) };

void JSAnimationTimelinePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAnimationTimeline::info(), JSAnimationTimelinePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSAnimationTimeline::s_info = { "AnimationTimeline"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnimationTimeline) };

JSAnimationTimeline::JSAnimationTimeline(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AnimationTimeline>&& impl)
    : JSDOMWrapper<AnimationTimeline>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, AnimationTimeline>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSAnimationTimeline::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSAnimationTimelinePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSAnimationTimelinePrototype::create(vm, &globalObject, structure);
}

JSObject* JSAnimationTimeline::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAnimationTimeline>(vm, globalObject);
}

JSValue JSAnimationTimeline::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAnimationTimelineDOMConstructor, DOMConstructorID::AnimationTimeline>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSAnimationTimeline::destroy(JSC::JSCell* cell)
{
    JSAnimationTimeline* thisObject = static_cast<JSAnimationTimeline*>(cell);
    thisObject->JSAnimationTimeline::~JSAnimationTimeline();
}

JSC_DEFINE_CUSTOM_GETTER(jsAnimationTimelineConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAnimationTimelinePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAnimationTimeline::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsAnimationTimeline_currentTimeGetter(JSGlobalObject& lexicalGlobalObject, JSAnimationTimeline& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLDouble>>(lexicalGlobalObject, throwScope, impl.bindingsCurrentTime())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAnimationTimeline_currentTime, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAnimationTimeline>::get<jsAnimationTimeline_currentTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSAnimationTimeline::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSAnimationTimeline, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForAnimationTimeline.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForAnimationTimeline = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForAnimationTimeline.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForAnimationTimeline = std::forward<decltype(space)>(space); }
    );
}

void JSAnimationTimeline::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAnimationTimeline*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSAnimationTimelineOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSAnimationTimelineOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsAnimationTimeline = static_cast<JSAnimationTimeline*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsAnimationTimeline->protectedWrapped().ptr(), jsAnimationTimeline);
}

AnimationTimeline* JSAnimationTimeline::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSAnimationTimeline*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
