/*
 * Copyright (C) 2021-2023 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "WebPageTesting.h"

#include "ArgumentCoders.h" // NOLINT
#include "Decoder.h" // NOLINT
#include "HandleMessage.h" // NOLINT
#include "WebCoreArgumentCoders.h" // NOLINT
#include "WebPageTestingMessages.h" // NOLINT
#include <WebCore/IntPoint.h> // NOLINT
#include <wtf/text/WTFString.h> // NOLINT

#if ENABLE(IPC_TESTING_API)
#include "JSIPCBinding.h"
#endif

namespace WebKit {

void WebPageTesting::didReceiveMessage(IPC::Connection& connection, IPC::Decoder& decoder)
{
    if (decoder.messageName() == Messages::WebPageTesting::SetDefersLoading::name())
        return IPC::handleMessage<Messages::WebPageTesting::SetDefersLoading>(connection, decoder, this, &WebPageTesting::setDefersLoading);
    if (decoder.messageName() == Messages::WebPageTesting::IsLayerTreeFrozen::name())
        return IPC::handleMessageAsync<Messages::WebPageTesting::IsLayerTreeFrozen>(connection, decoder, this, &WebPageTesting::isLayerTreeFrozen);
    if (decoder.messageName() == Messages::WebPageTesting::SetPermissionLevel::name())
        return IPC::handleMessage<Messages::WebPageTesting::SetPermissionLevel>(connection, decoder, this, &WebPageTesting::setPermissionLevel);
#if ENABLE(NOTIFICATIONS)
    if (decoder.messageName() == Messages::WebPageTesting::ClearNotificationPermissionState::name())
        return IPC::handleMessage<Messages::WebPageTesting::ClearNotificationPermissionState>(connection, decoder, this, &WebPageTesting::clearNotificationPermissionState);
#endif
    if (decoder.messageName() == Messages::WebPageTesting::ClearWheelEventTestMonitor::name())
        return IPC::handleMessage<Messages::WebPageTesting::ClearWheelEventTestMonitor>(connection, decoder, this, &WebPageTesting::clearWheelEventTestMonitor);
    if (decoder.messageName() == Messages::WebPageTesting::SetTopContentInset::name())
        return IPC::handleMessageAsync<Messages::WebPageTesting::SetTopContentInset>(connection, decoder, this, &WebPageTesting::setTopContentInset);
    if (decoder.messageName() == Messages::WebPageTesting::SetPageScaleFactor::name())
        return IPC::handleMessageAsync<Messages::WebPageTesting::SetPageScaleFactor>(connection, decoder, this, &WebPageTesting::setPageScaleFactor);
    UNUSED_PARAM(connection);
    UNUSED_PARAM(decoder);
#if ENABLE(IPC_TESTING_API)
    if (connection.ignoreInvalidMessageForTesting())
        return;
#endif // ENABLE(IPC_TESTING_API)
    ASSERT_NOT_REACHED_WITH_MESSAGE("Unhandled message %s to %" PRIu64, IPC::description(decoder.messageName()).characters(), decoder.destinationID());
}

bool WebPageTesting::didReceiveSyncMessage(IPC::Connection& connection, IPC::Decoder& decoder, UniqueRef<IPC::Encoder>& replyEncoder)
{
    if (decoder.messageName() == Messages::WebPageTesting::IsEditingCommandEnabled::name())
        return IPC::handleMessageSynchronous<Messages::WebPageTesting::IsEditingCommandEnabled>(connection, decoder, replyEncoder, this, &WebPageTesting::isEditingCommandEnabled);
    UNUSED_PARAM(connection);
    UNUSED_PARAM(decoder);
    UNUSED_PARAM(replyEncoder);
#if ENABLE(IPC_TESTING_API)
    if (connection.ignoreInvalidMessageForTesting())
        return false;
#endif // ENABLE(IPC_TESTING_API)
    ASSERT_NOT_REACHED_WITH_MESSAGE("Unhandled synchronous message %s to %" PRIu64, description(decoder.messageName()).characters(), decoder.destinationID());
    return false;
}

} // namespace WebKit

#if ENABLE(IPC_TESTING_API)

namespace IPC {

template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::WebPageTesting_SetDefersLoading>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::WebPageTesting::SetDefersLoading::Arguments>(globalObject, decoder);
}
template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::WebPageTesting_IsLayerTreeFrozen>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::WebPageTesting::IsLayerTreeFrozen::Arguments>(globalObject, decoder);
}
template<> std::optional<JSC::JSValue> jsValueForDecodedMessageReply<MessageName::WebPageTesting_IsLayerTreeFrozen>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::WebPageTesting::IsLayerTreeFrozen::ReplyArguments>(globalObject, decoder);
}
template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::WebPageTesting_SetPermissionLevel>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::WebPageTesting::SetPermissionLevel::Arguments>(globalObject, decoder);
}
template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::WebPageTesting_IsEditingCommandEnabled>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::WebPageTesting::IsEditingCommandEnabled::Arguments>(globalObject, decoder);
}
template<> std::optional<JSC::JSValue> jsValueForDecodedMessageReply<MessageName::WebPageTesting_IsEditingCommandEnabled>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::WebPageTesting::IsEditingCommandEnabled::ReplyArguments>(globalObject, decoder);
}
#if ENABLE(NOTIFICATIONS)
template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::WebPageTesting_ClearNotificationPermissionState>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::WebPageTesting::ClearNotificationPermissionState::Arguments>(globalObject, decoder);
}
#endif
template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::WebPageTesting_ClearWheelEventTestMonitor>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::WebPageTesting::ClearWheelEventTestMonitor::Arguments>(globalObject, decoder);
}
template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::WebPageTesting_SetTopContentInset>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::WebPageTesting::SetTopContentInset::Arguments>(globalObject, decoder);
}
template<> std::optional<JSC::JSValue> jsValueForDecodedMessageReply<MessageName::WebPageTesting_SetTopContentInset>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::WebPageTesting::SetTopContentInset::ReplyArguments>(globalObject, decoder);
}
template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::WebPageTesting_SetPageScaleFactor>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::WebPageTesting::SetPageScaleFactor::Arguments>(globalObject, decoder);
}
template<> std::optional<JSC::JSValue> jsValueForDecodedMessageReply<MessageName::WebPageTesting_SetPageScaleFactor>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::WebPageTesting::SetPageScaleFactor::ReplyArguments>(globalObject, decoder);
}

}

#endif

