/*
 * Copyright (C) 2010 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WebIDBConnectionToServerMessages_h
#define WebIDBConnectionToServerMessages_h

#if ENABLE(INDEXED_DATABASE) && ENABLE(DATABASE_PROCESS)

#include "Arguments.h"
#include "MessageEncoder.h"
#include "StringReference.h"
#include "WebCoreArgumentCoders.h"
#include <WebCore/IDBError.h>
#include <WebCore/IDBResourceIdentifier.h>
#include <WebCore/IDBResultData.h>


namespace Messages {
namespace WebIDBConnectionToServer {

static inline IPC::StringReference messageReceiverName()
{
    return IPC::StringReference("WebIDBConnectionToServer");
}

class DidDeleteDatabase {
public:
    typedef std::tuple<WebCore::IDBResultData> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("DidDeleteDatabase"); }
    static const bool isSync = false;

    explicit DidDeleteDatabase(const WebCore::IDBResultData& result)
        : m_arguments(result)
    {
    }

    const std::tuple<const WebCore::IDBResultData&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const WebCore::IDBResultData&> m_arguments;
};

class DidOpenDatabase {
public:
    typedef std::tuple<WebCore::IDBResultData> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("DidOpenDatabase"); }
    static const bool isSync = false;

    explicit DidOpenDatabase(const WebCore::IDBResultData& result)
        : m_arguments(result)
    {
    }

    const std::tuple<const WebCore::IDBResultData&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const WebCore::IDBResultData&> m_arguments;
};

class DidAbortTransaction {
public:
    typedef std::tuple<WebCore::IDBResourceIdentifier, WebCore::IDBError> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("DidAbortTransaction"); }
    static const bool isSync = false;

    DidAbortTransaction(const WebCore::IDBResourceIdentifier& transactionIdentifier, const WebCore::IDBError& error)
        : m_arguments(transactionIdentifier, error)
    {
    }

    const std::tuple<const WebCore::IDBResourceIdentifier&, const WebCore::IDBError&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const WebCore::IDBResourceIdentifier&, const WebCore::IDBError&> m_arguments;
};

class DidCommitTransaction {
public:
    typedef std::tuple<WebCore::IDBResourceIdentifier, WebCore::IDBError> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("DidCommitTransaction"); }
    static const bool isSync = false;

    DidCommitTransaction(const WebCore::IDBResourceIdentifier& transactionIdentifier, const WebCore::IDBError& error)
        : m_arguments(transactionIdentifier, error)
    {
    }

    const std::tuple<const WebCore::IDBResourceIdentifier&, const WebCore::IDBError&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const WebCore::IDBResourceIdentifier&, const WebCore::IDBError&> m_arguments;
};

class DidCreateObjectStore {
public:
    typedef std::tuple<WebCore::IDBResultData> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("DidCreateObjectStore"); }
    static const bool isSync = false;

    explicit DidCreateObjectStore(const WebCore::IDBResultData& result)
        : m_arguments(result)
    {
    }

    const std::tuple<const WebCore::IDBResultData&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const WebCore::IDBResultData&> m_arguments;
};

class DidDeleteObjectStore {
public:
    typedef std::tuple<WebCore::IDBResultData> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("DidDeleteObjectStore"); }
    static const bool isSync = false;

    explicit DidDeleteObjectStore(const WebCore::IDBResultData& result)
        : m_arguments(result)
    {
    }

    const std::tuple<const WebCore::IDBResultData&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const WebCore::IDBResultData&> m_arguments;
};

class DidClearObjectStore {
public:
    typedef std::tuple<WebCore::IDBResultData> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("DidClearObjectStore"); }
    static const bool isSync = false;

    explicit DidClearObjectStore(const WebCore::IDBResultData& result)
        : m_arguments(result)
    {
    }

    const std::tuple<const WebCore::IDBResultData&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const WebCore::IDBResultData&> m_arguments;
};

class DidCreateIndex {
public:
    typedef std::tuple<WebCore::IDBResultData> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("DidCreateIndex"); }
    static const bool isSync = false;

    explicit DidCreateIndex(const WebCore::IDBResultData& result)
        : m_arguments(result)
    {
    }

    const std::tuple<const WebCore::IDBResultData&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const WebCore::IDBResultData&> m_arguments;
};

class DidDeleteIndex {
public:
    typedef std::tuple<WebCore::IDBResultData> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("DidDeleteIndex"); }
    static const bool isSync = false;

    explicit DidDeleteIndex(const WebCore::IDBResultData& result)
        : m_arguments(result)
    {
    }

    const std::tuple<const WebCore::IDBResultData&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const WebCore::IDBResultData&> m_arguments;
};

class DidPutOrAdd {
public:
    typedef std::tuple<WebCore::IDBResultData> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("DidPutOrAdd"); }
    static const bool isSync = false;

    explicit DidPutOrAdd(const WebCore::IDBResultData& result)
        : m_arguments(result)
    {
    }

    const std::tuple<const WebCore::IDBResultData&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const WebCore::IDBResultData&> m_arguments;
};

class DidGetRecord {
public:
    typedef std::tuple<WebCore::IDBResultData> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("DidGetRecord"); }
    static const bool isSync = false;

    explicit DidGetRecord(const WebCore::IDBResultData& result)
        : m_arguments(result)
    {
    }

    const std::tuple<const WebCore::IDBResultData&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const WebCore::IDBResultData&> m_arguments;
};

class DidGetCount {
public:
    typedef std::tuple<WebCore::IDBResultData> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("DidGetCount"); }
    static const bool isSync = false;

    explicit DidGetCount(const WebCore::IDBResultData& result)
        : m_arguments(result)
    {
    }

    const std::tuple<const WebCore::IDBResultData&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const WebCore::IDBResultData&> m_arguments;
};

class DidDeleteRecord {
public:
    typedef std::tuple<WebCore::IDBResultData> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("DidDeleteRecord"); }
    static const bool isSync = false;

    explicit DidDeleteRecord(const WebCore::IDBResultData& result)
        : m_arguments(result)
    {
    }

    const std::tuple<const WebCore::IDBResultData&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const WebCore::IDBResultData&> m_arguments;
};

class DidOpenCursor {
public:
    typedef std::tuple<WebCore::IDBResultData> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("DidOpenCursor"); }
    static const bool isSync = false;

    explicit DidOpenCursor(const WebCore::IDBResultData& result)
        : m_arguments(result)
    {
    }

    const std::tuple<const WebCore::IDBResultData&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const WebCore::IDBResultData&> m_arguments;
};

class DidIterateCursor {
public:
    typedef std::tuple<WebCore::IDBResultData> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("DidIterateCursor"); }
    static const bool isSync = false;

    explicit DidIterateCursor(const WebCore::IDBResultData& result)
        : m_arguments(result)
    {
    }

    const std::tuple<const WebCore::IDBResultData&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const WebCore::IDBResultData&> m_arguments;
};

class FireVersionChangeEvent {
public:
    typedef std::tuple<uint64_t, WebCore::IDBResourceIdentifier, uint64_t> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("FireVersionChangeEvent"); }
    static const bool isSync = false;

    FireVersionChangeEvent(uint64_t databaseConnectionIdentifier, const WebCore::IDBResourceIdentifier& requestIdentifier, uint64_t requestedVersion)
        : m_arguments(databaseConnectionIdentifier, requestIdentifier, requestedVersion)
    {
    }

    const std::tuple<uint64_t, const WebCore::IDBResourceIdentifier&, uint64_t>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<uint64_t, const WebCore::IDBResourceIdentifier&, uint64_t> m_arguments;
};

class DidStartTransaction {
public:
    typedef std::tuple<WebCore::IDBResourceIdentifier, WebCore::IDBError> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("DidStartTransaction"); }
    static const bool isSync = false;

    DidStartTransaction(const WebCore::IDBResourceIdentifier& transactionIdentifier, const WebCore::IDBError& error)
        : m_arguments(transactionIdentifier, error)
    {
    }

    const std::tuple<const WebCore::IDBResourceIdentifier&, const WebCore::IDBError&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const WebCore::IDBResourceIdentifier&, const WebCore::IDBError&> m_arguments;
};

class NotifyOpenDBRequestBlocked {
public:
    typedef std::tuple<WebCore::IDBResourceIdentifier, uint64_t, uint64_t> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("NotifyOpenDBRequestBlocked"); }
    static const bool isSync = false;

    NotifyOpenDBRequestBlocked(const WebCore::IDBResourceIdentifier& requestIdentifier, uint64_t oldVersion, uint64_t newVersion)
        : m_arguments(requestIdentifier, oldVersion, newVersion)
    {
    }

    const std::tuple<const WebCore::IDBResourceIdentifier&, uint64_t, uint64_t>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const WebCore::IDBResourceIdentifier&, uint64_t, uint64_t> m_arguments;
};

} // namespace WebIDBConnectionToServer
} // namespace Messages

#endif // ENABLE(INDEXED_DATABASE) && ENABLE(DATABASE_PROCESS)

#endif // WebIDBConnectionToServerMessages_h
