/*
 * Copyright (c) 2015 Canon Inc.
 * Copyright (c) 2015 Igalia
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "WritableStreamInternalsBuiltins.h"

#if ENABLE(STREAMS_API)

#include "WebCoreJSClientData.h"
#include <runtime/Executable.h>
#include <runtime/JSCJSValueInlines.h>
#include <runtime/JSCellInlines.h>
#include <runtime/StructureInlines.h>
#include <runtime/VM.h>

namespace WebCore {

const JSC::ConstructAbility s_writableStreamInternalsIsWritableStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_writableStreamInternalsIsWritableStreamCodeLength = 100;
const char* s_writableStreamInternalsIsWritableStreamCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    return @isObject(stream) && !!stream.@underlyingSink;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_writableStreamInternalsSyncWritableStreamStateWithQueueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_writableStreamInternalsSyncWritableStreamStateWithQueueCodeLength = 641;
const char* s_writableStreamInternalsSyncWritableStreamStateWithQueueCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (stream.@state === @streamClosing)\n" \
    "        return;\n" \
    "    @assert(stream.@state === @streamWritable || stream.@state === @streamWaiting);\n" \
    "    const shouldApplyBackpressure = stream.@queue.size > stream.@strategy.highWaterMark;\n" \
    "    if (shouldApplyBackpressure && stream.@state === @streamWritable) {\n" \
    "        stream.@state = @streamWaiting;\n" \
    "        stream.@readyPromiseCapability = @newPromiseCapability(@Promise);\n" \
    "    }\n" \
    "    if (!shouldApplyBackpressure && stream.@state === @streamWaiting) {\n" \
    "        stream.@state = @streamWritable;\n" \
    "        stream.@readyPromiseCapability.@resolve.@call();\n" \
    "    }\n" \
    "})\n" \
;

const JSC::ConstructAbility s_writableStreamInternalsErrorWritableStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_writableStreamInternalsErrorWritableStreamCodeLength = 588;
const char* s_writableStreamInternalsErrorWritableStreamCode =
    "(function (stream, e)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (stream.@state === @streamClosed || stream.@state === @streamErrored)\n" \
    "        return;\n" \
    "    while (stream.@queue.content.length > 0) {\n" \
    "        const writeRecord = @dequeueValue(stream.@queue);\n" \
    "        if (writeRecord !== \"close\")\n" \
    "            writeRecord.promiseCapability.@reject.@call(@undefined, e);\n" \
    "    }\n" \
    "    stream.@storedError = e;\n" \
    "    if (stream.@state === @streamWaiting)\n" \
    "        stream.@readyPromiseCapability.@resolve.@call();\n" \
    "    stream.@closedPromiseCapability.@reject.@call(@undefined, e);\n" \
    "    stream.@state = @streamErrored;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_writableStreamInternalsCallOrScheduleWritableStreamAdvanceQueueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_writableStreamInternalsCallOrScheduleWritableStreamAdvanceQueueCodeLength = 213;
const char* s_writableStreamInternalsCallOrScheduleWritableStreamAdvanceQueueCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!stream.@started)\n" \
    "        stream.@startedPromise.@then(function() { @writableStreamAdvanceQueue(stream); });\n" \
    "    else\n" \
    "        @writableStreamAdvanceQueue(stream);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_writableStreamInternalsWritableStreamAdvanceQueueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_writableStreamInternalsWritableStreamAdvanceQueueCodeLength = 961;
const char* s_writableStreamInternalsWritableStreamAdvanceQueueCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (stream.@queue.content.length === 0 || stream.@writing)\n" \
    "        return;\n" \
    "    const writeRecord = @peekQueueValue(stream.@queue);\n" \
    "    if (writeRecord === \"close\") {\n" \
    "        @assert(stream.@state === @streamClosing);\n" \
    "        @dequeueValue(stream.@queue);\n" \
    "        @assert(stream.@queue.content.length === 0);\n" \
    "        @closeWritableStream(stream);\n" \
    "        return;\n" \
    "    }\n" \
    "    stream.@writing = true;\n" \
    "    @promiseInvokeOrNoop(stream.@underlyingSink, \"write\", [writeRecord.chunk]).@then(\n" \
    "        function() {\n" \
    "            if (stream.@state === @streamErrored)\n" \
    "                return;\n" \
    "            stream.@writing = false;\n" \
    "            writeRecord.promiseCapability.@resolve.@call();\n" \
    "            @dequeueValue(stream.@queue);\n" \
    "            @syncWritableStreamStateWithQueue(stream);\n" \
    "            @writableStreamAdvanceQueue(stream);\n" \
    "        },\n" \
    "        function(r) {\n" \
    "            @errorWritableStream(stream, r);\n" \
    "        }\n" \
    "    );\n" \
    "})\n" \
;

const JSC::ConstructAbility s_writableStreamInternalsCloseWritableStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_writableStreamInternalsCloseWritableStreamCodeLength = 504;
const char* s_writableStreamInternalsCloseWritableStreamCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    @assert(stream.@state === @streamClosing);\n" \
    "    @promiseInvokeOrNoop(stream.@underlyingSink, \"close\").@then(\n" \
    "        function() {\n" \
    "            if (stream.@state === @streamErrored)\n" \
    "                return;\n" \
    "            @assert(stream.@state === @streamClosing);\n" \
    "            stream.@closedPromiseCapability.@resolve.@call();\n" \
    "            stream.@state = @streamClosed;\n" \
    "        },\n" \
    "        function(r) {\n" \
    "            @errorWritableStream(stream, r);\n" \
    "        }\n" \
    "    );\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = static_cast<JSVMClientData*>(vm.clientData); \
    return clientData->builtinFunctions().writableStreamInternalsBuiltins().codeName##Executable()->link(vm, clientData->builtinFunctions().writableStreamInternalsBuiltins().codeName##Source()); \
}
WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore

#endif // ENABLE(STREAMS_API)
