/* This file is automatically generated from CSSPropertyNames.in by makeprop, do not edit */

#include "config.h"
#include "StyleBuilder.h"

#include "CSSPrimitiveValueMappings.h"
#include "CSSProperty.h"
#include "RenderStyle.h"
#include "StyleBuilderConverter.h"
#include "StyleBuilderCustom.h"
#include "StylePropertyShorthand.h"
#include "StyleResolver.h"

namespace WebCore {

class StyleBuilderFunctions {
public:
    static void applyInitialColor(StyleResolver& styleResolver)
    {
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setColor(RenderStyle::initialColor());
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkColor(RenderStyle::initialColor());
    }
    static void applyInheritColor(StyleResolver& styleResolver)
    {
        Color color = styleResolver.parentStyle()->color();
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setColor(color);
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkColor(color);
    }
    static void applyValueColor(StyleResolver& styleResolver, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (primitiveValue.getValueID() == CSSValueCurrentcolor) {
            applyInheritColor(styleResolver);
            return;
        }
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialDirection(StyleResolver& styleResolver)
    {
        styleResolver.style()->setDirection(RenderStyle::initialDirection());
    }
    static void applyInheritDirection(StyleResolver& styleResolver)
    {
        styleResolver.style()->setDirection(styleResolver.parentStyle()->direction());
    }
    static void applyInitialDisplay(StyleResolver& styleResolver)
    {
        styleResolver.style()->setDisplay(RenderStyle::initialDisplay());
    }
    static void applyInitialFontStyle(StyleResolver& styleResolver)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setItalic(FontCascadeDescription::initialItalic());
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyInheritFontStyle(StyleResolver& styleResolver)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setItalic(styleResolver.parentFontDescription().italic());
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyValueFontStyle(StyleResolver& styleResolver, CSSValue& value)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setItalic(downcast<CSSPrimitiveValue>(value));
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyInitialTextRendering(StyleResolver& styleResolver)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setTextRenderingMode(FontCascadeDescription::initialTextRenderingMode());
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyInheritTextRendering(StyleResolver& styleResolver)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setTextRenderingMode(styleResolver.parentFontDescription().textRenderingMode());
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyValueTextRendering(StyleResolver& styleResolver, CSSValue& value)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setTextRenderingMode(downcast<CSSPrimitiveValue>(value));
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyValueFontFeatureSettings(StyleResolver& styleResolver, CSSValue& value)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setFeatureSettings(StyleBuilderConverter::convertFontFeatureSettings(styleResolver, value));
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyInitialWebkitFontKerning(StyleResolver& styleResolver)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setKerning(FontCascadeDescription::initialKerning());
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyInheritWebkitFontKerning(StyleResolver& styleResolver)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setKerning(styleResolver.parentFontDescription().kerning());
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyValueWebkitFontKerning(StyleResolver& styleResolver, CSSValue& value)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setKerning(downcast<CSSPrimitiveValue>(value));
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyInitialWebkitFontSmoothing(StyleResolver& styleResolver)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setFontSmoothing(FontCascadeDescription::initialFontSmoothing());
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyInheritWebkitFontSmoothing(StyleResolver& styleResolver)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setFontSmoothing(styleResolver.parentFontDescription().fontSmoothing());
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyValueWebkitFontSmoothing(StyleResolver& styleResolver, CSSValue& value)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setFontSmoothing(downcast<CSSPrimitiveValue>(value));
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyInitialFontVariantPosition(StyleResolver& styleResolver)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setVariantPosition(FontCascadeDescription::initialVariantPosition());
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyInheritFontVariantPosition(StyleResolver& styleResolver)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setVariantPosition(styleResolver.parentFontDescription().variantPosition());
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyValueFontVariantPosition(StyleResolver& styleResolver, CSSValue& value)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setVariantPosition(downcast<CSSPrimitiveValue>(value));
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyInitialFontVariantCaps(StyleResolver& styleResolver)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setVariantCaps(FontCascadeDescription::initialVariantCaps());
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyInheritFontVariantCaps(StyleResolver& styleResolver)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setVariantCaps(styleResolver.parentFontDescription().variantCaps());
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyValueFontVariantCaps(StyleResolver& styleResolver, CSSValue& value)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setVariantCaps(downcast<CSSPrimitiveValue>(value));
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyInitialFontVariantAlternates(StyleResolver& styleResolver)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setVariantAlternates(FontCascadeDescription::initialVariantAlternates());
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyInheritFontVariantAlternates(StyleResolver& styleResolver)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setVariantAlternates(styleResolver.parentFontDescription().variantAlternates());
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyValueFontVariantAlternates(StyleResolver& styleResolver, CSSValue& value)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setVariantAlternates(downcast<CSSPrimitiveValue>(value));
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyInitialWebkitLocale(StyleResolver& styleResolver)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setLocale(FontCascadeDescription::initialLocale());
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyInheritWebkitLocale(StyleResolver& styleResolver)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setLocale(styleResolver.parentFontDescription().locale());
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyInitialWebkitTextOrientation(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextOrientation(RenderStyle::initialTextOrientation());
    }
    static void applyInheritWebkitTextOrientation(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextOrientation(styleResolver.parentStyle()->textOrientation());
    }
    static void applyInitialWebkitWritingMode(StyleResolver& styleResolver)
    {
        styleResolver.style()->setWritingMode(RenderStyle::initialWritingMode());
    }
    static void applyInheritWebkitWritingMode(StyleResolver& styleResolver)
    {
        styleResolver.style()->setWritingMode(styleResolver.parentStyle()->writingMode());
    }
    static void applyInitialWebkitTextZoom(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextZoom(RenderStyle::initialTextZoom());
    }
    static void applyInheritWebkitTextZoom(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextZoom(styleResolver.parentStyle()->textZoom());
    }
    static void applyInitialFontSynthesis(StyleResolver& styleResolver)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setFontSynthesis(FontCascadeDescription::initialFontSynthesis());
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyInheritFontSynthesis(StyleResolver& styleResolver)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setFontSynthesis(styleResolver.parentFontDescription().fontSynthesis());
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyValueFontSynthesis(StyleResolver& styleResolver, CSSValue& value)
    {
        auto fontDescription = styleResolver.fontDescription();
        fontDescription.setFontSynthesis(StyleBuilderConverter::convertFontSynthesis(styleResolver, value));
        styleResolver.setFontDescription(fontDescription);
    }
    static void applyInitialWebkitRubyPosition(StyleResolver& styleResolver)
    {
        styleResolver.style()->setRubyPosition(RenderStyle::initialRubyPosition());
    }
    static void applyInheritWebkitRubyPosition(StyleResolver& styleResolver)
    {
        styleResolver.style()->setRubyPosition(styleResolver.parentStyle()->rubyPosition());
    }
    static void applyValueWebkitRubyPosition(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setRubyPosition(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialAlignmentBaseline(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setAlignmentBaseline(SVGRenderStyle::initialAlignmentBaseline());
    }
    static void applyInheritAlignmentBaseline(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setAlignmentBaseline(styleResolver.parentStyle()->svgStyle().alignmentBaseline());
    }
    static void applyValueAlignmentBaseline(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setAlignmentBaseline(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialAnimationDelay(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setDelay(Animation::initialDelay());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearDelay();
    }
    static void applyInheritAnimationDelay(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        const AnimationList* parentList = styleResolver.parentStyle()->animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isDelaySet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setDelay(parentList->animation(i).delay());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        /* Reset any remaining animations to not have the property set. */
        for ( ; i < list.size(); ++i)
            list.animation(i).clearDelay();
    }
    static void applyValueAnimationDelay(StyleResolver& styleResolver, CSSValue& value)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                styleResolver.styleMap()->mapAnimationDelay(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            styleResolver.styleMap()->mapAnimationDelay(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearDelay();
        }
    }
    static void applyInitialAnimationDirection(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setDirection(Animation::initialDirection());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearDirection();
    }
    static void applyInheritAnimationDirection(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        const AnimationList* parentList = styleResolver.parentStyle()->animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isDirectionSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setDirection(parentList->animation(i).direction());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        /* Reset any remaining animations to not have the property set. */
        for ( ; i < list.size(); ++i)
            list.animation(i).clearDirection();
    }
    static void applyValueAnimationDirection(StyleResolver& styleResolver, CSSValue& value)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                styleResolver.styleMap()->mapAnimationDirection(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            styleResolver.styleMap()->mapAnimationDirection(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearDirection();
        }
    }
    static void applyInitialAnimationDuration(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setDuration(Animation::initialDuration());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearDuration();
    }
    static void applyInheritAnimationDuration(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        const AnimationList* parentList = styleResolver.parentStyle()->animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isDurationSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setDuration(parentList->animation(i).duration());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        /* Reset any remaining animations to not have the property set. */
        for ( ; i < list.size(); ++i)
            list.animation(i).clearDuration();
    }
    static void applyValueAnimationDuration(StyleResolver& styleResolver, CSSValue& value)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                styleResolver.styleMap()->mapAnimationDuration(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            styleResolver.styleMap()->mapAnimationDuration(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearDuration();
        }
    }
    static void applyInitialAnimationFillMode(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setFillMode(Animation::initialFillMode());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearFillMode();
    }
    static void applyInheritAnimationFillMode(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        const AnimationList* parentList = styleResolver.parentStyle()->animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isFillModeSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setFillMode(parentList->animation(i).fillMode());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        /* Reset any remaining animations to not have the property set. */
        for ( ; i < list.size(); ++i)
            list.animation(i).clearFillMode();
    }
    static void applyValueAnimationFillMode(StyleResolver& styleResolver, CSSValue& value)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                styleResolver.styleMap()->mapAnimationFillMode(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            styleResolver.styleMap()->mapAnimationFillMode(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearFillMode();
        }
    }
    static void applyInitialAnimationIterationCount(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setIterationCount(Animation::initialIterationCount());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearIterationCount();
    }
    static void applyInheritAnimationIterationCount(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        const AnimationList* parentList = styleResolver.parentStyle()->animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isIterationCountSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setIterationCount(parentList->animation(i).iterationCount());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        /* Reset any remaining animations to not have the property set. */
        for ( ; i < list.size(); ++i)
            list.animation(i).clearIterationCount();
    }
    static void applyValueAnimationIterationCount(StyleResolver& styleResolver, CSSValue& value)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                styleResolver.styleMap()->mapAnimationIterationCount(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            styleResolver.styleMap()->mapAnimationIterationCount(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearIterationCount();
        }
    }
    static void applyInitialAnimationName(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setName(Animation::initialName());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearName();
    }
    static void applyInheritAnimationName(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        const AnimationList* parentList = styleResolver.parentStyle()->animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isNameSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setName(parentList->animation(i).name());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        /* Reset any remaining animations to not have the property set. */
        for ( ; i < list.size(); ++i)
            list.animation(i).clearName();
    }
    static void applyValueAnimationName(StyleResolver& styleResolver, CSSValue& value)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                styleResolver.styleMap()->mapAnimationName(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            styleResolver.styleMap()->mapAnimationName(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearName();
        }
    }
    static void applyInitialAnimationPlayState(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setPlayState(Animation::initialPlayState());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearPlayState();
    }
    static void applyInheritAnimationPlayState(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        const AnimationList* parentList = styleResolver.parentStyle()->animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isPlayStateSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setPlayState(parentList->animation(i).playState());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        /* Reset any remaining animations to not have the property set. */
        for ( ; i < list.size(); ++i)
            list.animation(i).clearPlayState();
    }
    static void applyValueAnimationPlayState(StyleResolver& styleResolver, CSSValue& value)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                styleResolver.styleMap()->mapAnimationPlayState(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            styleResolver.styleMap()->mapAnimationPlayState(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearPlayState();
        }
    }
    static void applyInitialAnimationTimingFunction(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setTimingFunction(Animation::initialTimingFunction());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearTimingFunction();
    }
    static void applyInheritAnimationTimingFunction(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        const AnimationList* parentList = styleResolver.parentStyle()->animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isTimingFunctionSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setTimingFunction(parentList->animation(i).timingFunction());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        /* Reset any remaining animations to not have the property set. */
        for ( ; i < list.size(); ++i)
            list.animation(i).clearTimingFunction();
    }
    static void applyValueAnimationTimingFunction(StyleResolver& styleResolver, CSSValue& value)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                styleResolver.styleMap()->mapAnimationTimingFunction(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            styleResolver.styleMap()->mapAnimationTimingFunction(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearTimingFunction();
        }
    }
    static void applyInitialBackgroundAttachment(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->backgroundLayers();
        if (!layers.next() && (!layers.isAttachmentSet() || layers.attachment() == FillLayer::initialFillAttachment(BackgroundFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        child->setAttachment(FillLayer::initialFillAttachment(BackgroundFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearAttachment();
    }
    static void applyInheritBackgroundAttachment(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->backgroundLayers() == *styleResolver.style()->backgroundLayers())
            return;

        auto* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->backgroundLayers(); parent && parent->isAttachmentSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                child = previousChild->next();
            }
            child->setAttachment(parent->attachment());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearAttachment();
    }
    static void applyValueBackgroundAttachment(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillAttachment(CSSPropertyBackgroundAttachment, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillAttachment(CSSPropertyBackgroundAttachment, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearAttachment();
    }
    static void applyInitialBackgroundBlendMode(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->backgroundLayers();
        if (!layers.next() && (!layers.isBlendModeSet() || layers.blendMode() == FillLayer::initialFillBlendMode(BackgroundFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        child->setBlendMode(FillLayer::initialFillBlendMode(BackgroundFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearBlendMode();
    }
    static void applyInheritBackgroundBlendMode(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->backgroundLayers() == *styleResolver.style()->backgroundLayers())
            return;

        auto* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->backgroundLayers(); parent && parent->isBlendModeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                child = previousChild->next();
            }
            child->setBlendMode(parent->blendMode());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearBlendMode();
    }
    static void applyValueBackgroundBlendMode(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillBlendMode(CSSPropertyBackgroundBlendMode, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillBlendMode(CSSPropertyBackgroundBlendMode, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearBlendMode();
    }
    static void applyInitialBackgroundClip(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->backgroundLayers();
        if (!layers.next() && (!layers.isClipSet() || layers.clip() == FillLayer::initialFillClip(BackgroundFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        child->setClip(FillLayer::initialFillClip(BackgroundFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearClip();
    }
    static void applyInheritBackgroundClip(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->backgroundLayers() == *styleResolver.style()->backgroundLayers())
            return;

        auto* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->backgroundLayers(); parent && parent->isClipSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                child = previousChild->next();
            }
            child->setClip(parent->clip());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyValueBackgroundClip(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillClip(CSSPropertyBackgroundClip, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillClip(CSSPropertyBackgroundClip, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyInitialBackgroundColor(StyleResolver& styleResolver)
    {
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setBackgroundColor(RenderStyle::initialBackgroundColor());
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkBackgroundColor(RenderStyle::initialBackgroundColor());
    }
    static void applyInheritBackgroundColor(StyleResolver& styleResolver)
    {
        Color color = styleResolver.parentStyle()->backgroundColor();
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setBackgroundColor(color);
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkBackgroundColor(color);
    }
    static void applyValueBackgroundColor(StyleResolver& styleResolver, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setBackgroundColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkBackgroundColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialBackgroundImage(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->backgroundLayers();
        if (!layers.next() && (!layers.isImageSet() || layers.image() == FillLayer::initialFillImage(BackgroundFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        child->setImage(FillLayer::initialFillImage(BackgroundFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearImage();
    }
    static void applyInheritBackgroundImage(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->backgroundLayers() == *styleResolver.style()->backgroundLayers())
            return;

        auto* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->backgroundLayers(); parent && parent->isImageSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                child = previousChild->next();
            }
            child->setImage(parent->image());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearImage();
    }
    static void applyValueBackgroundImage(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillImage(CSSPropertyBackgroundImage, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillImage(CSSPropertyBackgroundImage, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearImage();
    }
    static void applyInitialBackgroundOrigin(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->backgroundLayers();
        if (!layers.next() && (!layers.isOriginSet() || layers.origin() == FillLayer::initialFillOrigin(BackgroundFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        child->setOrigin(FillLayer::initialFillOrigin(BackgroundFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearOrigin();
    }
    static void applyInheritBackgroundOrigin(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->backgroundLayers() == *styleResolver.style()->backgroundLayers())
            return;

        auto* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->backgroundLayers(); parent && parent->isOriginSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                child = previousChild->next();
            }
            child->setOrigin(parent->origin());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearOrigin();
    }
    static void applyValueBackgroundOrigin(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillOrigin(CSSPropertyBackgroundOrigin, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillOrigin(CSSPropertyBackgroundOrigin, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearOrigin();
    }
    static void applyInitialBackgroundPositionX(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->backgroundLayers();
        if (!layers.next() && (!layers.isXPositionSet() || layers.xPosition() == FillLayer::initialFillXPosition(BackgroundFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        child->setXPosition(FillLayer::initialFillXPosition(BackgroundFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearXPosition();
    }
    static void applyInheritBackgroundPositionX(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->backgroundLayers() == *styleResolver.style()->backgroundLayers())
            return;

        auto* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->backgroundLayers(); parent && parent->isXPositionSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                child = previousChild->next();
            }
            child->setXPosition(parent->xPosition());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearXPosition();
    }
    static void applyValueBackgroundPositionX(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillXPosition(CSSPropertyBackgroundPositionX, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillXPosition(CSSPropertyBackgroundPositionX, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearXPosition();
    }
    static void applyInitialBackgroundPositionY(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->backgroundLayers();
        if (!layers.next() && (!layers.isYPositionSet() || layers.yPosition() == FillLayer::initialFillYPosition(BackgroundFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        child->setYPosition(FillLayer::initialFillYPosition(BackgroundFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearYPosition();
    }
    static void applyInheritBackgroundPositionY(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->backgroundLayers() == *styleResolver.style()->backgroundLayers())
            return;

        auto* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->backgroundLayers(); parent && parent->isYPositionSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                child = previousChild->next();
            }
            child->setYPosition(parent->yPosition());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearYPosition();
    }
    static void applyValueBackgroundPositionY(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillYPosition(CSSPropertyBackgroundPositionY, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillYPosition(CSSPropertyBackgroundPositionY, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearYPosition();
    }
    static void applyInitialBackgroundRepeatX(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->backgroundLayers();
        if (!layers.next() && (!layers.isRepeatXSet() || layers.repeatX() == FillLayer::initialFillRepeatX(BackgroundFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        child->setRepeatX(FillLayer::initialFillRepeatX(BackgroundFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearRepeatX();
    }
    static void applyInheritBackgroundRepeatX(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->backgroundLayers() == *styleResolver.style()->backgroundLayers())
            return;

        auto* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->backgroundLayers(); parent && parent->isRepeatXSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                child = previousChild->next();
            }
            child->setRepeatX(parent->repeatX());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearRepeatX();
    }
    static void applyValueBackgroundRepeatX(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillRepeatX(CSSPropertyBackgroundRepeatX, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillRepeatX(CSSPropertyBackgroundRepeatX, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearRepeatX();
    }
    static void applyInitialBackgroundRepeatY(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->backgroundLayers();
        if (!layers.next() && (!layers.isRepeatYSet() || layers.repeatY() == FillLayer::initialFillRepeatY(BackgroundFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        child->setRepeatY(FillLayer::initialFillRepeatY(BackgroundFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearRepeatY();
    }
    static void applyInheritBackgroundRepeatY(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->backgroundLayers() == *styleResolver.style()->backgroundLayers())
            return;

        auto* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->backgroundLayers(); parent && parent->isRepeatYSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                child = previousChild->next();
            }
            child->setRepeatY(parent->repeatY());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearRepeatY();
    }
    static void applyValueBackgroundRepeatY(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillRepeatY(CSSPropertyBackgroundRepeatY, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillRepeatY(CSSPropertyBackgroundRepeatY, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearRepeatY();
    }
    static void applyInitialBackgroundSize(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->backgroundLayers();
        if (!layers.next() && (!layers.isSizeSet() || layers.size() == FillLayer::initialFillSize(BackgroundFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        child->setSize(FillLayer::initialFillSize(BackgroundFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearSize();
    }
    static void applyInheritBackgroundSize(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->backgroundLayers() == *styleResolver.style()->backgroundLayers())
            return;

        auto* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->backgroundLayers(); parent && parent->isSizeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                child = previousChild->next();
            }
            child->setSize(parent->size());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearSize();
    }
    static void applyValueBackgroundSize(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillSize(CSSPropertyBackgroundSize, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillSize(CSSPropertyBackgroundSize, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearSize();
    }
    static void applyInitialBaselineShift(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setBaselineShift(SVGRenderStyle::initialBaselineShift());
    }
    static void applyInheritBaselineShift(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setBaselineShift(styleResolver.parentStyle()->svgStyle().baselineShift());
    }
    static void applyInitialBorderBottomColor(StyleResolver& styleResolver)
    {
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setBorderBottomColor(RenderStyle::invalidColor());
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkBorderBottomColor(RenderStyle::invalidColor());
    }
    static void applyInheritBorderBottomColor(StyleResolver& styleResolver)
    {
        Color color = styleResolver.parentStyle()->borderBottomColor();
        if (!color.isValid())
            color = styleResolver.parentStyle()->color();
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setBorderBottomColor(color);
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkBorderBottomColor(color);
    }
    static void applyValueBorderBottomColor(StyleResolver& styleResolver, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setBorderBottomColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkBorderBottomColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialBorderBottomLeftRadius(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderBottomLeftRadius(RenderStyle::initialBorderRadius());
    }
    static void applyInheritBorderBottomLeftRadius(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderBottomLeftRadius(styleResolver.parentStyle()->borderBottomLeftRadius());
    }
    static void applyValueBorderBottomLeftRadius(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBorderBottomLeftRadius(StyleBuilderConverter::convertRadius(styleResolver, value));
    }
    static void applyInitialBorderBottomRightRadius(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderBottomRightRadius(RenderStyle::initialBorderRadius());
    }
    static void applyInheritBorderBottomRightRadius(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderBottomRightRadius(styleResolver.parentStyle()->borderBottomRightRadius());
    }
    static void applyValueBorderBottomRightRadius(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBorderBottomRightRadius(StyleBuilderConverter::convertRadius(styleResolver, value));
    }
    static void applyInitialBorderBottomStyle(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderBottomStyle(RenderStyle::initialBorderStyle());
    }
    static void applyInheritBorderBottomStyle(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderBottomStyle(styleResolver.parentStyle()->borderBottomStyle());
    }
    static void applyValueBorderBottomStyle(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBorderBottomStyle(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialBorderBottomWidth(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderBottomWidth(RenderStyle::initialBorderWidth());
    }
    static void applyInheritBorderBottomWidth(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderBottomWidth(styleResolver.parentStyle()->borderBottomWidth());
    }
    static void applyValueBorderBottomWidth(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBorderBottomWidth(StyleBuilderConverter::convertLineWidth<float>(styleResolver, value));
    }
    static void applyInitialBorderCollapse(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderCollapse(RenderStyle::initialBorderCollapse());
    }
    static void applyInheritBorderCollapse(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderCollapse(styleResolver.parentStyle()->borderCollapse());
    }
    static void applyValueBorderCollapse(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBorderCollapse(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialBorderImageSource(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderImageSource(RenderStyle::initialBorderImageSource());
    }
    static void applyInheritBorderImageSource(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderImageSource(styleResolver.parentStyle()->borderImageSource());
    }
    static void applyValueBorderImageSource(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBorderImageSource(StyleBuilderConverter::convertStyleImage<CSSPropertyBorderImageSource>(styleResolver, value));
    }
    static void applyInitialBorderLeftColor(StyleResolver& styleResolver)
    {
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setBorderLeftColor(RenderStyle::invalidColor());
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkBorderLeftColor(RenderStyle::invalidColor());
    }
    static void applyInheritBorderLeftColor(StyleResolver& styleResolver)
    {
        Color color = styleResolver.parentStyle()->borderLeftColor();
        if (!color.isValid())
            color = styleResolver.parentStyle()->color();
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setBorderLeftColor(color);
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkBorderLeftColor(color);
    }
    static void applyValueBorderLeftColor(StyleResolver& styleResolver, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setBorderLeftColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkBorderLeftColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialBorderLeftStyle(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderLeftStyle(RenderStyle::initialBorderStyle());
    }
    static void applyInheritBorderLeftStyle(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderLeftStyle(styleResolver.parentStyle()->borderLeftStyle());
    }
    static void applyValueBorderLeftStyle(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBorderLeftStyle(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialBorderLeftWidth(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderLeftWidth(RenderStyle::initialBorderWidth());
    }
    static void applyInheritBorderLeftWidth(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderLeftWidth(styleResolver.parentStyle()->borderLeftWidth());
    }
    static void applyValueBorderLeftWidth(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBorderLeftWidth(StyleBuilderConverter::convertLineWidth<float>(styleResolver, value));
    }
    static void applyInitialBorderRightColor(StyleResolver& styleResolver)
    {
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setBorderRightColor(RenderStyle::invalidColor());
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkBorderRightColor(RenderStyle::invalidColor());
    }
    static void applyInheritBorderRightColor(StyleResolver& styleResolver)
    {
        Color color = styleResolver.parentStyle()->borderRightColor();
        if (!color.isValid())
            color = styleResolver.parentStyle()->color();
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setBorderRightColor(color);
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkBorderRightColor(color);
    }
    static void applyValueBorderRightColor(StyleResolver& styleResolver, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setBorderRightColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkBorderRightColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialBorderRightStyle(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderRightStyle(RenderStyle::initialBorderStyle());
    }
    static void applyInheritBorderRightStyle(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderRightStyle(styleResolver.parentStyle()->borderRightStyle());
    }
    static void applyValueBorderRightStyle(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBorderRightStyle(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialBorderRightWidth(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderRightWidth(RenderStyle::initialBorderWidth());
    }
    static void applyInheritBorderRightWidth(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderRightWidth(styleResolver.parentStyle()->borderRightWidth());
    }
    static void applyValueBorderRightWidth(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBorderRightWidth(StyleBuilderConverter::convertLineWidth<float>(styleResolver, value));
    }
    static void applyInitialBorderTopColor(StyleResolver& styleResolver)
    {
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setBorderTopColor(RenderStyle::invalidColor());
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkBorderTopColor(RenderStyle::invalidColor());
    }
    static void applyInheritBorderTopColor(StyleResolver& styleResolver)
    {
        Color color = styleResolver.parentStyle()->borderTopColor();
        if (!color.isValid())
            color = styleResolver.parentStyle()->color();
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setBorderTopColor(color);
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkBorderTopColor(color);
    }
    static void applyValueBorderTopColor(StyleResolver& styleResolver, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setBorderTopColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkBorderTopColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialBorderTopLeftRadius(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderTopLeftRadius(RenderStyle::initialBorderRadius());
    }
    static void applyInheritBorderTopLeftRadius(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderTopLeftRadius(styleResolver.parentStyle()->borderTopLeftRadius());
    }
    static void applyValueBorderTopLeftRadius(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBorderTopLeftRadius(StyleBuilderConverter::convertRadius(styleResolver, value));
    }
    static void applyInitialBorderTopRightRadius(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderTopRightRadius(RenderStyle::initialBorderRadius());
    }
    static void applyInheritBorderTopRightRadius(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderTopRightRadius(styleResolver.parentStyle()->borderTopRightRadius());
    }
    static void applyValueBorderTopRightRadius(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBorderTopRightRadius(StyleBuilderConverter::convertRadius(styleResolver, value));
    }
    static void applyInitialBorderTopStyle(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderTopStyle(RenderStyle::initialBorderStyle());
    }
    static void applyInheritBorderTopStyle(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderTopStyle(styleResolver.parentStyle()->borderTopStyle());
    }
    static void applyValueBorderTopStyle(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBorderTopStyle(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialBorderTopWidth(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderTopWidth(RenderStyle::initialBorderWidth());
    }
    static void applyInheritBorderTopWidth(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderTopWidth(styleResolver.parentStyle()->borderTopWidth());
    }
    static void applyValueBorderTopWidth(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBorderTopWidth(StyleBuilderConverter::convertLineWidth<float>(styleResolver, value));
    }
    static void applyInitialBottom(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBottom(RenderStyle::initialOffset());
    }
    static void applyInheritBottom(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBottom(styleResolver.parentStyle()->bottom());
    }
    static void applyValueBottom(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBottom(StyleBuilderConverter::convertLengthOrAuto(styleResolver, value));
    }
    static void applyInitialBoxSizing(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBoxSizing(RenderStyle::initialBoxSizing());
    }
    static void applyInheritBoxSizing(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBoxSizing(styleResolver.parentStyle()->boxSizing());
    }
    static void applyValueBoxSizing(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBoxSizing(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialBreakAfter(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakAfter(RenderStyle::initialBreakBetween());
    }
    static void applyInheritBreakAfter(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakAfter(styleResolver.parentStyle()->breakAfter());
    }
    static void applyValueBreakAfter(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBreakAfter(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialBreakBefore(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakBefore(RenderStyle::initialBreakBetween());
    }
    static void applyInheritBreakBefore(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakBefore(styleResolver.parentStyle()->breakBefore());
    }
    static void applyValueBreakBefore(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBreakBefore(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialBreakInside(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakInside(RenderStyle::initialBreakInside());
    }
    static void applyInheritBreakInside(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakInside(styleResolver.parentStyle()->breakInside());
    }
    static void applyValueBreakInside(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBreakInside(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialBufferedRendering(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setBufferedRendering(SVGRenderStyle::initialBufferedRendering());
    }
    static void applyInheritBufferedRendering(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setBufferedRendering(styleResolver.parentStyle()->svgStyle().bufferedRendering());
    }
    static void applyValueBufferedRendering(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setBufferedRendering(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialCaptionSide(StyleResolver& styleResolver)
    {
        styleResolver.style()->setCaptionSide(RenderStyle::initialCaptionSide());
    }
    static void applyInheritCaptionSide(StyleResolver& styleResolver)
    {
        styleResolver.style()->setCaptionSide(styleResolver.parentStyle()->captionSide());
    }
    static void applyValueCaptionSide(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setCaptionSide(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialClear(StyleResolver& styleResolver)
    {
        styleResolver.style()->setClear(RenderStyle::initialClear());
    }
    static void applyInheritClear(StyleResolver& styleResolver)
    {
        styleResolver.style()->setClear(styleResolver.parentStyle()->clear());
    }
    static void applyValueClear(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setClear(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitClipPath(StyleResolver& styleResolver)
    {
        styleResolver.style()->setClipPath(RenderStyle::initialClipPath());
    }
    static void applyInheritWebkitClipPath(StyleResolver& styleResolver)
    {
        styleResolver.style()->setClipPath(styleResolver.parentStyle()->clipPath());
    }
    static void applyValueWebkitClipPath(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setClipPath(StyleBuilderConverter::convertClipPath(styleResolver, value));
    }
    static void applyInitialClipPath(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setClipperResource(SVGRenderStyle::initialClipperResource());
    }
    static void applyInheritClipPath(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setClipperResource(styleResolver.parentStyle()->svgStyle().clipperResource());
    }
    static void applyValueClipPath(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setClipperResource(StyleBuilderConverter::convertSVGURIReference(styleResolver, value));
    }
    static void applyInitialClipRule(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setClipRule(SVGRenderStyle::initialClipRule());
    }
    static void applyInheritClipRule(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setClipRule(styleResolver.parentStyle()->svgStyle().clipRule());
    }
    static void applyValueClipRule(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setClipRule(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialColorInterpolation(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setColorInterpolation(SVGRenderStyle::initialColorInterpolation());
    }
    static void applyInheritColorInterpolation(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setColorInterpolation(styleResolver.parentStyle()->svgStyle().colorInterpolation());
    }
    static void applyValueColorInterpolation(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setColorInterpolation(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialColorInterpolationFilters(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setColorInterpolationFilters(SVGRenderStyle::initialColorInterpolationFilters());
    }
    static void applyInheritColorInterpolationFilters(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setColorInterpolationFilters(styleResolver.parentStyle()->svgStyle().colorInterpolationFilters());
    }
    static void applyValueColorInterpolationFilters(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setColorInterpolationFilters(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialColorRendering(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setColorRendering(SVGRenderStyle::initialColorRendering());
    }
    static void applyInheritColorRendering(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setColorRendering(styleResolver.parentStyle()->svgStyle().colorRendering());
    }
    static void applyValueColorRendering(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setColorRendering(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialCx(StyleResolver& styleResolver)
    {
        styleResolver.style()->setCx(RenderStyle::initialZeroLength());
    }
    static void applyInheritCx(StyleResolver& styleResolver)
    {
        styleResolver.style()->setCx(styleResolver.parentStyle()->cx());
    }
    static void applyValueCx(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setCx(StyleBuilderConverter::convertLength(styleResolver, value));
    }
    static void applyInitialCy(StyleResolver& styleResolver)
    {
        styleResolver.style()->setCy(RenderStyle::initialZeroLength());
    }
    static void applyInheritCy(StyleResolver& styleResolver)
    {
        styleResolver.style()->setCy(styleResolver.parentStyle()->cy());
    }
    static void applyValueCy(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setCy(StyleBuilderConverter::convertLength(styleResolver, value));
    }
    static void applyInitialDominantBaseline(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setDominantBaseline(SVGRenderStyle::initialDominantBaseline());
    }
    static void applyInheritDominantBaseline(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setDominantBaseline(styleResolver.parentStyle()->svgStyle().dominantBaseline());
    }
    static void applyValueDominantBaseline(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setDominantBaseline(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialEmptyCells(StyleResolver& styleResolver)
    {
        styleResolver.style()->setEmptyCells(RenderStyle::initialEmptyCells());
    }
    static void applyInheritEmptyCells(StyleResolver& styleResolver)
    {
        styleResolver.style()->setEmptyCells(styleResolver.parentStyle()->emptyCells());
    }
    static void applyValueEmptyCells(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setEmptyCells(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialFillOpacity(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setFillOpacity(SVGRenderStyle::initialFillOpacity());
    }
    static void applyInheritFillOpacity(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setFillOpacity(styleResolver.parentStyle()->svgStyle().fillOpacity());
    }
    static void applyValueFillOpacity(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setFillOpacity(StyleBuilderConverter::convertOpacity(styleResolver, value));
    }
    static void applyInitialFillRule(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setFillRule(SVGRenderStyle::initialFillRule());
    }
    static void applyInheritFillRule(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setFillRule(styleResolver.parentStyle()->svgStyle().fillRule());
    }
    static void applyValueFillRule(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setFillRule(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialFloat(StyleResolver& styleResolver)
    {
        styleResolver.style()->setFloating(RenderStyle::initialFloating());
    }
    static void applyInheritFloat(StyleResolver& styleResolver)
    {
        styleResolver.style()->setFloating(styleResolver.parentStyle()->floating());
    }
    static void applyValueFloat(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setFloating(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialFloodColor(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setFloodColor(SVGRenderStyle::initialFloodColor());
    }
    static void applyInheritFloodColor(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setFloodColor(styleResolver.parentStyle()->svgStyle().floodColor());
    }
    static void applyValueFloodColor(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setFloodColor(StyleBuilderConverter::convertSVGColor(styleResolver, value));
    }
    static void applyInitialFloodOpacity(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setFloodOpacity(SVGRenderStyle::initialFloodOpacity());
    }
    static void applyInheritFloodOpacity(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setFloodOpacity(styleResolver.parentStyle()->svgStyle().floodOpacity());
    }
    static void applyValueFloodOpacity(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setFloodOpacity(StyleBuilderConverter::convertOpacity(styleResolver, value));
    }
    static void applyInitialGlyphOrientationHorizontal(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setGlyphOrientationHorizontal(SVGRenderStyle::initialGlyphOrientationHorizontal());
    }
    static void applyInheritGlyphOrientationHorizontal(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setGlyphOrientationHorizontal(styleResolver.parentStyle()->svgStyle().glyphOrientationHorizontal());
    }
    static void applyValueGlyphOrientationHorizontal(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setGlyphOrientationHorizontal(StyleBuilderConverter::convertGlyphOrientation(styleResolver, value));
    }
    static void applyInitialGlyphOrientationVertical(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setGlyphOrientationVertical(SVGRenderStyle::initialGlyphOrientationVertical());
    }
    static void applyInheritGlyphOrientationVertical(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setGlyphOrientationVertical(styleResolver.parentStyle()->svgStyle().glyphOrientationVertical());
    }
    static void applyValueGlyphOrientationVertical(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setGlyphOrientationVertical(StyleBuilderConverter::convertGlyphOrientationOrAuto(styleResolver, value));
    }
    static void applyInitialHangingPunctuation(StyleResolver& styleResolver)
    {
        styleResolver.style()->setHangingPunctuation(RenderStyle::initialHangingPunctuation());
    }
    static void applyInheritHangingPunctuation(StyleResolver& styleResolver)
    {
        styleResolver.style()->setHangingPunctuation(styleResolver.parentStyle()->hangingPunctuation());
    }
    static void applyValueHangingPunctuation(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setHangingPunctuation(StyleBuilderConverter::convertHangingPunctuation(styleResolver, value));
    }
    static void applyInitialHeight(StyleResolver& styleResolver)
    {
        styleResolver.style()->setHeight(RenderStyle::initialSize());
    }
    static void applyInheritHeight(StyleResolver& styleResolver)
    {
        styleResolver.style()->setHeight(styleResolver.parentStyle()->height());
    }
    static void applyValueHeight(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setHeight(StyleBuilderConverter::convertLengthSizing(styleResolver, value));
    }
    static void applyInitialImageRendering(StyleResolver& styleResolver)
    {
        styleResolver.style()->setImageRendering(RenderStyle::initialImageRendering());
    }
    static void applyInheritImageRendering(StyleResolver& styleResolver)
    {
        styleResolver.style()->setImageRendering(styleResolver.parentStyle()->imageRendering());
    }
    static void applyValueImageRendering(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setImageRendering(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialKerning(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setKerning(SVGRenderStyle::initialKerning());
    }
    static void applyInheritKerning(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setKerning(styleResolver.parentStyle()->svgStyle().kerning());
    }
    static void applyValueKerning(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setKerning(StyleBuilderConverter::convertSVGLength(styleResolver, value));
    }
    static void applyInitialLeft(StyleResolver& styleResolver)
    {
        styleResolver.style()->setLeft(RenderStyle::initialOffset());
    }
    static void applyInheritLeft(StyleResolver& styleResolver)
    {
        styleResolver.style()->setLeft(styleResolver.parentStyle()->left());
    }
    static void applyValueLeft(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setLeft(StyleBuilderConverter::convertLengthOrAuto(styleResolver, value));
    }
    static void applyInitialLetterSpacing(StyleResolver& styleResolver)
    {
        styleResolver.style()->setLetterSpacing(RenderStyle::initialLetterSpacing());
    }
    static void applyInheritLetterSpacing(StyleResolver& styleResolver)
    {
        styleResolver.style()->setLetterSpacing(styleResolver.parentStyle()->letterSpacing());
    }
    static void applyValueLetterSpacing(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setLetterSpacing(StyleBuilderConverter::convertSpacing(styleResolver, value));
    }
    static void applyInitialLightingColor(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setLightingColor(SVGRenderStyle::initialLightingColor());
    }
    static void applyInheritLightingColor(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setLightingColor(styleResolver.parentStyle()->svgStyle().lightingColor());
    }
    static void applyValueLightingColor(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setLightingColor(StyleBuilderConverter::convertSVGColor(styleResolver, value));
    }
    static void applyInitialLineHeight(StyleResolver& styleResolver)
    {
        styleResolver.style()->setLineHeight(RenderStyle::initialLineHeight());
    }
    static void applyInheritLineHeight(StyleResolver& styleResolver)
    {
        styleResolver.style()->setLineHeight(styleResolver.parentStyle()->specifiedLineHeight());
    }
    static void applyValueLineHeight(StyleResolver& styleResolver, CSSValue& value)
    {
        auto convertedValue = StyleBuilderConverter::convertLineHeight(styleResolver, value);
        if (convertedValue)
            styleResolver.style()->setLineHeight(convertedValue.value());
    }
    static void applyInitialListStyleImage(StyleResolver& styleResolver)
    {
        styleResolver.style()->setListStyleImage(RenderStyle::initialListStyleImage());
    }
    static void applyInheritListStyleImage(StyleResolver& styleResolver)
    {
        styleResolver.style()->setListStyleImage(styleResolver.parentStyle()->listStyleImage());
    }
    static void applyValueListStyleImage(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setListStyleImage(StyleBuilderConverter::convertStyleImage<CSSPropertyListStyleImage>(styleResolver, value));
    }
    static void applyInitialListStylePosition(StyleResolver& styleResolver)
    {
        styleResolver.style()->setListStylePosition(RenderStyle::initialListStylePosition());
    }
    static void applyInheritListStylePosition(StyleResolver& styleResolver)
    {
        styleResolver.style()->setListStylePosition(styleResolver.parentStyle()->listStylePosition());
    }
    static void applyValueListStylePosition(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setListStylePosition(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialListStyleType(StyleResolver& styleResolver)
    {
        styleResolver.style()->setListStyleType(RenderStyle::initialListStyleType());
    }
    static void applyInheritListStyleType(StyleResolver& styleResolver)
    {
        styleResolver.style()->setListStyleType(styleResolver.parentStyle()->listStyleType());
    }
    static void applyValueListStyleType(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setListStyleType(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialMarginBottom(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarginBottom(RenderStyle::initialMargin());
    }
    static void applyInheritMarginBottom(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarginBottom(styleResolver.parentStyle()->marginBottom());
    }
    static void applyValueMarginBottom(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setMarginBottom(StyleBuilderConverter::convertLengthOrAuto(styleResolver, value));
    }
    static void applyInitialMarginLeft(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarginLeft(RenderStyle::initialMargin());
    }
    static void applyInheritMarginLeft(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarginLeft(styleResolver.parentStyle()->marginLeft());
    }
    static void applyValueMarginLeft(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setMarginLeft(StyleBuilderConverter::convertLengthOrAuto(styleResolver, value));
    }
    static void applyInitialMarginRight(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarginRight(RenderStyle::initialMargin());
    }
    static void applyInheritMarginRight(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarginRight(styleResolver.parentStyle()->marginRight());
    }
    static void applyValueMarginRight(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setMarginRight(StyleBuilderConverter::convertLengthOrAuto(styleResolver, value));
    }
    static void applyInitialMarginTop(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarginTop(RenderStyle::initialMargin());
    }
    static void applyInheritMarginTop(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarginTop(styleResolver.parentStyle()->marginTop());
    }
    static void applyValueMarginTop(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setMarginTop(StyleBuilderConverter::convertLengthOrAuto(styleResolver, value));
    }
    static void applyInitialMarkerEnd(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setMarkerEndResource(SVGRenderStyle::initialMarkerEndResource());
    }
    static void applyInheritMarkerEnd(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setMarkerEndResource(styleResolver.parentStyle()->svgStyle().markerEndResource());
    }
    static void applyValueMarkerEnd(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setMarkerEndResource(StyleBuilderConverter::convertSVGURIReference(styleResolver, value));
    }
    static void applyInitialMarkerMid(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setMarkerMidResource(SVGRenderStyle::initialMarkerMidResource());
    }
    static void applyInheritMarkerMid(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setMarkerMidResource(styleResolver.parentStyle()->svgStyle().markerMidResource());
    }
    static void applyValueMarkerMid(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setMarkerMidResource(StyleBuilderConverter::convertSVGURIReference(styleResolver, value));
    }
    static void applyInitialMarkerStart(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setMarkerStartResource(SVGRenderStyle::initialMarkerStartResource());
    }
    static void applyInheritMarkerStart(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setMarkerStartResource(styleResolver.parentStyle()->svgStyle().markerStartResource());
    }
    static void applyValueMarkerStart(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setMarkerStartResource(StyleBuilderConverter::convertSVGURIReference(styleResolver, value));
    }
    static void applyInitialMask(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setMaskerResource(SVGRenderStyle::initialMaskerResource());
    }
    static void applyInheritMask(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setMaskerResource(styleResolver.parentStyle()->svgStyle().maskerResource());
    }
    static void applyValueMask(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setMaskerResource(StyleBuilderConverter::convertSVGURIReference(styleResolver, value));
    }
    static void applyInitialMaskType(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setMaskType(SVGRenderStyle::initialMaskType());
    }
    static void applyInheritMaskType(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setMaskType(styleResolver.parentStyle()->svgStyle().maskType());
    }
    static void applyValueMaskType(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setMaskType(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialMaxHeight(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMaxHeight(RenderStyle::initialMaxSize());
    }
    static void applyInheritMaxHeight(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMaxHeight(styleResolver.parentStyle()->maxHeight());
    }
    static void applyValueMaxHeight(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setMaxHeight(StyleBuilderConverter::convertLengthMaxSizing(styleResolver, value));
    }
    static void applyInitialMaxWidth(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMaxWidth(RenderStyle::initialMaxSize());
    }
    static void applyInheritMaxWidth(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMaxWidth(styleResolver.parentStyle()->maxWidth());
    }
    static void applyValueMaxWidth(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setMaxWidth(StyleBuilderConverter::convertLengthMaxSizing(styleResolver, value));
    }
    static void applyInitialMinHeight(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMinHeight(RenderStyle::initialMinSize());
    }
    static void applyInheritMinHeight(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMinHeight(styleResolver.parentStyle()->minHeight());
    }
    static void applyValueMinHeight(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setMinHeight(StyleBuilderConverter::convertLengthSizing(styleResolver, value));
    }
    static void applyInitialMinWidth(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMinWidth(RenderStyle::initialMinSize());
    }
    static void applyInheritMinWidth(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMinWidth(styleResolver.parentStyle()->minWidth());
    }
    static void applyValueMinWidth(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setMinWidth(StyleBuilderConverter::convertLengthSizing(styleResolver, value));
    }
    static void applyInitialObjectFit(StyleResolver& styleResolver)
    {
        styleResolver.style()->setObjectFit(RenderStyle::initialObjectFit());
    }
    static void applyInheritObjectFit(StyleResolver& styleResolver)
    {
        styleResolver.style()->setObjectFit(styleResolver.parentStyle()->objectFit());
    }
    static void applyValueObjectFit(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setObjectFit(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialObjectPosition(StyleResolver& styleResolver)
    {
        styleResolver.style()->setObjectPosition(RenderStyle::initialObjectPosition());
    }
    static void applyInheritObjectPosition(StyleResolver& styleResolver)
    {
        styleResolver.style()->setObjectPosition(styleResolver.parentStyle()->objectPosition());
    }
    static void applyValueObjectPosition(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setObjectPosition(StyleBuilderConverter::convertObjectPosition(styleResolver, value));
    }
    static void applyInitialOpacity(StyleResolver& styleResolver)
    {
        styleResolver.style()->setOpacity(RenderStyle::initialOpacity());
    }
    static void applyInheritOpacity(StyleResolver& styleResolver)
    {
        styleResolver.style()->setOpacity(styleResolver.parentStyle()->opacity());
    }
    static void applyValueOpacity(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setOpacity(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialOrphans(StyleResolver& styleResolver)
    {
        styleResolver.style()->setHasAutoOrphans();
    }
    static void applyInheritOrphans(StyleResolver& styleResolver)
    {
        if (styleResolver.parentStyle()->hasAutoOrphans()) {
            styleResolver.style()->setHasAutoOrphans();
            return;
        }
        styleResolver.style()->setOrphans(styleResolver.parentStyle()->orphans());
    }
    static void applyValueOrphans(StyleResolver& styleResolver, CSSValue& value)
    {
        if (downcast<CSSPrimitiveValue>(value).getValueID() == CSSValueAuto) {
            styleResolver.style()->setHasAutoOrphans();
            return;
        }
        styleResolver.style()->setOrphans(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialOutlineColor(StyleResolver& styleResolver)
    {
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setOutlineColor(RenderStyle::invalidColor());
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkOutlineColor(RenderStyle::invalidColor());
    }
    static void applyInheritOutlineColor(StyleResolver& styleResolver)
    {
        Color color = styleResolver.parentStyle()->outlineColor();
        if (!color.isValid())
            color = styleResolver.parentStyle()->color();
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setOutlineColor(color);
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkOutlineColor(color);
    }
    static void applyValueOutlineColor(StyleResolver& styleResolver, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setOutlineColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkOutlineColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialOutlineOffset(StyleResolver& styleResolver)
    {
        styleResolver.style()->setOutlineOffset(RenderStyle::initialOutlineOffset());
    }
    static void applyInheritOutlineOffset(StyleResolver& styleResolver)
    {
        styleResolver.style()->setOutlineOffset(styleResolver.parentStyle()->outlineOffset());
    }
    static void applyValueOutlineOffset(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setOutlineOffset(StyleBuilderConverter::convertComputedLength<float>(styleResolver, value));
    }
    static void applyInitialOutlineWidth(StyleResolver& styleResolver)
    {
        styleResolver.style()->setOutlineWidth(RenderStyle::initialOutlineWidth());
    }
    static void applyInheritOutlineWidth(StyleResolver& styleResolver)
    {
        styleResolver.style()->setOutlineWidth(styleResolver.parentStyle()->outlineWidth());
    }
    static void applyValueOutlineWidth(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setOutlineWidth(StyleBuilderConverter::convertLineWidth<float>(styleResolver, value));
    }
    static void applyInitialOverflowWrap(StyleResolver& styleResolver)
    {
        styleResolver.style()->setOverflowWrap(RenderStyle::initialOverflowWrap());
    }
    static void applyInheritOverflowWrap(StyleResolver& styleResolver)
    {
        styleResolver.style()->setOverflowWrap(styleResolver.parentStyle()->overflowWrap());
    }
    static void applyValueOverflowWrap(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setOverflowWrap(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialOverflowX(StyleResolver& styleResolver)
    {
        styleResolver.style()->setOverflowX(RenderStyle::initialOverflowX());
    }
    static void applyInheritOverflowX(StyleResolver& styleResolver)
    {
        styleResolver.style()->setOverflowX(styleResolver.parentStyle()->overflowX());
    }
    static void applyValueOverflowX(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setOverflowX(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialOverflowY(StyleResolver& styleResolver)
    {
        styleResolver.style()->setOverflowY(RenderStyle::initialOverflowY());
    }
    static void applyInheritOverflowY(StyleResolver& styleResolver)
    {
        styleResolver.style()->setOverflowY(styleResolver.parentStyle()->overflowY());
    }
    static void applyValueOverflowY(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setOverflowY(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialPaddingBottom(StyleResolver& styleResolver)
    {
        styleResolver.style()->setPaddingBottom(RenderStyle::initialPadding());
    }
    static void applyInheritPaddingBottom(StyleResolver& styleResolver)
    {
        styleResolver.style()->setPaddingBottom(styleResolver.parentStyle()->paddingBottom());
    }
    static void applyValuePaddingBottom(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setPaddingBottom(StyleBuilderConverter::convertLength(styleResolver, value));
    }
    static void applyInitialPaddingLeft(StyleResolver& styleResolver)
    {
        styleResolver.style()->setPaddingLeft(RenderStyle::initialPadding());
    }
    static void applyInheritPaddingLeft(StyleResolver& styleResolver)
    {
        styleResolver.style()->setPaddingLeft(styleResolver.parentStyle()->paddingLeft());
    }
    static void applyValuePaddingLeft(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setPaddingLeft(StyleBuilderConverter::convertLength(styleResolver, value));
    }
    static void applyInitialPaddingRight(StyleResolver& styleResolver)
    {
        styleResolver.style()->setPaddingRight(RenderStyle::initialPadding());
    }
    static void applyInheritPaddingRight(StyleResolver& styleResolver)
    {
        styleResolver.style()->setPaddingRight(styleResolver.parentStyle()->paddingRight());
    }
    static void applyValuePaddingRight(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setPaddingRight(StyleBuilderConverter::convertLength(styleResolver, value));
    }
    static void applyInitialPaddingTop(StyleResolver& styleResolver)
    {
        styleResolver.style()->setPaddingTop(RenderStyle::initialPadding());
    }
    static void applyInheritPaddingTop(StyleResolver& styleResolver)
    {
        styleResolver.style()->setPaddingTop(styleResolver.parentStyle()->paddingTop());
    }
    static void applyValuePaddingTop(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setPaddingTop(StyleBuilderConverter::convertLength(styleResolver, value));
    }
    static void applyInitialPageBreakAfter(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakAfter(RenderStyle::initialBreakBetween());
    }
    static void applyInheritPageBreakAfter(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakAfter(styleResolver.parentStyle()->breakAfter());
    }
    static void applyValuePageBreakAfter(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBreakAfter(StyleBuilderConverter::convertPageBreakBetween(styleResolver, value));
    }
    static void applyInitialPageBreakBefore(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakBefore(RenderStyle::initialBreakBetween());
    }
    static void applyInheritPageBreakBefore(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakBefore(styleResolver.parentStyle()->breakBefore());
    }
    static void applyValuePageBreakBefore(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBreakBefore(StyleBuilderConverter::convertPageBreakBetween(styleResolver, value));
    }
    static void applyInitialPageBreakInside(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakInside(RenderStyle::initialBreakInside());
    }
    static void applyInheritPageBreakInside(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakInside(styleResolver.parentStyle()->breakInside());
    }
    static void applyValuePageBreakInside(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBreakInside(StyleBuilderConverter::convertPageBreakInside(styleResolver, value));
    }
    static void applyInitialPaintOrder(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setPaintOrder(SVGRenderStyle::initialPaintOrder());
    }
    static void applyInheritPaintOrder(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setPaintOrder(styleResolver.parentStyle()->svgStyle().paintOrder());
    }
    static void applyValuePaintOrder(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setPaintOrder(StyleBuilderConverter::convertPaintOrder(styleResolver, value));
    }
    static void applyInitialPointerEvents(StyleResolver& styleResolver)
    {
        styleResolver.style()->setPointerEvents(RenderStyle::initialPointerEvents());
    }
    static void applyInheritPointerEvents(StyleResolver& styleResolver)
    {
        styleResolver.style()->setPointerEvents(styleResolver.parentStyle()->pointerEvents());
    }
    static void applyValuePointerEvents(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setPointerEvents(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialPosition(StyleResolver& styleResolver)
    {
        styleResolver.style()->setPosition(RenderStyle::initialPosition());
    }
    static void applyInheritPosition(StyleResolver& styleResolver)
    {
        styleResolver.style()->setPosition(styleResolver.parentStyle()->position());
    }
    static void applyValuePosition(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setPosition(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialQuotes(StyleResolver& styleResolver)
    {
        styleResolver.style()->setQuotes(RenderStyle::initialQuotes());
    }
    static void applyInheritQuotes(StyleResolver& styleResolver)
    {
        styleResolver.style()->setQuotes(styleResolver.parentStyle()->quotes());
    }
    static void applyValueQuotes(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setQuotes(StyleBuilderConverter::convertQuotes(styleResolver, value));
    }
    static void applyInitialR(StyleResolver& styleResolver)
    {
        styleResolver.style()->setR(RenderStyle::initialZeroLength());
    }
    static void applyInheritR(StyleResolver& styleResolver)
    {
        styleResolver.style()->setR(styleResolver.parentStyle()->r());
    }
    static void applyValueR(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setR(StyleBuilderConverter::convertLength(styleResolver, value));
    }
    static void applyInitialResize(StyleResolver& styleResolver)
    {
        styleResolver.style()->setResize(RenderStyle::initialResize());
    }
    static void applyInheritResize(StyleResolver& styleResolver)
    {
        styleResolver.style()->setResize(styleResolver.parentStyle()->resize());
    }
    static void applyValueResize(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setResize(StyleBuilderConverter::convertResize(styleResolver, value));
    }
    static void applyInitialRight(StyleResolver& styleResolver)
    {
        styleResolver.style()->setRight(RenderStyle::initialOffset());
    }
    static void applyInheritRight(StyleResolver& styleResolver)
    {
        styleResolver.style()->setRight(styleResolver.parentStyle()->right());
    }
    static void applyValueRight(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setRight(StyleBuilderConverter::convertLengthOrAuto(styleResolver, value));
    }
    static void applyInitialRx(StyleResolver& styleResolver)
    {
        styleResolver.style()->setRx(RenderStyle::initialZeroLength());
    }
    static void applyInheritRx(StyleResolver& styleResolver)
    {
        styleResolver.style()->setRx(styleResolver.parentStyle()->rx());
    }
    static void applyValueRx(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setRx(StyleBuilderConverter::convertLength(styleResolver, value));
    }
    static void applyInitialRy(StyleResolver& styleResolver)
    {
        styleResolver.style()->setRy(RenderStyle::initialZeroLength());
    }
    static void applyInheritRy(StyleResolver& styleResolver)
    {
        styleResolver.style()->setRy(styleResolver.parentStyle()->ry());
    }
    static void applyValueRy(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setRy(StyleBuilderConverter::convertLength(styleResolver, value));
    }
    static void applyInitialShapeRendering(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setShapeRendering(SVGRenderStyle::initialShapeRendering());
    }
    static void applyInheritShapeRendering(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setShapeRendering(styleResolver.parentStyle()->svgStyle().shapeRendering());
    }
    static void applyValueShapeRendering(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setShapeRendering(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialStopColor(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setStopColor(SVGRenderStyle::initialStopColor());
    }
    static void applyInheritStopColor(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setStopColor(styleResolver.parentStyle()->svgStyle().stopColor());
    }
    static void applyValueStopColor(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setStopColor(StyleBuilderConverter::convertSVGColor(styleResolver, value));
    }
    static void applyInitialStopOpacity(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setStopOpacity(SVGRenderStyle::initialStopOpacity());
    }
    static void applyInheritStopOpacity(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setStopOpacity(styleResolver.parentStyle()->svgStyle().stopOpacity());
    }
    static void applyValueStopOpacity(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setStopOpacity(StyleBuilderConverter::convertOpacity(styleResolver, value));
    }
    static void applyInitialStrokeDasharray(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setStrokeDashArray(SVGRenderStyle::initialStrokeDashArray());
    }
    static void applyInheritStrokeDasharray(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setStrokeDashArray(styleResolver.parentStyle()->svgStyle().strokeDashArray());
    }
    static void applyValueStrokeDasharray(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setStrokeDashArray(StyleBuilderConverter::convertStrokeDashArray(styleResolver, value));
    }
    static void applyInitialStrokeDashoffset(StyleResolver& styleResolver)
    {
        styleResolver.style()->setStrokeDashOffset(RenderStyle::initialZeroLength());
    }
    static void applyInheritStrokeDashoffset(StyleResolver& styleResolver)
    {
        styleResolver.style()->setStrokeDashOffset(styleResolver.parentStyle()->strokeDashOffset());
    }
    static void applyValueStrokeDashoffset(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setStrokeDashOffset(StyleBuilderConverter::convertLength(styleResolver, value));
    }
    static void applyInitialStrokeLinecap(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setCapStyle(SVGRenderStyle::initialCapStyle());
    }
    static void applyInheritStrokeLinecap(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setCapStyle(styleResolver.parentStyle()->svgStyle().capStyle());
    }
    static void applyValueStrokeLinecap(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setCapStyle(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialStrokeLinejoin(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setJoinStyle(SVGRenderStyle::initialJoinStyle());
    }
    static void applyInheritStrokeLinejoin(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setJoinStyle(styleResolver.parentStyle()->svgStyle().joinStyle());
    }
    static void applyValueStrokeLinejoin(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setJoinStyle(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialStrokeMiterlimit(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setStrokeMiterLimit(SVGRenderStyle::initialStrokeMiterLimit());
    }
    static void applyInheritStrokeMiterlimit(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setStrokeMiterLimit(styleResolver.parentStyle()->svgStyle().strokeMiterLimit());
    }
    static void applyValueStrokeMiterlimit(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setStrokeMiterLimit(StyleBuilderConverter::convertNumber<float>(styleResolver, value));
    }
    static void applyInitialStrokeOpacity(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setStrokeOpacity(SVGRenderStyle::initialStrokeOpacity());
    }
    static void applyInheritStrokeOpacity(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setStrokeOpacity(styleResolver.parentStyle()->svgStyle().strokeOpacity());
    }
    static void applyValueStrokeOpacity(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setStrokeOpacity(StyleBuilderConverter::convertOpacity(styleResolver, value));
    }
    static void applyInitialStrokeWidth(StyleResolver& styleResolver)
    {
        styleResolver.style()->setStrokeWidth(RenderStyle::initialOneLength());
    }
    static void applyInheritStrokeWidth(StyleResolver& styleResolver)
    {
        styleResolver.style()->setStrokeWidth(styleResolver.parentStyle()->strokeWidth());
    }
    static void applyValueStrokeWidth(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setStrokeWidth(StyleBuilderConverter::convertLength(styleResolver, value));
    }
    static void applyInitialSpeak(StyleResolver& styleResolver)
    {
        styleResolver.style()->setSpeak(RenderStyle::initialSpeak());
    }
    static void applyInheritSpeak(StyleResolver& styleResolver)
    {
        styleResolver.style()->setSpeak(styleResolver.parentStyle()->speak());
    }
    static void applyValueSpeak(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setSpeak(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialTableLayout(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTableLayout(RenderStyle::initialTableLayout());
    }
    static void applyInheritTableLayout(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTableLayout(styleResolver.parentStyle()->tableLayout());
    }
    static void applyValueTableLayout(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setTableLayout(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialTabSize(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTabSize(RenderStyle::initialTabSize());
    }
    static void applyInheritTabSize(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTabSize(styleResolver.parentStyle()->tabSize());
    }
    static void applyValueTabSize(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setTabSize(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialTextAlign(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextAlign(RenderStyle::initialTextAlign());
    }
    static void applyInheritTextAlign(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextAlign(styleResolver.parentStyle()->textAlign());
    }
    static void applyValueTextAlign(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setTextAlign(StyleBuilderConverter::convertTextAlign(styleResolver, value));
    }
    static void applyInitialTextAnchor(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setTextAnchor(SVGRenderStyle::initialTextAnchor());
    }
    static void applyInheritTextAnchor(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setTextAnchor(styleResolver.parentStyle()->svgStyle().textAnchor());
    }
    static void applyValueTextAnchor(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setTextAnchor(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialTextDecoration(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextDecoration(RenderStyle::initialTextDecoration());
    }
    static void applyInheritTextDecoration(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextDecoration(styleResolver.parentStyle()->textDecoration());
    }
    static void applyValueTextDecoration(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setTextDecoration(StyleBuilderConverter::convertTextDecoration(styleResolver, value));
    }
    static void applyInitialTextOverflow(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextOverflow(RenderStyle::initialTextOverflow());
    }
    static void applyInheritTextOverflow(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextOverflow(styleResolver.parentStyle()->textOverflow());
    }
    static void applyValueTextOverflow(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setTextOverflow(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialTextTransform(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextTransform(RenderStyle::initialTextTransform());
    }
    static void applyInheritTextTransform(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextTransform(styleResolver.parentStyle()->textTransform());
    }
    static void applyValueTextTransform(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setTextTransform(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialTop(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTop(RenderStyle::initialOffset());
    }
    static void applyInheritTop(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTop(styleResolver.parentStyle()->top());
    }
    static void applyValueTop(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setTop(StyleBuilderConverter::convertLengthOrAuto(styleResolver, value));
    }
    static void applyInitialUnicodeBidi(StyleResolver& styleResolver)
    {
        styleResolver.style()->setUnicodeBidi(RenderStyle::initialUnicodeBidi());
    }
    static void applyInheritUnicodeBidi(StyleResolver& styleResolver)
    {
        styleResolver.style()->setUnicodeBidi(styleResolver.parentStyle()->unicodeBidi());
    }
    static void applyValueUnicodeBidi(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setUnicodeBidi(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialVectorEffect(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setVectorEffect(SVGRenderStyle::initialVectorEffect());
    }
    static void applyInheritVectorEffect(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setVectorEffect(styleResolver.parentStyle()->svgStyle().vectorEffect());
    }
    static void applyValueVectorEffect(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setVectorEffect(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialVerticalAlign(StyleResolver& styleResolver)
    {
        styleResolver.style()->setVerticalAlign(RenderStyle::initialVerticalAlign());
    }
    static void applyInheritVerticalAlign(StyleResolver& styleResolver)
    {
        styleResolver.style()->setVerticalAlign(styleResolver.parentStyle()->verticalAlign());
    }
    static void applyInitialVisibility(StyleResolver& styleResolver)
    {
        styleResolver.style()->setVisibility(RenderStyle::initialVisibility());
    }
    static void applyInheritVisibility(StyleResolver& styleResolver)
    {
        styleResolver.style()->setVisibility(styleResolver.parentStyle()->visibility());
    }
    static void applyValueVisibility(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setVisibility(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWhiteSpace(StyleResolver& styleResolver)
    {
        styleResolver.style()->setWhiteSpace(RenderStyle::initialWhiteSpace());
    }
    static void applyInheritWhiteSpace(StyleResolver& styleResolver)
    {
        styleResolver.style()->setWhiteSpace(styleResolver.parentStyle()->whiteSpace());
    }
    static void applyValueWhiteSpace(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setWhiteSpace(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWidows(StyleResolver& styleResolver)
    {
        styleResolver.style()->setHasAutoWidows();
    }
    static void applyInheritWidows(StyleResolver& styleResolver)
    {
        if (styleResolver.parentStyle()->hasAutoWidows()) {
            styleResolver.style()->setHasAutoWidows();
            return;
        }
        styleResolver.style()->setWidows(styleResolver.parentStyle()->widows());
    }
    static void applyValueWidows(StyleResolver& styleResolver, CSSValue& value)
    {
        if (downcast<CSSPrimitiveValue>(value).getValueID() == CSSValueAuto) {
            styleResolver.style()->setHasAutoWidows();
            return;
        }
        styleResolver.style()->setWidows(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWidth(StyleResolver& styleResolver)
    {
        styleResolver.style()->setWidth(RenderStyle::initialSize());
    }
    static void applyInheritWidth(StyleResolver& styleResolver)
    {
        styleResolver.style()->setWidth(styleResolver.parentStyle()->width());
    }
    static void applyValueWidth(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setWidth(StyleBuilderConverter::convertLengthSizing(styleResolver, value));
    }
    static void applyInitialWillChange(StyleResolver& styleResolver)
    {
        styleResolver.style()->setWillChange(RenderStyle::initialWillChange());
    }
    static void applyInheritWillChange(StyleResolver& styleResolver)
    {
        styleResolver.style()->setWillChange(styleResolver.parentStyle()->willChange());
    }
    static void applyInitialWordBreak(StyleResolver& styleResolver)
    {
        styleResolver.style()->setWordBreak(RenderStyle::initialWordBreak());
    }
    static void applyInheritWordBreak(StyleResolver& styleResolver)
    {
        styleResolver.style()->setWordBreak(styleResolver.parentStyle()->wordBreak());
    }
    static void applyValueWordBreak(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setWordBreak(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWordSpacing(StyleResolver& styleResolver)
    {
        styleResolver.style()->setWordSpacing(RenderStyle::initialWordSpacing());
    }
    static void applyInheritWordSpacing(StyleResolver& styleResolver)
    {
        styleResolver.style()->setWordSpacing(styleResolver.parentStyle()->wordSpacing());
    }
    static void applyValueWordSpacing(StyleResolver& styleResolver, CSSValue& value)
    {
        auto convertedValue = StyleBuilderConverter::convertWordSpacing(styleResolver, value);
        if (convertedValue)
            styleResolver.style()->setWordSpacing(convertedValue.value());
    }
    static void applyInitialWordWrap(StyleResolver& styleResolver)
    {
        styleResolver.style()->setOverflowWrap(RenderStyle::initialOverflowWrap());
    }
    static void applyInheritWordWrap(StyleResolver& styleResolver)
    {
        styleResolver.style()->setOverflowWrap(styleResolver.parentStyle()->overflowWrap());
    }
    static void applyValueWordWrap(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setOverflowWrap(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWritingMode(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setWritingMode(SVGRenderStyle::initialWritingMode());
    }
    static void applyInheritWritingMode(StyleResolver& styleResolver)
    {
        styleResolver.style()->accessSVGStyle().setWritingMode(styleResolver.parentStyle()->svgStyle().writingMode());
    }
    static void applyValueWritingMode(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->accessSVGStyle().setWritingMode(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialX(StyleResolver& styleResolver)
    {
        styleResolver.style()->setX(RenderStyle::initialZeroLength());
    }
    static void applyInheritX(StyleResolver& styleResolver)
    {
        styleResolver.style()->setX(styleResolver.parentStyle()->x());
    }
    static void applyValueX(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setX(StyleBuilderConverter::convertLength(styleResolver, value));
    }
    static void applyInitialY(StyleResolver& styleResolver)
    {
        styleResolver.style()->setY(RenderStyle::initialZeroLength());
    }
    static void applyInheritY(StyleResolver& styleResolver)
    {
        styleResolver.style()->setY(styleResolver.parentStyle()->y());
    }
    static void applyValueY(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setY(StyleBuilderConverter::convertLength(styleResolver, value));
    }
    static void applyInitialZIndex(StyleResolver& styleResolver)
    {
        styleResolver.style()->setHasAutoZIndex();
    }
    static void applyInheritZIndex(StyleResolver& styleResolver)
    {
        if (styleResolver.parentStyle()->hasAutoZIndex()) {
            styleResolver.style()->setHasAutoZIndex();
            return;
        }
        styleResolver.style()->setZIndex(styleResolver.parentStyle()->zIndex());
    }
    static void applyValueZIndex(StyleResolver& styleResolver, CSSValue& value)
    {
        if (downcast<CSSPrimitiveValue>(value).getValueID() == CSSValueAuto) {
            styleResolver.style()->setHasAutoZIndex();
            return;
        }
        styleResolver.style()->setZIndex(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialAlt(StyleResolver& styleResolver)
    {
        styleResolver.style()->setContentAltText(RenderStyle::initialContentAltText());
    }
    static void applyInheritAlt(StyleResolver& styleResolver)
    {
        styleResolver.style()->setContentAltText(styleResolver.parentStyle()->contentAltText());
    }
    static void applyInitialWebkitAnimationDelay(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setDelay(Animation::initialDelay());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearDelay();
    }
    static void applyInheritWebkitAnimationDelay(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        const AnimationList* parentList = styleResolver.parentStyle()->animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isDelaySet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setDelay(parentList->animation(i).delay());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        /* Reset any remaining animations to not have the property set. */
        for ( ; i < list.size(); ++i)
            list.animation(i).clearDelay();
    }
    static void applyValueWebkitAnimationDelay(StyleResolver& styleResolver, CSSValue& value)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                styleResolver.styleMap()->mapAnimationDelay(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            styleResolver.styleMap()->mapAnimationDelay(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearDelay();
        }
    }
    static void applyInitialWebkitAnimationDirection(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setDirection(Animation::initialDirection());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearDirection();
    }
    static void applyInheritWebkitAnimationDirection(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        const AnimationList* parentList = styleResolver.parentStyle()->animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isDirectionSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setDirection(parentList->animation(i).direction());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        /* Reset any remaining animations to not have the property set. */
        for ( ; i < list.size(); ++i)
            list.animation(i).clearDirection();
    }
    static void applyValueWebkitAnimationDirection(StyleResolver& styleResolver, CSSValue& value)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                styleResolver.styleMap()->mapAnimationDirection(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            styleResolver.styleMap()->mapAnimationDirection(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearDirection();
        }
    }
    static void applyInitialWebkitAnimationDuration(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setDuration(Animation::initialDuration());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearDuration();
    }
    static void applyInheritWebkitAnimationDuration(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        const AnimationList* parentList = styleResolver.parentStyle()->animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isDurationSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setDuration(parentList->animation(i).duration());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        /* Reset any remaining animations to not have the property set. */
        for ( ; i < list.size(); ++i)
            list.animation(i).clearDuration();
    }
    static void applyValueWebkitAnimationDuration(StyleResolver& styleResolver, CSSValue& value)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                styleResolver.styleMap()->mapAnimationDuration(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            styleResolver.styleMap()->mapAnimationDuration(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearDuration();
        }
    }
    static void applyInitialWebkitAnimationFillMode(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setFillMode(Animation::initialFillMode());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearFillMode();
    }
    static void applyInheritWebkitAnimationFillMode(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        const AnimationList* parentList = styleResolver.parentStyle()->animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isFillModeSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setFillMode(parentList->animation(i).fillMode());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        /* Reset any remaining animations to not have the property set. */
        for ( ; i < list.size(); ++i)
            list.animation(i).clearFillMode();
    }
    static void applyValueWebkitAnimationFillMode(StyleResolver& styleResolver, CSSValue& value)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                styleResolver.styleMap()->mapAnimationFillMode(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            styleResolver.styleMap()->mapAnimationFillMode(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearFillMode();
        }
    }
    static void applyInitialWebkitAnimationIterationCount(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setIterationCount(Animation::initialIterationCount());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearIterationCount();
    }
    static void applyInheritWebkitAnimationIterationCount(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        const AnimationList* parentList = styleResolver.parentStyle()->animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isIterationCountSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setIterationCount(parentList->animation(i).iterationCount());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        /* Reset any remaining animations to not have the property set. */
        for ( ; i < list.size(); ++i)
            list.animation(i).clearIterationCount();
    }
    static void applyValueWebkitAnimationIterationCount(StyleResolver& styleResolver, CSSValue& value)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                styleResolver.styleMap()->mapAnimationIterationCount(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            styleResolver.styleMap()->mapAnimationIterationCount(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearIterationCount();
        }
    }
    static void applyInitialWebkitAnimationName(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setName(Animation::initialName());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearName();
    }
    static void applyInheritWebkitAnimationName(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        const AnimationList* parentList = styleResolver.parentStyle()->animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isNameSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setName(parentList->animation(i).name());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        /* Reset any remaining animations to not have the property set. */
        for ( ; i < list.size(); ++i)
            list.animation(i).clearName();
    }
    static void applyValueWebkitAnimationName(StyleResolver& styleResolver, CSSValue& value)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                styleResolver.styleMap()->mapAnimationName(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            styleResolver.styleMap()->mapAnimationName(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearName();
        }
    }
    static void applyInitialWebkitAnimationPlayState(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setPlayState(Animation::initialPlayState());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearPlayState();
    }
    static void applyInheritWebkitAnimationPlayState(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        const AnimationList* parentList = styleResolver.parentStyle()->animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isPlayStateSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setPlayState(parentList->animation(i).playState());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        /* Reset any remaining animations to not have the property set. */
        for ( ; i < list.size(); ++i)
            list.animation(i).clearPlayState();
    }
    static void applyValueWebkitAnimationPlayState(StyleResolver& styleResolver, CSSValue& value)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                styleResolver.styleMap()->mapAnimationPlayState(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            styleResolver.styleMap()->mapAnimationPlayState(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearPlayState();
        }
    }
    static void applyInitialWebkitAnimationTimingFunction(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setTimingFunction(Animation::initialTimingFunction());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearTimingFunction();
    }
    static void applyInheritWebkitAnimationTimingFunction(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        const AnimationList* parentList = styleResolver.parentStyle()->animations();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isTimingFunctionSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setTimingFunction(parentList->animation(i).timingFunction());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        /* Reset any remaining animations to not have the property set. */
        for ( ; i < list.size(); ++i)
            list.animation(i).clearTimingFunction();
    }
    static void applyValueWebkitAnimationTimingFunction(StyleResolver& styleResolver, CSSValue& value)
    {
        AnimationList& list = styleResolver.style()->ensureAnimations();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                styleResolver.styleMap()->mapAnimationTimingFunction(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            styleResolver.styleMap()->mapAnimationTimingFunction(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearTimingFunction();
        }
    }
    static void applyInitialWebkitAppearance(StyleResolver& styleResolver)
    {
        styleResolver.style()->setAppearance(RenderStyle::initialAppearance());
    }
    static void applyInheritWebkitAppearance(StyleResolver& styleResolver)
    {
        styleResolver.style()->setAppearance(styleResolver.parentStyle()->appearance());
    }
    static void applyValueWebkitAppearance(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setAppearance(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitBackfaceVisibility(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBackfaceVisibility(RenderStyle::initialBackfaceVisibility());
    }
    static void applyInheritWebkitBackfaceVisibility(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBackfaceVisibility(styleResolver.parentStyle()->backfaceVisibility());
    }
    static void applyValueWebkitBackfaceVisibility(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBackfaceVisibility(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitBackgroundClip(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->backgroundLayers();
        if (!layers.next() && (!layers.isClipSet() || layers.clip() == FillLayer::initialFillClip(BackgroundFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        child->setClip(FillLayer::initialFillClip(BackgroundFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearClip();
    }
    static void applyInheritWebkitBackgroundClip(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->backgroundLayers() == *styleResolver.style()->backgroundLayers())
            return;

        auto* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->backgroundLayers(); parent && parent->isClipSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                child = previousChild->next();
            }
            child->setClip(parent->clip());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyValueWebkitBackgroundClip(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillClip(CSSPropertyWebkitBackgroundClip, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillClip(CSSPropertyWebkitBackgroundClip, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyInitialWebkitBackgroundComposite(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->backgroundLayers();
        if (!layers.next() && (!layers.isCompositeSet() || layers.composite() == FillLayer::initialFillComposite(BackgroundFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        child->setComposite(FillLayer::initialFillComposite(BackgroundFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearComposite();
    }
    static void applyInheritWebkitBackgroundComposite(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->backgroundLayers() == *styleResolver.style()->backgroundLayers())
            return;

        auto* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->backgroundLayers(); parent && parent->isCompositeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                child = previousChild->next();
            }
            child->setComposite(parent->composite());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearComposite();
    }
    static void applyValueWebkitBackgroundComposite(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillComposite(CSSPropertyWebkitBackgroundComposite, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillComposite(CSSPropertyWebkitBackgroundComposite, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearComposite();
    }
    static void applyInitialWebkitBackgroundOrigin(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->backgroundLayers();
        if (!layers.next() && (!layers.isOriginSet() || layers.origin() == FillLayer::initialFillOrigin(BackgroundFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        child->setOrigin(FillLayer::initialFillOrigin(BackgroundFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearOrigin();
    }
    static void applyInheritWebkitBackgroundOrigin(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->backgroundLayers() == *styleResolver.style()->backgroundLayers())
            return;

        auto* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->backgroundLayers(); parent && parent->isOriginSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                child = previousChild->next();
            }
            child->setOrigin(parent->origin());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearOrigin();
    }
    static void applyValueWebkitBackgroundOrigin(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillOrigin(CSSPropertyWebkitBackgroundOrigin, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillOrigin(CSSPropertyWebkitBackgroundOrigin, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearOrigin();
    }
    static void applyInitialWebkitBackgroundSize(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->backgroundLayers();
        if (!layers.next() && (!layers.isSizeSet() || layers.size() == FillLayer::initialFillSize(BackgroundFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        child->setSize(FillLayer::initialFillSize(BackgroundFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearSize();
    }
    static void applyInheritWebkitBackgroundSize(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->backgroundLayers() == *styleResolver.style()->backgroundLayers())
            return;

        auto* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->backgroundLayers(); parent && parent->isSizeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                child = previousChild->next();
            }
            child->setSize(parent->size());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearSize();
    }
    static void applyValueWebkitBackgroundSize(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureBackgroundLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(BackgroundFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillSize(CSSPropertyWebkitBackgroundSize, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillSize(CSSPropertyWebkitBackgroundSize, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearSize();
    }
    static void applyInitialWebkitBorderFit(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderFit(RenderStyle::initialBorderFit());
    }
    static void applyInheritWebkitBorderFit(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderFit(styleResolver.parentStyle()->borderFit());
    }
    static void applyValueWebkitBorderFit(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBorderFit(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitBorderHorizontalSpacing(StyleResolver& styleResolver)
    {
        styleResolver.style()->setHorizontalBorderSpacing(RenderStyle::initialHorizontalBorderSpacing());
    }
    static void applyInheritWebkitBorderHorizontalSpacing(StyleResolver& styleResolver)
    {
        styleResolver.style()->setHorizontalBorderSpacing(styleResolver.parentStyle()->horizontalBorderSpacing());
    }
    static void applyValueWebkitBorderHorizontalSpacing(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setHorizontalBorderSpacing(StyleBuilderConverter::convertComputedLength<short>(styleResolver, value));
    }
    static void applyInitialWebkitBorderImage(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderImage(RenderStyle::initialNinePieceImage());
    }
    static void applyInheritWebkitBorderImage(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBorderImage(styleResolver.parentStyle()->borderImage());
    }
    static void applyValueWebkitBorderImage(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBorderImage(StyleBuilderConverter::convertBorderImage<CSSPropertyWebkitBorderImage>(styleResolver, value));
    }
    static void applyInitialWebkitBorderVerticalSpacing(StyleResolver& styleResolver)
    {
        styleResolver.style()->setVerticalBorderSpacing(RenderStyle::initialVerticalBorderSpacing());
    }
    static void applyInheritWebkitBorderVerticalSpacing(StyleResolver& styleResolver)
    {
        styleResolver.style()->setVerticalBorderSpacing(styleResolver.parentStyle()->verticalBorderSpacing());
    }
    static void applyValueWebkitBorderVerticalSpacing(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setVerticalBorderSpacing(StyleBuilderConverter::convertComputedLength<short>(styleResolver, value));
    }
    static void applyInitialWebkitBoxAlign(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBoxAlign(RenderStyle::initialBoxAlign());
    }
    static void applyInheritWebkitBoxAlign(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBoxAlign(styleResolver.parentStyle()->boxAlign());
    }
    static void applyValueWebkitBoxAlign(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBoxAlign(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitBoxDirection(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBoxDirection(RenderStyle::initialBoxDirection());
    }
    static void applyInheritWebkitBoxDirection(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBoxDirection(styleResolver.parentStyle()->boxDirection());
    }
    static void applyValueWebkitBoxDirection(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBoxDirection(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitBoxFlex(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBoxFlex(RenderStyle::initialBoxFlex());
    }
    static void applyInheritWebkitBoxFlex(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBoxFlex(styleResolver.parentStyle()->boxFlex());
    }
    static void applyValueWebkitBoxFlex(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBoxFlex(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitBoxFlexGroup(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBoxFlexGroup(RenderStyle::initialBoxFlexGroup());
    }
    static void applyInheritWebkitBoxFlexGroup(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBoxFlexGroup(styleResolver.parentStyle()->boxFlexGroup());
    }
    static void applyValueWebkitBoxFlexGroup(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBoxFlexGroup(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitBoxLines(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBoxLines(RenderStyle::initialBoxLines());
    }
    static void applyInheritWebkitBoxLines(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBoxLines(styleResolver.parentStyle()->boxLines());
    }
    static void applyValueWebkitBoxLines(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBoxLines(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitBoxOrdinalGroup(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBoxOrdinalGroup(RenderStyle::initialBoxOrdinalGroup());
    }
    static void applyInheritWebkitBoxOrdinalGroup(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBoxOrdinalGroup(styleResolver.parentStyle()->boxOrdinalGroup());
    }
    static void applyValueWebkitBoxOrdinalGroup(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBoxOrdinalGroup(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitBoxOrient(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBoxOrient(RenderStyle::initialBoxOrient());
    }
    static void applyInheritWebkitBoxOrient(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBoxOrient(styleResolver.parentStyle()->boxOrient());
    }
    static void applyValueWebkitBoxOrient(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBoxOrient(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitBoxPack(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBoxPack(RenderStyle::initialBoxPack());
    }
    static void applyInheritWebkitBoxPack(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBoxPack(styleResolver.parentStyle()->boxPack());
    }
    static void applyValueWebkitBoxPack(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBoxPack(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitBoxReflect(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBoxReflect(RenderStyle::initialBoxReflect());
    }
    static void applyInheritWebkitBoxReflect(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBoxReflect(styleResolver.parentStyle()->boxReflect());
    }
    static void applyValueWebkitBoxReflect(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBoxReflect(StyleBuilderConverter::convertReflection(styleResolver, value));
    }
    static void applyInitialWebkitColumnAxis(StyleResolver& styleResolver)
    {
        styleResolver.style()->setColumnAxis(RenderStyle::initialColumnAxis());
    }
    static void applyInheritWebkitColumnAxis(StyleResolver& styleResolver)
    {
        styleResolver.style()->setColumnAxis(styleResolver.parentStyle()->columnAxis());
    }
    static void applyValueWebkitColumnAxis(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setColumnAxis(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitColumnBreakAfter(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakAfter(RenderStyle::initialBreakBetween());
    }
    static void applyInheritWebkitColumnBreakAfter(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakAfter(styleResolver.parentStyle()->breakAfter());
    }
    static void applyValueWebkitColumnBreakAfter(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBreakAfter(StyleBuilderConverter::convertColumnBreakBetween(styleResolver, value));
    }
    static void applyInitialWebkitColumnBreakBefore(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakBefore(RenderStyle::initialBreakBetween());
    }
    static void applyInheritWebkitColumnBreakBefore(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakBefore(styleResolver.parentStyle()->breakBefore());
    }
    static void applyValueWebkitColumnBreakBefore(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBreakBefore(StyleBuilderConverter::convertColumnBreakBetween(styleResolver, value));
    }
    static void applyInitialWebkitColumnBreakInside(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakInside(RenderStyle::initialBreakInside());
    }
    static void applyInheritWebkitColumnBreakInside(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakInside(styleResolver.parentStyle()->breakInside());
    }
    static void applyValueWebkitColumnBreakInside(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBreakInside(StyleBuilderConverter::convertColumnBreakInside(styleResolver, value));
    }
    static void applyInitialColumnCount(StyleResolver& styleResolver)
    {
        styleResolver.style()->setHasAutoColumnCount();
    }
    static void applyInheritColumnCount(StyleResolver& styleResolver)
    {
        if (styleResolver.parentStyle()->hasAutoColumnCount()) {
            styleResolver.style()->setHasAutoColumnCount();
            return;
        }
        styleResolver.style()->setColumnCount(styleResolver.parentStyle()->columnCount());
    }
    static void applyValueColumnCount(StyleResolver& styleResolver, CSSValue& value)
    {
        if (downcast<CSSPrimitiveValue>(value).getValueID() == CSSValueAuto) {
            styleResolver.style()->setHasAutoColumnCount();
            return;
        }
        styleResolver.style()->setColumnCount(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialColumnFill(StyleResolver& styleResolver)
    {
        styleResolver.style()->setColumnFill(RenderStyle::initialColumnFill());
    }
    static void applyInheritColumnFill(StyleResolver& styleResolver)
    {
        styleResolver.style()->setColumnFill(styleResolver.parentStyle()->columnFill());
    }
    static void applyValueColumnFill(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setColumnFill(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialColumnProgression(StyleResolver& styleResolver)
    {
        styleResolver.style()->setColumnProgression(RenderStyle::initialColumnProgression());
    }
    static void applyInheritColumnProgression(StyleResolver& styleResolver)
    {
        styleResolver.style()->setColumnProgression(styleResolver.parentStyle()->columnProgression());
    }
    static void applyValueColumnProgression(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setColumnProgression(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialColumnRuleColor(StyleResolver& styleResolver)
    {
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setColumnRuleColor(RenderStyle::invalidColor());
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkColumnRuleColor(RenderStyle::invalidColor());
    }
    static void applyInheritColumnRuleColor(StyleResolver& styleResolver)
    {
        Color color = styleResolver.parentStyle()->columnRuleColor();
        if (!color.isValid())
            color = styleResolver.parentStyle()->color();
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setColumnRuleColor(color);
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkColumnRuleColor(color);
    }
    static void applyValueColumnRuleColor(StyleResolver& styleResolver, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setColumnRuleColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkColumnRuleColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialColumnRuleStyle(StyleResolver& styleResolver)
    {
        styleResolver.style()->setColumnRuleStyle(RenderStyle::initialBorderStyle());
    }
    static void applyInheritColumnRuleStyle(StyleResolver& styleResolver)
    {
        styleResolver.style()->setColumnRuleStyle(styleResolver.parentStyle()->columnRuleStyle());
    }
    static void applyValueColumnRuleStyle(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setColumnRuleStyle(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialColumnRuleWidth(StyleResolver& styleResolver)
    {
        styleResolver.style()->setColumnRuleWidth(RenderStyle::initialColumnRuleWidth());
    }
    static void applyInheritColumnRuleWidth(StyleResolver& styleResolver)
    {
        styleResolver.style()->setColumnRuleWidth(styleResolver.parentStyle()->columnRuleWidth());
    }
    static void applyValueColumnRuleWidth(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setColumnRuleWidth(StyleBuilderConverter::convertLineWidth<unsigned short>(styleResolver, value));
    }
    static void applyInitialColumnSpan(StyleResolver& styleResolver)
    {
        styleResolver.style()->setColumnSpan(RenderStyle::initialColumnSpan());
    }
    static void applyInheritColumnSpan(StyleResolver& styleResolver)
    {
        styleResolver.style()->setColumnSpan(styleResolver.parentStyle()->columnSpan());
    }
    static void applyValueColumnSpan(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setColumnSpan(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialColumnWidth(StyleResolver& styleResolver)
    {
        styleResolver.style()->setHasAutoColumnWidth();
    }
    static void applyInheritColumnWidth(StyleResolver& styleResolver)
    {
        if (styleResolver.parentStyle()->hasAutoColumnWidth()) {
            styleResolver.style()->setHasAutoColumnWidth();
            return;
        }
        styleResolver.style()->setColumnWidth(styleResolver.parentStyle()->columnWidth());
    }
    static void applyValueColumnWidth(StyleResolver& styleResolver, CSSValue& value)
    {
        if (downcast<CSSPrimitiveValue>(value).getValueID() == CSSValueAuto) {
            styleResolver.style()->setHasAutoColumnWidth();
            return;
        }
        styleResolver.style()->setColumnWidth(StyleBuilderConverter::convertComputedLength<float>(styleResolver, value));
    }
    static void applyInitialWebkitBoxDecorationBreak(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBoxDecorationBreak(RenderStyle::initialBoxDecorationBreak());
    }
    static void applyInheritWebkitBoxDecorationBreak(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBoxDecorationBreak(styleResolver.parentStyle()->boxDecorationBreak());
    }
    static void applyValueWebkitBoxDecorationBreak(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBoxDecorationBreak(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialMixBlendMode(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBlendMode(RenderStyle::initialBlendMode());
    }
    static void applyInheritMixBlendMode(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBlendMode(styleResolver.parentStyle()->blendMode());
    }
    static void applyValueMixBlendMode(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBlendMode(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialIsolation(StyleResolver& styleResolver)
    {
        styleResolver.style()->setIsolation(RenderStyle::initialIsolation());
    }
    static void applyInheritIsolation(StyleResolver& styleResolver)
    {
        styleResolver.style()->setIsolation(styleResolver.parentStyle()->isolation());
    }
    static void applyValueIsolation(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setIsolation(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialFilter(StyleResolver& styleResolver)
    {
        styleResolver.style()->setFilter(RenderStyle::initialFilter());
    }
    static void applyInheritFilter(StyleResolver& styleResolver)
    {
        styleResolver.style()->setFilter(styleResolver.parentStyle()->filter());
    }
    static void applyValueFilter(StyleResolver& styleResolver, CSSValue& value)
    {
        auto convertedValue = StyleBuilderConverter::convertFilterOperations(styleResolver, value);
        if (convertedValue)
            styleResolver.style()->setFilter(convertedValue.value());
    }
    static void applyInitialAlignContent(StyleResolver& styleResolver)
    {
        styleResolver.style()->setAlignContent(RenderStyle::initialContentAlignment());
    }
    static void applyInheritAlignContent(StyleResolver& styleResolver)
    {
        styleResolver.style()->setAlignContent(styleResolver.parentStyle()->alignContent());
    }
    static void applyValueAlignContent(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setAlignContent(StyleBuilderConverter::convertContentAlignmentData(styleResolver, value));
    }
    static void applyInitialAlignItems(StyleResolver& styleResolver)
    {
        styleResolver.style()->setAlignItems(RenderStyle::initialSelfAlignment());
    }
    static void applyInheritAlignItems(StyleResolver& styleResolver)
    {
        styleResolver.style()->setAlignItems(styleResolver.parentStyle()->alignItems());
    }
    static void applyValueAlignItems(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setAlignItems(StyleBuilderConverter::convertSelfOrDefaultAlignmentData(styleResolver, value));
    }
    static void applyInitialAlignSelf(StyleResolver& styleResolver)
    {
        styleResolver.style()->setAlignSelf(RenderStyle::initialSelfAlignment());
    }
    static void applyInheritAlignSelf(StyleResolver& styleResolver)
    {
        styleResolver.style()->setAlignSelf(styleResolver.parentStyle()->alignSelf());
    }
    static void applyValueAlignSelf(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setAlignSelf(StyleBuilderConverter::convertSelfOrDefaultAlignmentData(styleResolver, value));
    }
    static void applyInitialFlexBasis(StyleResolver& styleResolver)
    {
        styleResolver.style()->setFlexBasis(RenderStyle::initialFlexBasis());
    }
    static void applyInheritFlexBasis(StyleResolver& styleResolver)
    {
        styleResolver.style()->setFlexBasis(styleResolver.parentStyle()->flexBasis());
    }
    static void applyValueFlexBasis(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setFlexBasis(StyleBuilderConverter::convertLengthOrAuto(styleResolver, value));
    }
    static void applyInitialFlexDirection(StyleResolver& styleResolver)
    {
        styleResolver.style()->setFlexDirection(RenderStyle::initialFlexDirection());
    }
    static void applyInheritFlexDirection(StyleResolver& styleResolver)
    {
        styleResolver.style()->setFlexDirection(styleResolver.parentStyle()->flexDirection());
    }
    static void applyValueFlexDirection(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setFlexDirection(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialFlexGrow(StyleResolver& styleResolver)
    {
        styleResolver.style()->setFlexGrow(RenderStyle::initialFlexGrow());
    }
    static void applyInheritFlexGrow(StyleResolver& styleResolver)
    {
        styleResolver.style()->setFlexGrow(styleResolver.parentStyle()->flexGrow());
    }
    static void applyValueFlexGrow(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setFlexGrow(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialFlexShrink(StyleResolver& styleResolver)
    {
        styleResolver.style()->setFlexShrink(RenderStyle::initialFlexShrink());
    }
    static void applyInheritFlexShrink(StyleResolver& styleResolver)
    {
        styleResolver.style()->setFlexShrink(styleResolver.parentStyle()->flexShrink());
    }
    static void applyValueFlexShrink(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setFlexShrink(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialFlexWrap(StyleResolver& styleResolver)
    {
        styleResolver.style()->setFlexWrap(RenderStyle::initialFlexWrap());
    }
    static void applyInheritFlexWrap(StyleResolver& styleResolver)
    {
        styleResolver.style()->setFlexWrap(styleResolver.parentStyle()->flexWrap());
    }
    static void applyValueFlexWrap(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setFlexWrap(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialJustifyContent(StyleResolver& styleResolver)
    {
        styleResolver.style()->setJustifyContent(RenderStyle::initialContentAlignment());
    }
    static void applyInheritJustifyContent(StyleResolver& styleResolver)
    {
        styleResolver.style()->setJustifyContent(styleResolver.parentStyle()->justifyContent());
    }
    static void applyValueJustifyContent(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setJustifyContent(StyleBuilderConverter::convertContentAlignmentData(styleResolver, value));
    }
    static void applyInitialJustifySelf(StyleResolver& styleResolver)
    {
        styleResolver.style()->setJustifySelf(RenderStyle::initialSelfAlignment());
    }
    static void applyInheritJustifySelf(StyleResolver& styleResolver)
    {
        styleResolver.style()->setJustifySelf(styleResolver.parentStyle()->justifySelf());
    }
    static void applyValueJustifySelf(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setJustifySelf(StyleBuilderConverter::convertSelfOrDefaultAlignmentData(styleResolver, value));
    }
    static void applyInitialJustifyItems(StyleResolver& styleResolver)
    {
        styleResolver.style()->setJustifyItems(RenderStyle::initialSelfAlignment());
    }
    static void applyInheritJustifyItems(StyleResolver& styleResolver)
    {
        styleResolver.style()->setJustifyItems(styleResolver.parentStyle()->justifyItems());
    }
    static void applyValueJustifyItems(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setJustifyItems(StyleBuilderConverter::convertSelfOrDefaultAlignmentData(styleResolver, value));
    }
    static void applyInitialWebkitGridAutoColumns(StyleResolver& styleResolver)
    {
        styleResolver.style()->setGridAutoColumns(RenderStyle::initialGridAutoColumns());
    }
    static void applyInheritWebkitGridAutoColumns(StyleResolver& styleResolver)
    {
        styleResolver.style()->setGridAutoColumns(styleResolver.parentStyle()->gridAutoColumns());
    }
    static void applyValueWebkitGridAutoColumns(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setGridAutoColumns(StyleBuilderConverter::convertGridTrackSize(styleResolver, value));
    }
    static void applyInitialWebkitGridAutoRows(StyleResolver& styleResolver)
    {
        styleResolver.style()->setGridAutoRows(RenderStyle::initialGridAutoRows());
    }
    static void applyInheritWebkitGridAutoRows(StyleResolver& styleResolver)
    {
        styleResolver.style()->setGridAutoRows(styleResolver.parentStyle()->gridAutoRows());
    }
    static void applyValueWebkitGridAutoRows(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setGridAutoRows(StyleBuilderConverter::convertGridTrackSize(styleResolver, value));
    }
    static void applyInitialWebkitGridColumnEnd(StyleResolver& styleResolver)
    {
        styleResolver.style()->setGridItemColumnEnd(RenderStyle::initialGridItemColumnEnd());
    }
    static void applyInheritWebkitGridColumnEnd(StyleResolver& styleResolver)
    {
        styleResolver.style()->setGridItemColumnEnd(styleResolver.parentStyle()->gridItemColumnEnd());
    }
    static void applyValueWebkitGridColumnEnd(StyleResolver& styleResolver, CSSValue& value)
    {
        auto convertedValue = StyleBuilderConverter::convertGridPosition(styleResolver, value);
        if (convertedValue)
            styleResolver.style()->setGridItemColumnEnd(convertedValue.value());
    }
    static void applyInitialWebkitGridColumnGap(StyleResolver& styleResolver)
    {
        styleResolver.style()->setGridColumnGap(RenderStyle::initialZeroLength());
    }
    static void applyInheritWebkitGridColumnGap(StyleResolver& styleResolver)
    {
        styleResolver.style()->setGridColumnGap(styleResolver.parentStyle()->gridColumnGap());
    }
    static void applyValueWebkitGridColumnGap(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setGridColumnGap(StyleBuilderConverter::convertLength(styleResolver, value));
    }
    static void applyInitialWebkitGridColumnStart(StyleResolver& styleResolver)
    {
        styleResolver.style()->setGridItemColumnStart(RenderStyle::initialGridItemColumnStart());
    }
    static void applyInheritWebkitGridColumnStart(StyleResolver& styleResolver)
    {
        styleResolver.style()->setGridItemColumnStart(styleResolver.parentStyle()->gridItemColumnStart());
    }
    static void applyValueWebkitGridColumnStart(StyleResolver& styleResolver, CSSValue& value)
    {
        auto convertedValue = StyleBuilderConverter::convertGridPosition(styleResolver, value);
        if (convertedValue)
            styleResolver.style()->setGridItemColumnStart(convertedValue.value());
    }
    static void applyInitialWebkitGridRowEnd(StyleResolver& styleResolver)
    {
        styleResolver.style()->setGridItemRowEnd(RenderStyle::initialGridItemRowEnd());
    }
    static void applyInheritWebkitGridRowEnd(StyleResolver& styleResolver)
    {
        styleResolver.style()->setGridItemRowEnd(styleResolver.parentStyle()->gridItemRowEnd());
    }
    static void applyValueWebkitGridRowEnd(StyleResolver& styleResolver, CSSValue& value)
    {
        auto convertedValue = StyleBuilderConverter::convertGridPosition(styleResolver, value);
        if (convertedValue)
            styleResolver.style()->setGridItemRowEnd(convertedValue.value());
    }
    static void applyInitialWebkitGridRowGap(StyleResolver& styleResolver)
    {
        styleResolver.style()->setGridRowGap(RenderStyle::initialZeroLength());
    }
    static void applyInheritWebkitGridRowGap(StyleResolver& styleResolver)
    {
        styleResolver.style()->setGridRowGap(styleResolver.parentStyle()->gridRowGap());
    }
    static void applyValueWebkitGridRowGap(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setGridRowGap(StyleBuilderConverter::convertLength(styleResolver, value));
    }
    static void applyInitialWebkitGridRowStart(StyleResolver& styleResolver)
    {
        styleResolver.style()->setGridItemRowStart(RenderStyle::initialGridItemRowStart());
    }
    static void applyInheritWebkitGridRowStart(StyleResolver& styleResolver)
    {
        styleResolver.style()->setGridItemRowStart(styleResolver.parentStyle()->gridItemRowStart());
    }
    static void applyValueWebkitGridRowStart(StyleResolver& styleResolver, CSSValue& value)
    {
        auto convertedValue = StyleBuilderConverter::convertGridPosition(styleResolver, value);
        if (convertedValue)
            styleResolver.style()->setGridItemRowStart(convertedValue.value());
    }
    static void applyInitialWebkitGridAutoFlow(StyleResolver& styleResolver)
    {
        styleResolver.style()->setGridAutoFlow(RenderStyle::initialGridAutoFlow());
    }
    static void applyInheritWebkitGridAutoFlow(StyleResolver& styleResolver)
    {
        styleResolver.style()->setGridAutoFlow(styleResolver.parentStyle()->gridAutoFlow());
    }
    static void applyValueWebkitGridAutoFlow(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setGridAutoFlow(StyleBuilderConverter::convertGridAutoFlow(styleResolver, value));
    }
    static void applyInitialWebkitHyphenateCharacter(StyleResolver& styleResolver)
    {
        styleResolver.style()->setHyphenationString(RenderStyle::initialHyphenationString());
    }
    static void applyInheritWebkitHyphenateCharacter(StyleResolver& styleResolver)
    {
        styleResolver.style()->setHyphenationString(styleResolver.parentStyle()->hyphenationString());
    }
    static void applyValueWebkitHyphenateCharacter(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setHyphenationString(StyleBuilderConverter::convertStringOrAuto(styleResolver, value));
    }
    static void applyInitialWebkitHyphenateLimitAfter(StyleResolver& styleResolver)
    {
        styleResolver.style()->setHyphenationLimitAfter(RenderStyle::initialHyphenationLimitAfter());
    }
    static void applyInheritWebkitHyphenateLimitAfter(StyleResolver& styleResolver)
    {
        styleResolver.style()->setHyphenationLimitAfter(styleResolver.parentStyle()->hyphenationLimitAfter());
    }
    static void applyValueWebkitHyphenateLimitAfter(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setHyphenationLimitAfter(StyleBuilderConverter::convertNumberOrAuto<short>(styleResolver, value));
    }
    static void applyInitialWebkitHyphenateLimitBefore(StyleResolver& styleResolver)
    {
        styleResolver.style()->setHyphenationLimitBefore(RenderStyle::initialHyphenationLimitBefore());
    }
    static void applyInheritWebkitHyphenateLimitBefore(StyleResolver& styleResolver)
    {
        styleResolver.style()->setHyphenationLimitBefore(styleResolver.parentStyle()->hyphenationLimitBefore());
    }
    static void applyValueWebkitHyphenateLimitBefore(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setHyphenationLimitBefore(StyleBuilderConverter::convertNumberOrAuto<short>(styleResolver, value));
    }
    static void applyInitialWebkitHyphenateLimitLines(StyleResolver& styleResolver)
    {
        styleResolver.style()->setHyphenationLimitLines(RenderStyle::initialHyphenationLimitLines());
    }
    static void applyInheritWebkitHyphenateLimitLines(StyleResolver& styleResolver)
    {
        styleResolver.style()->setHyphenationLimitLines(styleResolver.parentStyle()->hyphenationLimitLines());
    }
    static void applyValueWebkitHyphenateLimitLines(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setHyphenationLimitLines(StyleBuilderConverter::convertWebkitHyphenateLimitLines(styleResolver, value));
    }
    static void applyInitialWebkitHyphens(StyleResolver& styleResolver)
    {
        styleResolver.style()->setHyphens(RenderStyle::initialHyphens());
    }
    static void applyInheritWebkitHyphens(StyleResolver& styleResolver)
    {
        styleResolver.style()->setHyphens(styleResolver.parentStyle()->hyphens());
    }
    static void applyValueWebkitHyphens(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setHyphens(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitInitialLetter(StyleResolver& styleResolver)
    {
        styleResolver.style()->setInitialLetter(RenderStyle::initialInitialLetter());
    }
    static void applyInheritWebkitInitialLetter(StyleResolver& styleResolver)
    {
        styleResolver.style()->setInitialLetter(styleResolver.parentStyle()->initialLetter());
    }
    static void applyValueWebkitInitialLetter(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setInitialLetter(StyleBuilderConverter::convertInitialLetter(styleResolver, value));
    }
    static void applyInitialWebkitLineBoxContain(StyleResolver& styleResolver)
    {
        styleResolver.style()->setLineBoxContain(RenderStyle::initialLineBoxContain());
    }
    static void applyInheritWebkitLineBoxContain(StyleResolver& styleResolver)
    {
        styleResolver.style()->setLineBoxContain(styleResolver.parentStyle()->lineBoxContain());
    }
    static void applyValueWebkitLineBoxContain(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setLineBoxContain(StyleBuilderConverter::convertLineBoxContain(styleResolver, value));
    }
    static void applyInitialWebkitLineAlign(StyleResolver& styleResolver)
    {
        styleResolver.style()->setLineAlign(RenderStyle::initialLineAlign());
    }
    static void applyInheritWebkitLineAlign(StyleResolver& styleResolver)
    {
        styleResolver.style()->setLineAlign(styleResolver.parentStyle()->lineAlign());
    }
    static void applyValueWebkitLineAlign(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setLineAlign(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitLineBreak(StyleResolver& styleResolver)
    {
        styleResolver.style()->setLineBreak(RenderStyle::initialLineBreak());
    }
    static void applyInheritWebkitLineBreak(StyleResolver& styleResolver)
    {
        styleResolver.style()->setLineBreak(styleResolver.parentStyle()->lineBreak());
    }
    static void applyValueWebkitLineBreak(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setLineBreak(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitLineClamp(StyleResolver& styleResolver)
    {
        styleResolver.style()->setLineClamp(RenderStyle::initialLineClamp());
    }
    static void applyInheritWebkitLineClamp(StyleResolver& styleResolver)
    {
        styleResolver.style()->setLineClamp(styleResolver.parentStyle()->lineClamp());
    }
    static void applyValueWebkitLineClamp(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setLineClamp(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitLineGrid(StyleResolver& styleResolver)
    {
        styleResolver.style()->setLineGrid(RenderStyle::initialLineGrid());
    }
    static void applyInheritWebkitLineGrid(StyleResolver& styleResolver)
    {
        styleResolver.style()->setLineGrid(styleResolver.parentStyle()->lineGrid());
    }
    static void applyValueWebkitLineGrid(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setLineGrid(StyleBuilderConverter::convertStringOrNone(styleResolver, value));
    }
    static void applyInitialWebkitLineSnap(StyleResolver& styleResolver)
    {
        styleResolver.style()->setLineSnap(RenderStyle::initialLineSnap());
    }
    static void applyInheritWebkitLineSnap(StyleResolver& styleResolver)
    {
        styleResolver.style()->setLineSnap(styleResolver.parentStyle()->lineSnap());
    }
    static void applyValueWebkitLineSnap(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setLineSnap(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitMarginAfterCollapse(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarginAfterCollapse(RenderStyle::initialMarginAfterCollapse());
    }
    static void applyInheritWebkitMarginAfterCollapse(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarginAfterCollapse(styleResolver.parentStyle()->marginAfterCollapse());
    }
    static void applyValueWebkitMarginAfterCollapse(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setMarginAfterCollapse(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitMarginBeforeCollapse(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarginBeforeCollapse(RenderStyle::initialMarginBeforeCollapse());
    }
    static void applyInheritWebkitMarginBeforeCollapse(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarginBeforeCollapse(styleResolver.parentStyle()->marginBeforeCollapse());
    }
    static void applyValueWebkitMarginBeforeCollapse(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setMarginBeforeCollapse(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitMarginBottomCollapse(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarginAfterCollapse(RenderStyle::initialMarginAfterCollapse());
    }
    static void applyInheritWebkitMarginBottomCollapse(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarginAfterCollapse(styleResolver.parentStyle()->marginAfterCollapse());
    }
    static void applyValueWebkitMarginBottomCollapse(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setMarginAfterCollapse(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitMarginTopCollapse(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarginBeforeCollapse(RenderStyle::initialMarginBeforeCollapse());
    }
    static void applyInheritWebkitMarginTopCollapse(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarginBeforeCollapse(styleResolver.parentStyle()->marginBeforeCollapse());
    }
    static void applyValueWebkitMarginTopCollapse(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setMarginBeforeCollapse(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitMarqueeDirection(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarqueeDirection(RenderStyle::initialMarqueeDirection());
    }
    static void applyInheritWebkitMarqueeDirection(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarqueeDirection(styleResolver.parentStyle()->marqueeDirection());
    }
    static void applyValueWebkitMarqueeDirection(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setMarqueeDirection(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitMarqueeIncrement(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarqueeIncrement(RenderStyle::initialMarqueeIncrement());
    }
    static void applyInheritWebkitMarqueeIncrement(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarqueeIncrement(styleResolver.parentStyle()->marqueeIncrement());
    }
    static void applyValueWebkitMarqueeIncrement(StyleResolver& styleResolver, CSSValue& value)
    {
        auto convertedValue = StyleBuilderConverter::convertMarqueeIncrement(styleResolver, value);
        if (convertedValue)
            styleResolver.style()->setMarqueeIncrement(convertedValue.value());
    }
    static void applyInitialWebkitMarqueeRepetition(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarqueeLoopCount(RenderStyle::initialMarqueeLoopCount());
    }
    static void applyInheritWebkitMarqueeRepetition(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarqueeLoopCount(styleResolver.parentStyle()->marqueeLoopCount());
    }
    static void applyValueWebkitMarqueeRepetition(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setMarqueeLoopCount(StyleBuilderConverter::convertMarqueeRepetition(styleResolver, value));
    }
    static void applyInitialWebkitMarqueeSpeed(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarqueeSpeed(RenderStyle::initialMarqueeSpeed());
    }
    static void applyInheritWebkitMarqueeSpeed(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarqueeSpeed(styleResolver.parentStyle()->marqueeSpeed());
    }
    static void applyValueWebkitMarqueeSpeed(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setMarqueeSpeed(StyleBuilderConverter::convertMarqueeSpeed(styleResolver, value));
    }
    static void applyInitialWebkitMarqueeStyle(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarqueeBehavior(RenderStyle::initialMarqueeBehavior());
    }
    static void applyInheritWebkitMarqueeStyle(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMarqueeBehavior(styleResolver.parentStyle()->marqueeBehavior());
    }
    static void applyValueWebkitMarqueeStyle(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setMarqueeBehavior(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitMaskBoxImage(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMaskBoxImage(RenderStyle::initialNinePieceImage());
    }
    static void applyInheritWebkitMaskBoxImage(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMaskBoxImage(styleResolver.parentStyle()->maskBoxImage());
    }
    static void applyValueWebkitMaskBoxImage(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setMaskBoxImage(StyleBuilderConverter::convertBorderMask<CSSPropertyWebkitMaskBoxImage>(styleResolver, value));
    }
    static void applyInitialWebkitMaskBoxImageSource(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMaskBoxImageSource(RenderStyle::initialMaskBoxImageSource());
    }
    static void applyInheritWebkitMaskBoxImageSource(StyleResolver& styleResolver)
    {
        styleResolver.style()->setMaskBoxImageSource(styleResolver.parentStyle()->maskBoxImageSource());
    }
    static void applyValueWebkitMaskBoxImageSource(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setMaskBoxImageSource(StyleBuilderConverter::convertStyleImage<CSSPropertyWebkitMaskBoxImageSource>(styleResolver, value));
    }
    static void applyInitialWebkitMaskClip(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->maskLayers();
        if (!layers.next() && (!layers.isClipSet() || layers.clip() == FillLayer::initialFillClip(MaskFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureMaskLayers();
        child->setClip(FillLayer::initialFillClip(MaskFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearClip();
    }
    static void applyInheritWebkitMaskClip(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->maskLayers() == *styleResolver.style()->maskLayers())
            return;

        auto* child = &styleResolver.style()->ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->maskLayers(); parent && parent->isClipSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(MaskFillLayer));
                child = previousChild->next();
            }
            child->setClip(parent->clip());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyValueWebkitMaskClip(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(MaskFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillClip(CSSPropertyWebkitMaskClip, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillClip(CSSPropertyWebkitMaskClip, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearClip();
    }
    static void applyInitialWebkitMaskComposite(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->maskLayers();
        if (!layers.next() && (!layers.isCompositeSet() || layers.composite() == FillLayer::initialFillComposite(MaskFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureMaskLayers();
        child->setComposite(FillLayer::initialFillComposite(MaskFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearComposite();
    }
    static void applyInheritWebkitMaskComposite(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->maskLayers() == *styleResolver.style()->maskLayers())
            return;

        auto* child = &styleResolver.style()->ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->maskLayers(); parent && parent->isCompositeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(MaskFillLayer));
                child = previousChild->next();
            }
            child->setComposite(parent->composite());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearComposite();
    }
    static void applyValueWebkitMaskComposite(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(MaskFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillComposite(CSSPropertyWebkitMaskComposite, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillComposite(CSSPropertyWebkitMaskComposite, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearComposite();
    }
    static void applyInitialWebkitMaskImage(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->maskLayers();
        if (!layers.next() && (!layers.isImageSet() || layers.image() == FillLayer::initialFillImage(MaskFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureMaskLayers();
        child->setImage(FillLayer::initialFillImage(MaskFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearImage();
    }
    static void applyInheritWebkitMaskImage(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->maskLayers() == *styleResolver.style()->maskLayers())
            return;

        auto* child = &styleResolver.style()->ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->maskLayers(); parent && parent->isImageSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(MaskFillLayer));
                child = previousChild->next();
            }
            child->setImage(parent->image());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearImage();
    }
    static void applyValueWebkitMaskImage(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(MaskFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillImage(CSSPropertyWebkitMaskImage, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillImage(CSSPropertyWebkitMaskImage, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearImage();
    }
    static void applyInitialWebkitMaskOrigin(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->maskLayers();
        if (!layers.next() && (!layers.isOriginSet() || layers.origin() == FillLayer::initialFillOrigin(MaskFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureMaskLayers();
        child->setOrigin(FillLayer::initialFillOrigin(MaskFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearOrigin();
    }
    static void applyInheritWebkitMaskOrigin(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->maskLayers() == *styleResolver.style()->maskLayers())
            return;

        auto* child = &styleResolver.style()->ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->maskLayers(); parent && parent->isOriginSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(MaskFillLayer));
                child = previousChild->next();
            }
            child->setOrigin(parent->origin());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearOrigin();
    }
    static void applyValueWebkitMaskOrigin(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(MaskFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillOrigin(CSSPropertyWebkitMaskOrigin, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillOrigin(CSSPropertyWebkitMaskOrigin, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearOrigin();
    }
    static void applyInitialWebkitMaskPositionX(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->maskLayers();
        if (!layers.next() && (!layers.isXPositionSet() || layers.xPosition() == FillLayer::initialFillXPosition(MaskFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureMaskLayers();
        child->setXPosition(FillLayer::initialFillXPosition(MaskFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearXPosition();
    }
    static void applyInheritWebkitMaskPositionX(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->maskLayers() == *styleResolver.style()->maskLayers())
            return;

        auto* child = &styleResolver.style()->ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->maskLayers(); parent && parent->isXPositionSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(MaskFillLayer));
                child = previousChild->next();
            }
            child->setXPosition(parent->xPosition());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearXPosition();
    }
    static void applyValueWebkitMaskPositionX(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(MaskFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillXPosition(CSSPropertyWebkitMaskPositionX, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillXPosition(CSSPropertyWebkitMaskPositionX, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearXPosition();
    }
    static void applyInitialWebkitMaskPositionY(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->maskLayers();
        if (!layers.next() && (!layers.isYPositionSet() || layers.yPosition() == FillLayer::initialFillYPosition(MaskFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureMaskLayers();
        child->setYPosition(FillLayer::initialFillYPosition(MaskFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearYPosition();
    }
    static void applyInheritWebkitMaskPositionY(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->maskLayers() == *styleResolver.style()->maskLayers())
            return;

        auto* child = &styleResolver.style()->ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->maskLayers(); parent && parent->isYPositionSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(MaskFillLayer));
                child = previousChild->next();
            }
            child->setYPosition(parent->yPosition());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearYPosition();
    }
    static void applyValueWebkitMaskPositionY(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(MaskFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillYPosition(CSSPropertyWebkitMaskPositionY, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillYPosition(CSSPropertyWebkitMaskPositionY, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearYPosition();
    }
    static void applyInitialWebkitMaskRepeatX(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->maskLayers();
        if (!layers.next() && (!layers.isRepeatXSet() || layers.repeatX() == FillLayer::initialFillRepeatX(MaskFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureMaskLayers();
        child->setRepeatX(FillLayer::initialFillRepeatX(MaskFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearRepeatX();
    }
    static void applyInheritWebkitMaskRepeatX(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->maskLayers() == *styleResolver.style()->maskLayers())
            return;

        auto* child = &styleResolver.style()->ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->maskLayers(); parent && parent->isRepeatXSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(MaskFillLayer));
                child = previousChild->next();
            }
            child->setRepeatX(parent->repeatX());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearRepeatX();
    }
    static void applyValueWebkitMaskRepeatX(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(MaskFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillRepeatX(CSSPropertyWebkitMaskRepeatX, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillRepeatX(CSSPropertyWebkitMaskRepeatX, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearRepeatX();
    }
    static void applyInitialWebkitMaskRepeatY(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->maskLayers();
        if (!layers.next() && (!layers.isRepeatYSet() || layers.repeatY() == FillLayer::initialFillRepeatY(MaskFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureMaskLayers();
        child->setRepeatY(FillLayer::initialFillRepeatY(MaskFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearRepeatY();
    }
    static void applyInheritWebkitMaskRepeatY(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->maskLayers() == *styleResolver.style()->maskLayers())
            return;

        auto* child = &styleResolver.style()->ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->maskLayers(); parent && parent->isRepeatYSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(MaskFillLayer));
                child = previousChild->next();
            }
            child->setRepeatY(parent->repeatY());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearRepeatY();
    }
    static void applyValueWebkitMaskRepeatY(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(MaskFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillRepeatY(CSSPropertyWebkitMaskRepeatY, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillRepeatY(CSSPropertyWebkitMaskRepeatY, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearRepeatY();
    }
    static void applyInitialWebkitMaskSize(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->maskLayers();
        if (!layers.next() && (!layers.isSizeSet() || layers.size() == FillLayer::initialFillSize(MaskFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureMaskLayers();
        child->setSize(FillLayer::initialFillSize(MaskFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearSize();
    }
    static void applyInheritWebkitMaskSize(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->maskLayers() == *styleResolver.style()->maskLayers())
            return;

        auto* child = &styleResolver.style()->ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->maskLayers(); parent && parent->isSizeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(MaskFillLayer));
                child = previousChild->next();
            }
            child->setSize(parent->size());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearSize();
    }
    static void applyValueWebkitMaskSize(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(MaskFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillSize(CSSPropertyWebkitMaskSize, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillSize(CSSPropertyWebkitMaskSize, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearSize();
    }
    static void applyInitialWebkitMaskSourceType(StyleResolver& styleResolver)
    {
        // Check for (single-layer) no-op before clearing anything.
        const FillLayer& layers = *styleResolver.style()->maskLayers();
        if (!layers.next() && (!layers.isMaskSourceTypeSet() || layers.maskSourceType() == FillLayer::initialFillMaskSourceType(MaskFillLayer)))
            return;

        FillLayer* child = &styleResolver.style()->ensureMaskLayers();
        child->setMaskSourceType(FillLayer::initialFillMaskSourceType(MaskFillLayer));
        for (child = child->next(); child; child = child->next())
            child->clearMaskSourceType();
    }
    static void applyInheritWebkitMaskSourceType(StyleResolver& styleResolver)
    {
        // Check for no-op before copying anything.
        if (*styleResolver.parentStyle()->maskLayers() == *styleResolver.style()->maskLayers())
            return;

        auto* child = &styleResolver.style()->ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        for (auto* parent = styleResolver.parentStyle()->maskLayers(); parent && parent->isMaskSourceTypeSet(); parent = parent->next()) {
            if (!child) {
                previousChild->setNext(std::make_unique<FillLayer>(MaskFillLayer));
                child = previousChild->next();
            }
            child->setMaskSourceType(parent->maskSourceType());
            previousChild = child;
            child = previousChild->next();
        }
        for (; child; child = child->next())
            child->clearMaskSourceType();
    }
    static void applyValueWebkitMaskSourceType(StyleResolver& styleResolver, CSSValue& value)
    {
        FillLayer* child = &styleResolver.style()->ensureMaskLayers();
        FillLayer* previousChild = nullptr;
        if (is<CSSValueList>(value)
#if ENABLE(CSS_IMAGE_SET)
        && !is<CSSImageSetValue>(value)
#endif
        ) {
            // Walk each value and put it into a layer, creating new layers as needed.
            for (auto& item : downcast<CSSValueList>(value)) {
                if (!child) {
                    previousChild->setNext(std::make_unique<FillLayer>(MaskFillLayer));
                    child = previousChild->next();
                }
                styleResolver.styleMap()->mapFillMaskSourceType(CSSPropertyWebkitMaskSourceType, *child, item);
                previousChild = child;
                child = child->next();
            }
        } else {
            styleResolver.styleMap()->mapFillMaskSourceType(CSSPropertyWebkitMaskSourceType, *child, value);
            child = child->next();
        }
        for (; child; child = child->next())
            child->clearMaskSourceType();
    }
    static void applyInitialWebkitNbspMode(StyleResolver& styleResolver)
    {
        styleResolver.style()->setNBSPMode(RenderStyle::initialNBSPMode());
    }
    static void applyInheritWebkitNbspMode(StyleResolver& styleResolver)
    {
        styleResolver.style()->setNBSPMode(styleResolver.parentStyle()->nbspMode());
    }
    static void applyValueWebkitNbspMode(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setNBSPMode(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialOrder(StyleResolver& styleResolver)
    {
        styleResolver.style()->setOrder(RenderStyle::initialOrder());
    }
    static void applyInheritOrder(StyleResolver& styleResolver)
    {
        styleResolver.style()->setOrder(styleResolver.parentStyle()->order());
    }
    static void applyValueOrder(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setOrder(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialPerspective(StyleResolver& styleResolver)
    {
        styleResolver.style()->setPerspective(RenderStyle::initialPerspective());
    }
    static void applyInheritPerspective(StyleResolver& styleResolver)
    {
        styleResolver.style()->setPerspective(styleResolver.parentStyle()->perspective());
    }
    static void applyValuePerspective(StyleResolver& styleResolver, CSSValue& value)
    {
        auto convertedValue = StyleBuilderConverter::convertPerspective(styleResolver, value);
        if (convertedValue)
            styleResolver.style()->setPerspective(convertedValue.value());
    }
    static void applyInitialPerspectiveOriginX(StyleResolver& styleResolver)
    {
        styleResolver.style()->setPerspectiveOriginX(RenderStyle::initialPerspectiveOriginX());
    }
    static void applyInheritPerspectiveOriginX(StyleResolver& styleResolver)
    {
        styleResolver.style()->setPerspectiveOriginX(styleResolver.parentStyle()->perspectiveOriginX());
    }
    static void applyValuePerspectiveOriginX(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setPerspectiveOriginX(StyleBuilderConverter::convertLength(styleResolver, value));
    }
    static void applyInitialPerspectiveOriginY(StyleResolver& styleResolver)
    {
        styleResolver.style()->setPerspectiveOriginY(RenderStyle::initialPerspectiveOriginY());
    }
    static void applyInheritPerspectiveOriginY(StyleResolver& styleResolver)
    {
        styleResolver.style()->setPerspectiveOriginY(styleResolver.parentStyle()->perspectiveOriginY());
    }
    static void applyValuePerspectiveOriginY(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setPerspectiveOriginY(StyleBuilderConverter::convertLength(styleResolver, value));
    }
    static void applyInitialWebkitPrintColorAdjust(StyleResolver& styleResolver)
    {
        styleResolver.style()->setPrintColorAdjust(RenderStyle::initialPrintColorAdjust());
    }
    static void applyInheritWebkitPrintColorAdjust(StyleResolver& styleResolver)
    {
        styleResolver.style()->setPrintColorAdjust(styleResolver.parentStyle()->printColorAdjust());
    }
    static void applyValueWebkitPrintColorAdjust(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setPrintColorAdjust(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitRtlOrdering(StyleResolver& styleResolver)
    {
        styleResolver.style()->setRTLOrdering(RenderStyle::initialRTLOrdering());
    }
    static void applyInheritWebkitRtlOrdering(StyleResolver& styleResolver)
    {
        styleResolver.style()->setRTLOrdering(styleResolver.parentStyle()->rtlOrdering());
    }
    static void applyValueWebkitRtlOrdering(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setRTLOrdering(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitTextCombine(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextCombine(RenderStyle::initialTextCombine());
    }
    static void applyInheritWebkitTextCombine(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextCombine(styleResolver.parentStyle()->textCombine());
    }
    static void applyValueWebkitTextCombine(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setTextCombine(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitTextDecorationLine(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextDecoration(RenderStyle::initialTextDecoration());
    }
    static void applyInheritWebkitTextDecorationLine(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextDecoration(styleResolver.parentStyle()->textDecoration());
    }
    static void applyValueWebkitTextDecorationLine(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setTextDecoration(StyleBuilderConverter::convertTextDecoration(styleResolver, value));
    }
    static void applyInitialWebkitTextDecorationStyle(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextDecorationStyle(RenderStyle::initialTextDecorationStyle());
    }
    static void applyInheritWebkitTextDecorationStyle(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextDecorationStyle(styleResolver.parentStyle()->textDecorationStyle());
    }
    static void applyValueWebkitTextDecorationStyle(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setTextDecorationStyle(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitTextDecorationColor(StyleResolver& styleResolver)
    {
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setTextDecorationColor(RenderStyle::invalidColor());
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkTextDecorationColor(RenderStyle::invalidColor());
    }
    static void applyInheritWebkitTextDecorationColor(StyleResolver& styleResolver)
    {
        Color color = styleResolver.parentStyle()->textDecorationColor();
        if (!color.isValid())
            color = styleResolver.parentStyle()->color();
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setTextDecorationColor(color);
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkTextDecorationColor(color);
    }
    static void applyValueWebkitTextDecorationColor(StyleResolver& styleResolver, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setTextDecorationColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkTextDecorationColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialWebkitTextDecorationSkip(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextDecorationSkip(RenderStyle::initialTextDecorationSkip());
    }
    static void applyInheritWebkitTextDecorationSkip(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextDecorationSkip(styleResolver.parentStyle()->textDecorationSkip());
    }
    static void applyValueWebkitTextDecorationSkip(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setTextDecorationSkip(StyleBuilderConverter::convertTextDecorationSkip(styleResolver, value));
    }
    static void applyInitialWebkitTextUnderlinePosition(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextUnderlinePosition(RenderStyle::initialTextUnderlinePosition());
    }
    static void applyInheritWebkitTextUnderlinePosition(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextUnderlinePosition(styleResolver.parentStyle()->textUnderlinePosition());
    }
    static void applyValueWebkitTextUnderlinePosition(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setTextUnderlinePosition(StyleBuilderConverter::convertTextUnderlinePosition(styleResolver, value));
    }
    static void applyInitialWebkitTextEmphasisColor(StyleResolver& styleResolver)
    {
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setTextEmphasisColor(RenderStyle::invalidColor());
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkTextEmphasisColor(RenderStyle::invalidColor());
    }
    static void applyInheritWebkitTextEmphasisColor(StyleResolver& styleResolver)
    {
        Color color = styleResolver.parentStyle()->textEmphasisColor();
        if (!color.isValid())
            color = styleResolver.parentStyle()->color();
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setTextEmphasisColor(color);
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkTextEmphasisColor(color);
    }
    static void applyValueWebkitTextEmphasisColor(StyleResolver& styleResolver, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setTextEmphasisColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkTextEmphasisColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialWebkitTextEmphasisPosition(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextEmphasisPosition(RenderStyle::initialTextEmphasisPosition());
    }
    static void applyInheritWebkitTextEmphasisPosition(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextEmphasisPosition(styleResolver.parentStyle()->textEmphasisPosition());
    }
    static void applyValueWebkitTextEmphasisPosition(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setTextEmphasisPosition(StyleBuilderConverter::convertTextEmphasisPosition(styleResolver, value));
    }
    static void applyInitialWebkitTextFillColor(StyleResolver& styleResolver)
    {
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setTextFillColor(RenderStyle::invalidColor());
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkTextFillColor(RenderStyle::invalidColor());
    }
    static void applyInheritWebkitTextFillColor(StyleResolver& styleResolver)
    {
        Color color = styleResolver.parentStyle()->textFillColor();
        if (!color.isValid())
            color = styleResolver.parentStyle()->color();
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setTextFillColor(color);
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkTextFillColor(color);
    }
    static void applyValueWebkitTextFillColor(StyleResolver& styleResolver, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setTextFillColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkTextFillColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialWebkitTextSecurity(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextSecurity(RenderStyle::initialTextSecurity());
    }
    static void applyInheritWebkitTextSecurity(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextSecurity(styleResolver.parentStyle()->textSecurity());
    }
    static void applyValueWebkitTextSecurity(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setTextSecurity(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitTextStrokeColor(StyleResolver& styleResolver)
    {
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setTextStrokeColor(RenderStyle::invalidColor());
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkTextStrokeColor(RenderStyle::invalidColor());
    }
    static void applyInheritWebkitTextStrokeColor(StyleResolver& styleResolver)
    {
        Color color = styleResolver.parentStyle()->textStrokeColor();
        if (!color.isValid())
            color = styleResolver.parentStyle()->color();
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setTextStrokeColor(color);
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkTextStrokeColor(color);
    }
    static void applyValueWebkitTextStrokeColor(StyleResolver& styleResolver, CSSValue& value)
    {
        auto& primitiveValue = downcast<CSSPrimitiveValue>(value);
        if (styleResolver.applyPropertyToRegularStyle())
            styleResolver.style()->setTextStrokeColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ false));
        if (styleResolver.applyPropertyToVisitedLinkStyle())
            styleResolver.style()->setVisitedLinkTextStrokeColor(styleResolver.colorFromPrimitiveValue(primitiveValue, /* forVisitedLink */ true));
    }
    static void applyInitialWebkitTextStrokeWidth(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextStrokeWidth(RenderStyle::initialTextStrokeWidth());
    }
    static void applyInheritWebkitTextStrokeWidth(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTextStrokeWidth(styleResolver.parentStyle()->textStrokeWidth());
    }
    static void applyValueWebkitTextStrokeWidth(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setTextStrokeWidth(StyleBuilderConverter::convertTextStrokeWidth(styleResolver, value));
    }
    static void applyInitialTransform(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTransform(RenderStyle::initialTransform());
    }
    static void applyInheritTransform(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTransform(styleResolver.parentStyle()->transform());
    }
    static void applyValueTransform(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setTransform(StyleBuilderConverter::convertTransform(styleResolver, value));
    }
    static void applyInitialTransformOriginX(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTransformOriginX(RenderStyle::initialTransformOriginX());
    }
    static void applyInheritTransformOriginX(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTransformOriginX(styleResolver.parentStyle()->transformOriginX());
    }
    static void applyValueTransformOriginX(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setTransformOriginX(StyleBuilderConverter::convertLength(styleResolver, value));
    }
    static void applyInitialTransformOriginY(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTransformOriginY(RenderStyle::initialTransformOriginY());
    }
    static void applyInheritTransformOriginY(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTransformOriginY(styleResolver.parentStyle()->transformOriginY());
    }
    static void applyValueTransformOriginY(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setTransformOriginY(StyleBuilderConverter::convertLength(styleResolver, value));
    }
    static void applyInitialTransformOriginZ(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTransformOriginZ(RenderStyle::initialTransformOriginZ());
    }
    static void applyInheritTransformOriginZ(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTransformOriginZ(styleResolver.parentStyle()->transformOriginZ());
    }
    static void applyValueTransformOriginZ(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setTransformOriginZ(StyleBuilderConverter::convertComputedLength<float>(styleResolver, value));
    }
    static void applyInitialTransformStyle(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTransformStyle3D(RenderStyle::initialTransformStyle3D());
    }
    static void applyInheritTransformStyle(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTransformStyle3D(styleResolver.parentStyle()->transformStyle3D());
    }
    static void applyValueTransformStyle(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setTransformStyle3D(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitTransformStyle(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTransformStyle3D(RenderStyle::initialTransformStyle3D());
    }
    static void applyInheritWebkitTransformStyle(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTransformStyle3D(styleResolver.parentStyle()->transformStyle3D());
    }
    static void applyValueWebkitTransformStyle(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setTransformStyle3D(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitTransitionDelay(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureTransitions();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setDelay(Animation::initialDelay());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearDelay();
    }
    static void applyInheritWebkitTransitionDelay(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureTransitions();
        const AnimationList* parentList = styleResolver.parentStyle()->transitions();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isDelaySet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setDelay(parentList->animation(i).delay());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        /* Reset any remaining animations to not have the property set. */
        for ( ; i < list.size(); ++i)
            list.animation(i).clearDelay();
    }
    static void applyValueWebkitTransitionDelay(StyleResolver& styleResolver, CSSValue& value)
    {
        AnimationList& list = styleResolver.style()->ensureTransitions();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                styleResolver.styleMap()->mapAnimationDelay(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            styleResolver.styleMap()->mapAnimationDelay(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearDelay();
        }
    }
    static void applyInitialWebkitTransitionDuration(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureTransitions();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setDuration(Animation::initialDuration());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearDuration();
    }
    static void applyInheritWebkitTransitionDuration(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureTransitions();
        const AnimationList* parentList = styleResolver.parentStyle()->transitions();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isDurationSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setDuration(parentList->animation(i).duration());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        /* Reset any remaining animations to not have the property set. */
        for ( ; i < list.size(); ++i)
            list.animation(i).clearDuration();
    }
    static void applyValueWebkitTransitionDuration(StyleResolver& styleResolver, CSSValue& value)
    {
        AnimationList& list = styleResolver.style()->ensureTransitions();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                styleResolver.styleMap()->mapAnimationDuration(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            styleResolver.styleMap()->mapAnimationDuration(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearDuration();
        }
    }
    static void applyInitialWebkitTransitionProperty(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureTransitions();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setProperty(Animation::initialProperty());
        list.animation(0).setAnimationMode(Animation::AnimateAll);
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearProperty();
    }
    static void applyInheritWebkitTransitionProperty(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureTransitions();
        const AnimationList* parentList = styleResolver.parentStyle()->transitions();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isPropertySet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setProperty(parentList->animation(i).property());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        /* Reset any remaining animations to not have the property set. */
        for ( ; i < list.size(); ++i)
            list.animation(i).clearProperty();
    }
    static void applyValueWebkitTransitionProperty(StyleResolver& styleResolver, CSSValue& value)
    {
        AnimationList& list = styleResolver.style()->ensureTransitions();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                styleResolver.styleMap()->mapAnimationProperty(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            styleResolver.styleMap()->mapAnimationProperty(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearProperty();
        }
    }
    static void applyInitialWebkitTransitionTimingFunction(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureTransitions();
        if (list.isEmpty())
            list.append(Animation::create());
        list.animation(0).setTimingFunction(Animation::initialTimingFunction());
        for (size_t i = 1; i < list.size(); ++i)
            list.animation(i).clearTimingFunction();
    }
    static void applyInheritWebkitTransitionTimingFunction(StyleResolver& styleResolver)
    {
        AnimationList& list = styleResolver.style()->ensureTransitions();
        const AnimationList* parentList = styleResolver.parentStyle()->transitions();
        size_t i = 0, parentSize = parentList ? parentList->size() : 0;
        for ( ; i < parentSize && parentList->animation(i).isTimingFunctionSet(); ++i) {
            if (list.size() <= i)
                list.append(Animation::create());
            list.animation(i).setTimingFunction(parentList->animation(i).timingFunction());
            list.animation(i).setAnimationMode(parentList->animation(i).animationMode());
        }

        /* Reset any remaining animations to not have the property set. */
        for ( ; i < list.size(); ++i)
            list.animation(i).clearTimingFunction();
    }
    static void applyValueWebkitTransitionTimingFunction(StyleResolver& styleResolver, CSSValue& value)
    {
        AnimationList& list = styleResolver.style()->ensureTransitions();
        size_t childIndex = 0;
        if (is<CSSValueList>(value)) {
            /* Walk each value and put it into an animation, creating new animations as needed. */
            for (auto& currentValue : downcast<CSSValueList>(value)) {
                if (childIndex <= list.size())
                    list.append(Animation::create());
                styleResolver.styleMap()->mapAnimationTimingFunction(list.animation(childIndex), currentValue);
                ++childIndex;
            }
        } else {
            if (list.isEmpty())
                list.append(Animation::create());
            styleResolver.styleMap()->mapAnimationTimingFunction(list.animation(childIndex), value);
            childIndex = 1;
        }
        for ( ; childIndex < list.size(); ++childIndex) {
            /* Reset all remaining animations to not have the property set. */
            list.animation(childIndex).clearTimingFunction();
        }
    }
    static void applyInitialWebkitUserDrag(StyleResolver& styleResolver)
    {
        styleResolver.style()->setUserDrag(RenderStyle::initialUserDrag());
    }
    static void applyInheritWebkitUserDrag(StyleResolver& styleResolver)
    {
        styleResolver.style()->setUserDrag(styleResolver.parentStyle()->userDrag());
    }
    static void applyValueWebkitUserDrag(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setUserDrag(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitUserModify(StyleResolver& styleResolver)
    {
        styleResolver.style()->setUserModify(RenderStyle::initialUserModify());
    }
    static void applyInheritWebkitUserModify(StyleResolver& styleResolver)
    {
        styleResolver.style()->setUserModify(styleResolver.parentStyle()->userModify());
    }
    static void applyValueWebkitUserModify(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setUserModify(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitUserSelect(StyleResolver& styleResolver)
    {
        styleResolver.style()->setUserSelect(RenderStyle::initialUserSelect());
    }
    static void applyInheritWebkitUserSelect(StyleResolver& styleResolver)
    {
        styleResolver.style()->setUserSelect(styleResolver.parentStyle()->userSelect());
    }
    static void applyValueWebkitUserSelect(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setUserSelect(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitFlowInto(StyleResolver& styleResolver)
    {
        styleResolver.style()->setFlowThread(RenderStyle::initialFlowThread());
    }
    static void applyInheritWebkitFlowInto(StyleResolver& styleResolver)
    {
        styleResolver.style()->setFlowThread(styleResolver.parentStyle()->flowThread());
    }
    static void applyValueWebkitFlowInto(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setFlowThread(StyleBuilderConverter::convertStringOrNone(styleResolver, value));
    }
    static void applyInitialWebkitFlowFrom(StyleResolver& styleResolver)
    {
        styleResolver.style()->setRegionThread(RenderStyle::initialRegionThread());
    }
    static void applyInheritWebkitFlowFrom(StyleResolver& styleResolver)
    {
        styleResolver.style()->setRegionThread(styleResolver.parentStyle()->regionThread());
    }
    static void applyValueWebkitFlowFrom(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setRegionThread(StyleBuilderConverter::convertStringOrNone(styleResolver, value));
    }
    static void applyInitialWebkitRegionFragment(StyleResolver& styleResolver)
    {
        styleResolver.style()->setRegionFragment(RenderStyle::initialRegionFragment());
    }
    static void applyInheritWebkitRegionFragment(StyleResolver& styleResolver)
    {
        styleResolver.style()->setRegionFragment(styleResolver.parentStyle()->regionFragment());
    }
    static void applyValueWebkitRegionFragment(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setRegionFragment(downcast<CSSPrimitiveValue>(value));
    }
    static void applyInitialWebkitRegionBreakAfter(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakAfter(RenderStyle::initialBreakBetween());
    }
    static void applyInheritWebkitRegionBreakAfter(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakAfter(styleResolver.parentStyle()->breakAfter());
    }
    static void applyValueWebkitRegionBreakAfter(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBreakAfter(StyleBuilderConverter::convertRegionBreakBetween(styleResolver, value));
    }
    static void applyInitialWebkitRegionBreakBefore(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakBefore(RenderStyle::initialBreakBetween());
    }
    static void applyInheritWebkitRegionBreakBefore(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakBefore(styleResolver.parentStyle()->breakBefore());
    }
    static void applyValueWebkitRegionBreakBefore(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBreakBefore(StyleBuilderConverter::convertRegionBreakBetween(styleResolver, value));
    }
    static void applyInitialWebkitRegionBreakInside(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakInside(RenderStyle::initialBreakInside());
    }
    static void applyInheritWebkitRegionBreakInside(StyleResolver& styleResolver)
    {
        styleResolver.style()->setBreakInside(styleResolver.parentStyle()->breakInside());
    }
    static void applyValueWebkitRegionBreakInside(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setBreakInside(StyleBuilderConverter::convertRegionBreakInside(styleResolver, value));
    }
    static void applyInitialWebkitShapeOutside(StyleResolver& styleResolver)
    {
        styleResolver.style()->setShapeOutside(RenderStyle::initialShapeOutside());
    }
    static void applyInheritWebkitShapeOutside(StyleResolver& styleResolver)
    {
        styleResolver.style()->setShapeOutside(styleResolver.parentStyle()->shapeOutside());
    }
    static void applyValueWebkitShapeOutside(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setShapeOutside(StyleBuilderConverter::convertShapeValue(styleResolver, value));
    }
    static void applyInitialWebkitShapeMargin(StyleResolver& styleResolver)
    {
        styleResolver.style()->setShapeMargin(RenderStyle::initialShapeMargin());
    }
    static void applyInheritWebkitShapeMargin(StyleResolver& styleResolver)
    {
        styleResolver.style()->setShapeMargin(styleResolver.parentStyle()->shapeMargin());
    }
    static void applyValueWebkitShapeMargin(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setShapeMargin(StyleBuilderConverter::convertLength(styleResolver, value));
    }
    static void applyInitialWebkitShapeImageThreshold(StyleResolver& styleResolver)
    {
        styleResolver.style()->setShapeImageThreshold(RenderStyle::initialShapeImageThreshold());
    }
    static void applyInheritWebkitShapeImageThreshold(StyleResolver& styleResolver)
    {
        styleResolver.style()->setShapeImageThreshold(styleResolver.parentStyle()->shapeImageThreshold());
    }
    static void applyValueWebkitShapeImageThreshold(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setShapeImageThreshold(StyleBuilderConverter::convertNumberOrAuto<float>(styleResolver, value));
    }
    static void applyInitialWebkitTapHighlightColor(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTapHighlightColor(RenderStyle::initialTapHighlightColor());
    }
    static void applyInheritWebkitTapHighlightColor(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTapHighlightColor(styleResolver.parentStyle()->tapHighlightColor());
    }
    static void applyValueWebkitTapHighlightColor(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setTapHighlightColor(StyleBuilderConverter::convertTapHighlightColor(styleResolver, value));
    }
    static void applyInitialTouchAction(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTouchAction(RenderStyle::initialTouchAction());
    }
    static void applyInheritTouchAction(StyleResolver& styleResolver)
    {
        styleResolver.style()->setTouchAction(styleResolver.parentStyle()->touchAction());
    }
    static void applyValueTouchAction(StyleResolver& styleResolver, CSSValue& value)
    {
        styleResolver.style()->setTouchAction(downcast<CSSPrimitiveValue>(value));
    }
};

void StyleBuilder::applyProperty(CSSPropertyID property, StyleResolver& styleResolver, CSSValue& value, bool isInitial, bool isInherit)
{
    switch (property) {
    case CSSPropertyInvalid:
    case CSSPropertyCustom:
        break;
    case CSSPropertyColor:
        if (isInitial)
            StyleBuilderFunctions::applyInitialColor(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritColor(styleResolver);
        else
            StyleBuilderFunctions::applyValueColor(styleResolver, value);
        break;
    case CSSPropertyDirection:
        if (isInitial)
            StyleBuilderFunctions::applyInitialDirection(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritDirection(styleResolver);
        else
            StyleBuilderCustom::applyValueDirection(styleResolver, value);
        break;
    case CSSPropertyDisplay:
        if (isInitial)
            StyleBuilderFunctions::applyInitialDisplay(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritDisplay(styleResolver);
        else
            StyleBuilderCustom::applyValueDisplay(styleResolver, value);
        break;
    case CSSPropertyFontFamily:
        if (isInitial)
            StyleBuilderCustom::applyInitialFontFamily(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritFontFamily(styleResolver);
        else
            StyleBuilderCustom::applyValueFontFamily(styleResolver, value);
        break;
    case CSSPropertyFontSize:
        if (isInitial)
            StyleBuilderCustom::applyInitialFontSize(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritFontSize(styleResolver);
        else
            StyleBuilderCustom::applyValueFontSize(styleResolver, value);
        break;
    case CSSPropertyFontStyle:
        if (isInitial)
            StyleBuilderFunctions::applyInitialFontStyle(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritFontStyle(styleResolver);
        else
            StyleBuilderFunctions::applyValueFontStyle(styleResolver, value);
        break;
    case CSSPropertyFontWeight:
        if (isInitial)
            StyleBuilderCustom::applyInitialFontWeight(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritFontWeight(styleResolver);
        else
            StyleBuilderCustom::applyValueFontWeight(styleResolver, value);
        break;
    case CSSPropertyTextRendering:
        if (isInitial)
            StyleBuilderFunctions::applyInitialTextRendering(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritTextRendering(styleResolver);
        else
            StyleBuilderFunctions::applyValueTextRendering(styleResolver, value);
        break;
    case CSSPropertyFontFeatureSettings:
        if (isInitial)
            StyleBuilderCustom::applyInitialFontFeatureSettings(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritFontFeatureSettings(styleResolver);
        else
            StyleBuilderFunctions::applyValueFontFeatureSettings(styleResolver, value);
        break;
    case CSSPropertyWebkitFontKerning:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitFontKerning(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitFontKerning(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitFontKerning(styleResolver, value);
        break;
    case CSSPropertyWebkitFontSmoothing:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitFontSmoothing(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitFontSmoothing(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitFontSmoothing(styleResolver, value);
        break;
    case CSSPropertyFontVariantLigatures:
        if (isInitial)
            StyleBuilderCustom::applyInitialFontVariantLigatures(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritFontVariantLigatures(styleResolver);
        else
            StyleBuilderCustom::applyValueFontVariantLigatures(styleResolver, value);
        break;
    case CSSPropertyFontVariantPosition:
        if (isInitial)
            StyleBuilderFunctions::applyInitialFontVariantPosition(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritFontVariantPosition(styleResolver);
        else
            StyleBuilderFunctions::applyValueFontVariantPosition(styleResolver, value);
        break;
    case CSSPropertyFontVariantCaps:
        if (isInitial)
            StyleBuilderFunctions::applyInitialFontVariantCaps(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritFontVariantCaps(styleResolver);
        else
            StyleBuilderFunctions::applyValueFontVariantCaps(styleResolver, value);
        break;
    case CSSPropertyFontVariantNumeric:
        if (isInitial)
            StyleBuilderCustom::applyInitialFontVariantNumeric(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritFontVariantNumeric(styleResolver);
        else
            StyleBuilderCustom::applyValueFontVariantNumeric(styleResolver, value);
        break;
    case CSSPropertyFontVariantAlternates:
        if (isInitial)
            StyleBuilderFunctions::applyInitialFontVariantAlternates(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritFontVariantAlternates(styleResolver);
        else
            StyleBuilderFunctions::applyValueFontVariantAlternates(styleResolver, value);
        break;
    case CSSPropertyFontVariantEastAsian:
        if (isInitial)
            StyleBuilderCustom::applyInitialFontVariantEastAsian(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritFontVariantEastAsian(styleResolver);
        else
            StyleBuilderCustom::applyValueFontVariantEastAsian(styleResolver, value);
        break;
    case CSSPropertyWebkitLocale:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitLocale(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitLocale(styleResolver);
        else
            StyleBuilderCustom::applyValueWebkitLocale(styleResolver, value);
        break;
    case CSSPropertyWebkitTextOrientation:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitTextOrientation(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitTextOrientation(styleResolver);
        else
            StyleBuilderCustom::applyValueWebkitTextOrientation(styleResolver, value);
        break;
    case CSSPropertyWebkitWritingMode:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitWritingMode(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitWritingMode(styleResolver);
        else
            StyleBuilderCustom::applyValueWebkitWritingMode(styleResolver, value);
        break;
    case CSSPropertyWebkitTextZoom:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitTextZoom(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitTextZoom(styleResolver);
        else
            StyleBuilderCustom::applyValueWebkitTextZoom(styleResolver, value);
        break;
    case CSSPropertyZoom:
        if (isInitial)
            StyleBuilderCustom::applyInitialZoom(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritZoom(styleResolver);
        else
            StyleBuilderCustom::applyValueZoom(styleResolver, value);
        break;
    case CSSPropertyFontSynthesis:
        if (isInitial)
            StyleBuilderFunctions::applyInitialFontSynthesis(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritFontSynthesis(styleResolver);
        else
            StyleBuilderFunctions::applyValueFontSynthesis(styleResolver, value);
        break;
    case CSSPropertyWebkitRubyPosition:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitRubyPosition(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitRubyPosition(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitRubyPosition(styleResolver, value);
        break;
    case CSSPropertyAlignmentBaseline:
        if (isInitial)
            StyleBuilderFunctions::applyInitialAlignmentBaseline(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritAlignmentBaseline(styleResolver);
        else
            StyleBuilderFunctions::applyValueAlignmentBaseline(styleResolver, value);
        break;
    case CSSPropertyAll:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyAnimation:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyAnimationDelay:
        if (isInitial)
            StyleBuilderFunctions::applyInitialAnimationDelay(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritAnimationDelay(styleResolver);
        else
            StyleBuilderFunctions::applyValueAnimationDelay(styleResolver, value);
        break;
    case CSSPropertyAnimationDirection:
        if (isInitial)
            StyleBuilderFunctions::applyInitialAnimationDirection(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritAnimationDirection(styleResolver);
        else
            StyleBuilderFunctions::applyValueAnimationDirection(styleResolver, value);
        break;
    case CSSPropertyAnimationDuration:
        if (isInitial)
            StyleBuilderFunctions::applyInitialAnimationDuration(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritAnimationDuration(styleResolver);
        else
            StyleBuilderFunctions::applyValueAnimationDuration(styleResolver, value);
        break;
    case CSSPropertyAnimationFillMode:
        if (isInitial)
            StyleBuilderFunctions::applyInitialAnimationFillMode(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritAnimationFillMode(styleResolver);
        else
            StyleBuilderFunctions::applyValueAnimationFillMode(styleResolver, value);
        break;
    case CSSPropertyAnimationIterationCount:
        if (isInitial)
            StyleBuilderFunctions::applyInitialAnimationIterationCount(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritAnimationIterationCount(styleResolver);
        else
            StyleBuilderFunctions::applyValueAnimationIterationCount(styleResolver, value);
        break;
    case CSSPropertyAnimationName:
        if (isInitial)
            StyleBuilderFunctions::applyInitialAnimationName(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritAnimationName(styleResolver);
        else
            StyleBuilderFunctions::applyValueAnimationName(styleResolver, value);
        break;
    case CSSPropertyAnimationPlayState:
        if (isInitial)
            StyleBuilderFunctions::applyInitialAnimationPlayState(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritAnimationPlayState(styleResolver);
        else
            StyleBuilderFunctions::applyValueAnimationPlayState(styleResolver, value);
        break;
    case CSSPropertyAnimationTimingFunction:
        if (isInitial)
            StyleBuilderFunctions::applyInitialAnimationTimingFunction(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritAnimationTimingFunction(styleResolver);
        else
            StyleBuilderFunctions::applyValueAnimationTimingFunction(styleResolver, value);
        break;
    case CSSPropertyBackground:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBackgroundAttachment:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBackgroundAttachment(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBackgroundAttachment(styleResolver);
        else
            StyleBuilderFunctions::applyValueBackgroundAttachment(styleResolver, value);
        break;
    case CSSPropertyBackgroundBlendMode:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBackgroundBlendMode(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBackgroundBlendMode(styleResolver);
        else
            StyleBuilderFunctions::applyValueBackgroundBlendMode(styleResolver, value);
        break;
    case CSSPropertyBackgroundClip:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBackgroundClip(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBackgroundClip(styleResolver);
        else
            StyleBuilderFunctions::applyValueBackgroundClip(styleResolver, value);
        break;
    case CSSPropertyBackgroundColor:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBackgroundColor(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBackgroundColor(styleResolver);
        else
            StyleBuilderFunctions::applyValueBackgroundColor(styleResolver, value);
        break;
    case CSSPropertyBackgroundImage:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBackgroundImage(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBackgroundImage(styleResolver);
        else
            StyleBuilderFunctions::applyValueBackgroundImage(styleResolver, value);
        break;
    case CSSPropertyBackgroundOrigin:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBackgroundOrigin(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBackgroundOrigin(styleResolver);
        else
            StyleBuilderFunctions::applyValueBackgroundOrigin(styleResolver, value);
        break;
    case CSSPropertyBackgroundPosition:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBackgroundPositionX:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBackgroundPositionX(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBackgroundPositionX(styleResolver);
        else
            StyleBuilderFunctions::applyValueBackgroundPositionX(styleResolver, value);
        break;
    case CSSPropertyBackgroundPositionY:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBackgroundPositionY(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBackgroundPositionY(styleResolver);
        else
            StyleBuilderFunctions::applyValueBackgroundPositionY(styleResolver, value);
        break;
    case CSSPropertyBackgroundRepeat:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBackgroundRepeatX:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBackgroundRepeatX(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBackgroundRepeatX(styleResolver);
        else
            StyleBuilderFunctions::applyValueBackgroundRepeatX(styleResolver, value);
        break;
    case CSSPropertyBackgroundRepeatY:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBackgroundRepeatY(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBackgroundRepeatY(styleResolver);
        else
            StyleBuilderFunctions::applyValueBackgroundRepeatY(styleResolver, value);
        break;
    case CSSPropertyBackgroundSize:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBackgroundSize(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBackgroundSize(styleResolver);
        else
            StyleBuilderFunctions::applyValueBackgroundSize(styleResolver, value);
        break;
    case CSSPropertyBaselineShift:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBaselineShift(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBaselineShift(styleResolver);
        else
            StyleBuilderCustom::applyValueBaselineShift(styleResolver, value);
        break;
    case CSSPropertyBorder:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderBottom:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderBottomColor:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBorderBottomColor(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBorderBottomColor(styleResolver);
        else
            StyleBuilderFunctions::applyValueBorderBottomColor(styleResolver, value);
        break;
    case CSSPropertyBorderBottomLeftRadius:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBorderBottomLeftRadius(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBorderBottomLeftRadius(styleResolver);
        else
            StyleBuilderFunctions::applyValueBorderBottomLeftRadius(styleResolver, value);
        break;
    case CSSPropertyBorderBottomRightRadius:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBorderBottomRightRadius(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBorderBottomRightRadius(styleResolver);
        else
            StyleBuilderFunctions::applyValueBorderBottomRightRadius(styleResolver, value);
        break;
    case CSSPropertyBorderBottomStyle:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBorderBottomStyle(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBorderBottomStyle(styleResolver);
        else
            StyleBuilderFunctions::applyValueBorderBottomStyle(styleResolver, value);
        break;
    case CSSPropertyBorderBottomWidth:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBorderBottomWidth(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBorderBottomWidth(styleResolver);
        else
            StyleBuilderFunctions::applyValueBorderBottomWidth(styleResolver, value);
        break;
    case CSSPropertyBorderCollapse:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBorderCollapse(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBorderCollapse(styleResolver);
        else
            StyleBuilderFunctions::applyValueBorderCollapse(styleResolver, value);
        break;
    case CSSPropertyBorderColor:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderImage:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderImageOutset:
        if (isInitial)
            StyleBuilderCustom::applyInitialBorderImageOutset(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritBorderImageOutset(styleResolver);
        else
            StyleBuilderCustom::applyValueBorderImageOutset(styleResolver, value);
        break;
    case CSSPropertyBorderImageRepeat:
        if (isInitial)
            StyleBuilderCustom::applyInitialBorderImageRepeat(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritBorderImageRepeat(styleResolver);
        else
            StyleBuilderCustom::applyValueBorderImageRepeat(styleResolver, value);
        break;
    case CSSPropertyBorderImageSlice:
        if (isInitial)
            StyleBuilderCustom::applyInitialBorderImageSlice(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritBorderImageSlice(styleResolver);
        else
            StyleBuilderCustom::applyValueBorderImageSlice(styleResolver, value);
        break;
    case CSSPropertyBorderImageSource:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBorderImageSource(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBorderImageSource(styleResolver);
        else
            StyleBuilderFunctions::applyValueBorderImageSource(styleResolver, value);
        break;
    case CSSPropertyBorderImageWidth:
        if (isInitial)
            StyleBuilderCustom::applyInitialBorderImageWidth(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritBorderImageWidth(styleResolver);
        else
            StyleBuilderCustom::applyValueBorderImageWidth(styleResolver, value);
        break;
    case CSSPropertyBorderLeft:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderLeftColor:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBorderLeftColor(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBorderLeftColor(styleResolver);
        else
            StyleBuilderFunctions::applyValueBorderLeftColor(styleResolver, value);
        break;
    case CSSPropertyBorderLeftStyle:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBorderLeftStyle(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBorderLeftStyle(styleResolver);
        else
            StyleBuilderFunctions::applyValueBorderLeftStyle(styleResolver, value);
        break;
    case CSSPropertyBorderLeftWidth:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBorderLeftWidth(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBorderLeftWidth(styleResolver);
        else
            StyleBuilderFunctions::applyValueBorderLeftWidth(styleResolver, value);
        break;
    case CSSPropertyBorderRadius:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderRight:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderRightColor:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBorderRightColor(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBorderRightColor(styleResolver);
        else
            StyleBuilderFunctions::applyValueBorderRightColor(styleResolver, value);
        break;
    case CSSPropertyBorderRightStyle:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBorderRightStyle(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBorderRightStyle(styleResolver);
        else
            StyleBuilderFunctions::applyValueBorderRightStyle(styleResolver, value);
        break;
    case CSSPropertyBorderRightWidth:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBorderRightWidth(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBorderRightWidth(styleResolver);
        else
            StyleBuilderFunctions::applyValueBorderRightWidth(styleResolver, value);
        break;
    case CSSPropertyBorderSpacing:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderStyle:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderTop:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBorderTopColor:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBorderTopColor(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBorderTopColor(styleResolver);
        else
            StyleBuilderFunctions::applyValueBorderTopColor(styleResolver, value);
        break;
    case CSSPropertyBorderTopLeftRadius:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBorderTopLeftRadius(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBorderTopLeftRadius(styleResolver);
        else
            StyleBuilderFunctions::applyValueBorderTopLeftRadius(styleResolver, value);
        break;
    case CSSPropertyBorderTopRightRadius:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBorderTopRightRadius(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBorderTopRightRadius(styleResolver);
        else
            StyleBuilderFunctions::applyValueBorderTopRightRadius(styleResolver, value);
        break;
    case CSSPropertyBorderTopStyle:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBorderTopStyle(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBorderTopStyle(styleResolver);
        else
            StyleBuilderFunctions::applyValueBorderTopStyle(styleResolver, value);
        break;
    case CSSPropertyBorderTopWidth:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBorderTopWidth(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBorderTopWidth(styleResolver);
        else
            StyleBuilderFunctions::applyValueBorderTopWidth(styleResolver, value);
        break;
    case CSSPropertyBorderWidth:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyBottom:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBottom(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBottom(styleResolver);
        else
            StyleBuilderFunctions::applyValueBottom(styleResolver, value);
        break;
    case CSSPropertyBoxShadow:
        if (isInitial)
            StyleBuilderCustom::applyInitialBoxShadow(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritBoxShadow(styleResolver);
        else
            StyleBuilderCustom::applyValueBoxShadow(styleResolver, value);
        break;
    case CSSPropertyBoxSizing:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBoxSizing(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBoxSizing(styleResolver);
        else
            StyleBuilderFunctions::applyValueBoxSizing(styleResolver, value);
        break;
    case CSSPropertyBreakAfter:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBreakAfter(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBreakAfter(styleResolver);
        else
            StyleBuilderFunctions::applyValueBreakAfter(styleResolver, value);
        break;
    case CSSPropertyBreakBefore:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBreakBefore(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBreakBefore(styleResolver);
        else
            StyleBuilderFunctions::applyValueBreakBefore(styleResolver, value);
        break;
    case CSSPropertyBreakInside:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBreakInside(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBreakInside(styleResolver);
        else
            StyleBuilderFunctions::applyValueBreakInside(styleResolver, value);
        break;
    case CSSPropertyBufferedRendering:
        if (isInitial)
            StyleBuilderFunctions::applyInitialBufferedRendering(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritBufferedRendering(styleResolver);
        else
            StyleBuilderFunctions::applyValueBufferedRendering(styleResolver, value);
        break;
    case CSSPropertyCaptionSide:
        if (isInitial)
            StyleBuilderFunctions::applyInitialCaptionSide(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritCaptionSide(styleResolver);
        else
            StyleBuilderFunctions::applyValueCaptionSide(styleResolver, value);
        break;
    case CSSPropertyClear:
        if (isInitial)
            StyleBuilderFunctions::applyInitialClear(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritClear(styleResolver);
        else
            StyleBuilderFunctions::applyValueClear(styleResolver, value);
        break;
    case CSSPropertyClip:
        if (isInitial)
            StyleBuilderCustom::applyInitialClip(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritClip(styleResolver);
        else
            StyleBuilderCustom::applyValueClip(styleResolver, value);
        break;
    case CSSPropertyWebkitClipPath:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitClipPath(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitClipPath(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitClipPath(styleResolver, value);
        break;
    case CSSPropertyClipPath:
        if (isInitial)
            StyleBuilderFunctions::applyInitialClipPath(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritClipPath(styleResolver);
        else
            StyleBuilderFunctions::applyValueClipPath(styleResolver, value);
        break;
    case CSSPropertyClipRule:
        if (isInitial)
            StyleBuilderFunctions::applyInitialClipRule(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritClipRule(styleResolver);
        else
            StyleBuilderFunctions::applyValueClipRule(styleResolver, value);
        break;
    case CSSPropertyColorInterpolation:
        if (isInitial)
            StyleBuilderFunctions::applyInitialColorInterpolation(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritColorInterpolation(styleResolver);
        else
            StyleBuilderFunctions::applyValueColorInterpolation(styleResolver, value);
        break;
    case CSSPropertyColorInterpolationFilters:
        if (isInitial)
            StyleBuilderFunctions::applyInitialColorInterpolationFilters(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritColorInterpolationFilters(styleResolver);
        else
            StyleBuilderFunctions::applyValueColorInterpolationFilters(styleResolver, value);
        break;
    case CSSPropertyColorProfile:
        break;
    case CSSPropertyColorRendering:
        if (isInitial)
            StyleBuilderFunctions::applyInitialColorRendering(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritColorRendering(styleResolver);
        else
            StyleBuilderFunctions::applyValueColorRendering(styleResolver, value);
        break;
    case CSSPropertyContent:
        if (isInitial)
            StyleBuilderCustom::applyInitialContent(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritContent(styleResolver);
        else
            StyleBuilderCustom::applyValueContent(styleResolver, value);
        break;
    case CSSPropertyCounterIncrement:
        if (isInitial)
            StyleBuilderCustom::applyInitialCounterIncrement(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritCounterIncrement(styleResolver);
        else
            StyleBuilderCustom::applyValueCounterIncrement(styleResolver, value);
        break;
    case CSSPropertyCounterReset:
        if (isInitial)
            StyleBuilderCustom::applyInitialCounterReset(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritCounterReset(styleResolver);
        else
            StyleBuilderCustom::applyValueCounterReset(styleResolver, value);
        break;
    case CSSPropertyCursor:
        if (isInitial)
            StyleBuilderCustom::applyInitialCursor(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritCursor(styleResolver);
        else
            StyleBuilderCustom::applyValueCursor(styleResolver, value);
        break;
    case CSSPropertyCx:
        if (isInitial)
            StyleBuilderFunctions::applyInitialCx(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritCx(styleResolver);
        else
            StyleBuilderFunctions::applyValueCx(styleResolver, value);
        break;
    case CSSPropertyCy:
        if (isInitial)
            StyleBuilderFunctions::applyInitialCy(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritCy(styleResolver);
        else
            StyleBuilderFunctions::applyValueCy(styleResolver, value);
        break;
    case CSSPropertyDominantBaseline:
        if (isInitial)
            StyleBuilderFunctions::applyInitialDominantBaseline(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritDominantBaseline(styleResolver);
        else
            StyleBuilderFunctions::applyValueDominantBaseline(styleResolver, value);
        break;
    case CSSPropertyEmptyCells:
        if (isInitial)
            StyleBuilderFunctions::applyInitialEmptyCells(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritEmptyCells(styleResolver);
        else
            StyleBuilderFunctions::applyValueEmptyCells(styleResolver, value);
        break;
    case CSSPropertyEnableBackground:
        break;
    case CSSPropertyFill:
        if (isInitial)
            StyleBuilderCustom::applyInitialFill(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritFill(styleResolver);
        else
            StyleBuilderCustom::applyValueFill(styleResolver, value);
        break;
    case CSSPropertyFillOpacity:
        if (isInitial)
            StyleBuilderFunctions::applyInitialFillOpacity(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritFillOpacity(styleResolver);
        else
            StyleBuilderFunctions::applyValueFillOpacity(styleResolver, value);
        break;
    case CSSPropertyFillRule:
        if (isInitial)
            StyleBuilderFunctions::applyInitialFillRule(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritFillRule(styleResolver);
        else
            StyleBuilderFunctions::applyValueFillRule(styleResolver, value);
        break;
    case CSSPropertyFloat:
        if (isInitial)
            StyleBuilderFunctions::applyInitialFloat(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritFloat(styleResolver);
        else
            StyleBuilderFunctions::applyValueFloat(styleResolver, value);
        break;
    case CSSPropertyFloodColor:
        if (isInitial)
            StyleBuilderFunctions::applyInitialFloodColor(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritFloodColor(styleResolver);
        else
            StyleBuilderFunctions::applyValueFloodColor(styleResolver, value);
        break;
    case CSSPropertyFloodOpacity:
        if (isInitial)
            StyleBuilderFunctions::applyInitialFloodOpacity(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritFloodOpacity(styleResolver);
        else
            StyleBuilderFunctions::applyValueFloodOpacity(styleResolver, value);
        break;
    case CSSPropertyFont:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyFontVariant:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyFontStretch:
        break;
    case CSSPropertyGlyphOrientationHorizontal:
        if (isInitial)
            StyleBuilderFunctions::applyInitialGlyphOrientationHorizontal(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritGlyphOrientationHorizontal(styleResolver);
        else
            StyleBuilderFunctions::applyValueGlyphOrientationHorizontal(styleResolver, value);
        break;
    case CSSPropertyGlyphOrientationVertical:
        if (isInitial)
            StyleBuilderFunctions::applyInitialGlyphOrientationVertical(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritGlyphOrientationVertical(styleResolver);
        else
            StyleBuilderFunctions::applyValueGlyphOrientationVertical(styleResolver, value);
        break;
    case CSSPropertyHangingPunctuation:
        if (isInitial)
            StyleBuilderFunctions::applyInitialHangingPunctuation(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritHangingPunctuation(styleResolver);
        else
            StyleBuilderFunctions::applyValueHangingPunctuation(styleResolver, value);
        break;
    case CSSPropertyHeight:
        if (isInitial)
            StyleBuilderFunctions::applyInitialHeight(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritHeight(styleResolver);
        else
            StyleBuilderFunctions::applyValueHeight(styleResolver, value);
        break;
    case CSSPropertyImageRendering:
        if (isInitial)
            StyleBuilderFunctions::applyInitialImageRendering(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritImageRendering(styleResolver);
        else
            StyleBuilderFunctions::applyValueImageRendering(styleResolver, value);
        break;
    case CSSPropertyKerning:
        if (isInitial)
            StyleBuilderFunctions::applyInitialKerning(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritKerning(styleResolver);
        else
            StyleBuilderFunctions::applyValueKerning(styleResolver, value);
        break;
    case CSSPropertyLeft:
        if (isInitial)
            StyleBuilderFunctions::applyInitialLeft(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritLeft(styleResolver);
        else
            StyleBuilderFunctions::applyValueLeft(styleResolver, value);
        break;
    case CSSPropertyLetterSpacing:
        if (isInitial)
            StyleBuilderFunctions::applyInitialLetterSpacing(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritLetterSpacing(styleResolver);
        else
            StyleBuilderFunctions::applyValueLetterSpacing(styleResolver, value);
        break;
    case CSSPropertyLightingColor:
        if (isInitial)
            StyleBuilderFunctions::applyInitialLightingColor(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritLightingColor(styleResolver);
        else
            StyleBuilderFunctions::applyValueLightingColor(styleResolver, value);
        break;
    case CSSPropertyLineHeight:
        if (isInitial)
            StyleBuilderFunctions::applyInitialLineHeight(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritLineHeight(styleResolver);
        else
            StyleBuilderFunctions::applyValueLineHeight(styleResolver, value);
        break;
    case CSSPropertyListStyle:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyListStyleImage:
        if (isInitial)
            StyleBuilderFunctions::applyInitialListStyleImage(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritListStyleImage(styleResolver);
        else
            StyleBuilderFunctions::applyValueListStyleImage(styleResolver, value);
        break;
    case CSSPropertyListStylePosition:
        if (isInitial)
            StyleBuilderFunctions::applyInitialListStylePosition(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritListStylePosition(styleResolver);
        else
            StyleBuilderFunctions::applyValueListStylePosition(styleResolver, value);
        break;
    case CSSPropertyListStyleType:
        if (isInitial)
            StyleBuilderFunctions::applyInitialListStyleType(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritListStyleType(styleResolver);
        else
            StyleBuilderFunctions::applyValueListStyleType(styleResolver, value);
        break;
    case CSSPropertyMargin:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyMarginBottom:
        if (isInitial)
            StyleBuilderFunctions::applyInitialMarginBottom(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritMarginBottom(styleResolver);
        else
            StyleBuilderFunctions::applyValueMarginBottom(styleResolver, value);
        break;
    case CSSPropertyMarginLeft:
        if (isInitial)
            StyleBuilderFunctions::applyInitialMarginLeft(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritMarginLeft(styleResolver);
        else
            StyleBuilderFunctions::applyValueMarginLeft(styleResolver, value);
        break;
    case CSSPropertyMarginRight:
        if (isInitial)
            StyleBuilderFunctions::applyInitialMarginRight(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritMarginRight(styleResolver);
        else
            StyleBuilderFunctions::applyValueMarginRight(styleResolver, value);
        break;
    case CSSPropertyMarginTop:
        if (isInitial)
            StyleBuilderFunctions::applyInitialMarginTop(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritMarginTop(styleResolver);
        else
            StyleBuilderFunctions::applyValueMarginTop(styleResolver, value);
        break;
    case CSSPropertyMarker:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyMarkerEnd:
        if (isInitial)
            StyleBuilderFunctions::applyInitialMarkerEnd(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritMarkerEnd(styleResolver);
        else
            StyleBuilderFunctions::applyValueMarkerEnd(styleResolver, value);
        break;
    case CSSPropertyMarkerMid:
        if (isInitial)
            StyleBuilderFunctions::applyInitialMarkerMid(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritMarkerMid(styleResolver);
        else
            StyleBuilderFunctions::applyValueMarkerMid(styleResolver, value);
        break;
    case CSSPropertyMarkerStart:
        if (isInitial)
            StyleBuilderFunctions::applyInitialMarkerStart(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritMarkerStart(styleResolver);
        else
            StyleBuilderFunctions::applyValueMarkerStart(styleResolver, value);
        break;
    case CSSPropertyMask:
        if (isInitial)
            StyleBuilderFunctions::applyInitialMask(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritMask(styleResolver);
        else
            StyleBuilderFunctions::applyValueMask(styleResolver, value);
        break;
    case CSSPropertyMaskType:
        if (isInitial)
            StyleBuilderFunctions::applyInitialMaskType(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritMaskType(styleResolver);
        else
            StyleBuilderFunctions::applyValueMaskType(styleResolver, value);
        break;
    case CSSPropertyMaxHeight:
        if (isInitial)
            StyleBuilderFunctions::applyInitialMaxHeight(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritMaxHeight(styleResolver);
        else
            StyleBuilderFunctions::applyValueMaxHeight(styleResolver, value);
        break;
    case CSSPropertyMaxWidth:
        if (isInitial)
            StyleBuilderFunctions::applyInitialMaxWidth(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritMaxWidth(styleResolver);
        else
            StyleBuilderFunctions::applyValueMaxWidth(styleResolver, value);
        break;
    case CSSPropertyMinHeight:
        if (isInitial)
            StyleBuilderFunctions::applyInitialMinHeight(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritMinHeight(styleResolver);
        else
            StyleBuilderFunctions::applyValueMinHeight(styleResolver, value);
        break;
    case CSSPropertyMinWidth:
        if (isInitial)
            StyleBuilderFunctions::applyInitialMinWidth(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritMinWidth(styleResolver);
        else
            StyleBuilderFunctions::applyValueMinWidth(styleResolver, value);
        break;
    case CSSPropertyObjectFit:
        if (isInitial)
            StyleBuilderFunctions::applyInitialObjectFit(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritObjectFit(styleResolver);
        else
            StyleBuilderFunctions::applyValueObjectFit(styleResolver, value);
        break;
    case CSSPropertyObjectPosition:
        if (isInitial)
            StyleBuilderFunctions::applyInitialObjectPosition(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritObjectPosition(styleResolver);
        else
            StyleBuilderFunctions::applyValueObjectPosition(styleResolver, value);
        break;
    case CSSPropertyOpacity:
        if (isInitial)
            StyleBuilderFunctions::applyInitialOpacity(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritOpacity(styleResolver);
        else
            StyleBuilderFunctions::applyValueOpacity(styleResolver, value);
        break;
    case CSSPropertyOrphans:
        if (isInitial)
            StyleBuilderFunctions::applyInitialOrphans(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritOrphans(styleResolver);
        else
            StyleBuilderFunctions::applyValueOrphans(styleResolver, value);
        break;
    case CSSPropertyOutline:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyOutlineColor:
        if (isInitial)
            StyleBuilderFunctions::applyInitialOutlineColor(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritOutlineColor(styleResolver);
        else
            StyleBuilderFunctions::applyValueOutlineColor(styleResolver, value);
        break;
    case CSSPropertyOutlineOffset:
        if (isInitial)
            StyleBuilderFunctions::applyInitialOutlineOffset(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritOutlineOffset(styleResolver);
        else
            StyleBuilderFunctions::applyValueOutlineOffset(styleResolver, value);
        break;
    case CSSPropertyOutlineStyle:
        if (isInitial)
            StyleBuilderCustom::applyInitialOutlineStyle(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritOutlineStyle(styleResolver);
        else
            StyleBuilderCustom::applyValueOutlineStyle(styleResolver, value);
        break;
    case CSSPropertyOutlineWidth:
        if (isInitial)
            StyleBuilderFunctions::applyInitialOutlineWidth(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritOutlineWidth(styleResolver);
        else
            StyleBuilderFunctions::applyValueOutlineWidth(styleResolver, value);
        break;
    case CSSPropertyOverflow:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyOverflowWrap:
        if (isInitial)
            StyleBuilderFunctions::applyInitialOverflowWrap(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritOverflowWrap(styleResolver);
        else
            StyleBuilderFunctions::applyValueOverflowWrap(styleResolver, value);
        break;
    case CSSPropertyOverflowX:
        if (isInitial)
            StyleBuilderFunctions::applyInitialOverflowX(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritOverflowX(styleResolver);
        else
            StyleBuilderFunctions::applyValueOverflowX(styleResolver, value);
        break;
    case CSSPropertyOverflowY:
        if (isInitial)
            StyleBuilderFunctions::applyInitialOverflowY(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritOverflowY(styleResolver);
        else
            StyleBuilderFunctions::applyValueOverflowY(styleResolver, value);
        break;
    case CSSPropertyPadding:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyPaddingBottom:
        if (isInitial)
            StyleBuilderFunctions::applyInitialPaddingBottom(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritPaddingBottom(styleResolver);
        else
            StyleBuilderFunctions::applyValuePaddingBottom(styleResolver, value);
        break;
    case CSSPropertyPaddingLeft:
        if (isInitial)
            StyleBuilderFunctions::applyInitialPaddingLeft(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritPaddingLeft(styleResolver);
        else
            StyleBuilderFunctions::applyValuePaddingLeft(styleResolver, value);
        break;
    case CSSPropertyPaddingRight:
        if (isInitial)
            StyleBuilderFunctions::applyInitialPaddingRight(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritPaddingRight(styleResolver);
        else
            StyleBuilderFunctions::applyValuePaddingRight(styleResolver, value);
        break;
    case CSSPropertyPaddingTop:
        if (isInitial)
            StyleBuilderFunctions::applyInitialPaddingTop(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritPaddingTop(styleResolver);
        else
            StyleBuilderFunctions::applyValuePaddingTop(styleResolver, value);
        break;
    case CSSPropertyPage:
        break;
    case CSSPropertyPageBreakAfter:
        if (isInitial)
            StyleBuilderFunctions::applyInitialPageBreakAfter(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritPageBreakAfter(styleResolver);
        else
            StyleBuilderFunctions::applyValuePageBreakAfter(styleResolver, value);
        break;
    case CSSPropertyPageBreakBefore:
        if (isInitial)
            StyleBuilderFunctions::applyInitialPageBreakBefore(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritPageBreakBefore(styleResolver);
        else
            StyleBuilderFunctions::applyValuePageBreakBefore(styleResolver, value);
        break;
    case CSSPropertyPageBreakInside:
        if (isInitial)
            StyleBuilderFunctions::applyInitialPageBreakInside(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritPageBreakInside(styleResolver);
        else
            StyleBuilderFunctions::applyValuePageBreakInside(styleResolver, value);
        break;
    case CSSPropertyPaintOrder:
        if (isInitial)
            StyleBuilderFunctions::applyInitialPaintOrder(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritPaintOrder(styleResolver);
        else
            StyleBuilderFunctions::applyValuePaintOrder(styleResolver, value);
        break;
    case CSSPropertyPointerEvents:
        if (isInitial)
            StyleBuilderFunctions::applyInitialPointerEvents(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritPointerEvents(styleResolver);
        else
            StyleBuilderFunctions::applyValuePointerEvents(styleResolver, value);
        break;
    case CSSPropertyPosition:
        if (isInitial)
            StyleBuilderFunctions::applyInitialPosition(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritPosition(styleResolver);
        else
            StyleBuilderFunctions::applyValuePosition(styleResolver, value);
        break;
    case CSSPropertyQuotes:
        if (isInitial)
            StyleBuilderFunctions::applyInitialQuotes(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritQuotes(styleResolver);
        else
            StyleBuilderFunctions::applyValueQuotes(styleResolver, value);
        break;
    case CSSPropertyR:
        if (isInitial)
            StyleBuilderFunctions::applyInitialR(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritR(styleResolver);
        else
            StyleBuilderFunctions::applyValueR(styleResolver, value);
        break;
    case CSSPropertyResize:
        if (isInitial)
            StyleBuilderFunctions::applyInitialResize(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritResize(styleResolver);
        else
            StyleBuilderFunctions::applyValueResize(styleResolver, value);
        break;
    case CSSPropertyRight:
        if (isInitial)
            StyleBuilderFunctions::applyInitialRight(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritRight(styleResolver);
        else
            StyleBuilderFunctions::applyValueRight(styleResolver, value);
        break;
    case CSSPropertyRx:
        if (isInitial)
            StyleBuilderFunctions::applyInitialRx(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritRx(styleResolver);
        else
            StyleBuilderFunctions::applyValueRx(styleResolver, value);
        break;
    case CSSPropertyRy:
        if (isInitial)
            StyleBuilderFunctions::applyInitialRy(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritRy(styleResolver);
        else
            StyleBuilderFunctions::applyValueRy(styleResolver, value);
        break;
    case CSSPropertyShapeRendering:
        if (isInitial)
            StyleBuilderFunctions::applyInitialShapeRendering(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritShapeRendering(styleResolver);
        else
            StyleBuilderFunctions::applyValueShapeRendering(styleResolver, value);
        break;
    case CSSPropertySize:
        if (isInitial)
            StyleBuilderCustom::applyInitialSize(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritSize(styleResolver);
        else
            StyleBuilderCustom::applyValueSize(styleResolver, value);
        break;
    case CSSPropertySrc:
        break;
    case CSSPropertyStopColor:
        if (isInitial)
            StyleBuilderFunctions::applyInitialStopColor(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritStopColor(styleResolver);
        else
            StyleBuilderFunctions::applyValueStopColor(styleResolver, value);
        break;
    case CSSPropertyStopOpacity:
        if (isInitial)
            StyleBuilderFunctions::applyInitialStopOpacity(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritStopOpacity(styleResolver);
        else
            StyleBuilderFunctions::applyValueStopOpacity(styleResolver, value);
        break;
    case CSSPropertyStroke:
        if (isInitial)
            StyleBuilderCustom::applyInitialStroke(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritStroke(styleResolver);
        else
            StyleBuilderCustom::applyValueStroke(styleResolver, value);
        break;
    case CSSPropertyStrokeDasharray:
        if (isInitial)
            StyleBuilderFunctions::applyInitialStrokeDasharray(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritStrokeDasharray(styleResolver);
        else
            StyleBuilderFunctions::applyValueStrokeDasharray(styleResolver, value);
        break;
    case CSSPropertyStrokeDashoffset:
        if (isInitial)
            StyleBuilderFunctions::applyInitialStrokeDashoffset(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritStrokeDashoffset(styleResolver);
        else
            StyleBuilderFunctions::applyValueStrokeDashoffset(styleResolver, value);
        break;
    case CSSPropertyStrokeLinecap:
        if (isInitial)
            StyleBuilderFunctions::applyInitialStrokeLinecap(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritStrokeLinecap(styleResolver);
        else
            StyleBuilderFunctions::applyValueStrokeLinecap(styleResolver, value);
        break;
    case CSSPropertyStrokeLinejoin:
        if (isInitial)
            StyleBuilderFunctions::applyInitialStrokeLinejoin(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritStrokeLinejoin(styleResolver);
        else
            StyleBuilderFunctions::applyValueStrokeLinejoin(styleResolver, value);
        break;
    case CSSPropertyStrokeMiterlimit:
        if (isInitial)
            StyleBuilderFunctions::applyInitialStrokeMiterlimit(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritStrokeMiterlimit(styleResolver);
        else
            StyleBuilderFunctions::applyValueStrokeMiterlimit(styleResolver, value);
        break;
    case CSSPropertyStrokeOpacity:
        if (isInitial)
            StyleBuilderFunctions::applyInitialStrokeOpacity(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritStrokeOpacity(styleResolver);
        else
            StyleBuilderFunctions::applyValueStrokeOpacity(styleResolver, value);
        break;
    case CSSPropertyStrokeWidth:
        if (isInitial)
            StyleBuilderFunctions::applyInitialStrokeWidth(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritStrokeWidth(styleResolver);
        else
            StyleBuilderFunctions::applyValueStrokeWidth(styleResolver, value);
        break;
    case CSSPropertySpeak:
        if (isInitial)
            StyleBuilderFunctions::applyInitialSpeak(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritSpeak(styleResolver);
        else
            StyleBuilderFunctions::applyValueSpeak(styleResolver, value);
        break;
    case CSSPropertyTableLayout:
        if (isInitial)
            StyleBuilderFunctions::applyInitialTableLayout(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritTableLayout(styleResolver);
        else
            StyleBuilderFunctions::applyValueTableLayout(styleResolver, value);
        break;
    case CSSPropertyTabSize:
        if (isInitial)
            StyleBuilderFunctions::applyInitialTabSize(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritTabSize(styleResolver);
        else
            StyleBuilderFunctions::applyValueTabSize(styleResolver, value);
        break;
    case CSSPropertyTextAlign:
        if (isInitial)
            StyleBuilderFunctions::applyInitialTextAlign(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritTextAlign(styleResolver);
        else
            StyleBuilderFunctions::applyValueTextAlign(styleResolver, value);
        break;
    case CSSPropertyTextAnchor:
        if (isInitial)
            StyleBuilderFunctions::applyInitialTextAnchor(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritTextAnchor(styleResolver);
        else
            StyleBuilderFunctions::applyValueTextAnchor(styleResolver, value);
        break;
    case CSSPropertyTextDecoration:
        if (isInitial)
            StyleBuilderFunctions::applyInitialTextDecoration(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritTextDecoration(styleResolver);
        else
            StyleBuilderFunctions::applyValueTextDecoration(styleResolver, value);
        break;
    case CSSPropertyTextIndent:
        if (isInitial)
            StyleBuilderCustom::applyInitialTextIndent(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritTextIndent(styleResolver);
        else
            StyleBuilderCustom::applyValueTextIndent(styleResolver, value);
        break;
    case CSSPropertyTextLineThrough:
        break;
    case CSSPropertyTextLineThroughColor:
        break;
    case CSSPropertyTextLineThroughMode:
        break;
    case CSSPropertyTextLineThroughStyle:
        break;
    case CSSPropertyTextLineThroughWidth:
        break;
    case CSSPropertyTextOverflow:
        if (isInitial)
            StyleBuilderFunctions::applyInitialTextOverflow(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritTextOverflow(styleResolver);
        else
            StyleBuilderFunctions::applyValueTextOverflow(styleResolver, value);
        break;
    case CSSPropertyTextOverline:
        break;
    case CSSPropertyTextOverlineColor:
        break;
    case CSSPropertyTextOverlineMode:
        break;
    case CSSPropertyTextOverlineStyle:
        break;
    case CSSPropertyTextOverlineWidth:
        break;
    case CSSPropertyTextShadow:
        if (isInitial)
            StyleBuilderCustom::applyInitialTextShadow(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritTextShadow(styleResolver);
        else
            StyleBuilderCustom::applyValueTextShadow(styleResolver, value);
        break;
    case CSSPropertyTextTransform:
        if (isInitial)
            StyleBuilderFunctions::applyInitialTextTransform(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritTextTransform(styleResolver);
        else
            StyleBuilderFunctions::applyValueTextTransform(styleResolver, value);
        break;
    case CSSPropertyTextUnderline:
        break;
    case CSSPropertyTextUnderlineColor:
        break;
    case CSSPropertyTextUnderlineMode:
        break;
    case CSSPropertyTextUnderlineStyle:
        break;
    case CSSPropertyTextUnderlineWidth:
        break;
    case CSSPropertyTop:
        if (isInitial)
            StyleBuilderFunctions::applyInitialTop(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritTop(styleResolver);
        else
            StyleBuilderFunctions::applyValueTop(styleResolver, value);
        break;
    case CSSPropertyTransition:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyTransitionDelay:
        break;
    case CSSPropertyTransitionDuration:
        break;
    case CSSPropertyTransitionProperty:
        break;
    case CSSPropertyTransitionTimingFunction:
        break;
    case CSSPropertyUnicodeBidi:
        if (isInitial)
            StyleBuilderFunctions::applyInitialUnicodeBidi(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritUnicodeBidi(styleResolver);
        else
            StyleBuilderFunctions::applyValueUnicodeBidi(styleResolver, value);
        break;
    case CSSPropertyUnicodeRange:
        break;
    case CSSPropertyVectorEffect:
        if (isInitial)
            StyleBuilderFunctions::applyInitialVectorEffect(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritVectorEffect(styleResolver);
        else
            StyleBuilderFunctions::applyValueVectorEffect(styleResolver, value);
        break;
    case CSSPropertyVerticalAlign:
        if (isInitial)
            StyleBuilderFunctions::applyInitialVerticalAlign(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritVerticalAlign(styleResolver);
        else
            StyleBuilderCustom::applyValueVerticalAlign(styleResolver, value);
        break;
    case CSSPropertyVisibility:
        if (isInitial)
            StyleBuilderFunctions::applyInitialVisibility(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritVisibility(styleResolver);
        else
            StyleBuilderFunctions::applyValueVisibility(styleResolver, value);
        break;
    case CSSPropertyWhiteSpace:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWhiteSpace(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWhiteSpace(styleResolver);
        else
            StyleBuilderFunctions::applyValueWhiteSpace(styleResolver, value);
        break;
    case CSSPropertyWidows:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWidows(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWidows(styleResolver);
        else
            StyleBuilderFunctions::applyValueWidows(styleResolver, value);
        break;
    case CSSPropertyWidth:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWidth(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWidth(styleResolver);
        else
            StyleBuilderFunctions::applyValueWidth(styleResolver, value);
        break;
    case CSSPropertyWillChange:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWillChange(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWillChange(styleResolver);
        else
            StyleBuilderCustom::applyValueWillChange(styleResolver, value);
        break;
    case CSSPropertyWordBreak:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWordBreak(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWordBreak(styleResolver);
        else
            StyleBuilderFunctions::applyValueWordBreak(styleResolver, value);
        break;
    case CSSPropertyWordSpacing:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWordSpacing(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWordSpacing(styleResolver);
        else
            StyleBuilderFunctions::applyValueWordSpacing(styleResolver, value);
        break;
    case CSSPropertyWordWrap:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWordWrap(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWordWrap(styleResolver);
        else
            StyleBuilderFunctions::applyValueWordWrap(styleResolver, value);
        break;
    case CSSPropertyWritingMode:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWritingMode(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWritingMode(styleResolver);
        else
            StyleBuilderFunctions::applyValueWritingMode(styleResolver, value);
        break;
    case CSSPropertyX:
        if (isInitial)
            StyleBuilderFunctions::applyInitialX(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritX(styleResolver);
        else
            StyleBuilderFunctions::applyValueX(styleResolver, value);
        break;
    case CSSPropertyY:
        if (isInitial)
            StyleBuilderFunctions::applyInitialY(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritY(styleResolver);
        else
            StyleBuilderFunctions::applyValueY(styleResolver, value);
        break;
    case CSSPropertyZIndex:
        if (isInitial)
            StyleBuilderFunctions::applyInitialZIndex(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritZIndex(styleResolver);
        else
            StyleBuilderFunctions::applyValueZIndex(styleResolver, value);
        break;
    case CSSPropertyAlt:
        if (isInitial)
            StyleBuilderFunctions::applyInitialAlt(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritAlt(styleResolver);
        else
            StyleBuilderCustom::applyValueAlt(styleResolver, value);
        break;
    case CSSPropertyWebkitAnimation:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitAnimationDelay:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitAnimationDelay(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitAnimationDelay(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitAnimationDelay(styleResolver, value);
        break;
    case CSSPropertyWebkitAnimationDirection:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitAnimationDirection(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitAnimationDirection(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitAnimationDirection(styleResolver, value);
        break;
    case CSSPropertyWebkitAnimationDuration:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitAnimationDuration(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitAnimationDuration(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitAnimationDuration(styleResolver, value);
        break;
    case CSSPropertyWebkitAnimationFillMode:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitAnimationFillMode(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitAnimationFillMode(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitAnimationFillMode(styleResolver, value);
        break;
    case CSSPropertyWebkitAnimationIterationCount:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitAnimationIterationCount(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitAnimationIterationCount(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitAnimationIterationCount(styleResolver, value);
        break;
    case CSSPropertyWebkitAnimationName:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitAnimationName(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitAnimationName(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitAnimationName(styleResolver, value);
        break;
    case CSSPropertyWebkitAnimationPlayState:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitAnimationPlayState(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitAnimationPlayState(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitAnimationPlayState(styleResolver, value);
        break;
    case CSSPropertyWebkitAnimationTimingFunction:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitAnimationTimingFunction(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitAnimationTimingFunction(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitAnimationTimingFunction(styleResolver, value);
        break;
    case CSSPropertyWebkitAppearance:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitAppearance(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitAppearance(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitAppearance(styleResolver, value);
        break;
    case CSSPropertyWebkitAspectRatio:
        if (isInitial)
            StyleBuilderCustom::applyInitialWebkitAspectRatio(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritWebkitAspectRatio(styleResolver);
        else
            StyleBuilderCustom::applyValueWebkitAspectRatio(styleResolver, value);
        break;
    case CSSPropertyWebkitBackfaceVisibility:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitBackfaceVisibility(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitBackfaceVisibility(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitBackfaceVisibility(styleResolver, value);
        break;
    case CSSPropertyWebkitBackgroundClip:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitBackgroundClip(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitBackgroundClip(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitBackgroundClip(styleResolver, value);
        break;
    case CSSPropertyWebkitBackgroundComposite:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitBackgroundComposite(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitBackgroundComposite(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitBackgroundComposite(styleResolver, value);
        break;
    case CSSPropertyWebkitBackgroundOrigin:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitBackgroundOrigin(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitBackgroundOrigin(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitBackgroundOrigin(styleResolver, value);
        break;
    case CSSPropertyWebkitBackgroundSize:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitBackgroundSize(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitBackgroundSize(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitBackgroundSize(styleResolver, value);
        break;
    case CSSPropertyWebkitBorderAfter:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitBorderAfterColor:
        break;
    case CSSPropertyWebkitBorderAfterStyle:
        break;
    case CSSPropertyWebkitBorderAfterWidth:
        break;
    case CSSPropertyWebkitBorderBefore:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitBorderBeforeColor:
        break;
    case CSSPropertyWebkitBorderBeforeStyle:
        break;
    case CSSPropertyWebkitBorderBeforeWidth:
        break;
    case CSSPropertyWebkitBorderEnd:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitBorderEndColor:
        break;
    case CSSPropertyWebkitBorderEndStyle:
        break;
    case CSSPropertyWebkitBorderEndWidth:
        break;
    case CSSPropertyWebkitBorderFit:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitBorderFit(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitBorderFit(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitBorderFit(styleResolver, value);
        break;
    case CSSPropertyWebkitBorderHorizontalSpacing:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitBorderHorizontalSpacing(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitBorderHorizontalSpacing(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitBorderHorizontalSpacing(styleResolver, value);
        break;
    case CSSPropertyWebkitBorderImage:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitBorderImage(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitBorderImage(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitBorderImage(styleResolver, value);
        break;
    case CSSPropertyWebkitBorderRadius:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitBorderStart:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitBorderStartColor:
        break;
    case CSSPropertyWebkitBorderStartStyle:
        break;
    case CSSPropertyWebkitBorderStartWidth:
        break;
    case CSSPropertyWebkitBorderVerticalSpacing:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitBorderVerticalSpacing(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitBorderVerticalSpacing(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitBorderVerticalSpacing(styleResolver, value);
        break;
    case CSSPropertyWebkitBoxAlign:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitBoxAlign(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitBoxAlign(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitBoxAlign(styleResolver, value);
        break;
    case CSSPropertyWebkitBoxDirection:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitBoxDirection(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitBoxDirection(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitBoxDirection(styleResolver, value);
        break;
    case CSSPropertyWebkitBoxFlex:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitBoxFlex(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitBoxFlex(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitBoxFlex(styleResolver, value);
        break;
    case CSSPropertyWebkitBoxFlexGroup:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitBoxFlexGroup(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitBoxFlexGroup(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitBoxFlexGroup(styleResolver, value);
        break;
    case CSSPropertyWebkitBoxLines:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitBoxLines(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitBoxLines(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitBoxLines(styleResolver, value);
        break;
    case CSSPropertyWebkitBoxOrdinalGroup:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitBoxOrdinalGroup(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitBoxOrdinalGroup(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitBoxOrdinalGroup(styleResolver, value);
        break;
    case CSSPropertyWebkitBoxOrient:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitBoxOrient(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitBoxOrient(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitBoxOrient(styleResolver, value);
        break;
    case CSSPropertyWebkitBoxPack:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitBoxPack(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitBoxPack(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitBoxPack(styleResolver, value);
        break;
    case CSSPropertyWebkitBoxReflect:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitBoxReflect(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitBoxReflect(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitBoxReflect(styleResolver, value);
        break;
    case CSSPropertyWebkitBoxShadow:
        if (isInitial)
            StyleBuilderCustom::applyInitialWebkitBoxShadow(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritWebkitBoxShadow(styleResolver);
        else
            StyleBuilderCustom::applyValueWebkitBoxShadow(styleResolver, value);
        break;
    case CSSPropertyWebkitColumnAxis:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitColumnAxis(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitColumnAxis(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitColumnAxis(styleResolver, value);
        break;
    case CSSPropertyWebkitColumnBreakAfter:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitColumnBreakAfter(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitColumnBreakAfter(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitColumnBreakAfter(styleResolver, value);
        break;
    case CSSPropertyWebkitColumnBreakBefore:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitColumnBreakBefore(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitColumnBreakBefore(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitColumnBreakBefore(styleResolver, value);
        break;
    case CSSPropertyWebkitColumnBreakInside:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitColumnBreakInside(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitColumnBreakInside(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitColumnBreakInside(styleResolver, value);
        break;
    case CSSPropertyColumnCount:
        if (isInitial)
            StyleBuilderFunctions::applyInitialColumnCount(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritColumnCount(styleResolver);
        else
            StyleBuilderFunctions::applyValueColumnCount(styleResolver, value);
        break;
    case CSSPropertyColumnFill:
        if (isInitial)
            StyleBuilderFunctions::applyInitialColumnFill(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritColumnFill(styleResolver);
        else
            StyleBuilderFunctions::applyValueColumnFill(styleResolver, value);
        break;
    case CSSPropertyColumnGap:
        if (isInitial)
            StyleBuilderCustom::applyInitialColumnGap(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritColumnGap(styleResolver);
        else
            StyleBuilderCustom::applyValueColumnGap(styleResolver, value);
        break;
    case CSSPropertyColumnProgression:
        if (isInitial)
            StyleBuilderFunctions::applyInitialColumnProgression(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritColumnProgression(styleResolver);
        else
            StyleBuilderFunctions::applyValueColumnProgression(styleResolver, value);
        break;
    case CSSPropertyColumnRule:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyColumnRuleColor:
        if (isInitial)
            StyleBuilderFunctions::applyInitialColumnRuleColor(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritColumnRuleColor(styleResolver);
        else
            StyleBuilderFunctions::applyValueColumnRuleColor(styleResolver, value);
        break;
    case CSSPropertyColumnRuleStyle:
        if (isInitial)
            StyleBuilderFunctions::applyInitialColumnRuleStyle(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritColumnRuleStyle(styleResolver);
        else
            StyleBuilderFunctions::applyValueColumnRuleStyle(styleResolver, value);
        break;
    case CSSPropertyColumnRuleWidth:
        if (isInitial)
            StyleBuilderFunctions::applyInitialColumnRuleWidth(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritColumnRuleWidth(styleResolver);
        else
            StyleBuilderFunctions::applyValueColumnRuleWidth(styleResolver, value);
        break;
    case CSSPropertyColumnSpan:
        if (isInitial)
            StyleBuilderFunctions::applyInitialColumnSpan(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritColumnSpan(styleResolver);
        else
            StyleBuilderFunctions::applyValueColumnSpan(styleResolver, value);
        break;
    case CSSPropertyColumnWidth:
        if (isInitial)
            StyleBuilderFunctions::applyInitialColumnWidth(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritColumnWidth(styleResolver);
        else
            StyleBuilderFunctions::applyValueColumnWidth(styleResolver, value);
        break;
    case CSSPropertyColumns:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitBoxDecorationBreak:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitBoxDecorationBreak(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitBoxDecorationBreak(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitBoxDecorationBreak(styleResolver, value);
        break;
    case CSSPropertyMixBlendMode:
        if (isInitial)
            StyleBuilderFunctions::applyInitialMixBlendMode(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritMixBlendMode(styleResolver);
        else
            StyleBuilderFunctions::applyValueMixBlendMode(styleResolver, value);
        break;
    case CSSPropertyIsolation:
        if (isInitial)
            StyleBuilderFunctions::applyInitialIsolation(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritIsolation(styleResolver);
        else
            StyleBuilderFunctions::applyValueIsolation(styleResolver, value);
        break;
    case CSSPropertyFilter:
        if (isInitial)
            StyleBuilderFunctions::applyInitialFilter(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritFilter(styleResolver);
        else
            StyleBuilderFunctions::applyValueFilter(styleResolver, value);
        break;
    case CSSPropertyAlignContent:
        if (isInitial)
            StyleBuilderFunctions::applyInitialAlignContent(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritAlignContent(styleResolver);
        else
            StyleBuilderFunctions::applyValueAlignContent(styleResolver, value);
        break;
    case CSSPropertyAlignItems:
        if (isInitial)
            StyleBuilderFunctions::applyInitialAlignItems(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritAlignItems(styleResolver);
        else
            StyleBuilderFunctions::applyValueAlignItems(styleResolver, value);
        break;
    case CSSPropertyAlignSelf:
        if (isInitial)
            StyleBuilderFunctions::applyInitialAlignSelf(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritAlignSelf(styleResolver);
        else
            StyleBuilderFunctions::applyValueAlignSelf(styleResolver, value);
        break;
    case CSSPropertyFlex:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyFlexBasis:
        if (isInitial)
            StyleBuilderFunctions::applyInitialFlexBasis(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritFlexBasis(styleResolver);
        else
            StyleBuilderFunctions::applyValueFlexBasis(styleResolver, value);
        break;
    case CSSPropertyFlexDirection:
        if (isInitial)
            StyleBuilderFunctions::applyInitialFlexDirection(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritFlexDirection(styleResolver);
        else
            StyleBuilderFunctions::applyValueFlexDirection(styleResolver, value);
        break;
    case CSSPropertyFlexFlow:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyFlexGrow:
        if (isInitial)
            StyleBuilderFunctions::applyInitialFlexGrow(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritFlexGrow(styleResolver);
        else
            StyleBuilderFunctions::applyValueFlexGrow(styleResolver, value);
        break;
    case CSSPropertyFlexShrink:
        if (isInitial)
            StyleBuilderFunctions::applyInitialFlexShrink(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritFlexShrink(styleResolver);
        else
            StyleBuilderFunctions::applyValueFlexShrink(styleResolver, value);
        break;
    case CSSPropertyFlexWrap:
        if (isInitial)
            StyleBuilderFunctions::applyInitialFlexWrap(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritFlexWrap(styleResolver);
        else
            StyleBuilderFunctions::applyValueFlexWrap(styleResolver, value);
        break;
    case CSSPropertyJustifyContent:
        if (isInitial)
            StyleBuilderFunctions::applyInitialJustifyContent(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritJustifyContent(styleResolver);
        else
            StyleBuilderFunctions::applyValueJustifyContent(styleResolver, value);
        break;
    case CSSPropertyJustifySelf:
        if (isInitial)
            StyleBuilderFunctions::applyInitialJustifySelf(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritJustifySelf(styleResolver);
        else
            StyleBuilderFunctions::applyValueJustifySelf(styleResolver, value);
        break;
    case CSSPropertyWebkitFontSizeDelta:
        break;
    case CSSPropertyJustifyItems:
        if (isInitial)
            StyleBuilderFunctions::applyInitialJustifyItems(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritJustifyItems(styleResolver);
        else
            StyleBuilderFunctions::applyValueJustifyItems(styleResolver, value);
        break;
    case CSSPropertyWebkitGrid:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitGridArea:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitGridAutoColumns:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitGridAutoColumns(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitGridAutoColumns(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitGridAutoColumns(styleResolver, value);
        break;
    case CSSPropertyWebkitGridAutoRows:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitGridAutoRows(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitGridAutoRows(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitGridAutoRows(styleResolver, value);
        break;
    case CSSPropertyWebkitGridColumnEnd:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitGridColumnEnd(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitGridColumnEnd(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitGridColumnEnd(styleResolver, value);
        break;
    case CSSPropertyWebkitGridColumnGap:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitGridColumnGap(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitGridColumnGap(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitGridColumnGap(styleResolver, value);
        break;
    case CSSPropertyWebkitGridColumnStart:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitGridColumnStart(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitGridColumnStart(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitGridColumnStart(styleResolver, value);
        break;
    case CSSPropertyWebkitGridTemplate:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitGridTemplateColumns:
        if (isInitial)
            StyleBuilderCustom::applyInitialWebkitGridTemplateColumns(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritWebkitGridTemplateColumns(styleResolver);
        else
            StyleBuilderCustom::applyValueWebkitGridTemplateColumns(styleResolver, value);
        break;
    case CSSPropertyWebkitGridTemplateRows:
        if (isInitial)
            StyleBuilderCustom::applyInitialWebkitGridTemplateRows(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritWebkitGridTemplateRows(styleResolver);
        else
            StyleBuilderCustom::applyValueWebkitGridTemplateRows(styleResolver, value);
        break;
    case CSSPropertyWebkitGridRowEnd:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitGridRowEnd(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitGridRowEnd(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitGridRowEnd(styleResolver, value);
        break;
    case CSSPropertyWebkitGridRowGap:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitGridRowGap(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitGridRowGap(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitGridRowGap(styleResolver, value);
        break;
    case CSSPropertyWebkitGridRowStart:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitGridRowStart(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitGridRowStart(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitGridRowStart(styleResolver, value);
        break;
    case CSSPropertyWebkitGridColumn:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitGridGap:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitGridRow:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitGridTemplateAreas:
        if (isInitial)
            StyleBuilderCustom::applyInitialWebkitGridTemplateAreas(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritWebkitGridTemplateAreas(styleResolver);
        else
            StyleBuilderCustom::applyValueWebkitGridTemplateAreas(styleResolver, value);
        break;
    case CSSPropertyWebkitGridAutoFlow:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitGridAutoFlow(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitGridAutoFlow(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitGridAutoFlow(styleResolver, value);
        break;
    case CSSPropertyWebkitHyphenateCharacter:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitHyphenateCharacter(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitHyphenateCharacter(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitHyphenateCharacter(styleResolver, value);
        break;
    case CSSPropertyWebkitHyphenateLimitAfter:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitHyphenateLimitAfter(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitHyphenateLimitAfter(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitHyphenateLimitAfter(styleResolver, value);
        break;
    case CSSPropertyWebkitHyphenateLimitBefore:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitHyphenateLimitBefore(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitHyphenateLimitBefore(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitHyphenateLimitBefore(styleResolver, value);
        break;
    case CSSPropertyWebkitHyphenateLimitLines:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitHyphenateLimitLines(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitHyphenateLimitLines(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitHyphenateLimitLines(styleResolver, value);
        break;
    case CSSPropertyWebkitHyphens:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitHyphens(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitHyphens(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitHyphens(styleResolver, value);
        break;
    case CSSPropertyWebkitInitialLetter:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitInitialLetter(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitInitialLetter(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitInitialLetter(styleResolver, value);
        break;
    case CSSPropertyWebkitLineBoxContain:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitLineBoxContain(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitLineBoxContain(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitLineBoxContain(styleResolver, value);
        break;
    case CSSPropertyWebkitLineAlign:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitLineAlign(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitLineAlign(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitLineAlign(styleResolver, value);
        break;
    case CSSPropertyWebkitLineBreak:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitLineBreak(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitLineBreak(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitLineBreak(styleResolver, value);
        break;
    case CSSPropertyWebkitLineClamp:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitLineClamp(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitLineClamp(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitLineClamp(styleResolver, value);
        break;
    case CSSPropertyWebkitLineGrid:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitLineGrid(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitLineGrid(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitLineGrid(styleResolver, value);
        break;
    case CSSPropertyWebkitLineSnap:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitLineSnap(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitLineSnap(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitLineSnap(styleResolver, value);
        break;
    case CSSPropertyWebkitLogicalWidth:
        break;
    case CSSPropertyWebkitLogicalHeight:
        break;
    case CSSPropertyWebkitMarginAfterCollapse:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitMarginAfterCollapse(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitMarginAfterCollapse(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitMarginAfterCollapse(styleResolver, value);
        break;
    case CSSPropertyWebkitMarginBeforeCollapse:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitMarginBeforeCollapse(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitMarginBeforeCollapse(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitMarginBeforeCollapse(styleResolver, value);
        break;
    case CSSPropertyWebkitMarginBottomCollapse:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitMarginBottomCollapse(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitMarginBottomCollapse(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitMarginBottomCollapse(styleResolver, value);
        break;
    case CSSPropertyWebkitMarginTopCollapse:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitMarginTopCollapse(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitMarginTopCollapse(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitMarginTopCollapse(styleResolver, value);
        break;
    case CSSPropertyWebkitMarginCollapse:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitMarginAfter:
        break;
    case CSSPropertyWebkitMarginBefore:
        break;
    case CSSPropertyWebkitMarginEnd:
        break;
    case CSSPropertyWebkitMarginStart:
        break;
    case CSSPropertyWebkitMarquee:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitMarqueeDirection:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitMarqueeDirection(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitMarqueeDirection(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitMarqueeDirection(styleResolver, value);
        break;
    case CSSPropertyWebkitMarqueeIncrement:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitMarqueeIncrement(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitMarqueeIncrement(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitMarqueeIncrement(styleResolver, value);
        break;
    case CSSPropertyWebkitMarqueeRepetition:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitMarqueeRepetition(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitMarqueeRepetition(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitMarqueeRepetition(styleResolver, value);
        break;
    case CSSPropertyWebkitMarqueeSpeed:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitMarqueeSpeed(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitMarqueeSpeed(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitMarqueeSpeed(styleResolver, value);
        break;
    case CSSPropertyWebkitMarqueeStyle:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitMarqueeStyle(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitMarqueeStyle(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitMarqueeStyle(styleResolver, value);
        break;
    case CSSPropertyWebkitMask:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitMaskBoxImage:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitMaskBoxImage(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitMaskBoxImage(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitMaskBoxImage(styleResolver, value);
        break;
    case CSSPropertyWebkitMaskBoxImageOutset:
        if (isInitial)
            StyleBuilderCustom::applyInitialWebkitMaskBoxImageOutset(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritWebkitMaskBoxImageOutset(styleResolver);
        else
            StyleBuilderCustom::applyValueWebkitMaskBoxImageOutset(styleResolver, value);
        break;
    case CSSPropertyWebkitMaskBoxImageRepeat:
        if (isInitial)
            StyleBuilderCustom::applyInitialWebkitMaskBoxImageRepeat(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritWebkitMaskBoxImageRepeat(styleResolver);
        else
            StyleBuilderCustom::applyValueWebkitMaskBoxImageRepeat(styleResolver, value);
        break;
    case CSSPropertyWebkitMaskBoxImageSlice:
        if (isInitial)
            StyleBuilderCustom::applyInitialWebkitMaskBoxImageSlice(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritWebkitMaskBoxImageSlice(styleResolver);
        else
            StyleBuilderCustom::applyValueWebkitMaskBoxImageSlice(styleResolver, value);
        break;
    case CSSPropertyWebkitMaskBoxImageSource:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitMaskBoxImageSource(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitMaskBoxImageSource(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitMaskBoxImageSource(styleResolver, value);
        break;
    case CSSPropertyWebkitMaskBoxImageWidth:
        if (isInitial)
            StyleBuilderCustom::applyInitialWebkitMaskBoxImageWidth(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritWebkitMaskBoxImageWidth(styleResolver);
        else
            StyleBuilderCustom::applyValueWebkitMaskBoxImageWidth(styleResolver, value);
        break;
    case CSSPropertyWebkitMaskClip:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitMaskClip(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitMaskClip(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitMaskClip(styleResolver, value);
        break;
    case CSSPropertyWebkitMaskComposite:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitMaskComposite(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitMaskComposite(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitMaskComposite(styleResolver, value);
        break;
    case CSSPropertyWebkitMaskImage:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitMaskImage(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitMaskImage(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitMaskImage(styleResolver, value);
        break;
    case CSSPropertyWebkitMaskOrigin:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitMaskOrigin(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitMaskOrigin(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitMaskOrigin(styleResolver, value);
        break;
    case CSSPropertyWebkitMaskPosition:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitMaskPositionX:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitMaskPositionX(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitMaskPositionX(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitMaskPositionX(styleResolver, value);
        break;
    case CSSPropertyWebkitMaskPositionY:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitMaskPositionY(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitMaskPositionY(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitMaskPositionY(styleResolver, value);
        break;
    case CSSPropertyWebkitMaskRepeat:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitMaskRepeatX:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitMaskRepeatX(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitMaskRepeatX(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitMaskRepeatX(styleResolver, value);
        break;
    case CSSPropertyWebkitMaskRepeatY:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitMaskRepeatY(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitMaskRepeatY(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitMaskRepeatY(styleResolver, value);
        break;
    case CSSPropertyWebkitMaskSize:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitMaskSize(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitMaskSize(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitMaskSize(styleResolver, value);
        break;
    case CSSPropertyWebkitMaskSourceType:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitMaskSourceType(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitMaskSourceType(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitMaskSourceType(styleResolver, value);
        break;
    case CSSPropertyWebkitMaxLogicalWidth:
        break;
    case CSSPropertyWebkitMaxLogicalHeight:
        break;
    case CSSPropertyWebkitMinLogicalWidth:
        break;
    case CSSPropertyWebkitMinLogicalHeight:
        break;
    case CSSPropertyWebkitNbspMode:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitNbspMode(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitNbspMode(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitNbspMode(styleResolver, value);
        break;
    case CSSPropertyOrder:
        if (isInitial)
            StyleBuilderFunctions::applyInitialOrder(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritOrder(styleResolver);
        else
            StyleBuilderFunctions::applyValueOrder(styleResolver, value);
        break;
    case CSSPropertyWebkitPaddingAfter:
        break;
    case CSSPropertyWebkitPaddingBefore:
        break;
    case CSSPropertyWebkitPaddingEnd:
        break;
    case CSSPropertyWebkitPaddingStart:
        break;
    case CSSPropertyPerspective:
        if (isInitial)
            StyleBuilderFunctions::applyInitialPerspective(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritPerspective(styleResolver);
        else
            StyleBuilderFunctions::applyValuePerspective(styleResolver, value);
        break;
    case CSSPropertyPerspectiveOrigin:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyPerspectiveOriginX:
        if (isInitial)
            StyleBuilderFunctions::applyInitialPerspectiveOriginX(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritPerspectiveOriginX(styleResolver);
        else
            StyleBuilderFunctions::applyValuePerspectiveOriginX(styleResolver, value);
        break;
    case CSSPropertyPerspectiveOriginY:
        if (isInitial)
            StyleBuilderFunctions::applyInitialPerspectiveOriginY(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritPerspectiveOriginY(styleResolver);
        else
            StyleBuilderFunctions::applyValuePerspectiveOriginY(styleResolver, value);
        break;
    case CSSPropertyWebkitPrintColorAdjust:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitPrintColorAdjust(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitPrintColorAdjust(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitPrintColorAdjust(styleResolver, value);
        break;
    case CSSPropertyWebkitRtlOrdering:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitRtlOrdering(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitRtlOrdering(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitRtlOrdering(styleResolver, value);
        break;
    case CSSPropertyWebkitSvgShadow:
        if (isInitial)
            StyleBuilderCustom::applyInitialWebkitSvgShadow(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritWebkitSvgShadow(styleResolver);
        else
            StyleBuilderCustom::applyValueWebkitSvgShadow(styleResolver, value);
        break;
    case CSSPropertyWebkitTextCombine:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitTextCombine(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitTextCombine(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitTextCombine(styleResolver, value);
        break;
    case CSSPropertyWebkitTextDecoration:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitTextDecorationLine:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitTextDecorationLine(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitTextDecorationLine(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitTextDecorationLine(styleResolver, value);
        break;
    case CSSPropertyWebkitTextDecorationStyle:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitTextDecorationStyle(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitTextDecorationStyle(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitTextDecorationStyle(styleResolver, value);
        break;
    case CSSPropertyWebkitTextDecorationColor:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitTextDecorationColor(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitTextDecorationColor(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitTextDecorationColor(styleResolver, value);
        break;
    case CSSPropertyWebkitTextDecorationSkip:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitTextDecorationSkip(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitTextDecorationSkip(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitTextDecorationSkip(styleResolver, value);
        break;
    case CSSPropertyWebkitTextUnderlinePosition:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitTextUnderlinePosition(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitTextUnderlinePosition(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitTextUnderlinePosition(styleResolver, value);
        break;
    case CSSPropertyWebkitTextDecorationsInEffect:
        break;
    case CSSPropertyWebkitTextEmphasis:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitTextEmphasisColor:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitTextEmphasisColor(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitTextEmphasisColor(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitTextEmphasisColor(styleResolver, value);
        break;
    case CSSPropertyWebkitTextEmphasisPosition:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitTextEmphasisPosition(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitTextEmphasisPosition(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitTextEmphasisPosition(styleResolver, value);
        break;
    case CSSPropertyWebkitTextEmphasisStyle:
        if (isInitial)
            StyleBuilderCustom::applyInitialWebkitTextEmphasisStyle(styleResolver);
        else if (isInherit)
            StyleBuilderCustom::applyInheritWebkitTextEmphasisStyle(styleResolver);
        else
            StyleBuilderCustom::applyValueWebkitTextEmphasisStyle(styleResolver, value);
        break;
    case CSSPropertyWebkitTextFillColor:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitTextFillColor(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitTextFillColor(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitTextFillColor(styleResolver, value);
        break;
    case CSSPropertyWebkitTextSecurity:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitTextSecurity(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitTextSecurity(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitTextSecurity(styleResolver, value);
        break;
    case CSSPropertyWebkitTextStroke:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitTextStrokeColor:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitTextStrokeColor(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitTextStrokeColor(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitTextStrokeColor(styleResolver, value);
        break;
    case CSSPropertyWebkitTextStrokeWidth:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitTextStrokeWidth(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitTextStrokeWidth(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitTextStrokeWidth(styleResolver, value);
        break;
    case CSSPropertyTransform:
        if (isInitial)
            StyleBuilderFunctions::applyInitialTransform(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritTransform(styleResolver);
        else
            StyleBuilderFunctions::applyValueTransform(styleResolver, value);
        break;
    case CSSPropertyTransformOrigin:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyTransformOriginX:
        if (isInitial)
            StyleBuilderFunctions::applyInitialTransformOriginX(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritTransformOriginX(styleResolver);
        else
            StyleBuilderFunctions::applyValueTransformOriginX(styleResolver, value);
        break;
    case CSSPropertyTransformOriginY:
        if (isInitial)
            StyleBuilderFunctions::applyInitialTransformOriginY(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritTransformOriginY(styleResolver);
        else
            StyleBuilderFunctions::applyValueTransformOriginY(styleResolver, value);
        break;
    case CSSPropertyTransformOriginZ:
        if (isInitial)
            StyleBuilderFunctions::applyInitialTransformOriginZ(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritTransformOriginZ(styleResolver);
        else
            StyleBuilderFunctions::applyValueTransformOriginZ(styleResolver, value);
        break;
    case CSSPropertyTransformStyle:
        if (isInitial)
            StyleBuilderFunctions::applyInitialTransformStyle(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritTransformStyle(styleResolver);
        else
            StyleBuilderFunctions::applyValueTransformStyle(styleResolver, value);
        break;
    case CSSPropertyWebkitTransformStyle:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitTransformStyle(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitTransformStyle(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitTransformStyle(styleResolver, value);
        break;
    case CSSPropertyWebkitTransition:
        ASSERT(isShorthandCSSProperty(property));
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyWebkitTransitionDelay:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitTransitionDelay(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitTransitionDelay(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitTransitionDelay(styleResolver, value);
        break;
    case CSSPropertyWebkitTransitionDuration:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitTransitionDuration(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitTransitionDuration(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitTransitionDuration(styleResolver, value);
        break;
    case CSSPropertyWebkitTransitionProperty:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitTransitionProperty(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitTransitionProperty(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitTransitionProperty(styleResolver, value);
        break;
    case CSSPropertyWebkitTransitionTimingFunction:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitTransitionTimingFunction(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitTransitionTimingFunction(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitTransitionTimingFunction(styleResolver, value);
        break;
    case CSSPropertyWebkitUserDrag:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitUserDrag(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitUserDrag(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitUserDrag(styleResolver, value);
        break;
    case CSSPropertyWebkitUserModify:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitUserModify(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitUserModify(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitUserModify(styleResolver, value);
        break;
    case CSSPropertyWebkitUserSelect:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitUserSelect(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitUserSelect(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitUserSelect(styleResolver, value);
        break;
    case CSSPropertyWebkitFlowInto:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitFlowInto(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitFlowInto(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitFlowInto(styleResolver, value);
        break;
    case CSSPropertyWebkitFlowFrom:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitFlowFrom(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitFlowFrom(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitFlowFrom(styleResolver, value);
        break;
    case CSSPropertyWebkitRegionFragment:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitRegionFragment(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitRegionFragment(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitRegionFragment(styleResolver, value);
        break;
    case CSSPropertyWebkitRegionBreakAfter:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitRegionBreakAfter(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitRegionBreakAfter(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitRegionBreakAfter(styleResolver, value);
        break;
    case CSSPropertyWebkitRegionBreakBefore:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitRegionBreakBefore(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitRegionBreakBefore(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitRegionBreakBefore(styleResolver, value);
        break;
    case CSSPropertyWebkitRegionBreakInside:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitRegionBreakInside(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitRegionBreakInside(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitRegionBreakInside(styleResolver, value);
        break;
    case CSSPropertyWebkitShapeOutside:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitShapeOutside(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitShapeOutside(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitShapeOutside(styleResolver, value);
        break;
    case CSSPropertyWebkitShapeMargin:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitShapeMargin(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitShapeMargin(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitShapeMargin(styleResolver, value);
        break;
    case CSSPropertyWebkitShapeImageThreshold:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitShapeImageThreshold(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitShapeImageThreshold(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitShapeImageThreshold(styleResolver, value);
        break;
    case CSSPropertyWebkitTapHighlightColor:
        if (isInitial)
            StyleBuilderFunctions::applyInitialWebkitTapHighlightColor(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritWebkitTapHighlightColor(styleResolver);
        else
            StyleBuilderFunctions::applyValueWebkitTapHighlightColor(styleResolver, value);
        break;
    case CSSPropertyTouchAction:
        if (isInitial)
            StyleBuilderFunctions::applyInitialTouchAction(styleResolver);
        else if (isInherit)
            StyleBuilderFunctions::applyInheritTouchAction(styleResolver);
        else
            StyleBuilderFunctions::applyValueTouchAction(styleResolver, value);
        break;
    };
}

} // namespace WebCore
