/*
 * Copyright (c) 2015 Canon Inc.
 * Copyright (c) 2015 Igalia.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "StreamInternalsBuiltins.h"

#if ENABLE(STREAMS_API)

#include "WebCoreJSClientData.h"
#include <runtime/Executable.h>
#include <runtime/JSCJSValueInlines.h>
#include <runtime/JSCellInlines.h>
#include <runtime/StructureInlines.h>
#include <runtime/VM.h>

namespace WebCore {

const JSC::ConstructAbility s_streamInternalsShieldingPromiseResolveCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_streamInternalsShieldingPromiseResolveCodeLength = 179;
const char* s_streamInternalsShieldingPromiseResolveCode =
    "(function (result)\n" \
    "{\n" \
    "    const promise = @Promise.@resolve(result);\n" \
    "    if (promise.@then === @undefined)\n" \
    "        promise.@then = @Promise.prototype.@then;\n" \
    "    return promise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_streamInternalsPromiseInvokeOrNoopNoCatchCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_streamInternalsPromiseInvokeOrNoopNoCatchCodeLength = 218;
const char* s_streamInternalsPromiseInvokeOrNoopNoCatchCode =
    "(function (object, key, args)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    const method = object[key];\n" \
    "    if (method === @undefined)\n" \
    "        return @Promise.@resolve();\n" \
    "    return @shieldingPromiseResolve(method.@apply(object, args));\n" \
    "})\n" \
;

const JSC::ConstructAbility s_streamInternalsPromiseInvokeOrNoopCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_streamInternalsPromiseInvokeOrNoopCodeLength = 197;
const char* s_streamInternalsPromiseInvokeOrNoopCode =
    "(function (object, key, args)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    try {\n" \
    "        return @promiseInvokeOrNoopNoCatch(object, key, args);\n" \
    "    }\n" \
    "    catch(error) {\n" \
    "        return @Promise.@reject(error);\n" \
    "    }\n" \
    "})\n" \
;

const JSC::ConstructAbility s_streamInternalsPromiseInvokeOrFallbackOrNoopCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_streamInternalsPromiseInvokeOrFallbackOrNoopCodeLength = 361;
const char* s_streamInternalsPromiseInvokeOrFallbackOrNoopCode =
    "(function (object, key1, args1, key2, args2)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    try {\n" \
    "        const method = object[key1];\n" \
    "        if (method === @undefined)\n" \
    "            return @promiseInvokeOrNoopNoCatch(object, key2, args2);\n" \
    "        return @shieldingPromiseResolve(method.@apply(object, args1));\n" \
    "    }\n" \
    "    catch(error) {\n" \
    "        return @Promise.@reject(error);\n" \
    "    }\n" \
    "})\n" \
;

const JSC::ConstructAbility s_streamInternalsValidateAndNormalizeQueuingStrategyCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_streamInternalsValidateAndNormalizeQueuingStrategyCodeLength = 576;
const char* s_streamInternalsValidateAndNormalizeQueuingStrategyCode =
    "(function (size, highWaterMark)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (size !== @undefined && typeof size !== \"function\")\n" \
    "        throw new @TypeError(\"size parameter must be a function\");\n" \
    "    const normalizedStrategy = { };\n" \
    "    normalizedStrategy.size = size;\n" \
    "    normalizedStrategy.highWaterMark = @Number(highWaterMark);\n" \
    "    if (@isNaN(normalizedStrategy.highWaterMark))\n" \
    "        throw new @TypeError(\"highWaterMark parameter is not a number\");\n" \
    "    if (normalizedStrategy.highWaterMark < 0)\n" \
    "        throw new @RangeError(\"highWaterMark is negative\");\n" \
    "    return normalizedStrategy;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_streamInternalsNewQueueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_streamInternalsNewQueueCodeLength = 73;
const char* s_streamInternalsNewQueueCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    return { content: [], size: 0 };\n" \
    "})\n" \
;

const JSC::ConstructAbility s_streamInternalsDequeueValueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_streamInternalsDequeueValueCodeLength = 140;
const char* s_streamInternalsDequeueValueCode =
    "(function (queue)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    const record = queue.content.@shift();\n" \
    "    queue.size -= record.size;\n" \
    "    return record.value;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_streamInternalsEnqueueValueWithSizeCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_streamInternalsEnqueueValueWithSizeCodeLength = 259;
const char* s_streamInternalsEnqueueValueWithSizeCode =
    "(function (queue, value, size)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    size = @Number(size);\n" \
    "    if (!@isFinite(size) || size < 0)\n" \
    "        throw new @RangeError(\"size has an incorrect value\");\n" \
    "    queue.content.@push({ value: value, size: size });\n" \
    "    queue.size += size;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_streamInternalsPeekQueueValueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_streamInternalsPeekQueueValueCodeLength = 115;
const char* s_streamInternalsPeekQueueValueCode =
    "(function (queue)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    @assert(queue.content.length > 0);\n" \
    "    return queue.content[0].value;\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = static_cast<JSVMClientData*>(vm.clientData); \
    return clientData->builtinFunctions().streamInternalsBuiltins().codeName##Executable()->link(vm, clientData->builtinFunctions().streamInternalsBuiltins().codeName##Source()); \
}
WEBCORE_FOREACH_STREAMINTERNALS_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore

#endif // ENABLE(STREAMS_API)
