/*
 * Copyright (c) 2015 Canon Inc.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "ReadableStreamControllerBuiltins.h"

#if ENABLE(STREAMS_API)

#include "WebCoreJSClientData.h"
#include <runtime/Executable.h>
#include <runtime/JSCJSValueInlines.h>
#include <runtime/JSCellInlines.h>
#include <runtime/StructureInlines.h>
#include <runtime/VM.h>

namespace WebCore {

const JSC::ConstructAbility s_readableStreamControllerEnqueueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamControllerEnqueueCodeLength = 456;
const char* s_readableStreamControllerEnqueueCode =
    "(function (chunk)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isReadableStreamController(this))\n" \
    "        throw new @TypeError(\"Function should be called on a ReadableStreamController\");\n" \
    "    const stream = this.@controlledReadableStream;\n" \
    "    if (stream.@state === @streamErrored)\n" \
    "        throw stream.@storedError;\n" \
    "    if (stream.@closeRequested)\n" \
    "        throw new @TypeError(\"ReadableStream is requested to close\");\n" \
    "    return @enqueueInReadableStream(stream, chunk);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamControllerErrorCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamControllerErrorCodeLength = 372;
const char* s_readableStreamControllerErrorCode =
    "(function (error)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isReadableStreamController(this))\n" \
    "        throw new @TypeError(\"Function should be called on a ReadableStreamController\");\n" \
    "    const stream = this.@controlledReadableStream;\n" \
    "    if (stream.@state !== @streamReadable)\n" \
    "        throw new @TypeError(\"ReaableStream is not readable\");\n" \
    "    @errorReadableStream(stream, error);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamControllerCloseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamControllerCloseCodeLength = 473;
const char* s_readableStreamControllerCloseCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isReadableStreamController(this))\n" \
    "        throw new @TypeError(\"Function should be called on a ReadableStreamController\");\n" \
    "    const stream = this.@controlledReadableStream;\n" \
    "    if (stream.@closeRequested)\n" \
    "        throw new @TypeError(\"ReadableStream is already requested to close\");\n" \
    "    if (stream.@state === @streamErrored)\n" \
    "        throw new @TypeError(\"ReadableStream is already errored\");\n" \
    "    @closeReadableStream(stream);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamControllerDesiredSizeCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamControllerDesiredSizeCodeLength = 243;
const char* s_readableStreamControllerDesiredSizeCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isReadableStreamController(this))\n" \
    "        throw new @TypeError(\"Function should be called on a ReadableStreamController\");\n" \
    "    return @getReadableStreamDesiredSize(this.@controlledReadableStream);\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = static_cast<JSVMClientData*>(vm.clientData); \
    return clientData->builtinFunctions().readableStreamControllerBuiltins().codeName##Executable()->link(vm, clientData->builtinFunctions().readableStreamControllerBuiltins().codeName##Source()); \
}
WEBCORE_FOREACH_READABLESTREAMCONTROLLER_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore

#endif // ENABLE(STREAMS_API)
