/*
 * Copyright (c) 2015 Canon Inc.
 * Copyright (c) 2015 Igalia.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "ReadableStreamBuiltins.h"

#if ENABLE(STREAMS_API)

#include "WebCoreJSClientData.h"
#include <runtime/Executable.h>
#include <runtime/JSCJSValueInlines.h>
#include <runtime/JSCellInlines.h>
#include <runtime/StructureInlines.h>
#include <runtime/VM.h>

namespace WebCore {

const JSC::ConstructAbility s_readableStreamInitializeReadableStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamInitializeReadableStreamCodeLength = 1323;
const char* s_readableStreamInitializeReadableStreamCode =
    "(function (underlyingSource, strategy)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "     if (underlyingSource === @undefined)\n" \
    "         underlyingSource = { };\n" \
    "     if (strategy === @undefined)\n" \
    "         strategy = { highWaterMark: 1, size: function() { return 1; } };\n" \
    "    if (!@isObject(underlyingSource))\n" \
    "        throw new @TypeError(\"ReadableStream constructor takes an object as first argument\");\n" \
    "    if (strategy !== @undefined && !@isObject(strategy))\n" \
    "        throw new @TypeError(\"ReadableStream constructor takes an object as second argument, if any\");\n" \
    "    this.@underlyingSource = underlyingSource;\n" \
    "    this.@queue = @newQueue();\n" \
    "    this.@state = @streamReadable;\n" \
    "    this.@started = false;\n" \
    "    this.@closeRequested = false;\n" \
    "    this.@pullAgain = false;\n" \
    "    this.@pulling = false;\n" \
    "    this.@reader = @undefined;\n" \
    "    this.@storedError = @undefined;\n" \
    "    this.@disturbed = false;\n" \
    "    this.@controller = new @ReadableStreamController(this);\n" \
    "    this.@strategy = @validateAndNormalizeQueuingStrategy(strategy.size, strategy.highWaterMark);\n" \
    "    @promiseInvokeOrNoopNoCatch(underlyingSource, \"start\", [this.@controller]).@then(() => {\n" \
    "        this.@started = true;\n" \
    "        @requestReadableStreamPull(this);\n" \
    "    }, (error) => {\n" \
    "        if (this.@state === @streamReadable)\n" \
    "            @errorReadableStream(this, error);\n" \
    "    });\n" \
    "    return this;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamCancelCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamCancelCodeLength = 338;
const char* s_readableStreamCancelCode =
    "(function (reason)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isReadableStream(this))\n" \
    "        return @Promise.@reject(new @TypeError(\"Function should be called on a ReadableStream\"));\n" \
    "    if (@isReadableStreamLocked(this))\n" \
    "        return @Promise.@reject(new @TypeError(\"ReadableStream is locked\"));\n" \
    "    return @cancelReadableStream(this, reason);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamGetReaderCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamGetReaderCodeLength = 193;
const char* s_readableStreamGetReaderCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isReadableStream(this))\n" \
    "        throw new @TypeError(\"Function should be called on a ReadableStream\");\n" \
    "    return new @ReadableStreamReader(this);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamPipeThroughCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamPipeThroughCodeLength = 187;
const char* s_readableStreamPipeThroughCode =
    "(function (streams, options)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    const writable = streams.writable;\n" \
    "    const readable = streams.readable;\n" \
    "    this.pipeTo(writable, options);\n" \
    "    return readable;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamPipeToCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamPipeToCodeLength = 2573;
const char* s_readableStreamPipeToCode =
    "(function (destination, options)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    const preventClose = @isObject(options) && !!options.preventClose;\n" \
    "    const preventAbort = @isObject(options) && !!options.preventAbort;\n" \
    "    const preventCancel = @isObject(options) && !!options.preventCancel;\n" \
    "    const source = this;\n" \
    "    let reader;\n" \
    "    let lastRead;\n" \
    "    let lastWrite;\n" \
    "    let closedPurposefully = false;\n" \
    "    let promiseCapability;\n" \
    "    function doPipe() {\n" \
    "        lastRead = reader.read();\n" \
    "        @Promise.prototype.@then.@call(@Promise.all([lastRead, destination.ready]), function([{ value, done }]) {\n" \
    "            if (done)\n" \
    "                closeDestination();\n" \
    "            else if (destination.state === \"writable\") {\n" \
    "                lastWrite = destination.write(value);\n" \
    "                doPipe();\n" \
    "            }\n" \
    "        }, function(e) {\n" \
    "            throw e;\n" \
    "        });\n" \
    "    }\n" \
    "    function cancelSource(reason) {\n" \
    "        if (!preventCancel) {\n" \
    "            reader.cancel(reason);\n" \
    "            reader.releaseLock();\n" \
    "            promiseCapability.@reject.@call(@undefined, reason);\n" \
    "        } else {\n" \
    "            @Promise.prototype.@then.@call(lastRead, function() {\n" \
    "                reader.releaseLock();\n" \
    "                promiseCapability.@reject.@call(@undefined, reason);\n" \
    "            });\n" \
    "        }\n" \
    "    }\n" \
    "    function closeDestination() {\n" \
    "        reader.releaseLock();\n" \
    "        const destinationState = destination.state;\n" \
    "        if (!preventClose && (destinationState === \"waiting\" || destinationState === \"writable\")) {\n" \
    "            closedPurposefully = true;\n" \
    "            @Promise.prototype.@then.@call(destination.close(), promiseCapability.@resolve, promiseCapability.@reject);\n" \
    "        } else if (lastWrite !== @undefined)\n" \
    "            @Promise.prototype.@then.@call(lastWrite, promiseCapability.@resolve, promiseCapability.@reject);\n" \
    "        else\n" \
    "            promiseCapability.@resolve.@call();\n" \
    "    }\n" \
    "    function abortDestination(reason) {\n" \
    "        reader.releaseLock();\n" \
    "        if (!preventAbort)\n" \
    "            destination.abort(reason);\n" \
    "        promiseCapability.@reject.@call(@undefined, reason);\n" \
    "    }\n" \
    "    promiseCapability = @newPromiseCapability(@Promise);\n" \
    "    reader = source.getReader();\n" \
    "    @Promise.prototype.@then.@call(reader.closed, @undefined, abortDestination);\n" \
    "    @Promise.prototype.@then.@call(destination.closed,\n" \
    "        function() {\n" \
    "            if (!closedPurposefully)\n" \
    "                cancelSource(new @TypeError('destination is closing or closed and cannot be piped to anymore'));\n" \
    "        },\n" \
    "        cancelSource\n" \
    "    );\n" \
    "    doPipe();\n" \
    "    \n" \
    "    return promiseCapability.@promise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamTeeCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamTeeCodeLength = 193;
const char* s_readableStreamTeeCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isReadableStream(this))\n" \
    "        throw new @TypeError(\"Function should be called on a ReadableStream\");\n" \
    "    return @teeReadableStream(this, false);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamLockedCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_readableStreamLockedCodeLength = 191;
const char* s_readableStreamLockedCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isReadableStream(this))\n" \
    "        throw new @TypeError(\"Function should be called on a ReadableStream\");\n" \
    "    return @isReadableStreamLocked(this);\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = static_cast<JSVMClientData*>(vm.clientData); \
    return clientData->builtinFunctions().readableStreamBuiltins().codeName##Executable()->link(vm, clientData->builtinFunctions().readableStreamBuiltins().codeName##Source()); \
}
WEBCORE_FOREACH_READABLESTREAM_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore

#endif // ENABLE(STREAMS_API)
