/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(STREAMS_API)

#include "JSWritableStream.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "WritableStreamBuiltins.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions


// Attributes

JSC::EncodedJSValue jsWritableStreamConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWritableStreamConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWritableStreamPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWritableStreamPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWritableStreamPrototype* ptr = new (NotNull, JSC::allocateCell<JSWritableStreamPrototype>(vm.heap)) JSWritableStreamPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWritableStreamPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSBuiltinConstructor<JSWritableStream> JSWritableStreamConstructor;

template<> JSValue JSWritableStreamConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWritableStreamConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWritableStream::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("WritableStream"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> FunctionExecutable* JSWritableStreamConstructor::initializeExecutable(VM& vm)
{
    return writableStreamInitializeWritableStreamCodeGenerator(vm);
}

template<> const ClassInfo JSWritableStreamConstructor::s_info = { "WritableStream", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWritableStreamConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWritableStreamPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWritableStreamConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWritableStreamConstructor) } },
    { "closed", ReadOnly | Accessor | Builtin, NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(writableStreamClosedCodeGenerator), (intptr_t) (0) } },
    { "ready", ReadOnly | Accessor | Builtin, NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(writableStreamReadyCodeGenerator), (intptr_t) (0) } },
    { "state", ReadOnly | Accessor | Builtin, NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(writableStreamStateCodeGenerator), (intptr_t) (0) } },
    { "abort", JSC::Builtin, NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(writableStreamAbortCodeGenerator), (intptr_t) (0) } },
    { "close", JSC::Builtin, NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(writableStreamCloseCodeGenerator), (intptr_t) (0) } },
    { "write", JSC::Builtin, NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(writableStreamWriteCodeGenerator), (intptr_t) (1) } },
};

const ClassInfo JSWritableStreamPrototype::s_info = { "WritableStreamPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWritableStreamPrototype) };

void JSWritableStreamPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWritableStreamPrototypeTableValues, *this);
}

const ClassInfo JSWritableStream::s_info = { "WritableStream", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWritableStream) };

JSWritableStream::JSWritableStream(Structure* structure, JSDOMGlobalObject& globalObject)
    : JSDOMObject(structure, globalObject) { }

JSObject* JSWritableStream::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWritableStreamPrototype::create(vm, globalObject, JSWritableStreamPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSWritableStream::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWritableStream>(vm, globalObject);
}

void JSWritableStream::destroy(JSC::JSCell* cell)
{
    JSWritableStream* thisObject = static_cast<JSWritableStream*>(cell);
    thisObject->JSWritableStream::~JSWritableStream();
}

EncodedJSValue jsWritableStreamConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSWritableStreamPrototype* domObject = jsDynamicCast<JSWritableStreamPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSWritableStream::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSWritableStreamConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSWritableStreamPrototype* domObject = jsDynamicCast<JSWritableStreamPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSWritableStream::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWritableStreamConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWritableStream::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSWritableStream*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
}


}

#endif // ENABLE(STREAMS_API)
