/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGLength.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsSVGLengthPrototypeFunctionNewValueSpecifiedUnits(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGLengthPrototypeFunctionConvertToSpecifiedUnits(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsSVGLengthUnitType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGLengthValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGLengthValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGLengthValueInSpecifiedUnits(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGLengthValueInSpecifiedUnits(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGLengthValueAsString(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGLengthValueAsString(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGLengthConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGLengthConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGLengthPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSVGLengthPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGLengthPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGLengthPrototype>(vm.heap)) JSSVGLengthPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGLengthPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSSVGLength> JSSVGLengthConstructor;

/* Hash table for constructor */

static const HashTableValue JSSVGLengthConstructorTableValues[] =
{
    { "SVG_LENGTHTYPE_UNKNOWN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_LENGTHTYPE_NUMBER", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_LENGTHTYPE_PERCENTAGE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "SVG_LENGTHTYPE_EMS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "SVG_LENGTHTYPE_EXS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "SVG_LENGTHTYPE_PX", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "SVG_LENGTHTYPE_CM", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "SVG_LENGTHTYPE_MM", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "SVG_LENGTHTYPE_IN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "SVG_LENGTHTYPE_PT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(9) } },
    { "SVG_LENGTHTYPE_PC", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(10) } },
};


COMPILE_ASSERT(0 == SVGLength::SVG_LENGTHTYPE_UNKNOWN, SVGLengthEnumSVG_LENGTHTYPE_UNKNOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == SVGLength::SVG_LENGTHTYPE_NUMBER, SVGLengthEnumSVG_LENGTHTYPE_NUMBERIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == SVGLength::SVG_LENGTHTYPE_PERCENTAGE, SVGLengthEnumSVG_LENGTHTYPE_PERCENTAGEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == SVGLength::SVG_LENGTHTYPE_EMS, SVGLengthEnumSVG_LENGTHTYPE_EMSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == SVGLength::SVG_LENGTHTYPE_EXS, SVGLengthEnumSVG_LENGTHTYPE_EXSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(5 == SVGLength::SVG_LENGTHTYPE_PX, SVGLengthEnumSVG_LENGTHTYPE_PXIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(6 == SVGLength::SVG_LENGTHTYPE_CM, SVGLengthEnumSVG_LENGTHTYPE_CMIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(7 == SVGLength::SVG_LENGTHTYPE_MM, SVGLengthEnumSVG_LENGTHTYPE_MMIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(8 == SVGLength::SVG_LENGTHTYPE_IN, SVGLengthEnumSVG_LENGTHTYPE_INIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(9 == SVGLength::SVG_LENGTHTYPE_PT, SVGLengthEnumSVG_LENGTHTYPE_PTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(10 == SVGLength::SVG_LENGTHTYPE_PC, SVGLengthEnumSVG_LENGTHTYPE_PCIsWrongUseDoNotCheckConstants);

template<> JSValue JSSVGLengthConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGLengthConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGLength::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("SVGLength"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSSVGLengthConstructorTableValues, *this);
}

template<> const ClassInfo JSSVGLengthConstructor::s_info = { "SVGLength", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGLengthConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGLengthPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGLengthConstructor) } },
    { "unitType", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthUnitType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "value", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGLengthValue) } },
    { "valueInSpecifiedUnits", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthValueInSpecifiedUnits), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGLengthValueInSpecifiedUnits) } },
    { "valueAsString", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthValueAsString), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGLengthValueAsString) } },
    { "newValueSpecifiedUnits", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGLengthPrototypeFunctionNewValueSpecifiedUnits), (intptr_t) (2) } },
    { "convertToSpecifiedUnits", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGLengthPrototypeFunctionConvertToSpecifiedUnits), (intptr_t) (1) } },
    { "SVG_LENGTHTYPE_UNKNOWN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_LENGTHTYPE_NUMBER", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_LENGTHTYPE_PERCENTAGE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "SVG_LENGTHTYPE_EMS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "SVG_LENGTHTYPE_EXS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "SVG_LENGTHTYPE_PX", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "SVG_LENGTHTYPE_CM", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "SVG_LENGTHTYPE_MM", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "SVG_LENGTHTYPE_IN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "SVG_LENGTHTYPE_PT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(9) } },
    { "SVG_LENGTHTYPE_PC", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(10) } },
};

const ClassInfo JSSVGLengthPrototype::s_info = { "SVGLengthPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGLengthPrototype) };

void JSSVGLengthPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGLengthPrototypeTableValues, *this);
}

const ClassInfo JSSVGLength::s_info = { "SVGLength", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGLength) };

JSSVGLength::JSSVGLength(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGPropertyTearOff<SVGLength>>&& impl)
    : JSDOMWrapper<SVGPropertyTearOff<SVGLength>>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGLength::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSVGLengthPrototype::create(vm, globalObject, JSSVGLengthPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSSVGLength::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGLength>(vm, globalObject);
}

void JSSVGLength::destroy(JSC::JSCell* cell)
{
    JSSVGLength* thisObject = static_cast<JSSVGLength*>(cell);
    thisObject->JSSVGLength::~JSSVGLength();
}

EncodedJSValue jsSVGLengthUnitType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGLength*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGLength", "unitType");
    }
    SVGLength& impl = castedThis->wrapped().propertyReference();
    JSValue result = jsNumber(impl.unitType());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGLengthValue(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGLength*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGLength", "value");
    }
    return JSValue::encode(castedThis->value(*state));
}


EncodedJSValue jsSVGLengthValueInSpecifiedUnits(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGLength*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGLength", "valueInSpecifiedUnits");
    }
    SVGLength& impl = castedThis->wrapped().propertyReference();
    JSValue result = jsNumber(impl.valueInSpecifiedUnits());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGLengthValueAsString(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGLength*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGLength", "valueAsString");
    }
    SVGLength& impl = castedThis->wrapped().propertyReference();
    JSValue result = jsStringWithCache(state, impl.valueAsString());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGLengthConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSSVGLengthPrototype* domObject = jsDynamicCast<JSSVGLengthPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSSVGLength::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSSVGLengthConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSVGLengthPrototype* domObject = jsDynamicCast<JSSVGLengthPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSSVGLengthValue(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGLength* castedThis = jsDynamicCast<JSSVGLength*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGLength", "value");
        return;
    }
    castedThis->setValue(*state, value);
}


void setJSSVGLengthValueInSpecifiedUnits(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGLength* castedThis = jsDynamicCast<JSSVGLength*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGLength", "valueInSpecifiedUnits");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    SVGLength& podImpl = impl.propertyReference();
    podImpl.setValueInSpecifiedUnits(nativeValue);
    impl.commitChange();
}


void setJSSVGLengthValueAsString(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGLength* castedThis = jsDynamicCast<JSSVGLength*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGLength", "valueAsString");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    SVGLength& podImpl = impl.propertyReference();
    podImpl.setValueAsString(nativeValue, ec);
    setDOMException(state, ec);
    if (!ec)
        impl.commitChange();
}


JSValue JSSVGLength::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGLengthConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGLengthPrototypeFunctionNewValueSpecifiedUnits(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGLength*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGLength", "newValueSpecifiedUnits");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGLength::info());
    auto& impl = castedThis->wrapped();
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGLength& podImpl = impl.propertyReference();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    uint16_t unitType = toUInt16(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float valueInSpecifiedUnits = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    podImpl.newValueSpecifiedUnits(unitType, valueInSpecifiedUnits, ec);
    setDOMException(state, ec);
    if (!ec)
        impl.commitChange();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGLengthPrototypeFunctionConvertToSpecifiedUnits(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGLength*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGLength", "convertToSpecifiedUnits");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGLength::info());
    return JSValue::encode(castedThis->convertToSpecifiedUnits(*state));
}

bool JSSVGLengthOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGLengthOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGLength = jsCast<JSSVGLength*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSVGLength->wrapped(), jsSVGLength);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, SVGPropertyTearOff<SVGLength>* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSSVGLength, SVGPropertyTearOff<SVGLength>>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, SVGPropertyTearOff<SVGLength>* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSVGLength, SVGPropertyTearOff<SVGLength>>(globalObject, impl))
        return result;
    return createNewWrapper<JSSVGLength, SVGPropertyTearOff<SVGLength>>(globalObject, impl);
}

SVGPropertyTearOff<SVGLength>* JSSVGLength::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGLength*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
