/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(LEGACY_NOTIFICATIONS) || ENABLE(NOTIFICATIONS)

#include "JSNotification.h"

#include "CallbackFunction.h"
#include "Document.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSEventListener.h"
#include "JSNotificationPermissionCallback.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

#if ENABLE(LEGACY_NOTIFICATIONS) || ENABLE(NOTIFICATIONS)
#include "Dictionary.h"
#include "URL.h"
#include <runtime/JSString.h>
#endif

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsNotificationPrototypeFunctionShow(JSC::ExecState*);
#if ENABLE(LEGACY_NOTIFICATIONS)
JSC::EncodedJSValue JSC_HOST_CALL jsNotificationPrototypeFunctionCancel(JSC::ExecState*);
#endif
#if ENABLE(NOTIFICATIONS)
JSC::EncodedJSValue JSC_HOST_CALL jsNotificationPrototypeFunctionClose(JSC::ExecState*);
#endif
#if ENABLE(NOTIFICATIONS)
JSC::EncodedJSValue JSC_HOST_CALL jsNotificationConstructorFunctionRequestPermission(JSC::ExecState*);
#endif

// Attributes

#if ENABLE(NOTIFICATIONS)
JSC::EncodedJSValue jsNotificationConstructorPermission(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
JSC::EncodedJSValue jsNotificationOnclick(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSNotificationOnclick(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsNotificationOnclose(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSNotificationOnclose(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsNotificationOndisplay(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSNotificationOndisplay(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsNotificationOnerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSNotificationOnerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsNotificationOnshow(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSNotificationOnshow(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(LEGACY_NOTIFICATIONS)
JSC::EncodedJSValue jsNotificationDir(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSNotificationDir(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(LEGACY_NOTIFICATIONS)
JSC::EncodedJSValue jsNotificationReplaceId(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSNotificationReplaceId(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(NOTIFICATIONS)
JSC::EncodedJSValue jsNotificationTag(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSNotificationTag(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsNotificationConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSNotificationConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSNotificationPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSNotificationPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSNotificationPrototype* ptr = new (NotNull, JSC::allocateCell<JSNotificationPrototype>(vm.heap)) JSNotificationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSNotificationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSNotification> JSNotificationConstructor;

/* Hash table for constructor */

static const HashTableValue JSNotificationConstructorTableValues[] =
{
#if ENABLE(NOTIFICATIONS)
    { "permission", DontDelete | ReadOnly, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationConstructorPermission), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(NOTIFICATIONS)
    { "requestPermission", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNotificationConstructorFunctionRequestPermission), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
};

template<> EncodedJSValue JSC_HOST_CALL JSNotificationConstructor::construct(ExecState* state)
{
    auto* castedThis = jsCast<JSNotificationConstructor*>(state->callee());
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    String title = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    Dictionary options = { state, state->argument(1) };
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwConstructorDocumentUnavailableError(*state, "Notification");
    auto& document = downcast<Document>(*context);
    RefPtr<Notification> object = Notification::create(document, title, options);
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> JSValue JSNotificationConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSNotificationConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSNotification::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("Notification"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSNotificationConstructorTableValues, *this);
}

template<> const ClassInfo JSNotificationConstructor::s_info = { "Notification", &Base::s_info, 0, CREATE_METHOD_TABLE(JSNotificationConstructor) };

/* Hash table for prototype */

static const HashTableValue JSNotificationPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSNotificationConstructor) } },
    { "onclick", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationOnclick), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSNotificationOnclick) } },
    { "onclose", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationOnclose), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSNotificationOnclose) } },
    { "ondisplay", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationOndisplay), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSNotificationOndisplay) } },
    { "onerror", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSNotificationOnerror) } },
    { "onshow", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationOnshow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSNotificationOnshow) } },
#if ENABLE(LEGACY_NOTIFICATIONS)
    { "dir", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationDir), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSNotificationDir) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(LEGACY_NOTIFICATIONS)
    { "replaceId", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationReplaceId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSNotificationReplaceId) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(NOTIFICATIONS)
    { "tag", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationTag), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSNotificationTag) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "show", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNotificationPrototypeFunctionShow), (intptr_t) (0) } },
#if ENABLE(LEGACY_NOTIFICATIONS)
    { "cancel", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNotificationPrototypeFunctionCancel), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(NOTIFICATIONS)
    { "close", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNotificationPrototypeFunctionClose), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
};

const ClassInfo JSNotificationPrototype::s_info = { "NotificationPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSNotificationPrototype) };

void JSNotificationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSNotificationPrototypeTableValues, *this);
}

const ClassInfo JSNotification::s_info = { "Notification", &Base::s_info, 0, CREATE_METHOD_TABLE(JSNotification) };

JSNotification::JSNotification(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Notification>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSNotification::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSNotificationPrototype::create(vm, globalObject, JSNotificationPrototype::createStructure(vm, globalObject, JSEventTarget::getPrototype(vm, globalObject)));
}

JSObject* JSNotification::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSNotification>(vm, globalObject);
}

#if ENABLE(NOTIFICATIONS)
EncodedJSValue jsNotificationConstructorPermission(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringWithCache(state, Notification::permission(scriptContext));
    return JSValue::encode(result);
}

#endif

EncodedJSValue jsNotificationOnclick(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSNotification*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Notification", "onclick");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().clickEvent));
}


EncodedJSValue jsNotificationOnclose(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSNotification*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Notification", "onclose");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().closeEvent));
}


EncodedJSValue jsNotificationOndisplay(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSNotification*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Notification", "ondisplay");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().showEvent));
}


EncodedJSValue jsNotificationOnerror(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSNotification*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Notification", "onerror");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().errorEvent));
}


EncodedJSValue jsNotificationOnshow(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSNotification*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Notification", "onshow");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().showEvent));
}


#if ENABLE(LEGACY_NOTIFICATIONS)
EncodedJSValue jsNotificationDir(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSNotification*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Notification", "dir");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.dir());
    return JSValue::encode(result);
}

#endif

#if ENABLE(LEGACY_NOTIFICATIONS)
EncodedJSValue jsNotificationReplaceId(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSNotification*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Notification", "replaceId");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.replaceId());
    return JSValue::encode(result);
}

#endif

#if ENABLE(NOTIFICATIONS)
EncodedJSValue jsNotificationTag(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSNotification*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Notification", "tag");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.tag());
    return JSValue::encode(result);
}

#endif

EncodedJSValue jsNotificationConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSNotificationPrototype* domObject = jsDynamicCast<JSNotificationPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSNotification::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSNotificationConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSNotificationPrototype* domObject = jsDynamicCast<JSNotificationPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSNotificationOnclick(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSNotification* castedThis = jsDynamicCast<JSNotification*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Notification", "onclick");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().clickEvent, value);
}


void setJSNotificationOnclose(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSNotification* castedThis = jsDynamicCast<JSNotification*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Notification", "onclose");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().closeEvent, value);
}


void setJSNotificationOndisplay(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSNotification* castedThis = jsDynamicCast<JSNotification*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Notification", "ondisplay");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().showEvent, value);
}


void setJSNotificationOnerror(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSNotification* castedThis = jsDynamicCast<JSNotification*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Notification", "onerror");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().errorEvent, value);
}


void setJSNotificationOnshow(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSNotification* castedThis = jsDynamicCast<JSNotification*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Notification", "onshow");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().showEvent, value);
}


#if ENABLE(LEGACY_NOTIFICATIONS)
void setJSNotificationDir(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSNotification* castedThis = jsDynamicCast<JSNotification*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Notification", "dir");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setDir(nativeValue);
}

#endif

#if ENABLE(LEGACY_NOTIFICATIONS)
void setJSNotificationReplaceId(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSNotification* castedThis = jsDynamicCast<JSNotification*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Notification", "replaceId");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setReplaceId(nativeValue);
}

#endif

#if ENABLE(NOTIFICATIONS)
void setJSNotificationTag(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSNotification* castedThis = jsDynamicCast<JSNotification*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Notification", "tag");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setTag(nativeValue);
}

#endif

JSValue JSNotification::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNotificationConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsNotificationPrototypeFunctionShow(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSNotification*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Notification", "show");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNotification::info());
    auto& impl = castedThis->wrapped();
    impl.show();
    return JSValue::encode(jsUndefined());
}

#if ENABLE(LEGACY_NOTIFICATIONS)
EncodedJSValue JSC_HOST_CALL jsNotificationPrototypeFunctionCancel(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSNotification*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Notification", "cancel");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNotification::info());
    auto& impl = castedThis->wrapped();
    impl.cancel();
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(NOTIFICATIONS)
EncodedJSValue JSC_HOST_CALL jsNotificationPrototypeFunctionClose(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSNotification*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Notification", "close");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNotification::info());
    auto& impl = castedThis->wrapped();
    impl.close();
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(NOTIFICATIONS)
EncodedJSValue JSC_HOST_CALL jsNotificationConstructorFunctionRequestPermission(ExecState* state)
{
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    RefPtr<NotificationPermissionCallback> callback;
    if (!state->argument(0).isUndefinedOrNull()) {
        if (!state->uncheckedArgument(0).isFunction())
            return throwArgumentMustBeFunctionError(*state, 0, "callback", "Notification", "requestPermission");
        callback = createFunctionOnlyCallback<JSNotificationPermissionCallback>(state, jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject()), state->uncheckedArgument(0));
    }
    Notification::requestPermission(scriptContext, callback);
    return JSValue::encode(jsUndefined());
}

#endif

void JSNotification::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSNotification*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

bool JSNotificationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsNotification = jsCast<JSNotification*>(handle.slot()->asCell());
    if (jsNotification->wrapped().hasPendingActivity())
        return true;
    if (jsNotification->wrapped().isFiringEventListeners())
        return true;
    UNUSED_PARAM(visitor);
    return false;
}

void JSNotificationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsNotification = jsCast<JSNotification*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsNotification->wrapped(), jsNotification);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Notification@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12NotificationE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, Notification* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSNotification>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, Notification* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSNotification>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7Notification@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12NotificationE[2];
#if COMPILER(CLANG)
    // If this fails Notification does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(Notification), Notification_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // Notification has subclasses. If Notification has subclasses that get passed
    // to toJS() we currently require Notification you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSNotification>(globalObject, impl);
}

Notification* JSNotification::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSNotification*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(LEGACY_NOTIFICATIONS) || ENABLE(NOTIFICATIONS)
