/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSMediaError.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsMediaErrorCode(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaErrorConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSMediaErrorConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSMediaErrorPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSMediaErrorPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaErrorPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaErrorPrototype>(vm.heap)) JSMediaErrorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaErrorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSMediaError> JSMediaErrorConstructor;

/* Hash table for constructor */

static const HashTableValue JSMediaErrorConstructorTableValues[] =
{
    { "MEDIA_ERR_ABORTED", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "MEDIA_ERR_NETWORK", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "MEDIA_ERR_DECODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "MEDIA_ERR_SRC_NOT_SUPPORTED", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
};


COMPILE_ASSERT(1 == MediaError::MEDIA_ERR_ABORTED, MediaErrorEnumMEDIA_ERR_ABORTEDIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == MediaError::MEDIA_ERR_NETWORK, MediaErrorEnumMEDIA_ERR_NETWORKIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == MediaError::MEDIA_ERR_DECODE, MediaErrorEnumMEDIA_ERR_DECODEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == MediaError::MEDIA_ERR_SRC_NOT_SUPPORTED, MediaErrorEnumMEDIA_ERR_SRC_NOT_SUPPORTEDIsWrongUseDoNotCheckConstants);

template<> JSValue JSMediaErrorConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSMediaErrorConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMediaError::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("MediaError"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSMediaErrorConstructorTableValues, *this);
}

template<> const ClassInfo JSMediaErrorConstructor::s_info = { "MediaError", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMediaErrorConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMediaErrorPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaErrorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaErrorConstructor) } },
    { "code", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaErrorCode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "MEDIA_ERR_ABORTED", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "MEDIA_ERR_NETWORK", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "MEDIA_ERR_DECODE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "MEDIA_ERR_SRC_NOT_SUPPORTED", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
};

const ClassInfo JSMediaErrorPrototype::s_info = { "MediaErrorPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMediaErrorPrototype) };

void JSMediaErrorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaErrorPrototypeTableValues, *this);
}

const ClassInfo JSMediaError::s_info = { "MediaError", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMediaError) };

JSMediaError::JSMediaError(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaError>&& impl)
    : JSDOMWrapper<MediaError>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSMediaError::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSMediaErrorPrototype::create(vm, globalObject, JSMediaErrorPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSMediaError::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMediaError>(vm, globalObject);
}

void JSMediaError::destroy(JSC::JSCell* cell)
{
    JSMediaError* thisObject = static_cast<JSMediaError*>(cell);
    thisObject->JSMediaError::~JSMediaError();
}

EncodedJSValue jsMediaErrorCode(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaError*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaError", "code");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.code());
    return JSValue::encode(result);
}


EncodedJSValue jsMediaErrorConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSMediaErrorPrototype* domObject = jsDynamicCast<JSMediaErrorPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSMediaError::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSMediaErrorConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSMediaErrorPrototype* domObject = jsDynamicCast<JSMediaErrorPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSMediaError::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaErrorConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSMediaErrorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSMediaErrorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaError = jsCast<JSMediaError*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMediaError->wrapped(), jsMediaError);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, MediaError* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSMediaError>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, MediaError* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSMediaError>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to MediaError.
    COMPILE_ASSERT(!__is_polymorphic(MediaError), MediaError_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSMediaError>(globalObject, impl);
}

MediaError* JSMediaError::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaError*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO)
