/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBObjectStore.h"

#include "DOMStringList.h"
#include "ExceptionCode.h"
#include "IDBAny.h"
#include "IDBIndex.h"
#include "IDBRequest.h"
#include "IDBTransaction.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMStringList.h"
#include "JSIDBAny.h"
#include "JSIDBIndex.h"
#include "JSIDBKeyRange.h"
#include "JSIDBRequest.h"
#include "JSIDBTransaction.h"
#include "URL.h"
#include <bindings/ScriptValue.h>
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionPut(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionAdd(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionDelete(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionGet(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionClear(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionOpenCursor(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionCreateIndex(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionIndex(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionDeleteIndex(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionCount(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsIDBObjectStoreName(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBObjectStoreKeyPath(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBObjectStoreIndexNames(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBObjectStoreTransaction(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBObjectStoreAutoIncrement(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBObjectStoreConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSIDBObjectStoreConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSIDBObjectStorePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSIDBObjectStorePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIDBObjectStorePrototype* ptr = new (NotNull, JSC::allocateCell<JSIDBObjectStorePrototype>(vm.heap)) JSIDBObjectStorePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIDBObjectStorePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSIDBObjectStore> JSIDBObjectStoreConstructor;

template<> JSValue JSIDBObjectStoreConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSIDBObjectStoreConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSIDBObjectStore::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("IDBObjectStore"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSIDBObjectStoreConstructor::s_info = { "IDBObjectStore", &Base::s_info, 0, CREATE_METHOD_TABLE(JSIDBObjectStoreConstructor) };

/* Hash table for prototype */

static const HashTableValue JSIDBObjectStorePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBObjectStoreConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIDBObjectStoreConstructor) } },
    { "name", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBObjectStoreName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "keyPath", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBObjectStoreKeyPath), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "indexNames", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBObjectStoreIndexNames), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "transaction", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBObjectStoreTransaction), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "autoIncrement", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBObjectStoreAutoIncrement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "put", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsIDBObjectStorePrototypeFunctionPut), (intptr_t) (1) } },
    { "add", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsIDBObjectStorePrototypeFunctionAdd), (intptr_t) (1) } },
    { "delete", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsIDBObjectStorePrototypeFunctionDelete), (intptr_t) (1) } },
    { "get", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsIDBObjectStorePrototypeFunctionGet), (intptr_t) (1) } },
    { "clear", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsIDBObjectStorePrototypeFunctionClear), (intptr_t) (0) } },
    { "openCursor", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsIDBObjectStorePrototypeFunctionOpenCursor), (intptr_t) (0) } },
    { "createIndex", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsIDBObjectStorePrototypeFunctionCreateIndex), (intptr_t) (2) } },
    { "index", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsIDBObjectStorePrototypeFunctionIndex), (intptr_t) (1) } },
    { "deleteIndex", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsIDBObjectStorePrototypeFunctionDeleteIndex), (intptr_t) (1) } },
    { "count", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsIDBObjectStorePrototypeFunctionCount), (intptr_t) (0) } },
};

const ClassInfo JSIDBObjectStorePrototype::s_info = { "IDBObjectStorePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSIDBObjectStorePrototype) };

void JSIDBObjectStorePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIDBObjectStorePrototypeTableValues, *this);
}

const ClassInfo JSIDBObjectStore::s_info = { "IDBObjectStore", &Base::s_info, 0, CREATE_METHOD_TABLE(JSIDBObjectStore) };

JSIDBObjectStore::JSIDBObjectStore(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IDBObjectStore>&& impl)
    : JSDOMWrapper<IDBObjectStore>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSIDBObjectStore::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSIDBObjectStorePrototype::create(vm, globalObject, JSIDBObjectStorePrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSIDBObjectStore::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSIDBObjectStore>(vm, globalObject);
}

void JSIDBObjectStore::destroy(JSC::JSCell* cell)
{
    JSIDBObjectStore* thisObject = static_cast<JSIDBObjectStore*>(cell);
    thisObject->JSIDBObjectStore::~JSIDBObjectStore();
}

EncodedJSValue jsIDBObjectStoreName(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSIDBObjectStore*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "IDBObjectStore", "name");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.name());
    return JSValue::encode(result);
}


EncodedJSValue jsIDBObjectStoreKeyPath(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSIDBObjectStore*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "IDBObjectStore", "keyPath");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.keyPathAny()));
    return JSValue::encode(result);
}


EncodedJSValue jsIDBObjectStoreIndexNames(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSIDBObjectStore*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "IDBObjectStore", "indexNames");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.indexNames()));
    return JSValue::encode(result);
}


EncodedJSValue jsIDBObjectStoreTransaction(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSIDBObjectStore*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "IDBObjectStore", "transaction");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.transaction()));
    return JSValue::encode(result);
}


EncodedJSValue jsIDBObjectStoreAutoIncrement(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSIDBObjectStore*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "IDBObjectStore", "autoIncrement");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.autoIncrement());
    return JSValue::encode(result);
}


EncodedJSValue jsIDBObjectStoreConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSIDBObjectStorePrototype* domObject = jsDynamicCast<JSIDBObjectStorePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSIDBObjectStore::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSIDBObjectStoreConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSIDBObjectStorePrototype* domObject = jsDynamicCast<JSIDBObjectStorePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSIDBObjectStore::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBObjectStoreConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionPut(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSIDBObjectStore*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "IDBObjectStore", "put");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSIDBObjectStore::info());
    return JSValue::encode(castedThis->putFunction(*state));
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionAdd(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSIDBObjectStore*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "IDBObjectStore", "add");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSIDBObjectStore::info());
    return JSValue::encode(castedThis->add(*state));
}

static EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionDelete1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSIDBObjectStore*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "IDBObjectStore", "delete");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSIDBObjectStore::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCodeWithMessage ec;
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    IDBKeyRange* keyRange = JSIDBKeyRange::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.deleteFunction(scriptContext, keyRange, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionDelete2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSIDBObjectStore*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "IDBObjectStore", "delete");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSIDBObjectStore::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCodeWithMessage ec;
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    Deprecated::ScriptValue key = { state->vm(), state->argument(0) };
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.deleteFunction(scriptContext, key, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionDelete(ExecState* state)
{
    size_t argsCount = std::min<size_t>(1, state->argumentCount());
    JSValue arg0(state->argument(0));
    if ((argsCount == 1 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSIDBKeyRange::info())))))
        return jsIDBObjectStorePrototypeFunctionDelete1(state);
    if (argsCount == 1)
        return jsIDBObjectStorePrototypeFunctionDelete2(state);
    if (argsCount < 1)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

static EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionGet1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSIDBObjectStore*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "IDBObjectStore", "get");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSIDBObjectStore::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCodeWithMessage ec;
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    IDBKeyRange* key = JSIDBKeyRange::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.get(scriptContext, key, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionGet2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSIDBObjectStore*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "IDBObjectStore", "get");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSIDBObjectStore::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCodeWithMessage ec;
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    Deprecated::ScriptValue key = { state->vm(), state->argument(0) };
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.get(scriptContext, key, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionGet(ExecState* state)
{
    size_t argsCount = std::min<size_t>(1, state->argumentCount());
    JSValue arg0(state->argument(0));
    if ((argsCount == 1 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSIDBKeyRange::info())))))
        return jsIDBObjectStorePrototypeFunctionGet1(state);
    if (argsCount == 1)
        return jsIDBObjectStorePrototypeFunctionGet2(state);
    if (argsCount < 1)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionClear(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSIDBObjectStore*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "IDBObjectStore", "clear");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSIDBObjectStore::info());
    auto& impl = castedThis->wrapped();
    ExceptionCodeWithMessage ec;
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.clear(scriptContext, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionOpenCursor1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSIDBObjectStore*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "IDBObjectStore", "openCursor");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSIDBObjectStore::info());
    auto& impl = castedThis->wrapped();
    ExceptionCodeWithMessage ec;
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 0) {
        JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.openCursor(scriptContext, ec)));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    IDBKeyRange* range = JSIDBKeyRange::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (argsCount <= 1) {
        JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.openCursor(scriptContext, range, ec)));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    String direction = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.openCursor(scriptContext, range, direction, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionOpenCursor2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSIDBObjectStore*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "IDBObjectStore", "openCursor");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSIDBObjectStore::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCodeWithMessage ec;
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    Deprecated::ScriptValue key = { state->vm(), state->argument(0) };
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 1) {
        JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.openCursor(scriptContext, key, ec)));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    String direction = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.openCursor(scriptContext, key, direction, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionOpenCursor(ExecState* state)
{
    size_t argsCount = std::min<size_t>(2, state->argumentCount());
    JSValue arg0(state->argument(0));
    if (argsCount == 0 || (argsCount == 1 && (arg0.isUndefined() || arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSIDBKeyRange::info())))) || (argsCount == 2 && (arg0.isUndefined() || arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSIDBKeyRange::info())))))
        return jsIDBObjectStorePrototypeFunctionOpenCursor1(state);
    if (argsCount == 1 || argsCount == 2)
        return jsIDBObjectStorePrototypeFunctionOpenCursor2(state);
    return throwVMTypeError(state);
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionCreateIndex(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSIDBObjectStore*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "IDBObjectStore", "createIndex");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSIDBObjectStore::info());
    return JSValue::encode(castedThis->createIndex(*state));
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionIndex(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSIDBObjectStore*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "IDBObjectStore", "index");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSIDBObjectStore::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCodeWithMessage ec;
    String name = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.index(name, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionDeleteIndex(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSIDBObjectStore*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "IDBObjectStore", "deleteIndex");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSIDBObjectStore::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCodeWithMessage ec;
    String name = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.deleteIndex(name, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionCount1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSIDBObjectStore*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "IDBObjectStore", "count");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSIDBObjectStore::info());
    auto& impl = castedThis->wrapped();
    ExceptionCodeWithMessage ec;
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 0) {
        JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.count(scriptContext, ec)));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    IDBKeyRange* range = JSIDBKeyRange::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.count(scriptContext, range, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionCount2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSIDBObjectStore*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "IDBObjectStore", "count");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSIDBObjectStore::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCodeWithMessage ec;
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    Deprecated::ScriptValue key = { state->vm(), state->argument(0) };
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.count(scriptContext, key, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionCount(ExecState* state)
{
    size_t argsCount = std::min<size_t>(1, state->argumentCount());
    JSValue arg0(state->argument(0));
    if (argsCount == 0 || (argsCount == 1 && (arg0.isUndefined() || arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSIDBKeyRange::info())))))
        return jsIDBObjectStorePrototypeFunctionCount1(state);
    if (argsCount == 1)
        return jsIDBObjectStorePrototypeFunctionCount2(state);
    return throwVMTypeError(state);
}

void JSIDBObjectStore::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSIDBObjectStore*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

bool JSIDBObjectStoreOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsIDBObjectStore = jsCast<JSIDBObjectStore*>(handle.slot()->asCell());
    IDBObjectStore* root = &jsIDBObjectStore->wrapped();
    return visitor.containsOpaqueRoot(root);
}

void JSIDBObjectStoreOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIDBObjectStore = jsCast<JSIDBObjectStore*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsIDBObjectStore->wrapped(), jsIDBObjectStore);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, IDBObjectStore* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSIDBObjectStore>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, IDBObjectStore* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSIDBObjectStore>(globalObject, impl))
        return result;
    return createNewWrapper<JSIDBObjectStore>(globalObject, impl);
}

IDBObjectStore* JSIDBObjectStore::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIDBObjectStore*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(INDEXED_DATABASE)
