/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLDocument.h"

#include "ExceptionCode.h"
#include "HTMLCollection.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSHTMLCollection.h"
#include "URL.h"
#include "wtf/text/AtomicString.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionClose(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionWrite(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionWriteln(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionClear(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionCaptureEvents(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionReleaseEvents(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsHTMLDocumentEmbeds(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLDocumentPlugins(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLDocumentScripts(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLDocumentAll(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLDocumentAll(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLDocumentDir(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLDocumentDir(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLDocumentDesignMode(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLDocumentDesignMode(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLDocumentCompatMode(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLDocumentBgColor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLDocumentBgColor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLDocumentFgColor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLDocumentFgColor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLDocumentAlinkColor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLDocumentAlinkColor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLDocumentLinkColor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLDocumentLinkColor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLDocumentVlinkColor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLDocumentVlinkColor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLDocumentConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLDocumentConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLDocumentPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSHTMLDocumentPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLDocumentPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLDocumentPrototype>(vm.heap)) JSHTMLDocumentPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLDocumentPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSHTMLDocument> JSHTMLDocumentConstructor;

template<> JSValue JSHTMLDocumentConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSDocument::getConstructor(vm, &globalObject);
}

template<> void JSHTMLDocumentConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLDocument::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("HTMLDocument"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSHTMLDocumentConstructor::s_info = { "HTMLDocument", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLDocumentConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLDocumentPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLDocumentConstructor) } },
    { "embeds", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentEmbeds), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "plugins", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentPlugins), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "scripts", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentScripts), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "all", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentAll), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLDocumentAll) } },
    { "dir", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentDir), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLDocumentDir) } },
    { "designMode", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentDesignMode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLDocumentDesignMode) } },
    { "compatMode", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentCompatMode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "bgColor", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentBgColor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLDocumentBgColor) } },
    { "fgColor", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentFgColor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLDocumentFgColor) } },
    { "alinkColor", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentAlinkColor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLDocumentAlinkColor) } },
    { "linkColor", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentLinkColor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLDocumentLinkColor) } },
    { "vlinkColor", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentVlinkColor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLDocumentVlinkColor) } },
    { "open", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLDocumentPrototypeFunctionOpen), (intptr_t) (0) } },
    { "close", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLDocumentPrototypeFunctionClose), (intptr_t) (0) } },
    { "write", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLDocumentPrototypeFunctionWrite), (intptr_t) (0) } },
    { "writeln", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLDocumentPrototypeFunctionWriteln), (intptr_t) (0) } },
    { "clear", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLDocumentPrototypeFunctionClear), (intptr_t) (0) } },
    { "captureEvents", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLDocumentPrototypeFunctionCaptureEvents), (intptr_t) (0) } },
    { "releaseEvents", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLDocumentPrototypeFunctionReleaseEvents), (intptr_t) (0) } },
};

const ClassInfo JSHTMLDocumentPrototype::s_info = { "HTMLDocumentPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLDocumentPrototype) };

void JSHTMLDocumentPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLDocumentPrototypeTableValues, *this);
}

const ClassInfo JSHTMLDocument::s_info = { "HTMLDocument", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLDocument) };

JSHTMLDocument::JSHTMLDocument(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLDocument>&& impl)
    : JSDocument(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSHTMLDocument::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSHTMLDocumentPrototype::create(vm, globalObject, JSHTMLDocumentPrototype::createStructure(vm, globalObject, JSDocument::getPrototype(vm, globalObject)));
}

JSObject* JSHTMLDocument::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLDocument>(vm, globalObject);
}

bool JSHTMLDocument::getOwnPropertySlotByIndex(JSObject* object, ExecState* state, unsigned index, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSHTMLDocument*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Identifier propertyName = Identifier::from(state, index);
    if (thisObject->classInfo() == info()) {
        JSValue value;
        if (thisObject->nameGetter(state, propertyName, value)) {
            slot.setValue(thisObject, ReadOnly | DontDelete | DontEnum, value);
            return true;
        }
    }
    return Base::getOwnPropertySlotByIndex(thisObject, state, index, slot);
}

EncodedJSValue jsHTMLDocumentEmbeds(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLDocument*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLDocument", "embeds");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.embeds()));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLDocumentPlugins(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLDocument*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLDocument", "plugins");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.plugins()));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLDocumentScripts(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLDocument*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLDocument", "scripts");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.scripts()));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLDocumentAll(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLDocument*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLDocument", "all");
    }
    return JSValue::encode(castedThis->all(*state));
}


EncodedJSValue jsHTMLDocumentDir(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLDocument*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLDocument", "dir");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.dir());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLDocumentDesignMode(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLDocument*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLDocument", "designMode");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.designMode());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLDocumentCompatMode(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLDocument*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLDocument", "compatMode");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.compatMode());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLDocumentBgColor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLDocument*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLDocument", "bgColor");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.bgColor());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLDocumentFgColor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLDocument*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLDocument", "fgColor");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fgColor());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLDocumentAlinkColor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLDocument*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLDocument", "alinkColor");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.alinkColor());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLDocumentLinkColor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLDocument*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLDocument", "linkColor");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.linkColor());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLDocumentVlinkColor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLDocument*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLDocument", "vlinkColor");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.vlinkColor());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLDocumentConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSHTMLDocumentPrototype* domObject = jsDynamicCast<JSHTMLDocumentPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSHTMLDocument::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSHTMLDocumentConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSHTMLDocumentPrototype* domObject = jsDynamicCast<JSHTMLDocumentPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSHTMLDocumentAll(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLDocument* castedThis = jsDynamicCast<JSHTMLDocument*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLDocument", "all");
        return;
    }
    castedThis->setAll(*state, value);
}


void setJSHTMLDocumentDir(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLDocument* castedThis = jsDynamicCast<JSHTMLDocument*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLDocument", "dir");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setDir(nativeValue);
}


void setJSHTMLDocumentDesignMode(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLDocument* castedThis = jsDynamicCast<JSHTMLDocument*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLDocument", "designMode");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setDesignMode(nativeValue);
}


void setJSHTMLDocumentBgColor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLDocument* castedThis = jsDynamicCast<JSHTMLDocument*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLDocument", "bgColor");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setBgColor(nativeValue);
}


void setJSHTMLDocumentFgColor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLDocument* castedThis = jsDynamicCast<JSHTMLDocument*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLDocument", "fgColor");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setFgColor(nativeValue);
}


void setJSHTMLDocumentAlinkColor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLDocument* castedThis = jsDynamicCast<JSHTMLDocument*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLDocument", "alinkColor");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAlinkColor(nativeValue);
}


void setJSHTMLDocumentLinkColor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLDocument* castedThis = jsDynamicCast<JSHTMLDocument*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLDocument", "linkColor");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setLinkColor(nativeValue);
}


void setJSHTMLDocumentVlinkColor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLDocument* castedThis = jsDynamicCast<JSHTMLDocument*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLDocument", "vlinkColor");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setVlinkColor(nativeValue);
}


JSValue JSHTMLDocument::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLDocumentConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionOpen(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLDocument*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLDocument", "open");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLDocument::info());
    return JSValue::encode(castedThis->open(*state));
}

EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionClose(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLDocument*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLDocument", "close");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLDocument::info());
    auto& impl = castedThis->wrapped();
    impl.close();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionWrite(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLDocument*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLDocument", "write");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLDocument::info());
    return JSValue::encode(castedThis->write(*state));
}

EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionWriteln(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLDocument*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLDocument", "writeln");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLDocument::info());
    return JSValue::encode(castedThis->writeln(*state));
}

EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionClear(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLDocument*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLDocument", "clear");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLDocument::info());
    auto& impl = castedThis->wrapped();
    impl.clear();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionCaptureEvents(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLDocument*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLDocument", "captureEvents");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLDocument::info());
    auto& impl = castedThis->wrapped();
    impl.captureEvents();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionReleaseEvents(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLDocument*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLDocument", "releaseEvents");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLDocument::info());
    auto& impl = castedThis->wrapped();
    impl.releaseEvents();
    return JSValue::encode(jsUndefined());
}

void JSHTMLDocument::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSHTMLDocument*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}


}
