/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSEventSource.h"

#include "Dictionary.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSEventListener.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsEventSourcePrototypeFunctionClose(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsEventSourceURL(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsEventSourceUrl(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsEventSourceWithCredentials(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsEventSourceReadyState(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsEventSourceOnopen(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSEventSourceOnopen(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsEventSourceOnmessage(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSEventSourceOnmessage(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsEventSourceOnerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSEventSourceOnerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsEventSourceConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSEventSourceConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSEventSourcePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSEventSourcePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEventSourcePrototype* ptr = new (NotNull, JSC::allocateCell<JSEventSourcePrototype>(vm.heap)) JSEventSourcePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEventSourcePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSEventSource> JSEventSourceConstructor;

/* Hash table for constructor */

static const HashTableValue JSEventSourceConstructorTableValues[] =
{
    { "CONNECTING", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "OPEN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CLOSED", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
};


COMPILE_ASSERT(0 == EventSource::CONNECTING, EventSourceEnumCONNECTINGIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == EventSource::OPEN, EventSourceEnumOPENIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == EventSource::CLOSED, EventSourceEnumCLOSEDIsWrongUseDoNotCheckConstants);

template<> EncodedJSValue JSC_HOST_CALL JSEventSourceConstructor::construct(ExecState* state)
{
    auto* castedThis = jsCast<JSEventSourceConstructor*>(state->callee());
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String url = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    Dictionary eventSourceInit = { state, state->argument(1) };
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwConstructorDocumentUnavailableError(*state, "EventSource");
    RefPtr<EventSource> object = EventSource::create(*context, url, eventSourceInit, ec);
    if (ec) {
        setDOMException(state, ec);
        return JSValue::encode(JSValue());
    }
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> JSValue JSEventSourceConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSEventSourceConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSEventSource::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("EventSource"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSEventSourceConstructorTableValues, *this);
}

template<> const ClassInfo JSEventSourceConstructor::s_info = { "EventSource", &Base::s_info, 0, CREATE_METHOD_TABLE(JSEventSourceConstructor) };

/* Hash table for prototype */

static const HashTableValue JSEventSourcePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventSourceConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSEventSourceConstructor) } },
    { "URL", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventSourceURL), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "url", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventSourceUrl), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "withCredentials", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventSourceWithCredentials), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "readyState", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventSourceReadyState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onopen", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventSourceOnopen), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSEventSourceOnopen) } },
    { "onmessage", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventSourceOnmessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSEventSourceOnmessage) } },
    { "onerror", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventSourceOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSEventSourceOnerror) } },
    { "close", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsEventSourcePrototypeFunctionClose), (intptr_t) (0) } },
    { "CONNECTING", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "OPEN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CLOSED", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
};

const ClassInfo JSEventSourcePrototype::s_info = { "EventSourcePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSEventSourcePrototype) };

void JSEventSourcePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSEventSourcePrototypeTableValues, *this);
}

const ClassInfo JSEventSource::s_info = { "EventSource", &Base::s_info, 0, CREATE_METHOD_TABLE(JSEventSource) };

JSEventSource::JSEventSource(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EventSource>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSEventSource::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSEventSourcePrototype::create(vm, globalObject, JSEventSourcePrototype::createStructure(vm, globalObject, JSEventTarget::getPrototype(vm, globalObject)));
}

JSObject* JSEventSource::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSEventSource>(vm, globalObject);
}

EncodedJSValue jsEventSourceURL(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSEventSource*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "EventSource", "URL");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.url());
    return JSValue::encode(result);
}


EncodedJSValue jsEventSourceUrl(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSEventSource*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "EventSource", "url");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.url());
    return JSValue::encode(result);
}


EncodedJSValue jsEventSourceWithCredentials(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSEventSource*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "EventSource", "withCredentials");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.withCredentials());
    return JSValue::encode(result);
}


EncodedJSValue jsEventSourceReadyState(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSEventSource*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "EventSource", "readyState");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.readyState());
    return JSValue::encode(result);
}


EncodedJSValue jsEventSourceOnopen(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSEventSource*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "EventSource", "onopen");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().openEvent));
}


EncodedJSValue jsEventSourceOnmessage(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSEventSource*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "EventSource", "onmessage");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().messageEvent));
}


EncodedJSValue jsEventSourceOnerror(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSEventSource*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "EventSource", "onerror");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().errorEvent));
}


EncodedJSValue jsEventSourceConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSEventSourcePrototype* domObject = jsDynamicCast<JSEventSourcePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSEventSource::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSEventSourceConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSEventSourcePrototype* domObject = jsDynamicCast<JSEventSourcePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSEventSourceOnopen(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSEventSource* castedThis = jsDynamicCast<JSEventSource*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "EventSource", "onopen");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().openEvent, value);
}


void setJSEventSourceOnmessage(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSEventSource* castedThis = jsDynamicCast<JSEventSource*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "EventSource", "onmessage");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().messageEvent, value);
}


void setJSEventSourceOnerror(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSEventSource* castedThis = jsDynamicCast<JSEventSource*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "EventSource", "onerror");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().errorEvent, value);
}


JSValue JSEventSource::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSEventSourceConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsEventSourcePrototypeFunctionClose(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSEventSource*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "EventSource", "close");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSEventSource::info());
    auto& impl = castedThis->wrapped();
    impl.close();
    return JSValue::encode(jsUndefined());
}

void JSEventSource::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSEventSource*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

bool JSEventSourceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsEventSource = jsCast<JSEventSource*>(handle.slot()->asCell());
    if (jsEventSource->wrapped().hasPendingActivity())
        return true;
    if (jsEventSource->wrapped().isFiringEventListeners())
        return true;
    UNUSED_PARAM(visitor);
    return false;
}

void JSEventSourceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEventSource = jsCast<JSEventSource*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsEventSource->wrapped(), jsEventSource);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EventSource@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11EventSourceE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, EventSource* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSEventSource>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, EventSource* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSEventSource>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7EventSource@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore11EventSourceE[2];
#if COMPILER(CLANG)
    // If this fails EventSource does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(EventSource), EventSource_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // EventSource has subclasses. If EventSource has subclasses that get passed
    // to toJS() we currently require EventSource you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSEventSource>(globalObject, impl);
}

EventSource* JSEventSource::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEventSource*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
