/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSDynamicsCompressorNode.h"

#include "AudioParam.h"
#include "JSAudioParam.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsDynamicsCompressorNodeThreshold(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDynamicsCompressorNodeKnee(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDynamicsCompressorNodeRatio(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDynamicsCompressorNodeReduction(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDynamicsCompressorNodeAttack(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDynamicsCompressorNodeRelease(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDynamicsCompressorNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDynamicsCompressorNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSDynamicsCompressorNodePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSDynamicsCompressorNodePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDynamicsCompressorNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSDynamicsCompressorNodePrototype>(vm.heap)) JSDynamicsCompressorNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDynamicsCompressorNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSDynamicsCompressorNode> JSDynamicsCompressorNodeConstructor;

template<> JSValue JSDynamicsCompressorNodeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSDynamicsCompressorNodeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDynamicsCompressorNode::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("DynamicsCompressorNode"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSDynamicsCompressorNodeConstructor::s_info = { "DynamicsCompressorNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDynamicsCompressorNodeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDynamicsCompressorNodePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDynamicsCompressorNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDynamicsCompressorNodeConstructor) } },
    { "threshold", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDynamicsCompressorNodeThreshold), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "knee", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDynamicsCompressorNodeKnee), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "ratio", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDynamicsCompressorNodeRatio), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "reduction", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDynamicsCompressorNodeReduction), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "attack", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDynamicsCompressorNodeAttack), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "release", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDynamicsCompressorNodeRelease), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSDynamicsCompressorNodePrototype::s_info = { "DynamicsCompressorNodePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDynamicsCompressorNodePrototype) };

void JSDynamicsCompressorNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDynamicsCompressorNodePrototypeTableValues, *this);
}

const ClassInfo JSDynamicsCompressorNode::s_info = { "DynamicsCompressorNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDynamicsCompressorNode) };

JSDynamicsCompressorNode::JSDynamicsCompressorNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DynamicsCompressorNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSDynamicsCompressorNode::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSDynamicsCompressorNodePrototype::create(vm, globalObject, JSDynamicsCompressorNodePrototype::createStructure(vm, globalObject, JSAudioNode::getPrototype(vm, globalObject)));
}

JSObject* JSDynamicsCompressorNode::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDynamicsCompressorNode>(vm, globalObject);
}

EncodedJSValue jsDynamicsCompressorNodeThreshold(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDynamicsCompressorNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DynamicsCompressorNode", "threshold");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.threshold()));
    return JSValue::encode(result);
}


EncodedJSValue jsDynamicsCompressorNodeKnee(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDynamicsCompressorNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DynamicsCompressorNode", "knee");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.knee()));
    return JSValue::encode(result);
}


EncodedJSValue jsDynamicsCompressorNodeRatio(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDynamicsCompressorNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DynamicsCompressorNode", "ratio");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.ratio()));
    return JSValue::encode(result);
}


EncodedJSValue jsDynamicsCompressorNodeReduction(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDynamicsCompressorNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DynamicsCompressorNode", "reduction");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.reduction()));
    return JSValue::encode(result);
}


EncodedJSValue jsDynamicsCompressorNodeAttack(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDynamicsCompressorNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DynamicsCompressorNode", "attack");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.attack()));
    return JSValue::encode(result);
}


EncodedJSValue jsDynamicsCompressorNodeRelease(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDynamicsCompressorNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DynamicsCompressorNode", "release");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.release()));
    return JSValue::encode(result);
}


EncodedJSValue jsDynamicsCompressorNodeConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSDynamicsCompressorNodePrototype* domObject = jsDynamicCast<JSDynamicsCompressorNodePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSDynamicsCompressorNode::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSDynamicsCompressorNodeConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSDynamicsCompressorNodePrototype* domObject = jsDynamicCast<JSDynamicsCompressorNodePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSDynamicsCompressorNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDynamicsCompressorNodeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDynamicsCompressorNode::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSDynamicsCompressorNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DynamicsCompressorNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22DynamicsCompressorNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, DynamicsCompressorNode* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSDynamicsCompressorNode>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, DynamicsCompressorNode* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSDynamicsCompressorNode>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7DynamicsCompressorNode@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore22DynamicsCompressorNodeE[2];
#if COMPILER(CLANG)
    // If this fails DynamicsCompressorNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(DynamicsCompressorNode), DynamicsCompressorNode_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // DynamicsCompressorNode has subclasses. If DynamicsCompressorNode has subclasses that get passed
    // to toJS() we currently require DynamicsCompressorNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSDynamicsCompressorNode>(globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
