/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDocument.h"

#include "Attr.h"
#include "CDATASection.h"
#include "CSSStyleDeclaration.h"
#include "CanvasRenderingContext.h"
#include "Comment.h"
#include "DOMImplementation.h"
#include "DOMNamedFlowCollection.h"
#include "DOMSelection.h"
#include "DOMWindow.h"
#include "DocumentFragment.h"
#include "DocumentType.h"
#include "Element.h"
#include "Event.h"
#include "ExceptionCode.h"
#include "HTMLCollection.h"
#include "HTMLElement.h"
#include "HTMLHeadElement.h"
#include "HTMLScriptElement.h"
#include "JSAttr.h"
#include "JSCDATASection.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCanvasRenderingContext.h"
#include "JSComment.h"
#include "JSCustomXPathNSResolver.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMImplementation.h"
#include "JSDOMSelection.h"
#include "JSDOMWindow.h"
#include "JSDocumentFragment.h"
#include "JSDocumentType.h"
#include "JSElement.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSEventTarget.h"
#include "JSHTMLCollection.h"
#include "JSHTMLElement.h"
#include "JSHTMLHeadElement.h"
#include "JSHTMLScriptElement.h"
#include "JSLocation.h"
#include "JSNode.h"
#include "JSNodeFilter.h"
#include "JSNodeIterator.h"
#include "JSNodeList.h"
#include "JSProcessingInstruction.h"
#include "JSRange.h"
#include "JSStyleSheetList.h"
#include "JSText.h"
#include "JSTouch.h"
#include "JSTreeWalker.h"
#include "JSXPathExpression.h"
#include "JSXPathNSResolver.h"
#include "JSXPathResult.h"
#include "Location.h"
#include "NameNodeList.h"
#include "Node.h"
#include "NodeIterator.h"
#include "NodeList.h"
#include "ProcessingInstruction.h"
#include "Range.h"
#include "StyleProperties.h"
#include "StyleSheetList.h"
#include "Text.h"
#include "Touch.h"
#include "TreeWalker.h"
#include "URL.h"
#include "XPathExpression.h"
#include "XPathNSResolver.h"
#include "XPathResult.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

#if ENABLE(CSS_REGIONS)
#include "JSDOMNamedFlowCollection.h"
#endif

#if ENABLE(FONT_LOAD_EVENTS)
#include "FontLoader.h"
#include "JSFontLoader.h"
#endif

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateElement(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateDocumentFragment(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTextNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateComment(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateCDATASection(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateProcessingInstruction(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateAttribute(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByTagName(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionImportNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateElementNS(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateAttributeNS(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByTagNameNS(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionAdoptNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateEvent(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateRange(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateNodeIterator(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTreeWalker(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetOverrideStyle(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateExpression(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateNSResolver(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionEvaluate(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionExecCommand(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandEnabled(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandIndeterm(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandState(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandSupported(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandValue(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByName(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionElementFromPoint(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCaretRangeFromPoint(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetSelection(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetCSSCanvasContext(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByClassName(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionHasFocus(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionWebkitCancelFullScreen(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionWebkitExitFullscreen(JSC::ExecState*);
#if ENABLE(POINTER_LOCK)
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionExitPointerLock(JSC::ExecState*);
#endif
#if ENABLE(CSS_REGIONS)
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionWebkitGetNamedFlows(JSC::ExecState*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTouch(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTouchList(JSC::ExecState*);
#if ENABLE(CUSTOM_ELEMENTS)
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionDefineCustomElement(JSC::ExecState*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementById(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionPrepend(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionAppend(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQuerySelector(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQuerySelectorAll(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsDocumentDoctype(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentImplementation(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentDocumentElement(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentInputEncoding(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentXMLEncoding(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentXMLVersion(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentXMLVersion(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentXMLStandalone(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentXMLStandalone(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentDocumentURI(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentDefaultView(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentStyleSheets(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentContentType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentTitle(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentTitle(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentReferrer(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentDomain(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentDomain(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentURL(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentCookie(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentCookie(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentBody(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentBody(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentHead(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentImages(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentApplets(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentLinks(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentForms(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentAnchors(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentLastModified(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentLocation(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentLocation(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentCharset(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentDefaultCharset(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentReadyState(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentCharacterSet(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentPreferredStylesheetSet(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentSelectedStylesheetSet(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentSelectedStylesheetSet(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentActiveElement(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentCompatMode(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentWebkitIsFullScreen(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentWebkitFullScreenKeyboardInputAllowed(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentWebkitCurrentFullScreenElement(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentWebkitFullscreenEnabled(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentWebkitFullscreenElement(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(POINTER_LOCK)
JSC::EncodedJSValue jsDocumentPointerLockElement(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(FONT_LOAD_EVENTS)
JSC::EncodedJSValue jsDocumentFonts(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
JSC::EncodedJSValue jsDocumentVisibilityState(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentHidden(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentCurrentScript(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentOrigin(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentScrollingElement(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentOnbeforecopy(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnbeforecopy(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnbeforecut(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnbeforecut(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnbeforepaste(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnbeforepaste(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOncopy(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOncopy(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOncut(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOncut(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnpaste(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnpaste(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnselectstart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnselectstart(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(FULLSCREEN_API)
JSC::EncodedJSValue jsDocumentOnwebkitfullscreenchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnwebkitfullscreenchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(FULLSCREEN_API)
JSC::EncodedJSValue jsDocumentOnwebkitfullscreenerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnwebkitfullscreenerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDocumentOnselectionchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnselectionchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnreadystatechange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnreadystatechange(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(CSP_NEXT)
JSC::EncodedJSValue jsDocumentOnsecuritypolicyviolation(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnsecuritypolicyviolation(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(POINTER_LOCK)
JSC::EncodedJSValue jsDocumentOnpointerlockchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnpointerlockchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(POINTER_LOCK)
JSC::EncodedJSValue jsDocumentOnpointerlockerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnpointerlockerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDocumentOnabort(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnabort(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(REQUEST_AUTOCOMPLETE)
JSC::EncodedJSValue jsDocumentOnautocomplete(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnautocomplete(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(REQUEST_AUTOCOMPLETE)
JSC::EncodedJSValue jsDocumentOnautocompleteerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnautocompleteerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDocumentOnblur(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnblur(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOncanplay(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOncanplay(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOncanplaythrough(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOncanplaythrough(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnclick(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnclick(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOncontextmenu(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOncontextmenu(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOndblclick(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOndblclick(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOndrag(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOndrag(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOndragend(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOndragend(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOndragenter(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOndragenter(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOndragleave(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOndragleave(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOndragover(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOndragover(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOndragstart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOndragstart(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOndrop(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOndrop(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOndurationchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOndurationchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnemptied(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnemptied(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnended(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnended(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnfocus(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnfocus(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOninput(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOninput(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOninvalid(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOninvalid(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnkeydown(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnkeydown(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnkeypress(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnkeypress(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnkeyup(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnkeyup(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnload(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnload(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnloadeddata(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnloadeddata(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnloadedmetadata(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnloadedmetadata(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnloadstart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnloadstart(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnmousedown(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnmousedown(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnmouseenter(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnmouseenter(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnmouseleave(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnmouseleave(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnmousemove(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnmousemove(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnmouseout(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnmouseout(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnmouseover(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnmouseover(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnmouseup(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnmouseup(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnmousewheel(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnmousewheel(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnpause(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnpause(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnplay(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnplay(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnplaying(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnplaying(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnprogress(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnprogress(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnratechange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnratechange(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnreset(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnreset(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnresize(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnresize(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnscroll(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnscroll(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnseeked(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnseeked(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnseeking(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnseeking(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnselect(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnselect(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnstalled(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnstalled(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnsubmit(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnsubmit(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnsuspend(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnsuspend(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOntimeupdate(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOntimeupdate(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnvolumechange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnvolumechange(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnwaiting(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnwaiting(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnsearch(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnsearch(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnwheel(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnwheel(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsDocumentOntouchcancel(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOntouchcancel(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsDocumentOntouchend(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOntouchend(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsDocumentOntouchmove(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOntouchmove(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsDocumentOntouchstart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOntouchstart(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsDocumentOnwebkitmouseforcechanged(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnwebkitmouseforcechanged(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsDocumentOnwebkitmouseforcedown(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnwebkitmouseforcedown(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsDocumentOnwebkitmouseforcewillbegin(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnwebkitmouseforcewillbegin(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsDocumentOnwebkitmouseforceup(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnwebkitmouseforceup(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
JSC::EncodedJSValue jsDocumentOnwebkitwillrevealbottom(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnwebkitwillrevealbottom(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
JSC::EncodedJSValue jsDocumentOnwebkitwillrevealleft(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnwebkitwillrevealleft(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
JSC::EncodedJSValue jsDocumentOnwebkitwillrevealright(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnwebkitwillrevealright(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
JSC::EncodedJSValue jsDocumentOnwebkitwillrevealtop(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentOnwebkitwillrevealtop(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDocumentChildren(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentFirstElementChild(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentLastElementChild(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentChildElementCount(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDocumentConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSDocumentPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSDocumentPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDocumentPrototype* ptr = new (NotNull, JSC::allocateCell<JSDocumentPrototype>(vm.heap)) JSDocumentPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDocumentPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSDocument> JSDocumentConstructor;

/* Hash table */

static const struct CompactHashIndex JSDocumentTableIndex[2] = {
    { 0, -1 },
    { -1, -1 },
};


static const HashTableValue JSDocumentTableValues[] =
{
    { "location", DontDelete | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentLocation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentLocation) } },
};

static const HashTable JSDocumentTable = { 1, 1, true, JSDocumentTableValues, JSDocumentTableIndex };
template<> EncodedJSValue JSC_HOST_CALL JSDocumentConstructor::construct(ExecState* state)
{
    auto* castedThis = jsCast<JSDocumentConstructor*>(state->callee());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwConstructorDocumentUnavailableError(*state, "Document");
    RefPtr<Document> object = Document::create(*context);
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> JSValue JSDocumentConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSNode::getConstructor(vm, &globalObject);
}

template<> void JSDocumentConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDocument::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("Document"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSDocumentConstructor::s_info = { "Document", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDocumentConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDocumentPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentConstructor) } },
    { "doctype", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDoctype), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "implementation", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentImplementation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "documentElement", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDocumentElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "inputEncoding", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentInputEncoding), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "xmlEncoding", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentXMLEncoding), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "xmlVersion", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentXMLVersion), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentXMLVersion) } },
    { "xmlStandalone", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentXMLStandalone), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentXMLStandalone) } },
    { "documentURI", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDocumentURI), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "defaultView", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDefaultView), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "styleSheets", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentStyleSheets), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "contentType", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentContentType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "title", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentTitle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentTitle) } },
    { "referrer", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentReferrer), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "domain", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDomain), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentDomain) } },
    { "URL", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentURL), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "cookie", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentCookie), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentCookie) } },
    { "body", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentBody), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentBody) } },
    { "head", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentHead), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "images", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentImages), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "applets", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentApplets), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "links", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentLinks), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "forms", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentForms), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "anchors", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentAnchors), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "lastModified", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentLastModified), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "charset", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentCharset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "defaultCharset", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDefaultCharset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "readyState", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentReadyState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "characterSet", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentCharacterSet), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "preferredStylesheetSet", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentPreferredStylesheetSet), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "selectedStylesheetSet", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentSelectedStylesheetSet), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentSelectedStylesheetSet) } },
    { "activeElement", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentActiveElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "compatMode", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentCompatMode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "webkitIsFullScreen", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentWebkitIsFullScreen), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "webkitFullScreenKeyboardInputAllowed", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentWebkitFullScreenKeyboardInputAllowed), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "webkitCurrentFullScreenElement", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentWebkitCurrentFullScreenElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "webkitFullscreenEnabled", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentWebkitFullscreenEnabled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "webkitFullscreenElement", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentWebkitFullscreenElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(POINTER_LOCK)
    { "pointerLockElement", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentPointerLockElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(FONT_LOAD_EVENTS)
    { "fonts", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentFonts), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "visibilityState", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentVisibilityState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "hidden", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentHidden), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "currentScript", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentCurrentScript), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "origin", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOrigin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "scrollingElement", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentScrollingElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onbeforecopy", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnbeforecopy), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnbeforecopy) } },
    { "onbeforecut", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnbeforecut), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnbeforecut) } },
    { "onbeforepaste", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnbeforepaste), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnbeforepaste) } },
    { "oncopy", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOncopy), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOncopy) } },
    { "oncut", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOncut), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOncut) } },
    { "onpaste", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnpaste), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnpaste) } },
    { "onselectstart", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnselectstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnselectstart) } },
#if ENABLE(FULLSCREEN_API)
    { "onwebkitfullscreenchange", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwebkitfullscreenchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnwebkitfullscreenchange) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "onwebkitfullscreenerror", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwebkitfullscreenerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnwebkitfullscreenerror) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "onselectionchange", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnselectionchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnselectionchange) } },
    { "onreadystatechange", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnreadystatechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnreadystatechange) } },
#if ENABLE(CSP_NEXT)
    { "onsecuritypolicyviolation", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnsecuritypolicyviolation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnsecuritypolicyviolation) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(POINTER_LOCK)
    { "onpointerlockchange", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnpointerlockchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnpointerlockchange) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(POINTER_LOCK)
    { "onpointerlockerror", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnpointerlockerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnpointerlockerror) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "onabort", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnabort), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnabort) } },
#if ENABLE(REQUEST_AUTOCOMPLETE)
    { "onautocomplete", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnautocomplete), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnautocomplete) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(REQUEST_AUTOCOMPLETE)
    { "onautocompleteerror", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnautocompleteerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnautocompleteerror) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "onblur", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnblur), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnblur) } },
    { "oncanplay", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOncanplay), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOncanplay) } },
    { "oncanplaythrough", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOncanplaythrough), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOncanplaythrough) } },
    { "onchange", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnchange) } },
    { "onclick", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnclick), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnclick) } },
    { "oncontextmenu", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOncontextmenu), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOncontextmenu) } },
    { "ondblclick", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndblclick), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOndblclick) } },
    { "ondrag", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndrag), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOndrag) } },
    { "ondragend", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOndragend) } },
    { "ondragenter", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragenter), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOndragenter) } },
    { "ondragleave", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragleave), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOndragleave) } },
    { "ondragover", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragover), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOndragover) } },
    { "ondragstart", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOndragstart) } },
    { "ondrop", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndrop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOndrop) } },
    { "ondurationchange", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndurationchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOndurationchange) } },
    { "onemptied", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnemptied), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnemptied) } },
    { "onended", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnended), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnended) } },
    { "onerror", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnerror) } },
    { "onfocus", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnfocus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnfocus) } },
    { "oninput", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOninput), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOninput) } },
    { "oninvalid", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOninvalid), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOninvalid) } },
    { "onkeydown", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnkeydown), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnkeydown) } },
    { "onkeypress", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnkeypress), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnkeypress) } },
    { "onkeyup", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnkeyup), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnkeyup) } },
    { "onload", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnload) } },
    { "onloadeddata", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnloadeddata), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnloadeddata) } },
    { "onloadedmetadata", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnloadedmetadata), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnloadedmetadata) } },
    { "onloadstart", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnloadstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnloadstart) } },
    { "onmousedown", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmousedown), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnmousedown) } },
    { "onmouseenter", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmouseenter), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnmouseenter) } },
    { "onmouseleave", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmouseleave), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnmouseleave) } },
    { "onmousemove", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmousemove), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnmousemove) } },
    { "onmouseout", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmouseout), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnmouseout) } },
    { "onmouseover", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmouseover), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnmouseover) } },
    { "onmouseup", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmouseup), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnmouseup) } },
    { "onmousewheel", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmousewheel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnmousewheel) } },
    { "onpause", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnpause), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnpause) } },
    { "onplay", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnplay), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnplay) } },
    { "onplaying", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnplaying), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnplaying) } },
    { "onprogress", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnprogress), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnprogress) } },
    { "onratechange", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnratechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnratechange) } },
    { "onreset", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnreset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnreset) } },
    { "onresize", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnresize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnresize) } },
    { "onscroll", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnscroll), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnscroll) } },
    { "onseeked", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnseeked), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnseeked) } },
    { "onseeking", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnseeking), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnseeking) } },
    { "onselect", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnselect), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnselect) } },
    { "onstalled", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnstalled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnstalled) } },
    { "onsubmit", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnsubmit), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnsubmit) } },
    { "onsuspend", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnsuspend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnsuspend) } },
    { "ontimeupdate", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntimeupdate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOntimeupdate) } },
    { "onvolumechange", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnvolumechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnvolumechange) } },
    { "onwaiting", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwaiting), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnwaiting) } },
    { "onsearch", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnsearch), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnsearch) } },
    { "onwheel", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwheel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnwheel) } },
#if ENABLE(TOUCH_EVENTS)
    { "ontouchcancel", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntouchcancel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOntouchcancel) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchend", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntouchend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOntouchend) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchmove", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntouchmove), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOntouchmove) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchstart", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntouchstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOntouchstart) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforcechanged", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwebkitmouseforcechanged), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnwebkitmouseforcechanged) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforcedown", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwebkitmouseforcedown), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnwebkitmouseforcedown) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforcewillbegin", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwebkitmouseforcewillbegin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnwebkitmouseforcewillbegin) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforceup", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwebkitmouseforceup), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnwebkitmouseforceup) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
    { "onwebkitwillrevealbottom", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwebkitwillrevealbottom), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnwebkitwillrevealbottom) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
    { "onwebkitwillrevealleft", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwebkitwillrevealleft), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnwebkitwillrevealleft) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
    { "onwebkitwillrevealright", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwebkitwillrevealright), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnwebkitwillrevealright) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
    { "onwebkitwillrevealtop", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwebkitwillrevealtop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnwebkitwillrevealtop) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "children", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentChildren), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "firstElementChild", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentFirstElementChild), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "lastElementChild", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentLastElementChild), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "childElementCount", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentChildElementCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "createElement", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateElement), (intptr_t) (1) } },
    { "createDocumentFragment", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateDocumentFragment), (intptr_t) (0) } },
    { "createTextNode", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateTextNode), (intptr_t) (0) } },
    { "createComment", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateComment), (intptr_t) (0) } },
    { "createCDATASection", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateCDATASection), (intptr_t) (0) } },
    { "createProcessingInstruction", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateProcessingInstruction), (intptr_t) (0) } },
    { "createAttribute", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateAttribute), (intptr_t) (0) } },
    { "getElementsByTagName", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetElementsByTagName), (intptr_t) (0) } },
    { "importNode", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionImportNode), (intptr_t) (0) } },
    { "createElementNS", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateElementNS), (intptr_t) (0) } },
    { "createAttributeNS", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateAttributeNS), (intptr_t) (0) } },
    { "getElementsByTagNameNS", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetElementsByTagNameNS), (intptr_t) (0) } },
    { "adoptNode", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionAdoptNode), (intptr_t) (0) } },
    { "createEvent", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateEvent), (intptr_t) (0) } },
    { "createRange", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateRange), (intptr_t) (0) } },
    { "createNodeIterator", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateNodeIterator), (intptr_t) (1) } },
    { "createTreeWalker", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateTreeWalker), (intptr_t) (1) } },
    { "getOverrideStyle", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetOverrideStyle), (intptr_t) (0) } },
    { "createExpression", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateExpression), (intptr_t) (0) } },
    { "createNSResolver", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateNSResolver), (intptr_t) (1) } },
    { "evaluate", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionEvaluate), (intptr_t) (0) } },
    { "execCommand", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionExecCommand), (intptr_t) (0) } },
    { "queryCommandEnabled", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQueryCommandEnabled), (intptr_t) (0) } },
    { "queryCommandIndeterm", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQueryCommandIndeterm), (intptr_t) (0) } },
    { "queryCommandState", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQueryCommandState), (intptr_t) (0) } },
    { "queryCommandSupported", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQueryCommandSupported), (intptr_t) (0) } },
    { "queryCommandValue", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQueryCommandValue), (intptr_t) (0) } },
    { "getElementsByName", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetElementsByName), (intptr_t) (0) } },
    { "elementFromPoint", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionElementFromPoint), (intptr_t) (0) } },
    { "caretRangeFromPoint", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCaretRangeFromPoint), (intptr_t) (0) } },
    { "getSelection", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetSelection), (intptr_t) (0) } },
    { "getCSSCanvasContext", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetCSSCanvasContext), (intptr_t) (4) } },
    { "getElementsByClassName", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetElementsByClassName), (intptr_t) (0) } },
    { "hasFocus", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionHasFocus), (intptr_t) (0) } },
    { "webkitCancelFullScreen", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionWebkitCancelFullScreen), (intptr_t) (0) } },
    { "webkitExitFullscreen", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionWebkitExitFullscreen), (intptr_t) (0) } },
#if ENABLE(POINTER_LOCK)
    { "exitPointerLock", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionExitPointerLock), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(CSS_REGIONS)
    { "webkitGetNamedFlows", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionWebkitGetNamedFlows), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "createTouch", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateTouch), (intptr_t) (0) } },
    { "createTouchList", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateTouchList), (intptr_t) (0) } },
#if ENABLE(CUSTOM_ELEMENTS)
    { "defineCustomElement", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionDefineCustomElement), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "getElementById", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetElementById), (intptr_t) (0) } },
    { "prepend", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionPrepend), (intptr_t) (0) } },
    { "append", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionAppend), (intptr_t) (0) } },
    { "querySelector", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQuerySelector), (intptr_t) (1) } },
    { "querySelectorAll", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQuerySelectorAll), (intptr_t) (1) } },
};

const ClassInfo JSDocumentPrototype::s_info = { "DocumentPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDocumentPrototype) };

void JSDocumentPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDocumentPrototypeTableValues, *this);
}

const ClassInfo JSDocument::s_info = { "Document", &Base::s_info, &JSDocumentTable, CREATE_METHOD_TABLE(JSDocument) };

JSDocument::JSDocument(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Document>&& impl)
    : JSNode(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSDocument::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSDocumentPrototype::create(vm, globalObject, JSDocumentPrototype::createStructure(vm, globalObject, JSNode::getPrototype(vm, globalObject)));
}

JSObject* JSDocument::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDocument>(vm, globalObject);
}

bool JSDocument::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSDocument*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (getStaticValueSlot<JSDocument, Base>(state, JSDocumentTable, thisObject, propertyName, slot))
        return true;
    return false;
}

EncodedJSValue jsDocumentDoctype(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "doctype");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.doctype()));
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentImplementation(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "implementation");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.implementation()));
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentDocumentElement(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "documentElement");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.documentElement()));
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentInputEncoding(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "inputEncoding");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.characterSetWithUTF8Fallback());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentXMLEncoding(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "xmlEncoding");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.xmlEncoding());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentXMLVersion(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "xmlVersion");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.xmlVersion());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentXMLStandalone(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "xmlStandalone");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.xmlStandalone());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentDocumentURI(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "documentURI");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.urlForBindings());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentDefaultView(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "defaultView");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.defaultView()));
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentStyleSheets(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "styleSheets");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.styleSheets()));
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentContentType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "contentType");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.contentType());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentTitle(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "title");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.title());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentReferrer(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "referrer");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.referrer());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentDomain(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "domain");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.domain());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentURL(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "URL");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.urlForBindings());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentCookie(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "cookie");
    }
    ExceptionCode ec = 0;
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.cookie(ec));
    setDOMException(state, ec);
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentBody(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "body");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.bodyOrFrameset()));
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentHead(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "head");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.head()));
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentImages(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "images");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.images()));
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentApplets(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "applets");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.applets()));
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentLinks(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "links");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.links()));
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentForms(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "forms");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.forms()));
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentAnchors(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "anchors");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.anchors()));
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentLastModified(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "lastModified");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.lastModified());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentLocation(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "location");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.location()));
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentCharset(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "charset");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.characterSetWithUTF8Fallback());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentDefaultCharset(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "defaultCharset");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrUndefined(state, impl.defaultCharset());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentReadyState(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "readyState");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrUndefined(state, impl.readyState());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentCharacterSet(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "characterSet");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.characterSetWithUTF8Fallback());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentPreferredStylesheetSet(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "preferredStylesheetSet");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.preferredStylesheetSet());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentSelectedStylesheetSet(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "selectedStylesheetSet");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.selectedStylesheetSet());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentActiveElement(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "activeElement");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.activeElement()));
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentCompatMode(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "compatMode");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.compatMode());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentWebkitIsFullScreen(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "webkitIsFullScreen");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.webkitIsFullScreen());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentWebkitFullScreenKeyboardInputAllowed(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "webkitFullScreenKeyboardInputAllowed");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.webkitFullScreenKeyboardInputAllowed());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentWebkitCurrentFullScreenElement(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "webkitCurrentFullScreenElement");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.webkitCurrentFullScreenElement()));
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentWebkitFullscreenEnabled(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "webkitFullscreenEnabled");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.webkitFullscreenEnabled());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentWebkitFullscreenElement(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "webkitFullscreenElement");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.webkitFullscreenElement()));
    return JSValue::encode(result);
}


#if ENABLE(POINTER_LOCK)
EncodedJSValue jsDocumentPointerLockElement(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "pointerLockElement");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.pointerLockElement()));
    return JSValue::encode(result);
}

#endif

#if ENABLE(FONT_LOAD_EVENTS)
EncodedJSValue jsDocumentFonts(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "fonts");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.fonts()));
    return JSValue::encode(result);
}

#endif

EncodedJSValue jsDocumentVisibilityState(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "visibilityState");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.visibilityState());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentHidden(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "hidden");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.hidden());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentCurrentScript(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "currentScript");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.currentScript()));
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentOrigin(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "origin");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.origin());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentScrollingElement(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "scrollingElement");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.scrollingElement()));
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentOnbeforecopy(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onbeforecopy");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().beforecopyEvent));
}


EncodedJSValue jsDocumentOnbeforecut(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onbeforecut");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().beforecutEvent));
}


EncodedJSValue jsDocumentOnbeforepaste(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onbeforepaste");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().beforepasteEvent));
}


EncodedJSValue jsDocumentOncopy(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "oncopy");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().copyEvent));
}


EncodedJSValue jsDocumentOncut(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "oncut");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().cutEvent));
}


EncodedJSValue jsDocumentOnpaste(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onpaste");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().pasteEvent));
}


EncodedJSValue jsDocumentOnselectstart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onselectstart");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().selectstartEvent));
}


#if ENABLE(FULLSCREEN_API)
EncodedJSValue jsDocumentOnwebkitfullscreenchange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onwebkitfullscreenchange");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitfullscreenchangeEvent));
}

#endif

#if ENABLE(FULLSCREEN_API)
EncodedJSValue jsDocumentOnwebkitfullscreenerror(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onwebkitfullscreenerror");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitfullscreenerrorEvent));
}

#endif

EncodedJSValue jsDocumentOnselectionchange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onselectionchange");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().selectionchangeEvent));
}


EncodedJSValue jsDocumentOnreadystatechange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return JSValue::encode(jsUndefined());
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().readystatechangeEvent));
}


#if ENABLE(CSP_NEXT)
EncodedJSValue jsDocumentOnsecuritypolicyviolation(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onsecuritypolicyviolation");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().securitypolicyviolationEvent));
}

#endif

#if ENABLE(POINTER_LOCK)
EncodedJSValue jsDocumentOnpointerlockchange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onpointerlockchange");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().pointerlockchangeEvent));
}

#endif

#if ENABLE(POINTER_LOCK)
EncodedJSValue jsDocumentOnpointerlockerror(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onpointerlockerror");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().pointerlockerrorEvent));
}

#endif

EncodedJSValue jsDocumentOnabort(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onabort");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().abortEvent));
}


#if ENABLE(REQUEST_AUTOCOMPLETE)
EncodedJSValue jsDocumentOnautocomplete(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onautocomplete");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().autocompleteEvent));
}

#endif

#if ENABLE(REQUEST_AUTOCOMPLETE)
EncodedJSValue jsDocumentOnautocompleteerror(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onautocompleteerror");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().autocompleteerrorEvent));
}

#endif

EncodedJSValue jsDocumentOnblur(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onblur");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().blurEvent));
}


EncodedJSValue jsDocumentOncanplay(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "oncanplay");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().canplayEvent));
}


EncodedJSValue jsDocumentOncanplaythrough(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "oncanplaythrough");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().canplaythroughEvent));
}


EncodedJSValue jsDocumentOnchange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onchange");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().changeEvent));
}


EncodedJSValue jsDocumentOnclick(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onclick");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().clickEvent));
}


EncodedJSValue jsDocumentOncontextmenu(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "oncontextmenu");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().contextmenuEvent));
}


EncodedJSValue jsDocumentOndblclick(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "ondblclick");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().dblclickEvent));
}


EncodedJSValue jsDocumentOndrag(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "ondrag");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().dragEvent));
}


EncodedJSValue jsDocumentOndragend(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "ondragend");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().dragendEvent));
}


EncodedJSValue jsDocumentOndragenter(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "ondragenter");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().dragenterEvent));
}


EncodedJSValue jsDocumentOndragleave(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "ondragleave");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().dragleaveEvent));
}


EncodedJSValue jsDocumentOndragover(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "ondragover");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().dragoverEvent));
}


EncodedJSValue jsDocumentOndragstart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "ondragstart");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().dragstartEvent));
}


EncodedJSValue jsDocumentOndrop(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "ondrop");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().dropEvent));
}


EncodedJSValue jsDocumentOndurationchange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "ondurationchange");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().durationchangeEvent));
}


EncodedJSValue jsDocumentOnemptied(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onemptied");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().emptiedEvent));
}


EncodedJSValue jsDocumentOnended(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onended");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().endedEvent));
}


EncodedJSValue jsDocumentOnerror(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onerror");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().errorEvent));
}


EncodedJSValue jsDocumentOnfocus(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onfocus");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().focusEvent));
}


EncodedJSValue jsDocumentOninput(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "oninput");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().inputEvent));
}


EncodedJSValue jsDocumentOninvalid(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "oninvalid");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().invalidEvent));
}


EncodedJSValue jsDocumentOnkeydown(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onkeydown");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().keydownEvent));
}


EncodedJSValue jsDocumentOnkeypress(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onkeypress");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().keypressEvent));
}


EncodedJSValue jsDocumentOnkeyup(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onkeyup");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().keyupEvent));
}


EncodedJSValue jsDocumentOnload(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onload");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().loadEvent));
}


EncodedJSValue jsDocumentOnloadeddata(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onloadeddata");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().loadeddataEvent));
}


EncodedJSValue jsDocumentOnloadedmetadata(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onloadedmetadata");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().loadedmetadataEvent));
}


EncodedJSValue jsDocumentOnloadstart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onloadstart");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().loadstartEvent));
}


EncodedJSValue jsDocumentOnmousedown(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onmousedown");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().mousedownEvent));
}


EncodedJSValue jsDocumentOnmouseenter(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return JSValue::encode(jsUndefined());
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().mouseenterEvent));
}


EncodedJSValue jsDocumentOnmouseleave(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return JSValue::encode(jsUndefined());
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().mouseleaveEvent));
}


EncodedJSValue jsDocumentOnmousemove(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onmousemove");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().mousemoveEvent));
}


EncodedJSValue jsDocumentOnmouseout(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onmouseout");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().mouseoutEvent));
}


EncodedJSValue jsDocumentOnmouseover(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onmouseover");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().mouseoverEvent));
}


EncodedJSValue jsDocumentOnmouseup(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onmouseup");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().mouseupEvent));
}


EncodedJSValue jsDocumentOnmousewheel(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onmousewheel");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().mousewheelEvent));
}


EncodedJSValue jsDocumentOnpause(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onpause");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().pauseEvent));
}


EncodedJSValue jsDocumentOnplay(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onplay");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().playEvent));
}


EncodedJSValue jsDocumentOnplaying(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onplaying");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().playingEvent));
}


EncodedJSValue jsDocumentOnprogress(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onprogress");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().progressEvent));
}


EncodedJSValue jsDocumentOnratechange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onratechange");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().ratechangeEvent));
}


EncodedJSValue jsDocumentOnreset(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onreset");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().resetEvent));
}


EncodedJSValue jsDocumentOnresize(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onresize");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().resizeEvent));
}


EncodedJSValue jsDocumentOnscroll(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onscroll");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().scrollEvent));
}


EncodedJSValue jsDocumentOnseeked(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onseeked");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().seekedEvent));
}


EncodedJSValue jsDocumentOnseeking(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onseeking");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().seekingEvent));
}


EncodedJSValue jsDocumentOnselect(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onselect");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().selectEvent));
}


EncodedJSValue jsDocumentOnstalled(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onstalled");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().stalledEvent));
}


EncodedJSValue jsDocumentOnsubmit(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onsubmit");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().submitEvent));
}


EncodedJSValue jsDocumentOnsuspend(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onsuspend");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().suspendEvent));
}


EncodedJSValue jsDocumentOntimeupdate(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "ontimeupdate");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().timeupdateEvent));
}


EncodedJSValue jsDocumentOnvolumechange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onvolumechange");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().volumechangeEvent));
}


EncodedJSValue jsDocumentOnwaiting(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onwaiting");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().waitingEvent));
}


EncodedJSValue jsDocumentOnsearch(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onsearch");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().searchEvent));
}


EncodedJSValue jsDocumentOnwheel(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onwheel");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().wheelEvent));
}


#if ENABLE(TOUCH_EVENTS)
EncodedJSValue jsDocumentOntouchcancel(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "ontouchcancel");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().touchcancelEvent));
}

#endif

#if ENABLE(TOUCH_EVENTS)
EncodedJSValue jsDocumentOntouchend(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "ontouchend");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().touchendEvent));
}

#endif

#if ENABLE(TOUCH_EVENTS)
EncodedJSValue jsDocumentOntouchmove(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "ontouchmove");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().touchmoveEvent));
}

#endif

#if ENABLE(TOUCH_EVENTS)
EncodedJSValue jsDocumentOntouchstart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "ontouchstart");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().touchstartEvent));
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
EncodedJSValue jsDocumentOnwebkitmouseforcechanged(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onwebkitmouseforcechanged");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitmouseforcechangedEvent));
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
EncodedJSValue jsDocumentOnwebkitmouseforcedown(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onwebkitmouseforcedown");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitmouseforcedownEvent));
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
EncodedJSValue jsDocumentOnwebkitmouseforcewillbegin(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onwebkitmouseforcewillbegin");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitmouseforcewillbeginEvent));
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
EncodedJSValue jsDocumentOnwebkitmouseforceup(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onwebkitmouseforceup");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitmouseforceupEvent));
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
EncodedJSValue jsDocumentOnwebkitwillrevealbottom(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onwebkitwillrevealbottom");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitwillrevealbottomEvent));
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
EncodedJSValue jsDocumentOnwebkitwillrevealleft(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onwebkitwillrevealleft");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitwillrevealleftEvent));
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
EncodedJSValue jsDocumentOnwebkitwillrevealright(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onwebkitwillrevealright");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitwillrevealrightEvent));
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
EncodedJSValue jsDocumentOnwebkitwillrevealtop(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "onwebkitwillrevealtop");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitwillrevealtopEvent));
}

#endif

EncodedJSValue jsDocumentChildren(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "children");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.children()));
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentFirstElementChild(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "firstElementChild");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.firstElementChild()));
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentLastElementChild(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "lastElementChild");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.lastElementChild()));
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentChildElementCount(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDocumentCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Document", "childElementCount");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.childElementCount());
    return JSValue::encode(result);
}


EncodedJSValue jsDocumentConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSDocumentPrototype* domObject = jsDynamicCast<JSDocumentPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSDocument::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSDocumentConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSDocumentPrototype* domObject = jsDynamicCast<JSDocumentPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSDocumentXMLVersion(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "xmlVersion");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setXMLVersion(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSDocumentXMLStandalone(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "xmlStandalone");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setXMLStandalone(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSDocumentTitle(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "title");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setTitle(nativeValue);
}


void setJSDocumentDomain(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "domain");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setDomain(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSDocumentCookie(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "cookie");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setCookie(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSDocumentBody(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "body");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    if (UNLIKELY(!value.isUndefinedOrNull() && !value.inherits(JSHTMLElement::info()))) {
        throwAttributeTypeError(*state, "Document", "body", "HTMLElement");
        return;
    };
    HTMLElement* nativeValue = JSHTMLElement::toWrapped(value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setBodyOrFrameset(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSDocumentLocation(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "location");
        return;
    }
    RefPtr<Location> forwardedImpl = castedThis->wrapped().location();
    if (!forwardedImpl)
        return;
    auto& impl = *forwardedImpl;
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setHref(activeDOMWindow(state), firstDOMWindow(state), nativeValue);
}


void setJSDocumentSelectedStylesheetSet(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "selectedStylesheetSet");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setSelectedStylesheetSet(nativeValue);
}


void setJSDocumentOnbeforecopy(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onbeforecopy");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().beforecopyEvent, value);
}


void setJSDocumentOnbeforecut(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onbeforecut");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().beforecutEvent, value);
}


void setJSDocumentOnbeforepaste(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onbeforepaste");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().beforepasteEvent, value);
}


void setJSDocumentOncopy(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "oncopy");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().copyEvent, value);
}


void setJSDocumentOncut(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "oncut");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().cutEvent, value);
}


void setJSDocumentOnpaste(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onpaste");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().pasteEvent, value);
}


void setJSDocumentOnselectstart(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onselectstart");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().selectstartEvent, value);
}


#if ENABLE(FULLSCREEN_API)
void setJSDocumentOnwebkitfullscreenchange(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onwebkitfullscreenchange");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitfullscreenchangeEvent, value);
}

#endif

#if ENABLE(FULLSCREEN_API)
void setJSDocumentOnwebkitfullscreenerror(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onwebkitfullscreenerror");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitfullscreenerrorEvent, value);
}

#endif

void setJSDocumentOnselectionchange(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onselectionchange");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().selectionchangeEvent, value);
}


void setJSDocumentOnreadystatechange(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().readystatechangeEvent, value);
}


#if ENABLE(CSP_NEXT)
void setJSDocumentOnsecuritypolicyviolation(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onsecuritypolicyviolation");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().securitypolicyviolationEvent, value);
}

#endif

#if ENABLE(POINTER_LOCK)
void setJSDocumentOnpointerlockchange(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onpointerlockchange");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().pointerlockchangeEvent, value);
}

#endif

#if ENABLE(POINTER_LOCK)
void setJSDocumentOnpointerlockerror(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onpointerlockerror");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().pointerlockerrorEvent, value);
}

#endif

void setJSDocumentOnabort(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onabort");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().abortEvent, value);
}


#if ENABLE(REQUEST_AUTOCOMPLETE)
void setJSDocumentOnautocomplete(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onautocomplete");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().autocompleteEvent, value);
}

#endif

#if ENABLE(REQUEST_AUTOCOMPLETE)
void setJSDocumentOnautocompleteerror(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onautocompleteerror");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().autocompleteerrorEvent, value);
}

#endif

void setJSDocumentOnblur(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onblur");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().blurEvent, value);
}


void setJSDocumentOncanplay(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "oncanplay");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().canplayEvent, value);
}


void setJSDocumentOncanplaythrough(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "oncanplaythrough");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().canplaythroughEvent, value);
}


void setJSDocumentOnchange(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onchange");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().changeEvent, value);
}


void setJSDocumentOnclick(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onclick");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().clickEvent, value);
}


void setJSDocumentOncontextmenu(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "oncontextmenu");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().contextmenuEvent, value);
}


void setJSDocumentOndblclick(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "ondblclick");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().dblclickEvent, value);
}


void setJSDocumentOndrag(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "ondrag");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().dragEvent, value);
}


void setJSDocumentOndragend(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "ondragend");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().dragendEvent, value);
}


void setJSDocumentOndragenter(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "ondragenter");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().dragenterEvent, value);
}


void setJSDocumentOndragleave(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "ondragleave");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().dragleaveEvent, value);
}


void setJSDocumentOndragover(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "ondragover");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().dragoverEvent, value);
}


void setJSDocumentOndragstart(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "ondragstart");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().dragstartEvent, value);
}


void setJSDocumentOndrop(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "ondrop");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().dropEvent, value);
}


void setJSDocumentOndurationchange(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "ondurationchange");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().durationchangeEvent, value);
}


void setJSDocumentOnemptied(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onemptied");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().emptiedEvent, value);
}


void setJSDocumentOnended(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onended");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().endedEvent, value);
}


void setJSDocumentOnerror(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onerror");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().errorEvent, value);
}


void setJSDocumentOnfocus(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onfocus");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().focusEvent, value);
}


void setJSDocumentOninput(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "oninput");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().inputEvent, value);
}


void setJSDocumentOninvalid(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "oninvalid");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().invalidEvent, value);
}


void setJSDocumentOnkeydown(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onkeydown");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().keydownEvent, value);
}


void setJSDocumentOnkeypress(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onkeypress");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().keypressEvent, value);
}


void setJSDocumentOnkeyup(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onkeyup");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().keyupEvent, value);
}


void setJSDocumentOnload(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onload");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().loadEvent, value);
}


void setJSDocumentOnloadeddata(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onloadeddata");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().loadeddataEvent, value);
}


void setJSDocumentOnloadedmetadata(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onloadedmetadata");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().loadedmetadataEvent, value);
}


void setJSDocumentOnloadstart(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onloadstart");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().loadstartEvent, value);
}


void setJSDocumentOnmousedown(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onmousedown");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().mousedownEvent, value);
}


void setJSDocumentOnmouseenter(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().mouseenterEvent, value);
}


void setJSDocumentOnmouseleave(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().mouseleaveEvent, value);
}


void setJSDocumentOnmousemove(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onmousemove");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().mousemoveEvent, value);
}


void setJSDocumentOnmouseout(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onmouseout");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().mouseoutEvent, value);
}


void setJSDocumentOnmouseover(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onmouseover");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().mouseoverEvent, value);
}


void setJSDocumentOnmouseup(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onmouseup");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().mouseupEvent, value);
}


void setJSDocumentOnmousewheel(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onmousewheel");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().mousewheelEvent, value);
}


void setJSDocumentOnpause(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onpause");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().pauseEvent, value);
}


void setJSDocumentOnplay(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onplay");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().playEvent, value);
}


void setJSDocumentOnplaying(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onplaying");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().playingEvent, value);
}


void setJSDocumentOnprogress(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onprogress");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().progressEvent, value);
}


void setJSDocumentOnratechange(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onratechange");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().ratechangeEvent, value);
}


void setJSDocumentOnreset(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onreset");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().resetEvent, value);
}


void setJSDocumentOnresize(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onresize");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().resizeEvent, value);
}


void setJSDocumentOnscroll(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onscroll");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().scrollEvent, value);
}


void setJSDocumentOnseeked(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onseeked");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().seekedEvent, value);
}


void setJSDocumentOnseeking(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onseeking");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().seekingEvent, value);
}


void setJSDocumentOnselect(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onselect");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().selectEvent, value);
}


void setJSDocumentOnstalled(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onstalled");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().stalledEvent, value);
}


void setJSDocumentOnsubmit(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onsubmit");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().submitEvent, value);
}


void setJSDocumentOnsuspend(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onsuspend");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().suspendEvent, value);
}


void setJSDocumentOntimeupdate(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "ontimeupdate");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().timeupdateEvent, value);
}


void setJSDocumentOnvolumechange(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onvolumechange");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().volumechangeEvent, value);
}


void setJSDocumentOnwaiting(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onwaiting");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().waitingEvent, value);
}


void setJSDocumentOnsearch(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onsearch");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().searchEvent, value);
}


void setJSDocumentOnwheel(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onwheel");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().wheelEvent, value);
}


#if ENABLE(TOUCH_EVENTS)
void setJSDocumentOntouchcancel(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "ontouchcancel");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().touchcancelEvent, value);
}

#endif

#if ENABLE(TOUCH_EVENTS)
void setJSDocumentOntouchend(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "ontouchend");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().touchendEvent, value);
}

#endif

#if ENABLE(TOUCH_EVENTS)
void setJSDocumentOntouchmove(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "ontouchmove");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().touchmoveEvent, value);
}

#endif

#if ENABLE(TOUCH_EVENTS)
void setJSDocumentOntouchstart(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "ontouchstart");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().touchstartEvent, value);
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
void setJSDocumentOnwebkitmouseforcechanged(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onwebkitmouseforcechanged");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitmouseforcechangedEvent, value);
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
void setJSDocumentOnwebkitmouseforcedown(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onwebkitmouseforcedown");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitmouseforcedownEvent, value);
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
void setJSDocumentOnwebkitmouseforcewillbegin(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onwebkitmouseforcewillbegin");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitmouseforcewillbeginEvent, value);
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
void setJSDocumentOnwebkitmouseforceup(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onwebkitmouseforceup");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitmouseforceupEvent, value);
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
void setJSDocumentOnwebkitwillrevealbottom(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onwebkitwillrevealbottom");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitwillrevealbottomEvent, value);
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
void setJSDocumentOnwebkitwillrevealleft(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onwebkitwillrevealleft");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitwillrevealleftEvent, value);
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
void setJSDocumentOnwebkitwillrevealright(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onwebkitwillrevealright");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitwillrevealrightEvent, value);
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
void setJSDocumentOnwebkitwillrevealtop(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDocument* castedThis = jsDocumentCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Document", "onwebkitwillrevealtop");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitwillrevealtopEvent, value);
}

#endif

JSValue JSDocument::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDocumentConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateElement(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "createElement");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String tagName = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.createElementForBindings(tagName, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateDocumentFragment(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "createDocumentFragment");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.createDocumentFragment()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTextNode(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "createTextNode");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    String data = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.createTextNode(data)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateComment(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "createComment");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    String data = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.createComment(data)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateCDATASection(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "createCDATASection");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String data = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.createCDATASection(data, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateProcessingInstruction(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "createProcessingInstruction");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String target = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String data = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.createProcessingInstruction(target, data, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateAttribute(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "createAttribute");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String name = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.createAttribute(name, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByTagName(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "getElementsByTagName");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    String tagname = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getElementsByTagName(tagname)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionImportNode(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "importNode");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    Node* importedNode = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 1) {
        JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.importNode(importedNode, ec)));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    bool deep = state->argument(1).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.importNode(importedNode, deep, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateElementNS(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "createElementNS");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String namespaceURI = valueToStringWithUndefinedOrNullCheck(state, state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String qualifiedName = valueToStringWithNullCheck(state, state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.createElementNS(namespaceURI, qualifiedName, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateAttributeNS(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "createAttributeNS");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String namespaceURI = valueToStringWithUndefinedOrNullCheck(state, state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String qualifiedName = valueToStringWithNullCheck(state, state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.createAttributeNS(namespaceURI, qualifiedName, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByTagNameNS(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "getElementsByTagNameNS");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    String namespaceURI = valueToStringWithNullCheck(state, state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String localName = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getElementsByTagNameNS(namespaceURI, localName)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionAdoptNode(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "adoptNode");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    Node* source = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.adoptNode(source, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateEvent(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "createEvent");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String eventType = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.createEvent(eventType, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateRange(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "createRange");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.createRange()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateNodeIterator(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "createNodeIterator");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    Node* root = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 1) {
        JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.createNodeIterator(root, ec)));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    unsigned whatToShow = state->argument(1).isUndefined() ? 0xFFFFFFFF : toUInt32(state, state->uncheckedArgument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    RefPtr<NodeFilter> filter;
    if (!state->argument(2).isUndefinedOrNull()) {
        if (!state->uncheckedArgument(2).isObject())
            return throwArgumentMustBeFunctionError(*state, 2, "filter", "Document", "createNodeIterator");
        filter = JSNodeFilter::create(asObject(state->uncheckedArgument(2)), castedThis->globalObject());
    }
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.createNodeIterator(root, whatToShow, filter.get(), ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTreeWalker(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "createTreeWalker");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    Node* root = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 1) {
        JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.createTreeWalker(root, ec)));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    unsigned whatToShow = state->argument(1).isUndefined() ? 0xFFFFFFFF : toUInt32(state, state->uncheckedArgument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    RefPtr<NodeFilter> filter;
    if (!state->argument(2).isUndefinedOrNull()) {
        if (!state->uncheckedArgument(2).isObject())
            return throwArgumentMustBeFunctionError(*state, 2, "filter", "Document", "createTreeWalker");
        filter = JSNodeFilter::create(asObject(state->uncheckedArgument(2)), castedThis->globalObject());
    }
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.createTreeWalker(root, whatToShow, filter.get(), ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetOverrideStyle(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "getOverrideStyle");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    Element* element = JSElement::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String pseudoElement = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getOverrideStyle(element, pseudoElement)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateExpression(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "createExpression");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String expression = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    RefPtr<XPathNSResolver> customResolver;
    XPathNSResolver* resolver = JSXPathNSResolver::toWrapped(state->argument(1));
    if (!resolver) {
        customResolver = JSCustomXPathNSResolver::create(state, state->argument(1));
        if (UNLIKELY(state->hadException()))
            return JSValue::encode(jsUndefined());
        resolver = customResolver.get();
    }
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createExpression(expression, resolver, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateNSResolver(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "createNSResolver");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    Node* nodeResolver = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createNSResolver(nodeResolver)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionEvaluate(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "evaluate");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String expression = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    Node* contextNode = JSNode::toWrapped(state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    RefPtr<XPathNSResolver> customResolver;
    XPathNSResolver* resolver = JSXPathNSResolver::toWrapped(state->argument(2));
    if (!resolver) {
        customResolver = JSCustomXPathNSResolver::create(state, state->argument(2));
        if (UNLIKELY(state->hadException()))
            return JSValue::encode(jsUndefined());
        resolver = customResolver.get();
    }
    uint16_t type = toUInt16(state, state->argument(3), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    XPathResult* inResult = JSXPathResult::toWrapped(state->argument(4));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.evaluate(expression, contextNode, resolver, type, inResult, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionExecCommand(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "execCommand");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    String command = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool userInterface = state->argument(1).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String value = valueToStringWithUndefinedOrNullCheck(state, state->argument(2));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.execCommand(command, userInterface, value));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandEnabled(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "queryCommandEnabled");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    String command = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.queryCommandEnabled(command));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandIndeterm(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "queryCommandIndeterm");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    String command = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.queryCommandIndeterm(command));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandState(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "queryCommandState");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    String command = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.queryCommandState(command));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandSupported(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "queryCommandSupported");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    String command = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.queryCommandSupported(command));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandValue(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "queryCommandValue");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    String command = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringWithCache(state, impl.queryCommandValue(command));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByName(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "getElementsByName");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    String elementName = state->argument(0).toString(state)->toAtomicString(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getElementsByName(elementName)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionElementFromPoint(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "elementFromPoint");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    int x = toInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int y = toInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.elementFromPoint(x, y)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCaretRangeFromPoint(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "caretRangeFromPoint");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    int x = toInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int y = toInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.caretRangeFromPoint(x, y)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetSelection(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "getSelection");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getSelection()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetCSSCanvasContext(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "getCSSCanvasContext");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 4))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    String contextId = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String name = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int width = toInt32(state, state->argument(2), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int height = toInt32(state, state->argument(3), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getCSSCanvasContext(contextId, name, width, height)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByClassName(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "getElementsByClassName");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    String classNames = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getElementsByClassName(classNames)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionHasFocus(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "hasFocus");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.hasFocus());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionWebkitCancelFullScreen(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "webkitCancelFullScreen");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    impl.webkitCancelFullScreen();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionWebkitExitFullscreen(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "webkitExitFullscreen");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    impl.webkitExitFullscreen();
    return JSValue::encode(jsUndefined());
}

#if ENABLE(POINTER_LOCK)
EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionExitPointerLock(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "exitPointerLock");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    impl.exitPointerLock();
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(CSS_REGIONS)
EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionWebkitGetNamedFlows(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "webkitGetNamedFlows");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.webkitGetNamedFlows()));
    return JSValue::encode(result);
}

#endif

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTouch(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "createTouch");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    DOMWindow* window = JSDOMWindow::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    EventTarget* target = JSEventTarget::toWrapped(state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int identifier = toInt32(state, state->argument(2), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int pageX = toInt32(state, state->argument(3), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int pageY = toInt32(state, state->argument(4), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int screenX = toInt32(state, state->argument(5), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int screenY = toInt32(state, state->argument(6), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int webkitRadiusX = toInt32(state, state->argument(7), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int webkitRadiusY = toInt32(state, state->argument(8), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float webkitRotationAngle = state->argument(9).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float webkitForce = state->argument(10).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.createTouch(window, target, identifier, pageX, pageY, screenX, screenY, webkitRadiusX, webkitRadiusY, webkitRotationAngle, webkitForce, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTouchList(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "createTouchList");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    return JSValue::encode(castedThis->createTouchList(*state));
}

#if ENABLE(CUSTOM_ELEMENTS)
EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionDefineCustomElement(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "defineCustomElement");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    return JSValue::encode(castedThis->defineCustomElement(*state));
}

#endif

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementById(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "getElementById");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    AtomicString elementId = state->argument(0).toString(state)->toExistingAtomicString(state).get();
    if (elementId.isNull())
        return JSValue::encode(jsNull());
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getElementById(elementId)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionPrepend(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "prepend");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    return JSValue::encode(castedThis->prepend(*state));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionAppend(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "append");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    return JSValue::encode(castedThis->append(*state));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQuerySelector(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "querySelector");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String selectors = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.querySelector(selectors, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQuerySelectorAll(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDocumentCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Document", "querySelectorAll");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDocument::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String selectors = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.querySelectorAll(selectors, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

void JSDocument::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSDocument*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

Document* JSDocument::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDocumentCast(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
