/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSRuleList.h"

#include "CSSRule.h"
#include "ExceptionCode.h"
#include "JSCSSRule.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsCSSRuleListPrototypeFunctionItem(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsCSSRuleListLength(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCSSRuleListConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCSSRuleListConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSCSSRuleListPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSCSSRuleListPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSRuleListPrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSRuleListPrototype>(vm.heap)) JSCSSRuleListPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSRuleListPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSCSSRuleList> JSCSSRuleListConstructor;

template<> JSValue JSCSSRuleListConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCSSRuleListConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSCSSRuleList::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("CSSRuleList"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSCSSRuleListConstructor::s_info = { "CSSRuleList", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSRuleListConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCSSRuleListPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCSSRuleListConstructor) } },
    { "length", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleListLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "item", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCSSRuleListPrototypeFunctionItem), (intptr_t) (0) } },
};

const ClassInfo JSCSSRuleListPrototype::s_info = { "CSSRuleListPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSRuleListPrototype) };

void JSCSSRuleListPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSRuleListPrototypeTableValues, *this);
}

const ClassInfo JSCSSRuleList::s_info = { "CSSRuleList", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSRuleList) };

JSCSSRuleList::JSCSSRuleList(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSRuleList>&& impl)
    : JSDOMWrapper<CSSRuleList>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSCSSRuleList::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSCSSRuleListPrototype::create(vm, globalObject, JSCSSRuleListPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSCSSRuleList::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSRuleList>(vm, globalObject);
}

void JSCSSRuleList::destroy(JSC::JSCell* cell)
{
    JSCSSRuleList* thisObject = static_cast<JSCSSRuleList*>(cell);
    thisObject->JSCSSRuleList::~JSCSSRuleList();
}

bool JSCSSRuleList::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSCSSRuleList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Optional<uint32_t> optionalIndex = parseIndex(propertyName);
    if (optionalIndex && optionalIndex.value() < thisObject->wrapped().length()) {
        unsigned index = optionalIndex.value();
        unsigned attributes = DontDelete | ReadOnly;
        slot.setValue(thisObject, attributes, toJS(state, thisObject->globalObject(), thisObject->wrapped().item(index)));
        return true;
    }
    if (Base::getOwnPropertySlot(thisObject, state, propertyName, slot))
        return true;
    return false;
}

bool JSCSSRuleList::getOwnPropertySlotByIndex(JSObject* object, ExecState* state, unsigned index, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSCSSRuleList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (index < thisObject->wrapped().length()) {
        unsigned attributes = DontDelete | ReadOnly;
        slot.setValue(thisObject, attributes, toJS(state, thisObject->globalObject(), thisObject->wrapped().item(index)));
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, state, index, slot);
}

EncodedJSValue jsCSSRuleListLength(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCSSRuleList*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CSSRuleList", "length");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.length());
    return JSValue::encode(result);
}


EncodedJSValue jsCSSRuleListConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSCSSRuleListPrototype* domObject = jsDynamicCast<JSCSSRuleListPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSCSSRuleList::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSCSSRuleListConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSCSSRuleListPrototype* domObject = jsDynamicCast<JSCSSRuleListPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void JSCSSRuleList::getOwnPropertyNames(JSObject* object, ExecState* state, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    auto* thisObject = jsCast<JSCSSRuleList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    for (unsigned i = 0, count = thisObject->wrapped().length(); i < count; ++i)
        propertyNames.add(Identifier::from(state, i));
    Base::getOwnPropertyNames(thisObject, state, propertyNames, mode);
}

JSValue JSCSSRuleList::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSRuleListConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsCSSRuleListPrototypeFunctionItem(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCSSRuleList*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CSSRuleList", "item");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCSSRuleList::info());
    auto& impl = castedThis->wrapped();
    unsigned index = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.item(index)));
    return JSValue::encode(result);
}

void JSCSSRuleListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCSSRuleList = jsCast<JSCSSRuleList*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsCSSRuleList->wrapped(), jsCSSRuleList);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, CSSRuleList* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSCSSRuleList>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, CSSRuleList* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSCSSRuleList>(globalObject, impl))
        return result;
    return createNewWrapper<JSCSSRuleList>(globalObject, impl);
}

CSSRuleList* JSCSSRuleList::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSRuleList*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
