/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioBufferSourceNode.h"

#include "AudioBuffer.h"
#include "AudioParam.h"
#include "ExceptionCode.h"
#include "JSAudioBuffer.h"
#include "JSAudioParam.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSEventListener.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsAudioBufferSourceNodePrototypeFunctionStart(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioBufferSourceNodePrototypeFunctionStop(JSC::ExecState*);
#if ENABLE(LEGACY_WEB_AUDIO)
JSC::EncodedJSValue JSC_HOST_CALL jsAudioBufferSourceNodePrototypeFunctionNoteOn(JSC::ExecState*);
#endif
#if ENABLE(LEGACY_WEB_AUDIO)
JSC::EncodedJSValue JSC_HOST_CALL jsAudioBufferSourceNodePrototypeFunctionNoteGrainOn(JSC::ExecState*);
#endif
#if ENABLE(LEGACY_WEB_AUDIO)
JSC::EncodedJSValue JSC_HOST_CALL jsAudioBufferSourceNodePrototypeFunctionNoteOff(JSC::ExecState*);
#endif

// Attributes

JSC::EncodedJSValue jsAudioBufferSourceNodeBuffer(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAudioBufferSourceNodeBuffer(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioBufferSourceNodePlaybackState(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioBufferSourceNodeGain(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioBufferSourceNodePlaybackRate(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioBufferSourceNodeLoop(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAudioBufferSourceNodeLoop(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioBufferSourceNodeLoopStart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAudioBufferSourceNodeLoopStart(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioBufferSourceNodeLoopEnd(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAudioBufferSourceNodeLoopEnd(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(LEGACY_WEB_AUDIO)
JSC::EncodedJSValue jsAudioBufferSourceNodeLooping(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAudioBufferSourceNodeLooping(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsAudioBufferSourceNodeOnended(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAudioBufferSourceNodeOnended(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioBufferSourceNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAudioBufferSourceNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSAudioBufferSourceNodePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSAudioBufferSourceNodePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAudioBufferSourceNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSAudioBufferSourceNodePrototype>(vm.heap)) JSAudioBufferSourceNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAudioBufferSourceNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSAudioBufferSourceNode> JSAudioBufferSourceNodeConstructor;

/* Hash table for constructor */

static const HashTableValue JSAudioBufferSourceNodeConstructorTableValues[] =
{
    { "UNSCHEDULED_STATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SCHEDULED_STATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "PLAYING_STATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "FINISHED_STATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
};


COMPILE_ASSERT(0 == AudioBufferSourceNode::UNSCHEDULED_STATE, AudioBufferSourceNodeEnumUNSCHEDULED_STATEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == AudioBufferSourceNode::SCHEDULED_STATE, AudioBufferSourceNodeEnumSCHEDULED_STATEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == AudioBufferSourceNode::PLAYING_STATE, AudioBufferSourceNodeEnumPLAYING_STATEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == AudioBufferSourceNode::FINISHED_STATE, AudioBufferSourceNodeEnumFINISHED_STATEIsWrongUseDoNotCheckConstants);

template<> JSValue JSAudioBufferSourceNodeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSAudioBufferSourceNodeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSAudioBufferSourceNode::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("AudioBufferSourceNode"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSAudioBufferSourceNodeConstructorTableValues, *this);
}

template<> const ClassInfo JSAudioBufferSourceNodeConstructor::s_info = { "AudioBufferSourceNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAudioBufferSourceNodeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSAudioBufferSourceNodePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferSourceNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioBufferSourceNodeConstructor) } },
    { "buffer", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferSourceNodeBuffer), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioBufferSourceNodeBuffer) } },
    { "playbackState", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferSourceNodePlaybackState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "gain", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferSourceNodeGain), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "playbackRate", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferSourceNodePlaybackRate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "loop", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferSourceNodeLoop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioBufferSourceNodeLoop) } },
    { "loopStart", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferSourceNodeLoopStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioBufferSourceNodeLoopStart) } },
    { "loopEnd", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferSourceNodeLoopEnd), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioBufferSourceNodeLoopEnd) } },
#if ENABLE(LEGACY_WEB_AUDIO)
    { "looping", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferSourceNodeLooping), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioBufferSourceNodeLooping) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "onended", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferSourceNodeOnended), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioBufferSourceNodeOnended) } },
    { "start", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioBufferSourceNodePrototypeFunctionStart), (intptr_t) (0) } },
    { "stop", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioBufferSourceNodePrototypeFunctionStop), (intptr_t) (0) } },
#if ENABLE(LEGACY_WEB_AUDIO)
    { "noteOn", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioBufferSourceNodePrototypeFunctionNoteOn), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(LEGACY_WEB_AUDIO)
    { "noteGrainOn", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioBufferSourceNodePrototypeFunctionNoteGrainOn), (intptr_t) (3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(LEGACY_WEB_AUDIO)
    { "noteOff", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioBufferSourceNodePrototypeFunctionNoteOff), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "UNSCHEDULED_STATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SCHEDULED_STATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "PLAYING_STATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "FINISHED_STATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
};

const ClassInfo JSAudioBufferSourceNodePrototype::s_info = { "AudioBufferSourceNodePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAudioBufferSourceNodePrototype) };

void JSAudioBufferSourceNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAudioBufferSourceNodePrototypeTableValues, *this);
}

const ClassInfo JSAudioBufferSourceNode::s_info = { "AudioBufferSourceNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAudioBufferSourceNode) };

JSAudioBufferSourceNode::JSAudioBufferSourceNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AudioBufferSourceNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSAudioBufferSourceNode::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSAudioBufferSourceNodePrototype::create(vm, globalObject, JSAudioBufferSourceNodePrototype::createStructure(vm, globalObject, JSAudioNode::getPrototype(vm, globalObject)));
}

JSObject* JSAudioBufferSourceNode::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSAudioBufferSourceNode>(vm, globalObject);
}

EncodedJSValue jsAudioBufferSourceNodeBuffer(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioBufferSourceNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioBufferSourceNode", "buffer");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.buffer()));
    return JSValue::encode(result);
}


EncodedJSValue jsAudioBufferSourceNodePlaybackState(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioBufferSourceNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioBufferSourceNode", "playbackState");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.playbackState());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioBufferSourceNodeGain(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioBufferSourceNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioBufferSourceNode", "gain");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.gain()));
    return JSValue::encode(result);
}


EncodedJSValue jsAudioBufferSourceNodePlaybackRate(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioBufferSourceNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioBufferSourceNode", "playbackRate");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.playbackRate()));
    return JSValue::encode(result);
}


EncodedJSValue jsAudioBufferSourceNodeLoop(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioBufferSourceNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioBufferSourceNode", "loop");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.loop());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioBufferSourceNodeLoopStart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioBufferSourceNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioBufferSourceNode", "loopStart");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.loopStart());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioBufferSourceNodeLoopEnd(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioBufferSourceNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioBufferSourceNode", "loopEnd");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.loopEnd());
    return JSValue::encode(result);
}


#if ENABLE(LEGACY_WEB_AUDIO)
EncodedJSValue jsAudioBufferSourceNodeLooping(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioBufferSourceNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioBufferSourceNode", "looping");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.looping());
    return JSValue::encode(result);
}

#endif

EncodedJSValue jsAudioBufferSourceNodeOnended(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioBufferSourceNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioBufferSourceNode", "onended");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().endedEvent));
}


EncodedJSValue jsAudioBufferSourceNodeConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSAudioBufferSourceNodePrototype* domObject = jsDynamicCast<JSAudioBufferSourceNodePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSAudioBufferSourceNode::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSAudioBufferSourceNodeConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSAudioBufferSourceNodePrototype* domObject = jsDynamicCast<JSAudioBufferSourceNodePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSAudioBufferSourceNodeBuffer(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSAudioBufferSourceNode* castedThis = jsDynamicCast<JSAudioBufferSourceNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "AudioBufferSourceNode", "buffer");
        return;
    }
    castedThis->setBuffer(*state, value);
}


void setJSAudioBufferSourceNodeLoop(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSAudioBufferSourceNode* castedThis = jsDynamicCast<JSAudioBufferSourceNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "AudioBufferSourceNode", "loop");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setLoop(nativeValue);
}


void setJSAudioBufferSourceNodeLoopStart(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSAudioBufferSourceNode* castedThis = jsDynamicCast<JSAudioBufferSourceNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "AudioBufferSourceNode", "loopStart");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setLoopStart(nativeValue);
}


void setJSAudioBufferSourceNodeLoopEnd(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSAudioBufferSourceNode* castedThis = jsDynamicCast<JSAudioBufferSourceNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "AudioBufferSourceNode", "loopEnd");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setLoopEnd(nativeValue);
}


#if ENABLE(LEGACY_WEB_AUDIO)
void setJSAudioBufferSourceNodeLooping(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSAudioBufferSourceNode* castedThis = jsDynamicCast<JSAudioBufferSourceNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "AudioBufferSourceNode", "looping");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setLooping(nativeValue);
}

#endif

void setJSAudioBufferSourceNodeOnended(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSAudioBufferSourceNode* castedThis = jsDynamicCast<JSAudioBufferSourceNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "AudioBufferSourceNode", "onended");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().endedEvent, value);
}


JSValue JSAudioBufferSourceNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioBufferSourceNodeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsAudioBufferSourceNodePrototypeFunctionStart(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioBufferSourceNode*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioBufferSourceNode", "start");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioBufferSourceNode::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;

    size_t argsCount = state->argumentCount();
    if (argsCount <= 0) {
        impl.start(ec);
        setDOMException(state, ec);
        return JSValue::encode(jsUndefined());
    }

    double when = state->argument(0).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (argsCount <= 1) {
        impl.start(when, ec);
        setDOMException(state, ec);
        return JSValue::encode(jsUndefined());
    }

    double grainOffset = state->argument(1).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (argsCount <= 2) {
        impl.start(when, grainOffset, ec);
        setDOMException(state, ec);
        return JSValue::encode(jsUndefined());
    }

    double grainDuration = state->argument(2).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.start(when, grainOffset, grainDuration, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioBufferSourceNodePrototypeFunctionStop(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioBufferSourceNode*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioBufferSourceNode", "stop");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioBufferSourceNode::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;

    size_t argsCount = state->argumentCount();
    if (argsCount <= 0) {
        impl.stop(ec);
        setDOMException(state, ec);
        return JSValue::encode(jsUndefined());
    }

    double when = state->argument(0).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.stop(when, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

#if ENABLE(LEGACY_WEB_AUDIO)
EncodedJSValue JSC_HOST_CALL jsAudioBufferSourceNodePrototypeFunctionNoteOn(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioBufferSourceNode*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioBufferSourceNode", "noteOn");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioBufferSourceNode::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    double when = state->argument(0).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.noteOn(when, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(LEGACY_WEB_AUDIO)
EncodedJSValue JSC_HOST_CALL jsAudioBufferSourceNodePrototypeFunctionNoteGrainOn(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioBufferSourceNode*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioBufferSourceNode", "noteGrainOn");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioBufferSourceNode::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    double when = state->argument(0).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    double grainOffset = state->argument(1).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    double grainDuration = state->argument(2).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.noteGrainOn(when, grainOffset, grainDuration, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(LEGACY_WEB_AUDIO)
EncodedJSValue JSC_HOST_CALL jsAudioBufferSourceNodePrototypeFunctionNoteOff(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioBufferSourceNode*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioBufferSourceNode", "noteOff");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioBufferSourceNode::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    double when = state->argument(0).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.noteOff(when, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

#endif

void JSAudioBufferSourceNode::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSAudioBufferSourceNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AudioBufferSourceNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21AudioBufferSourceNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, AudioBufferSourceNode* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSAudioBufferSourceNode>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, AudioBufferSourceNode* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSAudioBufferSourceNode>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7AudioBufferSourceNode@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore21AudioBufferSourceNodeE[2];
#if COMPILER(CLANG)
    // If this fails AudioBufferSourceNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(AudioBufferSourceNode), AudioBufferSourceNode_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // AudioBufferSourceNode has subclasses. If AudioBufferSourceNode has subclasses that get passed
    // to toJS() we currently require AudioBufferSourceNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSAudioBufferSourceNode>(globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
