/*
 * Copyright (c) 2016 Canon Inc.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "FetchHeadersBuiltins.h"

#if ENABLE(FETCH_API)

#include "WebCoreJSClientData.h"
#include <runtime/Executable.h>
#include <runtime/JSCJSValueInlines.h>
#include <runtime/JSCellInlines.h>
#include <runtime/StructureInlines.h>
#include <runtime/VM.h>

namespace WebCore {

const JSC::ConstructAbility s_fetchHeadersInitializeFetchHeadersCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_fetchHeadersInitializeFetchHeadersCodeLength = 809;
const char* s_fetchHeadersInitializeFetchHeadersCode =
    "(function (headersInit)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (headersInit === @undefined)\n" \
    "        return this;\n" \
    "    if (!@isObject(headersInit))\n" \
    "        throw new @TypeError(\"headersInit must be an object\");\n" \
    "    if (this.constructor === headersInit.constructor) {\n" \
    "         this.@initializeWith(headersInit);\n" \
    "    }\n" \
    "    if (headersInit instanceof @Array) {\n" \
    "        for (let i = 0; i < headersInit.length; i++) {\n" \
    "            let header = headersInit[i];\n" \
    "            if (header.length !== 2)\n" \
    "                throw new @TypeError(\"headersInit sequence items should contain two values\");\n" \
    "            this.@appendFromJS(header[0], header[1]);\n" \
    "        }\n" \
    "        return this;\n" \
    "    }\n" \
    "    @Object.@getOwnPropertyNames(headersInit).forEach((name) => {\n" \
    "        this.@appendFromJS(name, headersInit[name]);\n" \
    "    });\n" \
    "    return this;\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = static_cast<JSVMClientData*>(vm.clientData); \
    return clientData->builtinFunctions().fetchHeadersBuiltins().codeName##Executable()->link(vm, clientData->builtinFunctions().fetchHeadersBuiltins().codeName##Source()); \
}
WEBCORE_FOREACH_FETCHHEADERS_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore

#endif // ENABLE(FETCH_API)
