SCM_GLOBAL_SMOB (scm_tc16_avahi_client_state_enum, "client-state", 0);
SCM scm_avahi_client_state_enum_values = SCM_EOL;
static const char *
scm_avahi_client_state_to_c_string (AvahiClientState c_obj)
{
  static const struct { AvahiClientState value; const char *name; } table[] =
    {
       { AVAHI_CLIENT_S_REGISTERING, "s-registering" },
       { AVAHI_CLIENT_S_RUNNING, "s-running" },
       { AVAHI_CLIENT_S_COLLISION, "s-collision" },
       { AVAHI_CLIENT_FAILURE, "failure" },
       { AVAHI_CLIENT_CONNECTING, "connecting" },
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < 5; i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_avahi_client_state_enum, client_state_print, obj, port, pstate)
{
  scm_puts ("#<avahi-client-state-enum ", port);
  scm_puts (scm_avahi_client_state_to_c_string (scm_to_avahi_client_state (obj, 1, "client_state_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_avahi_client_state_to_string, "client-state->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{client-state} value.")
#define FUNC_NAME s_scm_avahi_client_state_to_string
{
  AvahiClientState c_enum;
  const char *c_string;
  c_enum = scm_to_avahi_client_state (enumval, 1, FUNC_NAME);
  c_string = scm_avahi_client_state_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_avahi_client_flag_enum, "client-flag", 0);
SCM scm_avahi_client_flag_enum_values = SCM_EOL;
static const char *
scm_avahi_client_flag_to_c_string (AvahiClientFlags c_obj)
{
  static const struct { AvahiClientFlags value; const char *name; } table[] =
    {
       { AVAHI_CLIENT_IGNORE_USER_CONFIG, "ignore-user-config" },
       { AVAHI_CLIENT_NO_FAIL, "no-fail" },
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < 2; i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_avahi_client_flag_enum, client_flag_print, obj, port, pstate)
{
  scm_puts ("#<avahi-client-flag-enum ", port);
  scm_puts (scm_avahi_client_flag_to_c_string (scm_to_avahi_client_flag (obj, 1, "client_flag_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_avahi_client_flag_to_string, "client-flag->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{client-flag} value.")
#define FUNC_NAME s_scm_avahi_client_flag_to_string
{
  AvahiClientFlags c_enum;
  const char *c_string;
  c_enum = scm_to_avahi_client_flag (enumval, 1, FUNC_NAME);
  c_string = scm_avahi_client_flag_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
static inline void
scm_avahi_define_enums (void)
{
  SCM enum_values, enum_smob;
  enum_values = SCM_EOL;
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_client_state_enum, (scm_t_bits) AVAHI_CLIENT_S_REGISTERING);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("client-state/s-registering", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_client_state_enum, (scm_t_bits) AVAHI_CLIENT_S_RUNNING);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("client-state/s-running", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_client_state_enum, (scm_t_bits) AVAHI_CLIENT_S_COLLISION);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("client-state/s-collision", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_client_state_enum, (scm_t_bits) AVAHI_CLIENT_FAILURE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("client-state/failure", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_client_state_enum, (scm_t_bits) AVAHI_CLIENT_CONNECTING);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("client-state/connecting", enum_smob);
  scm_avahi_client_state_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_client_flag_enum, (scm_t_bits) AVAHI_CLIENT_IGNORE_USER_CONFIG);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("client-flag/ignore-user-config", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_client_flag_enum, (scm_t_bits) AVAHI_CLIENT_NO_FAIL);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("client-flag/no-fail", enum_smob);
  scm_avahi_client_flag_enum_values = scm_permanent_object (enum_values);
}
