
/* Automatically generated struct definitions for the Data API.
 * Do not edit manually, changes will be overwritten.           */

#define RNA_RUNTIME

#include <float.h>
#include <stdio.h>
#include <limits.h>
#include <limits>
#include <string.h>

#include <stddef.h>

#include <algorithm>

#include "MEM_guardedalloc.h"

#include "DNA_ID.h"
#include "DNA_scene_types.h"
#include "DNA_node_types.h"
#include "BLI_fileops.h"

#include "BLI_listbase.h"

#include "BLI_path_utils.hh"

#include "BLI_rect.h"

#include "BLI_string.h"

#include "BLI_string_utf8.h"

#include "BLI_utildefines.h"

#include "BKE_context.hh"
#include "BKE_lib_id.hh"
#include "BKE_main.hh"
#include "BKE_report.hh"
#include "RNA_define.hh"
#include "RNA_types.hh"
#include "rna_internal.hh"

#include "rna_prototypes_gen.hh"

#include "rna_sculpt_paint.cc"

#pragma GCC diagnostic ignored "-Wunused-parameter"

/* Auto-generated Functions. */


extern PropertyRNA &rna_ID_rna_properties;
extern PropertyRNA &rna_ID_rna_type;
extern PropertyRNA &rna_ID_name;
extern PropertyRNA &rna_ID_name_full;
extern PropertyRNA &rna_ID_id_type;
extern PropertyRNA &rna_ID_session_uid;
extern PropertyRNA &rna_ID_is_evaluated;
extern PropertyRNA &rna_ID_original;
extern PropertyRNA &rna_ID_users;
extern PropertyRNA &rna_ID_use_fake_user;
extern PropertyRNA &rna_ID_use_extra_user;
extern PropertyRNA &rna_ID_is_embedded_data;
extern PropertyRNA &rna_ID_is_missing;
extern PropertyRNA &rna_ID_is_runtime_data;
extern PropertyRNA &rna_ID_is_editable;
extern PropertyRNA &rna_ID_tag;
extern PropertyRNA &rna_ID_is_library_indirect;
extern PropertyRNA &rna_ID_library;
extern PropertyRNA &rna_ID_library_weak_reference;
extern PropertyRNA &rna_ID_asset_data;
extern PropertyRNA &rna_ID_override_library;
extern PropertyRNA &rna_ID_preview;

extern FunctionRNA rna_ID_rename_func;
extern PropertyRNA &rna_ID_rename_name;
extern PropertyRNA &rna_ID_rename_mode;
extern PropertyRNA &rna_ID_rename_id_rename_result;

extern FunctionRNA rna_ID_evaluated_get_func;
extern PropertyRNA &rna_ID_evaluated_get_depsgraph;
extern PropertyRNA &rna_ID_evaluated_get_id;

extern FunctionRNA rna_ID_copy_func;
extern PropertyRNA &rna_ID_copy_id;

extern FunctionRNA rna_ID_asset_mark_func;
extern FunctionRNA rna_ID_asset_clear_func;
extern FunctionRNA rna_ID_asset_generate_preview_func;
extern FunctionRNA rna_ID_override_create_func;
extern PropertyRNA &rna_ID_override_create_id;
extern PropertyRNA &rna_ID_override_create_remap_local_usages;

extern FunctionRNA rna_ID_override_hierarchy_create_func;
extern PropertyRNA &rna_ID_override_hierarchy_create_id;
extern PropertyRNA &rna_ID_override_hierarchy_create_scene;
extern PropertyRNA &rna_ID_override_hierarchy_create_view_layer;
extern PropertyRNA &rna_ID_override_hierarchy_create_reference;
extern PropertyRNA &rna_ID_override_hierarchy_create_do_fully_editable;

extern FunctionRNA rna_ID_user_clear_func;
extern FunctionRNA rna_ID_user_remap_func;
extern PropertyRNA &rna_ID_user_remap_new_id;

extern FunctionRNA rna_ID_make_local_func;
extern PropertyRNA &rna_ID_make_local_clear_proxy;
extern PropertyRNA &rna_ID_make_local_clear_liboverride;
extern PropertyRNA &rna_ID_make_local_clear_asset_data;
extern PropertyRNA &rna_ID_make_local_id;

extern FunctionRNA rna_ID_user_of_id_func;
extern PropertyRNA &rna_ID_user_of_id_id;
extern PropertyRNA &rna_ID_user_of_id_count;

extern FunctionRNA rna_ID_animation_data_create_func;
extern PropertyRNA &rna_ID_animation_data_create_anim_data;

extern FunctionRNA rna_ID_animation_data_clear_func;
extern FunctionRNA rna_ID_update_tag_func;
extern PropertyRNA &rna_ID_update_tag_refresh;

extern FunctionRNA rna_ID_preview_ensure_func;
extern PropertyRNA &rna_ID_preview_ensure_preview_image;



extern PropertyRNA &rna_Paint_rna_properties;
extern PropertyRNA &rna_Paint_rna_type;
extern PropertyRNA &rna_Paint_brush;
extern PropertyRNA &rna_Paint_brush_asset_reference;
extern PropertyRNA &rna_Paint_eraser_brush;
extern PropertyRNA &rna_Paint_eraser_brush_asset_reference;
extern PropertyRNA &rna_Paint_palette;
extern PropertyRNA &rna_Paint_show_brush;
extern PropertyRNA &rna_Paint_show_brush_on_surface;
extern PropertyRNA &rna_Paint_show_low_resolution;
extern PropertyRNA &rna_Paint_use_sculpt_delay_updates;
extern PropertyRNA &rna_Paint_use_symmetry_x;
extern PropertyRNA &rna_Paint_use_symmetry_y;
extern PropertyRNA &rna_Paint_use_symmetry_z;
extern PropertyRNA &rna_Paint_use_symmetry_feather;
extern PropertyRNA &rna_Paint_cavity_curve;
extern PropertyRNA &rna_Paint_use_cavity;
extern PropertyRNA &rna_Paint_tile_offset;
extern PropertyRNA &rna_Paint_tile_x;
extern PropertyRNA &rna_Paint_tile_y;
extern PropertyRNA &rna_Paint_tile_z;


extern PropertyRNA &rna_Paint_rna_properties;
extern PropertyRNA &rna_Paint_rna_type;
extern PropertyRNA &rna_Paint_brush;
extern PropertyRNA &rna_Paint_brush_asset_reference;
extern PropertyRNA &rna_Paint_eraser_brush;
extern PropertyRNA &rna_Paint_eraser_brush_asset_reference;
extern PropertyRNA &rna_Paint_palette;
extern PropertyRNA &rna_Paint_show_brush;
extern PropertyRNA &rna_Paint_show_brush_on_surface;
extern PropertyRNA &rna_Paint_show_low_resolution;
extern PropertyRNA &rna_Paint_use_sculpt_delay_updates;
extern PropertyRNA &rna_Paint_use_symmetry_x;
extern PropertyRNA &rna_Paint_use_symmetry_y;
extern PropertyRNA &rna_Paint_use_symmetry_z;
extern PropertyRNA &rna_Paint_use_symmetry_feather;
extern PropertyRNA &rna_Paint_cavity_curve;
extern PropertyRNA &rna_Paint_use_cavity;
extern PropertyRNA &rna_Paint_tile_offset;
extern PropertyRNA &rna_Paint_tile_x;
extern PropertyRNA &rna_Paint_tile_y;
extern PropertyRNA &rna_Paint_tile_z;

extern PropertyRNA &rna_Sculpt_radial_symmetry;
extern PropertyRNA &rna_Sculpt_lock_x;
extern PropertyRNA &rna_Sculpt_lock_y;
extern PropertyRNA &rna_Sculpt_lock_z;
extern PropertyRNA &rna_Sculpt_use_deform_only;
extern PropertyRNA &rna_Sculpt_detail_size;
extern PropertyRNA &rna_Sculpt_detail_percent;
extern PropertyRNA &rna_Sculpt_constant_detail_resolution;
extern PropertyRNA &rna_Sculpt_use_automasking_topology;
extern PropertyRNA &rna_Sculpt_use_automasking_face_sets;
extern PropertyRNA &rna_Sculpt_use_automasking_boundary_edges;
extern PropertyRNA &rna_Sculpt_use_automasking_boundary_face_sets;
extern PropertyRNA &rna_Sculpt_use_automasking_cavity;
extern PropertyRNA &rna_Sculpt_use_automasking_cavity_inverted;
extern PropertyRNA &rna_Sculpt_use_automasking_custom_cavity_curve;
extern PropertyRNA &rna_Sculpt_automasking_boundary_edges_propagation_steps;
extern PropertyRNA &rna_Sculpt_automasking_cavity_factor;
extern PropertyRNA &rna_Sculpt_automasking_cavity_blur_steps;
extern PropertyRNA &rna_Sculpt_automasking_cavity_curve;
extern PropertyRNA &rna_Sculpt_automasking_cavity_curve_op;
extern PropertyRNA &rna_Sculpt_use_automasking_start_normal;
extern PropertyRNA &rna_Sculpt_use_automasking_view_normal;
extern PropertyRNA &rna_Sculpt_use_automasking_view_occlusion;
extern PropertyRNA &rna_Sculpt_automasking_start_normal_limit;
extern PropertyRNA &rna_Sculpt_automasking_start_normal_falloff;
extern PropertyRNA &rna_Sculpt_automasking_view_normal_limit;
extern PropertyRNA &rna_Sculpt_automasking_view_normal_falloff;
extern PropertyRNA &rna_Sculpt_symmetrize_direction;
extern PropertyRNA &rna_Sculpt_detail_refine_method;
extern PropertyRNA &rna_Sculpt_detail_type_method;
extern PropertyRNA &rna_Sculpt_gravity;
extern PropertyRNA &rna_Sculpt_transform_mode;
extern PropertyRNA &rna_Sculpt_gravity_object;


extern PropertyRNA &rna_UvSculpt_rna_properties;
extern PropertyRNA &rna_UvSculpt_rna_type;
extern PropertyRNA &rna_UvSculpt_size;
extern PropertyRNA &rna_UvSculpt_strength;
extern PropertyRNA &rna_UvSculpt_strength_curve;
extern PropertyRNA &rna_UvSculpt_curve_preset;


extern PropertyRNA &rna_Paint_rna_properties;
extern PropertyRNA &rna_Paint_rna_type;
extern PropertyRNA &rna_Paint_brush;
extern PropertyRNA &rna_Paint_brush_asset_reference;
extern PropertyRNA &rna_Paint_eraser_brush;
extern PropertyRNA &rna_Paint_eraser_brush_asset_reference;
extern PropertyRNA &rna_Paint_palette;
extern PropertyRNA &rna_Paint_show_brush;
extern PropertyRNA &rna_Paint_show_brush_on_surface;
extern PropertyRNA &rna_Paint_show_low_resolution;
extern PropertyRNA &rna_Paint_use_sculpt_delay_updates;
extern PropertyRNA &rna_Paint_use_symmetry_x;
extern PropertyRNA &rna_Paint_use_symmetry_y;
extern PropertyRNA &rna_Paint_use_symmetry_z;
extern PropertyRNA &rna_Paint_use_symmetry_feather;
extern PropertyRNA &rna_Paint_cavity_curve;
extern PropertyRNA &rna_Paint_use_cavity;
extern PropertyRNA &rna_Paint_tile_offset;
extern PropertyRNA &rna_Paint_tile_x;
extern PropertyRNA &rna_Paint_tile_y;
extern PropertyRNA &rna_Paint_tile_z;

extern PropertyRNA &rna_GpPaint_color_mode;


extern PropertyRNA &rna_Paint_rna_properties;
extern PropertyRNA &rna_Paint_rna_type;
extern PropertyRNA &rna_Paint_brush;
extern PropertyRNA &rna_Paint_brush_asset_reference;
extern PropertyRNA &rna_Paint_eraser_brush;
extern PropertyRNA &rna_Paint_eraser_brush_asset_reference;
extern PropertyRNA &rna_Paint_palette;
extern PropertyRNA &rna_Paint_show_brush;
extern PropertyRNA &rna_Paint_show_brush_on_surface;
extern PropertyRNA &rna_Paint_show_low_resolution;
extern PropertyRNA &rna_Paint_use_sculpt_delay_updates;
extern PropertyRNA &rna_Paint_use_symmetry_x;
extern PropertyRNA &rna_Paint_use_symmetry_y;
extern PropertyRNA &rna_Paint_use_symmetry_z;
extern PropertyRNA &rna_Paint_use_symmetry_feather;
extern PropertyRNA &rna_Paint_cavity_curve;
extern PropertyRNA &rna_Paint_use_cavity;
extern PropertyRNA &rna_Paint_tile_offset;
extern PropertyRNA &rna_Paint_tile_x;
extern PropertyRNA &rna_Paint_tile_y;
extern PropertyRNA &rna_Paint_tile_z;


extern PropertyRNA &rna_Paint_rna_properties;
extern PropertyRNA &rna_Paint_rna_type;
extern PropertyRNA &rna_Paint_brush;
extern PropertyRNA &rna_Paint_brush_asset_reference;
extern PropertyRNA &rna_Paint_eraser_brush;
extern PropertyRNA &rna_Paint_eraser_brush_asset_reference;
extern PropertyRNA &rna_Paint_palette;
extern PropertyRNA &rna_Paint_show_brush;
extern PropertyRNA &rna_Paint_show_brush_on_surface;
extern PropertyRNA &rna_Paint_show_low_resolution;
extern PropertyRNA &rna_Paint_use_sculpt_delay_updates;
extern PropertyRNA &rna_Paint_use_symmetry_x;
extern PropertyRNA &rna_Paint_use_symmetry_y;
extern PropertyRNA &rna_Paint_use_symmetry_z;
extern PropertyRNA &rna_Paint_use_symmetry_feather;
extern PropertyRNA &rna_Paint_cavity_curve;
extern PropertyRNA &rna_Paint_use_cavity;
extern PropertyRNA &rna_Paint_tile_offset;
extern PropertyRNA &rna_Paint_tile_x;
extern PropertyRNA &rna_Paint_tile_y;
extern PropertyRNA &rna_Paint_tile_z;


extern PropertyRNA &rna_Paint_rna_properties;
extern PropertyRNA &rna_Paint_rna_type;
extern PropertyRNA &rna_Paint_brush;
extern PropertyRNA &rna_Paint_brush_asset_reference;
extern PropertyRNA &rna_Paint_eraser_brush;
extern PropertyRNA &rna_Paint_eraser_brush_asset_reference;
extern PropertyRNA &rna_Paint_palette;
extern PropertyRNA &rna_Paint_show_brush;
extern PropertyRNA &rna_Paint_show_brush_on_surface;
extern PropertyRNA &rna_Paint_show_low_resolution;
extern PropertyRNA &rna_Paint_use_sculpt_delay_updates;
extern PropertyRNA &rna_Paint_use_symmetry_x;
extern PropertyRNA &rna_Paint_use_symmetry_y;
extern PropertyRNA &rna_Paint_use_symmetry_z;
extern PropertyRNA &rna_Paint_use_symmetry_feather;
extern PropertyRNA &rna_Paint_cavity_curve;
extern PropertyRNA &rna_Paint_use_cavity;
extern PropertyRNA &rna_Paint_tile_offset;
extern PropertyRNA &rna_Paint_tile_x;
extern PropertyRNA &rna_Paint_tile_y;
extern PropertyRNA &rna_Paint_tile_z;


extern PropertyRNA &rna_Paint_rna_properties;
extern PropertyRNA &rna_Paint_rna_type;
extern PropertyRNA &rna_Paint_brush;
extern PropertyRNA &rna_Paint_brush_asset_reference;
extern PropertyRNA &rna_Paint_eraser_brush;
extern PropertyRNA &rna_Paint_eraser_brush_asset_reference;
extern PropertyRNA &rna_Paint_palette;
extern PropertyRNA &rna_Paint_show_brush;
extern PropertyRNA &rna_Paint_show_brush_on_surface;
extern PropertyRNA &rna_Paint_show_low_resolution;
extern PropertyRNA &rna_Paint_use_sculpt_delay_updates;
extern PropertyRNA &rna_Paint_use_symmetry_x;
extern PropertyRNA &rna_Paint_use_symmetry_y;
extern PropertyRNA &rna_Paint_use_symmetry_z;
extern PropertyRNA &rna_Paint_use_symmetry_feather;
extern PropertyRNA &rna_Paint_cavity_curve;
extern PropertyRNA &rna_Paint_use_cavity;
extern PropertyRNA &rna_Paint_tile_offset;
extern PropertyRNA &rna_Paint_tile_x;
extern PropertyRNA &rna_Paint_tile_y;
extern PropertyRNA &rna_Paint_tile_z;

extern PropertyRNA &rna_VertexPaint_use_group_restrict;
extern PropertyRNA &rna_VertexPaint_radial_symmetry;


extern PropertyRNA &rna_PaintModeSettings_rna_properties;
extern PropertyRNA &rna_PaintModeSettings_rna_type;
extern PropertyRNA &rna_PaintModeSettings_canvas_source;
extern PropertyRNA &rna_PaintModeSettings_canvas_image;


extern PropertyRNA &rna_Paint_rna_properties;
extern PropertyRNA &rna_Paint_rna_type;
extern PropertyRNA &rna_Paint_brush;
extern PropertyRNA &rna_Paint_brush_asset_reference;
extern PropertyRNA &rna_Paint_eraser_brush;
extern PropertyRNA &rna_Paint_eraser_brush_asset_reference;
extern PropertyRNA &rna_Paint_palette;
extern PropertyRNA &rna_Paint_show_brush;
extern PropertyRNA &rna_Paint_show_brush_on_surface;
extern PropertyRNA &rna_Paint_show_low_resolution;
extern PropertyRNA &rna_Paint_use_sculpt_delay_updates;
extern PropertyRNA &rna_Paint_use_symmetry_x;
extern PropertyRNA &rna_Paint_use_symmetry_y;
extern PropertyRNA &rna_Paint_use_symmetry_z;
extern PropertyRNA &rna_Paint_use_symmetry_feather;
extern PropertyRNA &rna_Paint_cavity_curve;
extern PropertyRNA &rna_Paint_use_cavity;
extern PropertyRNA &rna_Paint_tile_offset;
extern PropertyRNA &rna_Paint_tile_x;
extern PropertyRNA &rna_Paint_tile_y;
extern PropertyRNA &rna_Paint_tile_z;

extern PropertyRNA &rna_ImagePaint_use_occlude;
extern PropertyRNA &rna_ImagePaint_use_backface_culling;
extern PropertyRNA &rna_ImagePaint_use_normal_falloff;
extern PropertyRNA &rna_ImagePaint_use_stencil_layer;
extern PropertyRNA &rna_ImagePaint_invert_stencil;
extern PropertyRNA &rna_ImagePaint_stencil_image;
extern PropertyRNA &rna_ImagePaint_canvas;
extern PropertyRNA &rna_ImagePaint_clone_image;
extern PropertyRNA &rna_ImagePaint_stencil_color;
extern PropertyRNA &rna_ImagePaint_dither;
extern PropertyRNA &rna_ImagePaint_use_clone_layer;
extern PropertyRNA &rna_ImagePaint_seam_bleed;
extern PropertyRNA &rna_ImagePaint_normal_angle;
extern PropertyRNA &rna_ImagePaint_screen_grab_size;
extern PropertyRNA &rna_ImagePaint_mode;
extern PropertyRNA &rna_ImagePaint_interpolation;
extern PropertyRNA &rna_ImagePaint_missing_uvs;
extern PropertyRNA &rna_ImagePaint_missing_materials;
extern PropertyRNA &rna_ImagePaint_missing_stencil;
extern PropertyRNA &rna_ImagePaint_missing_texture;
extern PropertyRNA &rna_ImagePaint_clone_alpha;
extern PropertyRNA &rna_ImagePaint_clone_offset;

extern FunctionRNA rna_ImagePaint_detect_data_func;
extern PropertyRNA &rna_ImagePaint_detect_data_ok;



extern PropertyRNA &rna_ParticleEdit_rna_properties;
extern PropertyRNA &rna_ParticleEdit_rna_type;
extern PropertyRNA &rna_ParticleEdit_tool;
extern PropertyRNA &rna_ParticleEdit_select_mode;
extern PropertyRNA &rna_ParticleEdit_use_preserve_length;
extern PropertyRNA &rna_ParticleEdit_use_preserve_root;
extern PropertyRNA &rna_ParticleEdit_use_emitter_deflect;
extern PropertyRNA &rna_ParticleEdit_emitter_distance;
extern PropertyRNA &rna_ParticleEdit_use_fade_time;
extern PropertyRNA &rna_ParticleEdit_use_auto_velocity;
extern PropertyRNA &rna_ParticleEdit_show_particles;
extern PropertyRNA &rna_ParticleEdit_use_default_interpolate;
extern PropertyRNA &rna_ParticleEdit_default_key_count;
extern PropertyRNA &rna_ParticleEdit_brush;
extern PropertyRNA &rna_ParticleEdit_display_step;
extern PropertyRNA &rna_ParticleEdit_fade_frames;
extern PropertyRNA &rna_ParticleEdit_type;
extern PropertyRNA &rna_ParticleEdit_is_editable;
extern PropertyRNA &rna_ParticleEdit_is_hair;
extern PropertyRNA &rna_ParticleEdit_object;
extern PropertyRNA &rna_ParticleEdit_shape_object;


extern PropertyRNA &rna_ParticleBrush_rna_properties;
extern PropertyRNA &rna_ParticleBrush_rna_type;
extern PropertyRNA &rna_ParticleBrush_size;
extern PropertyRNA &rna_ParticleBrush_strength;
extern PropertyRNA &rna_ParticleBrush_count;
extern PropertyRNA &rna_ParticleBrush_steps;
extern PropertyRNA &rna_ParticleBrush_puff_mode;
extern PropertyRNA &rna_ParticleBrush_use_puff_volume;
extern PropertyRNA &rna_ParticleBrush_length_mode;
extern PropertyRNA &rna_ParticleBrush_curve;


extern PropertyRNA &rna_GPencilSculptGuide_rna_properties;
extern PropertyRNA &rna_GPencilSculptGuide_rna_type;
extern PropertyRNA &rna_GPencilSculptGuide_use_guide;
extern PropertyRNA &rna_GPencilSculptGuide_use_snapping;
extern PropertyRNA &rna_GPencilSculptGuide_reference_object;
extern PropertyRNA &rna_GPencilSculptGuide_reference_point;
extern PropertyRNA &rna_GPencilSculptGuide_type;
extern PropertyRNA &rna_GPencilSculptGuide_angle;
extern PropertyRNA &rna_GPencilSculptGuide_angle_snap;
extern PropertyRNA &rna_GPencilSculptGuide_spacing;
extern PropertyRNA &rna_GPencilSculptGuide_location;


extern PropertyRNA &rna_GPencilSculptSettings_rna_properties;
extern PropertyRNA &rna_GPencilSculptSettings_rna_type;
extern PropertyRNA &rna_GPencilSculptSettings_guide;
extern PropertyRNA &rna_GPencilSculptSettings_use_multiframe_falloff;
extern PropertyRNA &rna_GPencilSculptSettings_use_thickness_curve;
extern PropertyRNA &rna_GPencilSculptSettings_use_scale_thickness;
extern PropertyRNA &rna_GPencilSculptSettings_use_automasking_stroke;
extern PropertyRNA &rna_GPencilSculptSettings_use_automasking_layer_stroke;
extern PropertyRNA &rna_GPencilSculptSettings_use_automasking_material_stroke;
extern PropertyRNA &rna_GPencilSculptSettings_use_automasking_layer_active;
extern PropertyRNA &rna_GPencilSculptSettings_use_automasking_material_active;
extern PropertyRNA &rna_GPencilSculptSettings_multiframe_falloff_curve;
extern PropertyRNA &rna_GPencilSculptSettings_thickness_primitive_curve;
extern PropertyRNA &rna_GPencilSculptSettings_lock_axis;
extern PropertyRNA &rna_GPencilSculptSettings_intersection_threshold;


extern PropertyRNA &rna_Paint_rna_properties;
extern PropertyRNA &rna_Paint_rna_type;
extern PropertyRNA &rna_Paint_brush;
extern PropertyRNA &rna_Paint_brush_asset_reference;
extern PropertyRNA &rna_Paint_eraser_brush;
extern PropertyRNA &rna_Paint_eraser_brush_asset_reference;
extern PropertyRNA &rna_Paint_palette;
extern PropertyRNA &rna_Paint_show_brush;
extern PropertyRNA &rna_Paint_show_brush_on_surface;
extern PropertyRNA &rna_Paint_show_low_resolution;
extern PropertyRNA &rna_Paint_use_sculpt_delay_updates;
extern PropertyRNA &rna_Paint_use_symmetry_x;
extern PropertyRNA &rna_Paint_use_symmetry_y;
extern PropertyRNA &rna_Paint_use_symmetry_z;
extern PropertyRNA &rna_Paint_use_symmetry_feather;
extern PropertyRNA &rna_Paint_cavity_curve;
extern PropertyRNA &rna_Paint_use_cavity;
extern PropertyRNA &rna_Paint_tile_offset;
extern PropertyRNA &rna_Paint_tile_x;
extern PropertyRNA &rna_Paint_tile_y;
extern PropertyRNA &rna_Paint_tile_z;

static PointerRNA Paint_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void Paint_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_Paint_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = Paint_rna_properties_get(iter);
    }
}

extern void Paint_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = Paint_rna_properties_get(iter);
    }
}

extern void Paint_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool Paint_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA Paint_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern PointerRNA Paint_brush_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_Paint_brush_get;
    return fn(ptr);
}

extern PointerRNA Paint_brush_asset_reference_get(PointerRNA *ptr)
{
    Paint *data = (Paint *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_AssetWeakReference, data->brush_asset_reference);
}

extern PointerRNA Paint_eraser_brush_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_Paint_eraser_brush_get;
    return fn(ptr);
}

extern void Paint_eraser_brush_set(PointerRNA *ptr, PointerRNA value, struct ReportList *reports)
{
    PropPointerSetFunc fn = rna_Paint_eraser_brush_set;
    fn(ptr, value, reports);
}

extern PointerRNA Paint_eraser_brush_asset_reference_get(PointerRNA *ptr)
{
    Paint *data = (Paint *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_AssetWeakReference, data->eraser_brush_asset_reference);
}

extern PointerRNA Paint_palette_get(PointerRNA *ptr)
{
    Paint *data = (Paint *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_Palette, data->palette);
}

extern void Paint_palette_set(PointerRNA *ptr, PointerRNA value, struct ReportList *reports)
{
    Paint *data = (Paint *)(ptr->data);
    if (value.data && ptr->owner_id && value.owner_id && !BKE_id_can_use_id(*ptr->owner_id, *value.owner_id)) {
      return;
    }

    if (data->palette) {
        id_us_min((ID *)data->palette);
    }
    if (value.data) {
        id_us_plus((ID *)value.data);
    }
    *(void **)&data->palette = value.data;
}

extern bool Paint_show_brush_get(PointerRNA *ptr)
{
    Paint *data = (Paint *)(ptr->data);
    return (((data->flags) & 1) != 0);
}

extern void Paint_show_brush_set(PointerRNA *ptr, bool value)
{
    Paint *data = (Paint *)(ptr->data);
    if (value) { data->flags |= 1; }
    else { data->flags &= ~1; }
}

extern bool Paint_show_brush_on_surface_get(PointerRNA *ptr)
{
    Paint *data = (Paint *)(ptr->data);
    return (((data->flags) & 4) != 0);
}

extern void Paint_show_brush_on_surface_set(PointerRNA *ptr, bool value)
{
    Paint *data = (Paint *)(ptr->data);
    if (value) { data->flags |= 4; }
    else { data->flags &= ~4; }
}

extern bool Paint_show_low_resolution_get(PointerRNA *ptr)
{
    Paint *data = (Paint *)(ptr->data);
    return (((data->flags) & 2) != 0);
}

extern void Paint_show_low_resolution_set(PointerRNA *ptr, bool value)
{
    Paint *data = (Paint *)(ptr->data);
    if (value) { data->flags |= 2; }
    else { data->flags &= ~2; }
}

extern bool Paint_use_sculpt_delay_updates_get(PointerRNA *ptr)
{
    Paint *data = (Paint *)(ptr->data);
    return (((data->flags) & 16) != 0);
}

extern void Paint_use_sculpt_delay_updates_set(PointerRNA *ptr, bool value)
{
    Paint *data = (Paint *)(ptr->data);
    if (value) { data->flags |= 16; }
    else { data->flags &= ~16; }
}

extern bool Paint_use_symmetry_x_get(PointerRNA *ptr)
{
    Paint *data = (Paint *)(ptr->data);
    return (((data->symmetry_flags) & 1) != 0);
}

extern void Paint_use_symmetry_x_set(PointerRNA *ptr, bool value)
{
    Paint *data = (Paint *)(ptr->data);
    if (value) { data->symmetry_flags |= 1; }
    else { data->symmetry_flags &= ~1; }
}

extern bool Paint_use_symmetry_y_get(PointerRNA *ptr)
{
    Paint *data = (Paint *)(ptr->data);
    return (((data->symmetry_flags) & 2) != 0);
}

extern void Paint_use_symmetry_y_set(PointerRNA *ptr, bool value)
{
    Paint *data = (Paint *)(ptr->data);
    if (value) { data->symmetry_flags |= 2; }
    else { data->symmetry_flags &= ~2; }
}

extern bool Paint_use_symmetry_z_get(PointerRNA *ptr)
{
    Paint *data = (Paint *)(ptr->data);
    return (((data->symmetry_flags) & 4) != 0);
}

extern void Paint_use_symmetry_z_set(PointerRNA *ptr, bool value)
{
    Paint *data = (Paint *)(ptr->data);
    if (value) { data->symmetry_flags |= 4; }
    else { data->symmetry_flags &= ~4; }
}

extern bool Paint_use_symmetry_feather_get(PointerRNA *ptr)
{
    Paint *data = (Paint *)(ptr->data);
    return (((data->symmetry_flags) & 8) != 0);
}

extern void Paint_use_symmetry_feather_set(PointerRNA *ptr, bool value)
{
    Paint *data = (Paint *)(ptr->data);
    if (value) { data->symmetry_flags |= 8; }
    else { data->symmetry_flags &= ~8; }
}

extern PointerRNA Paint_cavity_curve_get(PointerRNA *ptr)
{
    Paint *data = (Paint *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_CurveMapping, data->cavity_curve);
}

extern bool Paint_use_cavity_get(PointerRNA *ptr)
{
    Paint *data = (Paint *)(ptr->data);
    return (((data->flags) & 8) != 0);
}

extern void Paint_use_cavity_set(PointerRNA *ptr, bool value)
{
    Paint *data = (Paint *)(ptr->data);
    if (value) { data->flags |= 8; }
    else { data->flags &= ~8; }
}

extern void Paint_tile_offset_get(PointerRNA *ptr, float values[3])
{
    Paint *data = (Paint *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        values[i] = (float)(((float *)data->tile_offset)[i]);
    }
}

extern void Paint_tile_offset_set(PointerRNA *ptr, const float values[3])
{
    Paint *data = (Paint *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        ((float *)data->tile_offset)[i] = std::clamp(values[i], 0.0099999998f, FLT_MAX);
    }
}

extern bool Paint_tile_x_get(PointerRNA *ptr)
{
    Paint *data = (Paint *)(ptr->data);
    return (((data->symmetry_flags) & 16) != 0);
}

extern void Paint_tile_x_set(PointerRNA *ptr, bool value)
{
    Paint *data = (Paint *)(ptr->data);
    if (value) { data->symmetry_flags |= 16; }
    else { data->symmetry_flags &= ~16; }
}

extern bool Paint_tile_y_get(PointerRNA *ptr)
{
    Paint *data = (Paint *)(ptr->data);
    return (((data->symmetry_flags) & 32) != 0);
}

extern void Paint_tile_y_set(PointerRNA *ptr, bool value)
{
    Paint *data = (Paint *)(ptr->data);
    if (value) { data->symmetry_flags |= 32; }
    else { data->symmetry_flags &= ~32; }
}

extern bool Paint_tile_z_get(PointerRNA *ptr)
{
    Paint *data = (Paint *)(ptr->data);
    return (((data->symmetry_flags) & 64) != 0);
}

extern void Paint_tile_z_set(PointerRNA *ptr, bool value)
{
    Paint *data = (Paint *)(ptr->data);
    if (value) { data->symmetry_flags |= 64; }
    else { data->symmetry_flags &= ~64; }
}

extern void Sculpt_radial_symmetry_get(PointerRNA *ptr, int values[3])
{
    Sculpt *data = (Sculpt *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        values[i] = (int)(((int *)data->radial_symm)[i]);
    }
}

extern void Sculpt_radial_symmetry_set(PointerRNA *ptr, const int values[3])
{
    Sculpt *data = (Sculpt *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        ((int *)data->radial_symm)[i] = std::clamp(values[i], 1, 64);
    }
}

extern bool Sculpt_lock_x_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (((data->flags) & 8) != 0);
}

extern void Sculpt_lock_x_set(PointerRNA *ptr, bool value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    if (value) { data->flags |= 8; }
    else { data->flags &= ~8; }
}

extern bool Sculpt_lock_y_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (((data->flags) & 16) != 0);
}

extern void Sculpt_lock_y_set(PointerRNA *ptr, bool value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    if (value) { data->flags |= 16; }
    else { data->flags &= ~16; }
}

extern bool Sculpt_lock_z_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (((data->flags) & 32) != 0);
}

extern void Sculpt_lock_z_set(PointerRNA *ptr, bool value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    if (value) { data->flags |= 32; }
    else { data->flags &= ~32; }
}

extern bool Sculpt_use_deform_only_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (((data->flags) & 256) != 0);
}

extern void Sculpt_use_deform_only_set(PointerRNA *ptr, bool value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    if (value) { data->flags |= 256; }
    else { data->flags &= ~256; }
}

extern float Sculpt_detail_size_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (float)(data->detail_size);
}

extern void Sculpt_detail_size_set(PointerRNA *ptr, float value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
#ifdef __cplusplus
    data->detail_size = (std::remove_reference_t<decltype(data->detail_size)>)std::clamp(value, 0.5000000000f, 40.0f);
#else
    data->detail_size = std::clamp(value, 0.5000000000f, 40.0f);
#endif
}

extern float Sculpt_detail_percent_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (float)(data->detail_percent);
}

extern void Sculpt_detail_percent_set(PointerRNA *ptr, float value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
#ifdef __cplusplus
    data->detail_percent = (std::remove_reference_t<decltype(data->detail_percent)>)std::clamp(value, 0.5000000000f, 100.0f);
#else
    data->detail_percent = std::clamp(value, 0.5000000000f, 100.0f);
#endif
}

extern float Sculpt_constant_detail_resolution_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (float)(data->constant_detail);
}

extern void Sculpt_constant_detail_resolution_set(PointerRNA *ptr, float value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
#ifdef __cplusplus
    data->constant_detail = (std::remove_reference_t<decltype(data->constant_detail)>)std::clamp(value, 0.0001000000f, FLT_MAX);
#else
    data->constant_detail = std::clamp(value, 0.0001000000f, FLT_MAX);
#endif
}

extern bool Sculpt_use_automasking_topology_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (((data->automasking_flags) & 1) != 0);
}

extern void Sculpt_use_automasking_topology_set(PointerRNA *ptr, bool value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    if (value) { data->automasking_flags |= 1; }
    else { data->automasking_flags &= ~1; }
}

extern bool Sculpt_use_automasking_face_sets_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (((data->automasking_flags) & 2) != 0);
}

extern void Sculpt_use_automasking_face_sets_set(PointerRNA *ptr, bool value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    if (value) { data->automasking_flags |= 2; }
    else { data->automasking_flags &= ~2; }
}

extern bool Sculpt_use_automasking_boundary_edges_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (((data->automasking_flags) & 4) != 0);
}

extern void Sculpt_use_automasking_boundary_edges_set(PointerRNA *ptr, bool value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    if (value) { data->automasking_flags |= 4; }
    else { data->automasking_flags &= ~4; }
}

extern bool Sculpt_use_automasking_boundary_face_sets_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (((data->automasking_flags) & 8) != 0);
}

extern void Sculpt_use_automasking_boundary_face_sets_set(PointerRNA *ptr, bool value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    if (value) { data->automasking_flags |= 8; }
    else { data->automasking_flags &= ~8; }
}

extern bool Sculpt_use_automasking_cavity_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (((data->automasking_flags) & 16) != 0);
}

extern void Sculpt_use_automasking_cavity_set(PointerRNA *ptr, bool value)
{
    PropBooleanSetFunc fn = rna_Sculpt_automasking_cavity_set;
    fn(ptr, value);
}

extern bool Sculpt_use_automasking_cavity_inverted_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (((data->automasking_flags) & 32) != 0);
}

extern void Sculpt_use_automasking_cavity_inverted_set(PointerRNA *ptr, bool value)
{
    PropBooleanSetFunc fn = rna_Sculpt_automasking_invert_cavity_set;
    fn(ptr, value);
}

extern bool Sculpt_use_automasking_custom_cavity_curve_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (((data->automasking_flags) & 64) != 0);
}

extern void Sculpt_use_automasking_custom_cavity_curve_set(PointerRNA *ptr, bool value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    if (value) { data->automasking_flags |= 64; }
    else { data->automasking_flags &= ~64; }
}

extern int Sculpt_automasking_boundary_edges_propagation_steps_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (int)(data->automasking_boundary_edges_propagation_steps);
}

extern void Sculpt_automasking_boundary_edges_propagation_steps_set(PointerRNA *ptr, int value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
#ifdef __cplusplus
    data->automasking_boundary_edges_propagation_steps = (std::remove_reference_t<decltype(data->automasking_boundary_edges_propagation_steps)>)std::clamp(value, 1, 20);
#else
    data->automasking_boundary_edges_propagation_steps = std::clamp(value, 1, 20);
#endif
}

extern float Sculpt_automasking_cavity_factor_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (float)(data->automasking_cavity_factor);
}

extern void Sculpt_automasking_cavity_factor_set(PointerRNA *ptr, float value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
#ifdef __cplusplus
    data->automasking_cavity_factor = (std::remove_reference_t<decltype(data->automasking_cavity_factor)>)std::clamp(value, 0.0f, 5.0f);
#else
    data->automasking_cavity_factor = std::clamp(value, 0.0f, 5.0f);
#endif
}

extern int Sculpt_automasking_cavity_blur_steps_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (int)(data->automasking_cavity_blur_steps);
}

extern void Sculpt_automasking_cavity_blur_steps_set(PointerRNA *ptr, int value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
#ifdef __cplusplus
    data->automasking_cavity_blur_steps = (std::remove_reference_t<decltype(data->automasking_cavity_blur_steps)>)std::clamp(value, 0, 25);
#else
    data->automasking_cavity_blur_steps = std::clamp(value, 0, 25);
#endif
}

extern PointerRNA Sculpt_automasking_cavity_curve_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_CurveMapping, data->automasking_cavity_curve);
}

extern PointerRNA Sculpt_automasking_cavity_curve_op_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_CurveMapping, data->automasking_cavity_curve_op);
}

extern bool Sculpt_use_automasking_start_normal_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (((data->automasking_flags) & 256) != 0);
}

extern void Sculpt_use_automasking_start_normal_set(PointerRNA *ptr, bool value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    if (value) { data->automasking_flags |= 256; }
    else { data->automasking_flags &= ~256; }
}

extern bool Sculpt_use_automasking_view_normal_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (((data->automasking_flags) & 512) != 0);
}

extern void Sculpt_use_automasking_view_normal_set(PointerRNA *ptr, bool value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    if (value) { data->automasking_flags |= 512; }
    else { data->automasking_flags &= ~512; }
}

extern bool Sculpt_use_automasking_view_occlusion_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (((data->automasking_flags) & 1024) != 0);
}

extern void Sculpt_use_automasking_view_occlusion_set(PointerRNA *ptr, bool value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    if (value) { data->automasking_flags |= 1024; }
    else { data->automasking_flags &= ~1024; }
}

extern float Sculpt_automasking_start_normal_limit_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (float)(data->automasking_start_normal_limit);
}

extern void Sculpt_automasking_start_normal_limit_set(PointerRNA *ptr, float value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
#ifdef __cplusplus
    data->automasking_start_normal_limit = (std::remove_reference_t<decltype(data->automasking_start_normal_limit)>)std::clamp(value, 0.0001000000f, 3.1415927410f);
#else
    data->automasking_start_normal_limit = std::clamp(value, 0.0001000000f, 3.1415927410f);
#endif
}

extern float Sculpt_automasking_start_normal_falloff_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (float)(data->automasking_start_normal_falloff);
}

extern void Sculpt_automasking_start_normal_falloff_set(PointerRNA *ptr, float value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
#ifdef __cplusplus
    data->automasking_start_normal_falloff = (std::remove_reference_t<decltype(data->automasking_start_normal_falloff)>)std::clamp(value, 0.0001000000f, 1.0f);
#else
    data->automasking_start_normal_falloff = std::clamp(value, 0.0001000000f, 1.0f);
#endif
}

extern float Sculpt_automasking_view_normal_limit_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (float)(data->automasking_view_normal_limit);
}

extern void Sculpt_automasking_view_normal_limit_set(PointerRNA *ptr, float value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
#ifdef __cplusplus
    data->automasking_view_normal_limit = (std::remove_reference_t<decltype(data->automasking_view_normal_limit)>)std::clamp(value, 0.0001000000f, 3.1415927410f);
#else
    data->automasking_view_normal_limit = std::clamp(value, 0.0001000000f, 3.1415927410f);
#endif
}

extern float Sculpt_automasking_view_normal_falloff_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (float)(data->automasking_view_normal_falloff);
}

extern void Sculpt_automasking_view_normal_falloff_set(PointerRNA *ptr, float value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
#ifdef __cplusplus
    data->automasking_view_normal_falloff = (std::remove_reference_t<decltype(data->automasking_view_normal_falloff)>)std::clamp(value, 0.0001000000f, 1.0f);
#else
    data->automasking_view_normal_falloff = std::clamp(value, 0.0001000000f, 1.0f);
#endif
}

extern int Sculpt_symmetrize_direction_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (int)(data->symmetrize_direction);
}

extern void Sculpt_symmetrize_direction_set(PointerRNA *ptr, int value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
#ifdef __cplusplus
    data->symmetrize_direction = (std::remove_reference_t<decltype(data->symmetrize_direction)>)value;
#else
    data->symmetrize_direction = value;
#endif
}

extern int Sculpt_detail_refine_method_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return ((data->flags) & 6144);
}

extern void Sculpt_detail_refine_method_set(PointerRNA *ptr, int value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    data->flags &= ~6144;
    data->flags |= value;
}

extern int Sculpt_detail_type_method_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return ((data->flags) & 90112);
}

extern void Sculpt_detail_type_method_set(PointerRNA *ptr, int value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    data->flags &= ~90112;
    data->flags |= value;
}

extern float Sculpt_gravity_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (float)(data->gravity_factor);
}

extern void Sculpt_gravity_set(PointerRNA *ptr, float value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
#ifdef __cplusplus
    data->gravity_factor = (std::remove_reference_t<decltype(data->gravity_factor)>)std::clamp(value, 0.0f, 1.0f);
#else
    data->gravity_factor = std::clamp(value, 0.0f, 1.0f);
#endif
}

extern int Sculpt_transform_mode_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return (int)(data->transform_mode);
}

extern void Sculpt_transform_mode_set(PointerRNA *ptr, int value)
{
    Sculpt *data = (Sculpt *)(ptr->data);
#ifdef __cplusplus
    data->transform_mode = (std::remove_reference_t<decltype(data->transform_mode)>)value;
#else
    data->transform_mode = value;
#endif
}

extern PointerRNA Sculpt_gravity_object_get(PointerRNA *ptr)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_Object, data->gravity_object);
}

extern void Sculpt_gravity_object_set(PointerRNA *ptr, PointerRNA value, struct ReportList *reports)
{
    Sculpt *data = (Sculpt *)(ptr->data);
    if (value.data && ptr->owner_id && value.owner_id && !BKE_id_can_use_id(*ptr->owner_id, *value.owner_id)) {
      return;
    }
    if (value.data) {
        id_lib_extern((ID *)value.data);
    }
    *(void **)&data->gravity_object = value.data;
}

static PointerRNA UvSculpt_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void UvSculpt_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_UvSculpt_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = UvSculpt_rna_properties_get(iter);
    }
}

extern void UvSculpt_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = UvSculpt_rna_properties_get(iter);
    }
}

extern void UvSculpt_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool UvSculpt_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA UvSculpt_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern int UvSculpt_size_get(PointerRNA *ptr)
{
    UvSculpt *data = (UvSculpt *)(ptr->data);
    return (int)(data->size);
}

extern void UvSculpt_size_set(PointerRNA *ptr, int value)
{
    UvSculpt *data = (UvSculpt *)(ptr->data);
#ifdef __cplusplus
    data->size = (std::remove_reference_t<decltype(data->size)>)std::clamp(value, 1, 5000);
#else
    data->size = std::clamp(value, 1, 5000);
#endif
}

extern float UvSculpt_strength_get(PointerRNA *ptr)
{
    UvSculpt *data = (UvSculpt *)(ptr->data);
    return (float)(data->strength);
}

extern void UvSculpt_strength_set(PointerRNA *ptr, float value)
{
    UvSculpt *data = (UvSculpt *)(ptr->data);
#ifdef __cplusplus
    data->strength = (std::remove_reference_t<decltype(data->strength)>)std::clamp(value, 0.0f, 1.0f);
#else
    data->strength = std::clamp(value, 0.0f, 1.0f);
#endif
}

extern PointerRNA UvSculpt_strength_curve_get(PointerRNA *ptr)
{
    UvSculpt *data = (UvSculpt *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_CurveMapping, data->strength_curve);
}

extern int UvSculpt_curve_preset_get(PointerRNA *ptr)
{
    UvSculpt *data = (UvSculpt *)(ptr->data);
    return (int)(data->curve_preset);
}

extern void UvSculpt_curve_preset_set(PointerRNA *ptr, int value)
{
    PropEnumSetFunc fn = rna_UvSculpt_curve_preset_set;
    fn(ptr, value);
}

extern int GpPaint_color_mode_get(PointerRNA *ptr)
{
    GpPaint *data = (GpPaint *)(ptr->data);
    return (int)(data->mode);
}

extern void GpPaint_color_mode_set(PointerRNA *ptr, int value)
{
    GpPaint *data = (GpPaint *)(ptr->data);
#ifdef __cplusplus
    data->mode = (std::remove_reference_t<decltype(data->mode)>)value;
#else
    data->mode = value;
#endif
}

extern bool VertexPaint_use_group_restrict_get(PointerRNA *ptr)
{
    VPaint *data = (VPaint *)(ptr->data);
    return (((data->flag) & 128) != 0);
}

extern void VertexPaint_use_group_restrict_set(PointerRNA *ptr, bool value)
{
    VPaint *data = (VPaint *)(ptr->data);
    if (value) { data->flag |= 128; }
    else { data->flag &= ~128; }
}

extern void VertexPaint_radial_symmetry_get(PointerRNA *ptr, int values[3])
{
    VPaint *data = (VPaint *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        values[i] = (int)(((int *)data->radial_symm)[i]);
    }
}

extern void VertexPaint_radial_symmetry_set(PointerRNA *ptr, const int values[3])
{
    VPaint *data = (VPaint *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        ((int *)data->radial_symm)[i] = std::clamp(values[i], 1, 64);
    }
}

static PointerRNA PaintModeSettings_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void PaintModeSettings_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_PaintModeSettings_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = PaintModeSettings_rna_properties_get(iter);
    }
}

extern void PaintModeSettings_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = PaintModeSettings_rna_properties_get(iter);
    }
}

extern void PaintModeSettings_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool PaintModeSettings_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA PaintModeSettings_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern int PaintModeSettings_canvas_source_get(PointerRNA *ptr)
{
    PaintModeSettings *data = (PaintModeSettings *)(ptr->data);
    return (int)(data->canvas_source);
}

extern void PaintModeSettings_canvas_source_set(PointerRNA *ptr, int value)
{
    PaintModeSettings *data = (PaintModeSettings *)(ptr->data);
#ifdef __cplusplus
    data->canvas_source = (std::remove_reference_t<decltype(data->canvas_source)>)value;
#else
    data->canvas_source = value;
#endif
}

extern PointerRNA PaintModeSettings_canvas_image_get(PointerRNA *ptr)
{
    PaintModeSettings *data = (PaintModeSettings *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_Image, data->canvas_image);
}

extern void PaintModeSettings_canvas_image_set(PointerRNA *ptr, PointerRNA value, struct ReportList *reports)
{
    PaintModeSettings *data = (PaintModeSettings *)(ptr->data);
    if (value.data && ptr->owner_id && value.owner_id && !BKE_id_can_use_id(*ptr->owner_id, *value.owner_id)) {
      return;
    }

    if (data->canvas_image) {
        id_us_min((ID *)data->canvas_image);
    }
    if (value.data) {
        id_us_plus((ID *)value.data);
    }
    *(void **)&data->canvas_image = value.data;
}

extern bool ImagePaint_use_occlude_get(PointerRNA *ptr)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    return !(((data->flag) & 16) != 0);
}

extern void ImagePaint_use_occlude_set(PointerRNA *ptr, bool value)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    if (!value) { data->flag |= 16; }
    else { data->flag &= ~16; }
}

extern bool ImagePaint_use_backface_culling_get(PointerRNA *ptr)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    return !(((data->flag) & 32) != 0);
}

extern void ImagePaint_use_backface_culling_set(PointerRNA *ptr, bool value)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    if (!value) { data->flag |= 32; }
    else { data->flag &= ~32; }
}

extern bool ImagePaint_use_normal_falloff_get(PointerRNA *ptr)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    return !(((data->flag) & 64) != 0);
}

extern void ImagePaint_use_normal_falloff_set(PointerRNA *ptr, bool value)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    if (!value) { data->flag |= 64; }
    else { data->flag &= ~64; }
}

extern bool ImagePaint_use_stencil_layer_get(PointerRNA *ptr)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    return (((data->flag) & 256) != 0);
}

extern void ImagePaint_use_stencil_layer_set(PointerRNA *ptr, bool value)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    if (value) { data->flag |= 256; }
    else { data->flag &= ~256; }
}

extern bool ImagePaint_invert_stencil_get(PointerRNA *ptr)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    return (((data->flag) & 512) != 0);
}

extern void ImagePaint_invert_stencil_set(PointerRNA *ptr, bool value)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    if (value) { data->flag |= 512; }
    else { data->flag &= ~512; }
}

extern PointerRNA ImagePaint_stencil_image_get(PointerRNA *ptr)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_Image, data->stencil);
}

extern void ImagePaint_stencil_image_set(PointerRNA *ptr, PointerRNA value, struct ReportList *reports)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    if (value.data && ptr->owner_id && value.owner_id && !BKE_id_can_use_id(*ptr->owner_id, *value.owner_id)) {
      return;
    }

    if (data->stencil) {
        id_us_min((ID *)data->stencil);
    }
    if (value.data) {
        id_us_plus((ID *)value.data);
    }
    *(void **)&data->stencil = value.data;
}

extern PointerRNA ImagePaint_canvas_get(PointerRNA *ptr)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_Image, data->canvas);
}

extern void ImagePaint_canvas_set(PointerRNA *ptr, PointerRNA value, struct ReportList *reports)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    if (value.data && ptr->owner_id && value.owner_id && !BKE_id_can_use_id(*ptr->owner_id, *value.owner_id)) {
      return;
    }

    if (data->canvas) {
        id_us_min((ID *)data->canvas);
    }
    if (value.data) {
        id_us_plus((ID *)value.data);
    }
    *(void **)&data->canvas = value.data;
}

extern PointerRNA ImagePaint_clone_image_get(PointerRNA *ptr)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_Image, data->clone);
}

extern void ImagePaint_clone_image_set(PointerRNA *ptr, PointerRNA value, struct ReportList *reports)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    if (value.data && ptr->owner_id && value.owner_id && !BKE_id_can_use_id(*ptr->owner_id, *value.owner_id)) {
      return;
    }

    if (data->clone) {
        id_us_min((ID *)data->clone);
    }
    if (value.data) {
        id_us_plus((ID *)value.data);
    }
    *(void **)&data->clone = value.data;
}

extern void ImagePaint_stencil_color_get(PointerRNA *ptr, float values[3])
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        values[i] = (float)(((float *)data->stencil_col)[i]);
    }
}

extern void ImagePaint_stencil_color_set(PointerRNA *ptr, const float values[3])
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        ((float *)data->stencil_col)[i] = std::clamp(values[i], 0.0f, 1.0f);
    }
}

extern float ImagePaint_dither_get(PointerRNA *ptr)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    return (float)(data->dither);
}

extern void ImagePaint_dither_set(PointerRNA *ptr, float value)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
#ifdef __cplusplus
    data->dither = (std::remove_reference_t<decltype(data->dither)>)std::clamp(value, 0.0f, 2.0f);
#else
    data->dither = std::clamp(value, 0.0f, 2.0f);
#endif
}

extern bool ImagePaint_use_clone_layer_get(PointerRNA *ptr)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    return (((data->flag) & 128) != 0);
}

extern void ImagePaint_use_clone_layer_set(PointerRNA *ptr, bool value)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    if (value) { data->flag |= 128; }
    else { data->flag &= ~128; }
}

extern int ImagePaint_seam_bleed_get(PointerRNA *ptr)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    return (int)(data->seam_bleed);
}

extern void ImagePaint_seam_bleed_set(PointerRNA *ptr, int value)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
#ifdef __cplusplus
    data->seam_bleed = (std::remove_reference_t<decltype(data->seam_bleed)>)std::clamp(value, -32768, 32767);
#else
    data->seam_bleed = std::clamp(value, -32768, 32767);
#endif
}

extern int ImagePaint_normal_angle_get(PointerRNA *ptr)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    return (int)(data->normal_angle);
}

extern void ImagePaint_normal_angle_set(PointerRNA *ptr, int value)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
#ifdef __cplusplus
    data->normal_angle = (std::remove_reference_t<decltype(data->normal_angle)>)std::clamp(value, 0, 90);
#else
    data->normal_angle = std::clamp(value, 0, 90);
#endif
}

extern void ImagePaint_screen_grab_size_get(PointerRNA *ptr, int values[2])
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 2; i++) {
        values[i] = (int)(((short *)data->screen_grab_size)[i]);
    }
}

extern void ImagePaint_screen_grab_size_set(PointerRNA *ptr, const int values[2])
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 2; i++) {
        ((short *)data->screen_grab_size)[i] = std::clamp(values[i], 512, 16384);
    }
}

extern int ImagePaint_mode_get(PointerRNA *ptr)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    return (int)(data->mode);
}

extern void ImagePaint_mode_set(PointerRNA *ptr, int value)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
#ifdef __cplusplus
    data->mode = (std::remove_reference_t<decltype(data->mode)>)value;
#else
    data->mode = value;
#endif
}

extern int ImagePaint_interpolation_get(PointerRNA *ptr)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    return (int)(data->interp);
}

extern void ImagePaint_interpolation_set(PointerRNA *ptr, int value)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
#ifdef __cplusplus
    data->interp = (std::remove_reference_t<decltype(data->interp)>)value;
#else
    data->interp = value;
#endif
}

extern bool ImagePaint_missing_uvs_get(PointerRNA *ptr)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    return (((data->missing_data) & 1) != 0);
}

extern bool ImagePaint_missing_materials_get(PointerRNA *ptr)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    return (((data->missing_data) & 2) != 0);
}

extern bool ImagePaint_missing_stencil_get(PointerRNA *ptr)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    return (((data->missing_data) & 8) != 0);
}

extern bool ImagePaint_missing_texture_get(PointerRNA *ptr)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    return (((data->missing_data) & 4) != 0);
}

extern float ImagePaint_clone_alpha_get(PointerRNA *ptr)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    return (float)(data->clone_alpha);
}

extern void ImagePaint_clone_alpha_set(PointerRNA *ptr, float value)
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
#ifdef __cplusplus
    data->clone_alpha = (std::remove_reference_t<decltype(data->clone_alpha)>)std::clamp(value, 0.0f, 1.0f);
#else
    data->clone_alpha = std::clamp(value, 0.0f, 1.0f);
#endif
}

extern void ImagePaint_clone_offset_get(PointerRNA *ptr, float values[2])
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 2; i++) {
        values[i] = (float)(((float *)data->clone_offset)[i]);
    }
}

extern void ImagePaint_clone_offset_set(PointerRNA *ptr, const float values[2])
{
    ImagePaintSettings *data = (ImagePaintSettings *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 2; i++) {
        ((float *)data->clone_offset)[i] = values[i];
    }
}

static PointerRNA ParticleEdit_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void ParticleEdit_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_ParticleEdit_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = ParticleEdit_rna_properties_get(iter);
    }
}

extern void ParticleEdit_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = ParticleEdit_rna_properties_get(iter);
    }
}

extern void ParticleEdit_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool ParticleEdit_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA ParticleEdit_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern int ParticleEdit_tool_get(PointerRNA *ptr)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    return (int)(data->brushtype);
}

extern void ParticleEdit_tool_set(PointerRNA *ptr, int value)
{
    PropEnumSetFunc fn = rna_ParticleEdit_tool_set;
    fn(ptr, value);
}

extern int ParticleEdit_select_mode_get(PointerRNA *ptr)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    return ((data->selectmode) & 7);
}

extern void ParticleEdit_select_mode_set(PointerRNA *ptr, int value)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    data->selectmode &= ~7;
    data->selectmode |= value;
}

extern bool ParticleEdit_use_preserve_length_get(PointerRNA *ptr)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    return (((data->flag) & 1) != 0);
}

extern void ParticleEdit_use_preserve_length_set(PointerRNA *ptr, bool value)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    if (value) { data->flag |= 1; }
    else { data->flag &= ~1; }
}

extern bool ParticleEdit_use_preserve_root_get(PointerRNA *ptr)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    return (((data->flag) & 2) != 0);
}

extern void ParticleEdit_use_preserve_root_set(PointerRNA *ptr, bool value)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    if (value) { data->flag |= 2; }
    else { data->flag &= ~2; }
}

extern bool ParticleEdit_use_emitter_deflect_get(PointerRNA *ptr)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    return (((data->flag) & 4) != 0);
}

extern void ParticleEdit_use_emitter_deflect_set(PointerRNA *ptr, bool value)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    if (value) { data->flag |= 4; }
    else { data->flag &= ~4; }
}

extern float ParticleEdit_emitter_distance_get(PointerRNA *ptr)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    return (float)(data->emitterdist);
}

extern void ParticleEdit_emitter_distance_set(PointerRNA *ptr, float value)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
#ifdef __cplusplus
    data->emitterdist = (std::remove_reference_t<decltype(data->emitterdist)>)value;
#else
    data->emitterdist = value;
#endif
}

extern bool ParticleEdit_use_fade_time_get(PointerRNA *ptr)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    return (((data->flag) & 128) != 0);
}

extern void ParticleEdit_use_fade_time_set(PointerRNA *ptr, bool value)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    if (value) { data->flag |= 128; }
    else { data->flag &= ~128; }
}

extern bool ParticleEdit_use_auto_velocity_get(PointerRNA *ptr)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    return (((data->flag) & 256) != 0);
}

extern void ParticleEdit_use_auto_velocity_set(PointerRNA *ptr, bool value)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    if (value) { data->flag |= 256; }
    else { data->flag &= ~256; }
}

extern bool ParticleEdit_show_particles_get(PointerRNA *ptr)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    return (((data->flag) & 16) != 0);
}

extern void ParticleEdit_show_particles_set(PointerRNA *ptr, bool value)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    if (value) { data->flag |= 16; }
    else { data->flag &= ~16; }
}

extern bool ParticleEdit_use_default_interpolate_get(PointerRNA *ptr)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    return (((data->flag) & 8) != 0);
}

extern void ParticleEdit_use_default_interpolate_set(PointerRNA *ptr, bool value)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    if (value) { data->flag |= 8; }
    else { data->flag &= ~8; }
}

extern int ParticleEdit_default_key_count_get(PointerRNA *ptr)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    return (int)(data->totaddkey);
}

extern void ParticleEdit_default_key_count_set(PointerRNA *ptr, int value)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
#ifdef __cplusplus
    data->totaddkey = (std::remove_reference_t<decltype(data->totaddkey)>)std::clamp(value, 2, 32767);
#else
    data->totaddkey = std::clamp(value, 2, 32767);
#endif
}

extern PointerRNA ParticleEdit_brush_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_ParticleEdit_brush_get;
    return fn(ptr);
}

extern int ParticleEdit_display_step_get(PointerRNA *ptr)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    return (int)(data->draw_step);
}

extern void ParticleEdit_display_step_set(PointerRNA *ptr, int value)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
#ifdef __cplusplus
    data->draw_step = (std::remove_reference_t<decltype(data->draw_step)>)std::clamp(value, 1, 10);
#else
    data->draw_step = std::clamp(value, 1, 10);
#endif
}

extern int ParticleEdit_fade_frames_get(PointerRNA *ptr)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    return (int)(data->fade_frames);
}

extern void ParticleEdit_fade_frames_set(PointerRNA *ptr, int value)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
#ifdef __cplusplus
    data->fade_frames = (std::remove_reference_t<decltype(data->fade_frames)>)std::clamp(value, 1, 100);
#else
    data->fade_frames = std::clamp(value, 1, 100);
#endif
}

extern int ParticleEdit_type_get(PointerRNA *ptr)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    return (int)(data->edittype);
}

extern void ParticleEdit_type_set(PointerRNA *ptr, int value)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
#ifdef __cplusplus
    data->edittype = (std::remove_reference_t<decltype(data->edittype)>)value;
#else
    data->edittype = value;
#endif
}

extern bool ParticleEdit_is_editable_get(PointerRNA *ptr)
{
    PropBooleanGetFunc fn = rna_ParticleEdit_editable_get;
    return fn(ptr);
}

extern bool ParticleEdit_is_hair_get(PointerRNA *ptr)
{
    PropBooleanGetFunc fn = rna_ParticleEdit_hair_get;
    return fn(ptr);
}

extern PointerRNA ParticleEdit_object_get(PointerRNA *ptr)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_Object, data->object);
}

extern PointerRNA ParticleEdit_shape_object_get(PointerRNA *ptr)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_Object, data->shape_object);
}

extern void ParticleEdit_shape_object_set(PointerRNA *ptr, PointerRNA value, struct ReportList *reports)
{
    ParticleEditSettings *data = (ParticleEditSettings *)(ptr->data);
    if (value.data && ptr->owner_id && value.owner_id && !BKE_id_can_use_id(*ptr->owner_id, *value.owner_id)) {
      return;
    }
    if (value.data) {
        id_lib_extern((ID *)value.data);
    }
    *(void **)&data->shape_object = value.data;
}

static PointerRNA ParticleBrush_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void ParticleBrush_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_ParticleBrush_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = ParticleBrush_rna_properties_get(iter);
    }
}

extern void ParticleBrush_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = ParticleBrush_rna_properties_get(iter);
    }
}

extern void ParticleBrush_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool ParticleBrush_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA ParticleBrush_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern int ParticleBrush_size_get(PointerRNA *ptr)
{
    ParticleBrushData *data = (ParticleBrushData *)(ptr->data);
    return (int)(data->size);
}

extern void ParticleBrush_size_set(PointerRNA *ptr, int value)
{
    ParticleBrushData *data = (ParticleBrushData *)(ptr->data);
#ifdef __cplusplus
    data->size = (std::remove_reference_t<decltype(data->size)>)std::clamp(value, 1, 32767);
#else
    data->size = std::clamp(value, 1, 32767);
#endif
}

extern float ParticleBrush_strength_get(PointerRNA *ptr)
{
    ParticleBrushData *data = (ParticleBrushData *)(ptr->data);
    return (float)(data->strength);
}

extern void ParticleBrush_strength_set(PointerRNA *ptr, float value)
{
    ParticleBrushData *data = (ParticleBrushData *)(ptr->data);
#ifdef __cplusplus
    data->strength = (std::remove_reference_t<decltype(data->strength)>)std::clamp(value, 0.0010000000f, 1.0f);
#else
    data->strength = std::clamp(value, 0.0010000000f, 1.0f);
#endif
}

extern int ParticleBrush_count_get(PointerRNA *ptr)
{
    ParticleBrushData *data = (ParticleBrushData *)(ptr->data);
    return (int)(data->count);
}

extern void ParticleBrush_count_set(PointerRNA *ptr, int value)
{
    ParticleBrushData *data = (ParticleBrushData *)(ptr->data);
#ifdef __cplusplus
    data->count = (std::remove_reference_t<decltype(data->count)>)std::clamp(value, 1, 1000);
#else
    data->count = std::clamp(value, 1, 1000);
#endif
}

extern int ParticleBrush_steps_get(PointerRNA *ptr)
{
    ParticleBrushData *data = (ParticleBrushData *)(ptr->data);
    return (int)(data->step);
}

extern void ParticleBrush_steps_set(PointerRNA *ptr, int value)
{
    ParticleBrushData *data = (ParticleBrushData *)(ptr->data);
#ifdef __cplusplus
    data->step = (std::remove_reference_t<decltype(data->step)>)std::clamp(value, 1, 32767);
#else
    data->step = std::clamp(value, 1, 32767);
#endif
}

extern int ParticleBrush_puff_mode_get(PointerRNA *ptr)
{
    ParticleBrushData *data = (ParticleBrushData *)(ptr->data);
    return (int)(data->invert);
}

extern void ParticleBrush_puff_mode_set(PointerRNA *ptr, int value)
{
    ParticleBrushData *data = (ParticleBrushData *)(ptr->data);
#ifdef __cplusplus
    data->invert = (std::remove_reference_t<decltype(data->invert)>)value;
#else
    data->invert = value;
#endif
}

extern bool ParticleBrush_use_puff_volume_get(PointerRNA *ptr)
{
    ParticleBrushData *data = (ParticleBrushData *)(ptr->data);
    return (((data->flag) & 1) != 0);
}

extern void ParticleBrush_use_puff_volume_set(PointerRNA *ptr, bool value)
{
    ParticleBrushData *data = (ParticleBrushData *)(ptr->data);
    if (value) { data->flag |= 1; }
    else { data->flag &= ~1; }
}

extern int ParticleBrush_length_mode_get(PointerRNA *ptr)
{
    ParticleBrushData *data = (ParticleBrushData *)(ptr->data);
    return (int)(data->invert);
}

extern void ParticleBrush_length_mode_set(PointerRNA *ptr, int value)
{
    ParticleBrushData *data = (ParticleBrushData *)(ptr->data);
#ifdef __cplusplus
    data->invert = (std::remove_reference_t<decltype(data->invert)>)value;
#else
    data->invert = value;
#endif
}

extern PointerRNA ParticleBrush_curve_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_ParticleBrush_curve_get;
    return fn(ptr);
}

static PointerRNA GPencilSculptGuide_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void GPencilSculptGuide_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_GPencilSculptGuide_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = GPencilSculptGuide_rna_properties_get(iter);
    }
}

extern void GPencilSculptGuide_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = GPencilSculptGuide_rna_properties_get(iter);
    }
}

extern void GPencilSculptGuide_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool GPencilSculptGuide_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA GPencilSculptGuide_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern bool GPencilSculptGuide_use_guide_get(PointerRNA *ptr)
{
    GP_Sculpt_Guide *data = (GP_Sculpt_Guide *)(ptr->data);
    return (bool)(data->use_guide);
}

extern void GPencilSculptGuide_use_guide_set(PointerRNA *ptr, bool value)
{
    GP_Sculpt_Guide *data = (GP_Sculpt_Guide *)(ptr->data);
#ifdef __cplusplus
    data->use_guide = (std::remove_reference_t<decltype(data->use_guide)>)value;
#else
    data->use_guide = value;
#endif
}

extern bool GPencilSculptGuide_use_snapping_get(PointerRNA *ptr)
{
    GP_Sculpt_Guide *data = (GP_Sculpt_Guide *)(ptr->data);
    return (bool)(data->use_snapping);
}

extern void GPencilSculptGuide_use_snapping_set(PointerRNA *ptr, bool value)
{
    GP_Sculpt_Guide *data = (GP_Sculpt_Guide *)(ptr->data);
#ifdef __cplusplus
    data->use_snapping = (std::remove_reference_t<decltype(data->use_snapping)>)value;
#else
    data->use_snapping = value;
#endif
}

extern PointerRNA GPencilSculptGuide_reference_object_get(PointerRNA *ptr)
{
    GP_Sculpt_Guide *data = (GP_Sculpt_Guide *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_Object, data->reference_object);
}

extern void GPencilSculptGuide_reference_object_set(PointerRNA *ptr, PointerRNA value, struct ReportList *reports)
{
    GP_Sculpt_Guide *data = (GP_Sculpt_Guide *)(ptr->data);
    ID *id = ptr->owner_id;
    if (id == value.data) {
      return;
    }
    if (value.data && ptr->owner_id && value.owner_id && !BKE_id_can_use_id(*ptr->owner_id, *value.owner_id)) {
      return;
    }
    if (value.data) {
        id_lib_extern((ID *)value.data);
    }
    *(void **)&data->reference_object = value.data;
}

extern int GPencilSculptGuide_reference_point_get(PointerRNA *ptr)
{
    GP_Sculpt_Guide *data = (GP_Sculpt_Guide *)(ptr->data);
    return (int)(data->reference_point);
}

extern void GPencilSculptGuide_reference_point_set(PointerRNA *ptr, int value)
{
    GP_Sculpt_Guide *data = (GP_Sculpt_Guide *)(ptr->data);
#ifdef __cplusplus
    data->reference_point = (std::remove_reference_t<decltype(data->reference_point)>)value;
#else
    data->reference_point = value;
#endif
}

extern int GPencilSculptGuide_type_get(PointerRNA *ptr)
{
    GP_Sculpt_Guide *data = (GP_Sculpt_Guide *)(ptr->data);
    return (int)(data->type);
}

extern void GPencilSculptGuide_type_set(PointerRNA *ptr, int value)
{
    GP_Sculpt_Guide *data = (GP_Sculpt_Guide *)(ptr->data);
#ifdef __cplusplus
    data->type = (std::remove_reference_t<decltype(data->type)>)value;
#else
    data->type = value;
#endif
}

extern float GPencilSculptGuide_angle_get(PointerRNA *ptr)
{
    GP_Sculpt_Guide *data = (GP_Sculpt_Guide *)(ptr->data);
    return (float)(data->angle);
}

extern void GPencilSculptGuide_angle_set(PointerRNA *ptr, float value)
{
    GP_Sculpt_Guide *data = (GP_Sculpt_Guide *)(ptr->data);
#ifdef __cplusplus
    data->angle = (std::remove_reference_t<decltype(data->angle)>)std::clamp(value, -6.2831854820f, 6.2831854820f);
#else
    data->angle = std::clamp(value, -6.2831854820f, 6.2831854820f);
#endif
}

extern float GPencilSculptGuide_angle_snap_get(PointerRNA *ptr)
{
    GP_Sculpt_Guide *data = (GP_Sculpt_Guide *)(ptr->data);
    return (float)(data->angle_snap);
}

extern void GPencilSculptGuide_angle_snap_set(PointerRNA *ptr, float value)
{
    GP_Sculpt_Guide *data = (GP_Sculpt_Guide *)(ptr->data);
#ifdef __cplusplus
    data->angle_snap = (std::remove_reference_t<decltype(data->angle_snap)>)std::clamp(value, -6.2831854820f, 6.2831854820f);
#else
    data->angle_snap = std::clamp(value, -6.2831854820f, 6.2831854820f);
#endif
}

extern float GPencilSculptGuide_spacing_get(PointerRNA *ptr)
{
    GP_Sculpt_Guide *data = (GP_Sculpt_Guide *)(ptr->data);
    return (float)(data->spacing);
}

extern void GPencilSculptGuide_spacing_set(PointerRNA *ptr, float value)
{
    GP_Sculpt_Guide *data = (GP_Sculpt_Guide *)(ptr->data);
#ifdef __cplusplus
    data->spacing = (std::remove_reference_t<decltype(data->spacing)>)std::clamp(value, 0.0f, FLT_MAX);
#else
    data->spacing = std::clamp(value, 0.0f, FLT_MAX);
#endif
}

extern void GPencilSculptGuide_location_get(PointerRNA *ptr, float values[3])
{
    GP_Sculpt_Guide *data = (GP_Sculpt_Guide *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        values[i] = (float)(((float *)data->location)[i]);
    }
}

extern void GPencilSculptGuide_location_set(PointerRNA *ptr, const float values[3])
{
    GP_Sculpt_Guide *data = (GP_Sculpt_Guide *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        ((float *)data->location)[i] = values[i];
    }
}

static PointerRNA GPencilSculptSettings_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void GPencilSculptSettings_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_GPencilSculptSettings_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = GPencilSculptSettings_rna_properties_get(iter);
    }
}

extern void GPencilSculptSettings_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = GPencilSculptSettings_rna_properties_get(iter);
    }
}

extern void GPencilSculptSettings_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool GPencilSculptSettings_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA GPencilSculptSettings_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern PointerRNA GPencilSculptSettings_guide_get(PointerRNA *ptr)
{
    GP_Sculpt_Settings *data = (GP_Sculpt_Settings *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_GPencilSculptGuide, &data->guide);
}

extern bool GPencilSculptSettings_use_multiframe_falloff_get(PointerRNA *ptr)
{
    GP_Sculpt_Settings *data = (GP_Sculpt_Settings *)(ptr->data);
    return (((data->flag) & 1) != 0);
}

extern void GPencilSculptSettings_use_multiframe_falloff_set(PointerRNA *ptr, bool value)
{
    GP_Sculpt_Settings *data = (GP_Sculpt_Settings *)(ptr->data);
    if (value) { data->flag |= 1; }
    else { data->flag &= ~1; }
}

extern bool GPencilSculptSettings_use_thickness_curve_get(PointerRNA *ptr)
{
    GP_Sculpt_Settings *data = (GP_Sculpt_Settings *)(ptr->data);
    return (((data->flag) & 2) != 0);
}

extern void GPencilSculptSettings_use_thickness_curve_set(PointerRNA *ptr, bool value)
{
    GP_Sculpt_Settings *data = (GP_Sculpt_Settings *)(ptr->data);
    if (value) { data->flag |= 2; }
    else { data->flag &= ~2; }
}

extern bool GPencilSculptSettings_use_scale_thickness_get(PointerRNA *ptr)
{
    GP_Sculpt_Settings *data = (GP_Sculpt_Settings *)(ptr->data);
    return (((data->flag) & 8) != 0);
}

extern void GPencilSculptSettings_use_scale_thickness_set(PointerRNA *ptr, bool value)
{
    GP_Sculpt_Settings *data = (GP_Sculpt_Settings *)(ptr->data);
    if (value) { data->flag |= 8; }
    else { data->flag &= ~8; }
}

extern bool GPencilSculptSettings_use_automasking_stroke_get(PointerRNA *ptr)
{
    GP_Sculpt_Settings *data = (GP_Sculpt_Settings *)(ptr->data);
    return (((data->flag) & 16) != 0);
}

extern void GPencilSculptSettings_use_automasking_stroke_set(PointerRNA *ptr, bool value)
{
    GP_Sculpt_Settings *data = (GP_Sculpt_Settings *)(ptr->data);
    if (value) { data->flag |= 16; }
    else { data->flag &= ~16; }
}

extern bool GPencilSculptSettings_use_automasking_layer_stroke_get(PointerRNA *ptr)
{
    GP_Sculpt_Settings *data = (GP_Sculpt_Settings *)(ptr->data);
    return (((data->flag) & 32) != 0);
}

extern void GPencilSculptSettings_use_automasking_layer_stroke_set(PointerRNA *ptr, bool value)
{
    GP_Sculpt_Settings *data = (GP_Sculpt_Settings *)(ptr->data);
    if (value) { data->flag |= 32; }
    else { data->flag &= ~32; }
}

extern bool GPencilSculptSettings_use_automasking_material_stroke_get(PointerRNA *ptr)
{
    GP_Sculpt_Settings *data = (GP_Sculpt_Settings *)(ptr->data);
    return (((data->flag) & 64) != 0);
}

extern void GPencilSculptSettings_use_automasking_material_stroke_set(PointerRNA *ptr, bool value)
{
    GP_Sculpt_Settings *data = (GP_Sculpt_Settings *)(ptr->data);
    if (value) { data->flag |= 64; }
    else { data->flag &= ~64; }
}

extern bool GPencilSculptSettings_use_automasking_layer_active_get(PointerRNA *ptr)
{
    GP_Sculpt_Settings *data = (GP_Sculpt_Settings *)(ptr->data);
    return (((data->flag) & 128) != 0);
}

extern void GPencilSculptSettings_use_automasking_layer_active_set(PointerRNA *ptr, bool value)
{
    GP_Sculpt_Settings *data = (GP_Sculpt_Settings *)(ptr->data);
    if (value) { data->flag |= 128; }
    else { data->flag &= ~128; }
}

extern bool GPencilSculptSettings_use_automasking_material_active_get(PointerRNA *ptr)
{
    GP_Sculpt_Settings *data = (GP_Sculpt_Settings *)(ptr->data);
    return (((data->flag) & 256) != 0);
}

extern void GPencilSculptSettings_use_automasking_material_active_set(PointerRNA *ptr, bool value)
{
    GP_Sculpt_Settings *data = (GP_Sculpt_Settings *)(ptr->data);
    if (value) { data->flag |= 256; }
    else { data->flag &= ~256; }
}

extern PointerRNA GPencilSculptSettings_multiframe_falloff_curve_get(PointerRNA *ptr)
{
    GP_Sculpt_Settings *data = (GP_Sculpt_Settings *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_CurveMapping, data->cur_falloff);
}

extern PointerRNA GPencilSculptSettings_thickness_primitive_curve_get(PointerRNA *ptr)
{
    GP_Sculpt_Settings *data = (GP_Sculpt_Settings *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_CurveMapping, data->cur_primitive);
}

extern int GPencilSculptSettings_lock_axis_get(PointerRNA *ptr)
{
    GP_Sculpt_Settings *data = (GP_Sculpt_Settings *)(ptr->data);
    return (int)(data->lock_axis);
}

extern void GPencilSculptSettings_lock_axis_set(PointerRNA *ptr, int value)
{
    GP_Sculpt_Settings *data = (GP_Sculpt_Settings *)(ptr->data);
#ifdef __cplusplus
    data->lock_axis = (std::remove_reference_t<decltype(data->lock_axis)>)value;
#else
    data->lock_axis = value;
#endif
}

extern float GPencilSculptSettings_intersection_threshold_get(PointerRNA *ptr)
{
    GP_Sculpt_Settings *data = (GP_Sculpt_Settings *)(ptr->data);
    return (float)(data->isect_threshold);
}

extern void GPencilSculptSettings_intersection_threshold_set(PointerRNA *ptr, float value)
{
    GP_Sculpt_Settings *data = (GP_Sculpt_Settings *)(ptr->data);
#ifdef __cplusplus
    data->isect_threshold = (std::remove_reference_t<decltype(data->isect_threshold)>)std::clamp(value, 0.0f, 10.0f);
#else
    data->isect_threshold = std::clamp(value, 0.0f, 10.0f);
#endif
}











extern bool ImagePaint_detect_data_func(struct ImagePaintSettings *_self)
{
	return rna_ImaPaint_detect_data(_self);
}

static void ImagePaint_detect_data_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct ImagePaintSettings *_self;
	bool ok;
	char *_data, *_retdata;
	
	_self = (struct ImagePaintSettings *)_ptr->data;
	_data = (char *)_parms->data;
	_retdata = _data;
	
	ok = rna_ImaPaint_detect_data(_self);
	*((bool *)_retdata) = ok;
}

/* Repeated prototypes to detect errors */

bool rna_ImaPaint_detect_data(struct ImagePaintSettings *_self);






/* Paint Curve */
StructRNA RNA_PaintCurve = {
	{(ContainerRNA *)&RNA_Paint, (ContainerRNA *)&RNA_View2D,
	nullptr,
	{nullptr, nullptr}},
	"PaintCurve", nullptr, nullptr, 519, nullptr, "Paint Curve",
	"",
	"*", 307,
	&rna_ID_name, &rna_ID_rna_properties,
	&RNA_ID,
	nullptr,
	rna_ID_refine,
	nullptr,
	nullptr,
	nullptr,
	rna_ID_instance,
	rna_ID_idprops,
	{nullptr, nullptr}
};

/* Paint */
static CollectionPropertyRNA rna_Paint_rna_properties_ = {
	{&rna_Paint_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Paint_rna_properties_begin, Paint_rna_properties_next, Paint_rna_properties_end, Paint_rna_properties_get, nullptr, nullptr, Paint_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_Paint_rna_properties = reinterpret_cast<PropertyRNA &>(rna_Paint_rna_properties_);

static PointerPropertyRNA rna_Paint_rna_type_ = {
	{&rna_Paint_brush, &rna_Paint_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Paint_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_Paint_rna_type = reinterpret_cast<PropertyRNA &>(rna_Paint_rna_type_);

static PointerPropertyRNA rna_Paint_brush_ = {
	{&rna_Paint_brush_asset_reference, &rna_Paint_rna_type,
	-1, "brush", 8388800, 0, 0, 0, 0, PropertyPathTemplateType(0), "Brush",
	"Active brush",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 201326598, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Paint_brush_get, nullptr, nullptr, rna_Paint_brush_poll,&RNA_Brush
};
PropertyRNA &rna_Paint_brush = reinterpret_cast<PropertyRNA &>(rna_Paint_brush_);

static PointerPropertyRNA rna_Paint_brush_asset_reference_ = {
	{&rna_Paint_eraser_brush, &rna_Paint_brush,
	-1, "brush_asset_reference", 8388608, 0, 0, 0, 0, PropertyPathTemplateType(0), "Brush Asset Reference",
	"A weak reference to the matching brush asset, used e.g. to restore the last used brush on file load",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Paint_brush_asset_reference_get, nullptr, nullptr, nullptr,&RNA_AssetWeakReference
};
PropertyRNA &rna_Paint_brush_asset_reference = reinterpret_cast<PropertyRNA &>(rna_Paint_brush_asset_reference_);

static PointerPropertyRNA rna_Paint_eraser_brush_ = {
	{&rna_Paint_eraser_brush_asset_reference, &rna_Paint_brush_asset_reference,
	-1, "eraser_brush", 8388801, 0, 0, 0, 0, PropertyPathTemplateType(0), "Default Eraser Brush",
	"Default eraser brush for quickly alternating with the main brush",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 201326598, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Paint_eraser_brush_get, Paint_eraser_brush_set, nullptr, rna_Paint_eraser_brush_poll,&RNA_Brush
};
PropertyRNA &rna_Paint_eraser_brush = reinterpret_cast<PropertyRNA &>(rna_Paint_eraser_brush_);

static PointerPropertyRNA rna_Paint_eraser_brush_asset_reference_ = {
	{&rna_Paint_palette, &rna_Paint_eraser_brush,
	-1, "eraser_brush_asset_reference", 8388608, 0, 0, 0, 0, PropertyPathTemplateType(0), "Eraser Brush Asset Reference",
	"A weak reference to the matching brush asset, used e.g. to restore the last used brush on file load",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Paint_eraser_brush_asset_reference_get, nullptr, nullptr, nullptr,&RNA_AssetWeakReference
};
PropertyRNA &rna_Paint_eraser_brush_asset_reference = reinterpret_cast<PropertyRNA &>(rna_Paint_eraser_brush_asset_reference_);

static PointerPropertyRNA rna_Paint_palette_ = {
	{&rna_Paint_show_brush, &rna_Paint_eraser_brush_asset_reference,
	-1, "palette", 8388801, 0, 0, 0, 0, PropertyPathTemplateType(0), "Palette",
	"Active Palette",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Paint_palette_get, Paint_palette_set, nullptr, nullptr,&RNA_Palette
};
PropertyRNA &rna_Paint_palette = reinterpret_cast<PropertyRNA &>(rna_Paint_palette_);

static BoolPropertyRNA rna_Paint_show_brush_ = {
	{&rna_Paint_show_brush_on_surface, &rna_Paint_palette,
	-1, "show_brush", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Show Brush",
	"",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Paint_show_brush_get, Paint_show_brush_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Paint_show_brush = reinterpret_cast<PropertyRNA &>(rna_Paint_show_brush_);

static BoolPropertyRNA rna_Paint_show_brush_on_surface_ = {
	{&rna_Paint_show_low_resolution, &rna_Paint_show_brush,
	-1, "show_brush_on_surface", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Show Brush On Surface",
	"",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Paint_show_brush_on_surface_get, Paint_show_brush_on_surface_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Paint_show_brush_on_surface = reinterpret_cast<PropertyRNA &>(rna_Paint_show_brush_on_surface_);

static BoolPropertyRNA rna_Paint_show_low_resolution_ = {
	{&rna_Paint_use_sculpt_delay_updates, &rna_Paint_show_brush_on_surface,
	-1, "show_low_resolution", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Fast Navigate",
	"For multires, show low resolution while navigating the view",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Paint_show_low_resolution_get, Paint_show_low_resolution_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Paint_show_low_resolution = reinterpret_cast<PropertyRNA &>(rna_Paint_show_low_resolution_);

static BoolPropertyRNA rna_Paint_use_sculpt_delay_updates_ = {
	{&rna_Paint_use_symmetry_x, &rna_Paint_show_low_resolution,
	-1, "use_sculpt_delay_updates", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Delay Viewport Updates",
	"Update the geometry when it enters the view, providing faster view navigation",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Paint_use_sculpt_delay_updates_get, Paint_use_sculpt_delay_updates_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Paint_use_sculpt_delay_updates = reinterpret_cast<PropertyRNA &>(rna_Paint_use_sculpt_delay_updates_);

static BoolPropertyRNA rna_Paint_use_symmetry_x_ = {
	{&rna_Paint_use_symmetry_y, &rna_Paint_use_sculpt_delay_updates,
	-1, "use_symmetry_x", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Symmetry X",
	"Mirror brush across the X axis",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Paint_use_symmetry_x_get, Paint_use_symmetry_x_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Paint_use_symmetry_x = reinterpret_cast<PropertyRNA &>(rna_Paint_use_symmetry_x_);

static BoolPropertyRNA rna_Paint_use_symmetry_y_ = {
	{&rna_Paint_use_symmetry_z, &rna_Paint_use_symmetry_x,
	-1, "use_symmetry_y", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Symmetry Y",
	"Mirror brush across the Y axis",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Paint_use_symmetry_y_get, Paint_use_symmetry_y_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Paint_use_symmetry_y = reinterpret_cast<PropertyRNA &>(rna_Paint_use_symmetry_y_);

static BoolPropertyRNA rna_Paint_use_symmetry_z_ = {
	{&rna_Paint_use_symmetry_feather, &rna_Paint_use_symmetry_y,
	-1, "use_symmetry_z", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Symmetry Z",
	"Mirror brush across the Z axis",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Paint_use_symmetry_z_get, Paint_use_symmetry_z_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Paint_use_symmetry_z = reinterpret_cast<PropertyRNA &>(rna_Paint_use_symmetry_z_);

static BoolPropertyRNA rna_Paint_use_symmetry_feather_ = {
	{&rna_Paint_cavity_curve, &rna_Paint_use_symmetry_z,
	-1, "use_symmetry_feather", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Symmetry Feathering",
	"Reduce the strength of the brush where it overlaps symmetrical daubs",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Paint_use_symmetry_feather_get, Paint_use_symmetry_feather_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Paint_use_symmetry_feather = reinterpret_cast<PropertyRNA &>(rna_Paint_use_symmetry_feather_);

static PointerPropertyRNA rna_Paint_cavity_curve_ = {
	{&rna_Paint_use_cavity, &rna_Paint_use_symmetry_feather,
	-1, "cavity_curve", 8650752, 0, 0, 0, 0, PropertyPathTemplateType(0), "Curve",
	"Editable cavity curve",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Paint_cavity_curve_get, nullptr, nullptr, nullptr,&RNA_CurveMapping
};
PropertyRNA &rna_Paint_cavity_curve = reinterpret_cast<PropertyRNA &>(rna_Paint_cavity_curve_);

static BoolPropertyRNA rna_Paint_use_cavity_ = {
	{&rna_Paint_tile_offset, &rna_Paint_cavity_curve,
	-1, "use_cavity", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Cavity Mask",
	"Mask painting according to mesh geometry cavity",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Paint_use_cavity_get, Paint_use_cavity_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Paint_use_cavity = reinterpret_cast<PropertyRNA &>(rna_Paint_use_cavity_);

static float rna_Paint_tile_offset_default[3] = {
	0.0f,
	0.0f,
	0.0f
};

static FloatPropertyRNA rna_Paint_tile_offset_ = {
	{&rna_Paint_tile_x, &rna_Paint_use_cavity,
	-1, "tile_offset", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Tiling offset for the X Axis",
	"Stride at which tiled strokes are copied",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_XYZ) | int(PROP_UNIT_LENGTH)), nullptr, 1, {3, 0, 0}, 3,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(Paint, tile_offset), RawPropertyType(5), nullptr},
	nullptr, nullptr, Paint_tile_offset_get, Paint_tile_offset_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0099999998f, 100.0f, 0.0099999998f, FLT_MAX, 100.0f, 2, nullptr, nullptr, 0.0f, rna_Paint_tile_offset_default
};
PropertyRNA &rna_Paint_tile_offset = reinterpret_cast<PropertyRNA &>(rna_Paint_tile_offset_);

static BoolPropertyRNA rna_Paint_tile_x_ = {
	{&rna_Paint_tile_y, &rna_Paint_tile_offset,
	-1, "tile_x", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Tile X",
	"Tile along X axis",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Paint_tile_x_get, Paint_tile_x_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Paint_tile_x = reinterpret_cast<PropertyRNA &>(rna_Paint_tile_x_);

static BoolPropertyRNA rna_Paint_tile_y_ = {
	{&rna_Paint_tile_z, &rna_Paint_tile_x,
	-1, "tile_y", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Tile Y",
	"Tile along Y axis",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Paint_tile_y_get, Paint_tile_y_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Paint_tile_y = reinterpret_cast<PropertyRNA &>(rna_Paint_tile_y_);

static BoolPropertyRNA rna_Paint_tile_z_ = {
	{nullptr, &rna_Paint_tile_y,
	-1, "tile_z", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Tile Z",
	"Tile along Z axis",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Paint_tile_z_get, Paint_tile_z_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Paint_tile_z = reinterpret_cast<PropertyRNA &>(rna_Paint_tile_z_);

StructRNA RNA_Paint = {
	{(ContainerRNA *)&RNA_Sculpt, (ContainerRNA *)&RNA_PaintCurve,
	nullptr,
	{&rna_Paint_rna_properties, &rna_Paint_tile_z}},
	"Paint", nullptr, nullptr, 516, nullptr, "Paint",
	"",
	"*", 61,
	nullptr, &rna_Paint_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Sculpt */
static int rna_Sculpt_radial_symmetry_default[3] = {
	0,
	0,
	0
};

static IntPropertyRNA rna_Sculpt_radial_symmetry_ = {
	{&rna_Sculpt_lock_x, nullptr,
	-1, "radial_symmetry", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Radial Symmetry Count X Axis",
	"Number of times to copy strokes across the surface",
	0, "*",
	PROP_INT, PropertySubType(int(PROP_XYZ) | int(PROP_UNIT_NONE)), nullptr, 1, {3, 0, 0}, 3,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(Sculpt, radial_symm), RawPropertyType(0), nullptr},
	nullptr, nullptr, Sculpt_radial_symmetry_get, Sculpt_radial_symmetry_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 0, 32, 1, 64, 1, nullptr, nullptr, 1, rna_Sculpt_radial_symmetry_default
};
PropertyRNA &rna_Sculpt_radial_symmetry = reinterpret_cast<PropertyRNA &>(rna_Sculpt_radial_symmetry_);

static BoolPropertyRNA rna_Sculpt_lock_x_ = {
	{&rna_Sculpt_lock_y, &rna_Sculpt_radial_symmetry,
	-1, "lock_x", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Lock X",
	"Disallow changes to the X axis of vertices",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Sculpt_lock_x_get, Sculpt_lock_x_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Sculpt_lock_x = reinterpret_cast<PropertyRNA &>(rna_Sculpt_lock_x_);

static BoolPropertyRNA rna_Sculpt_lock_y_ = {
	{&rna_Sculpt_lock_z, &rna_Sculpt_lock_x,
	-1, "lock_y", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Lock Y",
	"Disallow changes to the Y axis of vertices",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Sculpt_lock_y_get, Sculpt_lock_y_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Sculpt_lock_y = reinterpret_cast<PropertyRNA &>(rna_Sculpt_lock_y_);

static BoolPropertyRNA rna_Sculpt_lock_z_ = {
	{&rna_Sculpt_use_deform_only, &rna_Sculpt_lock_y,
	-1, "lock_z", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Lock Z",
	"Disallow changes to the Z axis of vertices",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Sculpt_lock_z_get, Sculpt_lock_z_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Sculpt_lock_z = reinterpret_cast<PropertyRNA &>(rna_Sculpt_lock_z_);

static BoolPropertyRNA rna_Sculpt_use_deform_only_ = {
	{&rna_Sculpt_detail_size, &rna_Sculpt_lock_z,
	-1, "use_deform_only", 4194305, 0, 0, 0, 0, PropertyPathTemplateType(0), "Use Deform Only",
	"Use only deformation modifiers (temporary disable all constructive modifiers except multi-resolution)",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	(UpdateFunc)(void *)rna_Sculpt_update, 102170624, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Sculpt_use_deform_only_get, Sculpt_use_deform_only_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Sculpt_use_deform_only = reinterpret_cast<PropertyRNA &>(rna_Sculpt_use_deform_only_);

static FloatPropertyRNA rna_Sculpt_detail_size_ = {
	{&rna_Sculpt_detail_percent, &rna_Sculpt_use_deform_only,
	-1, "detail_size", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Detail Size",
	"Maximum edge length for dynamic topology sculpting (in pixels)",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_PIXEL) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(Sculpt, detail_size), RawPropertyType(5), nullptr},
	Sculpt_detail_size_get, Sculpt_detail_size_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_CUBIC, 0.5000000000f, 40.0f, 0.5000000000f, 40.0f, 0.1000000015f, 2, nullptr, nullptr, 12.0f, nullptr
};
PropertyRNA &rna_Sculpt_detail_size = reinterpret_cast<PropertyRNA &>(rna_Sculpt_detail_size_);

static FloatPropertyRNA rna_Sculpt_detail_percent_ = {
	{&rna_Sculpt_constant_detail_resolution, &rna_Sculpt_detail_size,
	-1, "detail_percent", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Detail Percentage",
	"Maximum edge length for dynamic topology sculpting (in brush percentage)",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_PERCENTAGE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(Sculpt, detail_percent), RawPropertyType(5), nullptr},
	Sculpt_detail_percent_get, Sculpt_detail_percent_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.5000000000f, 100.0f, 0.5000000000f, 100.0f, 10.0f, 2, nullptr, nullptr, 25.0f, nullptr
};
PropertyRNA &rna_Sculpt_detail_percent = reinterpret_cast<PropertyRNA &>(rna_Sculpt_detail_percent_);

static FloatPropertyRNA rna_Sculpt_constant_detail_resolution_ = {
	{&rna_Sculpt_use_automasking_topology, &rna_Sculpt_detail_percent,
	-1, "constant_detail_resolution", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Resolution",
	"Maximum edge length for dynamic topology sculpting (as divisor of Blender unit - higher value means smaller edge length)",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(Sculpt, constant_detail), RawPropertyType(5), nullptr},
	Sculpt_constant_detail_resolution_get, Sculpt_constant_detail_resolution_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0010000000f, 1000.0f, 0.0001000000f, FLT_MAX, 10.0f, 2, nullptr, nullptr, 3.0f, nullptr
};
PropertyRNA &rna_Sculpt_constant_detail_resolution = reinterpret_cast<PropertyRNA &>(rna_Sculpt_constant_detail_resolution_);

static BoolPropertyRNA rna_Sculpt_use_automasking_topology_ = {
	{&rna_Sculpt_use_automasking_face_sets, &rna_Sculpt_constant_detail_resolution,
	-1, "use_automasking_topology", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Topology",
	"Affect only vertices connected to the active vertex under the brush",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Sculpt_use_automasking_topology_get, Sculpt_use_automasking_topology_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Sculpt_use_automasking_topology = reinterpret_cast<PropertyRNA &>(rna_Sculpt_use_automasking_topology_);

static BoolPropertyRNA rna_Sculpt_use_automasking_face_sets_ = {
	{&rna_Sculpt_use_automasking_boundary_edges, &rna_Sculpt_use_automasking_topology,
	-1, "use_automasking_face_sets", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Face Sets",
	"Affect only vertices that share Face Sets with the active vertex",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Sculpt_use_automasking_face_sets_get, Sculpt_use_automasking_face_sets_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Sculpt_use_automasking_face_sets = reinterpret_cast<PropertyRNA &>(rna_Sculpt_use_automasking_face_sets_);

static BoolPropertyRNA rna_Sculpt_use_automasking_boundary_edges_ = {
	{&rna_Sculpt_use_automasking_boundary_face_sets, &rna_Sculpt_use_automasking_face_sets,
	-1, "use_automasking_boundary_edges", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Mesh Boundary Auto-Masking",
	"Do not affect non manifold boundary edges",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Sculpt_use_automasking_boundary_edges_get, Sculpt_use_automasking_boundary_edges_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Sculpt_use_automasking_boundary_edges = reinterpret_cast<PropertyRNA &>(rna_Sculpt_use_automasking_boundary_edges_);

static BoolPropertyRNA rna_Sculpt_use_automasking_boundary_face_sets_ = {
	{&rna_Sculpt_use_automasking_cavity, &rna_Sculpt_use_automasking_boundary_edges,
	-1, "use_automasking_boundary_face_sets", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Face Sets Boundary Automasking",
	"Do not affect vertices that belong to a Face Set boundary",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Sculpt_use_automasking_boundary_face_sets_get, Sculpt_use_automasking_boundary_face_sets_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Sculpt_use_automasking_boundary_face_sets = reinterpret_cast<PropertyRNA &>(rna_Sculpt_use_automasking_boundary_face_sets_);

static BoolPropertyRNA rna_Sculpt_use_automasking_cavity_ = {
	{&rna_Sculpt_use_automasking_cavity_inverted, &rna_Sculpt_use_automasking_boundary_face_sets,
	-1, "use_automasking_cavity", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Cavity Mask",
	"Do not affect vertices on peaks, based on the surface curvature",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Sculpt_use_automasking_cavity_get, Sculpt_use_automasking_cavity_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Sculpt_use_automasking_cavity = reinterpret_cast<PropertyRNA &>(rna_Sculpt_use_automasking_cavity_);

static BoolPropertyRNA rna_Sculpt_use_automasking_cavity_inverted_ = {
	{&rna_Sculpt_use_automasking_custom_cavity_curve, &rna_Sculpt_use_automasking_cavity,
	-1, "use_automasking_cavity_inverted", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Inverted Cavity Mask",
	"Do not affect vertices within crevices, based on the surface curvature",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Sculpt_use_automasking_cavity_inverted_get, Sculpt_use_automasking_cavity_inverted_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Sculpt_use_automasking_cavity_inverted = reinterpret_cast<PropertyRNA &>(rna_Sculpt_use_automasking_cavity_inverted_);

static BoolPropertyRNA rna_Sculpt_use_automasking_custom_cavity_curve_ = {
	{&rna_Sculpt_automasking_boundary_edges_propagation_steps, &rna_Sculpt_use_automasking_cavity_inverted,
	-1, "use_automasking_custom_cavity_curve", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Custom Cavity Curve",
	"Use custom curve",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Sculpt_use_automasking_custom_cavity_curve_get, Sculpt_use_automasking_custom_cavity_curve_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Sculpt_use_automasking_custom_cavity_curve = reinterpret_cast<PropertyRNA &>(rna_Sculpt_use_automasking_custom_cavity_curve_);

static IntPropertyRNA rna_Sculpt_automasking_boundary_edges_propagation_steps_ = {
	{&rna_Sculpt_automasking_cavity_factor, &rna_Sculpt_use_automasking_custom_cavity_curve,
	-1, "automasking_boundary_edges_propagation_steps", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Propagation Steps",
	"Distance where boundary edge automasking is going to protect vertices from the fully masked edge",
	0, "*",
	PROP_INT, PropertySubType(int(PROP_UNSIGNED) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(Sculpt, automasking_boundary_edges_propagation_steps), RawPropertyType(0), nullptr},
	Sculpt_automasking_boundary_edges_propagation_steps_get, Sculpt_automasking_boundary_edges_propagation_steps_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 1, 20, 1, 20, 1, nullptr, nullptr, 1, nullptr
};
PropertyRNA &rna_Sculpt_automasking_boundary_edges_propagation_steps = reinterpret_cast<PropertyRNA &>(rna_Sculpt_automasking_boundary_edges_propagation_steps_);

static FloatPropertyRNA rna_Sculpt_automasking_cavity_factor_ = {
	{&rna_Sculpt_automasking_cavity_blur_steps, &rna_Sculpt_automasking_boundary_edges_propagation_steps,
	-1, "automasking_cavity_factor", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Cavity Factor",
	"The contrast of the cavity mask",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_FACTOR) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(Sculpt, automasking_cavity_factor), RawPropertyType(5), nullptr},
	Sculpt_automasking_cavity_factor_get, Sculpt_automasking_cavity_factor_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0f, 1.0f, 0.0f, 5.0f, 0.1000000015f, 3, nullptr, nullptr, 1.0f, nullptr
};
PropertyRNA &rna_Sculpt_automasking_cavity_factor = reinterpret_cast<PropertyRNA &>(rna_Sculpt_automasking_cavity_factor_);

static IntPropertyRNA rna_Sculpt_automasking_cavity_blur_steps_ = {
	{&rna_Sculpt_automasking_cavity_curve, &rna_Sculpt_automasking_cavity_factor,
	-1, "automasking_cavity_blur_steps", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Blur Steps",
	"The number of times the cavity mask is blurred",
	0, "*",
	PROP_INT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(Sculpt, automasking_cavity_blur_steps), RawPropertyType(0), nullptr},
	Sculpt_automasking_cavity_blur_steps_get, Sculpt_automasking_cavity_blur_steps_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 0, 10, 0, 25, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Sculpt_automasking_cavity_blur_steps = reinterpret_cast<PropertyRNA &>(rna_Sculpt_automasking_cavity_blur_steps_);

static PointerPropertyRNA rna_Sculpt_automasking_cavity_curve_ = {
	{&rna_Sculpt_automasking_cavity_curve_op, &rna_Sculpt_automasking_cavity_blur_steps,
	-1, "automasking_cavity_curve", 8388608, 0, 0, 0, 0, PropertyPathTemplateType(0), "Cavity Curve",
	"Curve used for the sensitivity",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Sculpt_automasking_cavity_curve_get, nullptr, nullptr, nullptr,&RNA_CurveMapping
};
PropertyRNA &rna_Sculpt_automasking_cavity_curve = reinterpret_cast<PropertyRNA &>(rna_Sculpt_automasking_cavity_curve_);

static PointerPropertyRNA rna_Sculpt_automasking_cavity_curve_op_ = {
	{&rna_Sculpt_use_automasking_start_normal, &rna_Sculpt_automasking_cavity_curve,
	-1, "automasking_cavity_curve_op", 8388608, 0, 0, 0, 0, PropertyPathTemplateType(0), "Cavity Curve",
	"Curve used for the sensitivity",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Sculpt_automasking_cavity_curve_op_get, nullptr, nullptr, nullptr,&RNA_CurveMapping
};
PropertyRNA &rna_Sculpt_automasking_cavity_curve_op = reinterpret_cast<PropertyRNA &>(rna_Sculpt_automasking_cavity_curve_op_);

static BoolPropertyRNA rna_Sculpt_use_automasking_start_normal_ = {
	{&rna_Sculpt_use_automasking_view_normal, &rna_Sculpt_automasking_cavity_curve_op,
	-1, "use_automasking_start_normal", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Area Normal",
	"Affect only vertices with a similar normal to where the stroke starts",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Sculpt_use_automasking_start_normal_get, Sculpt_use_automasking_start_normal_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Sculpt_use_automasking_start_normal = reinterpret_cast<PropertyRNA &>(rna_Sculpt_use_automasking_start_normal_);

static BoolPropertyRNA rna_Sculpt_use_automasking_view_normal_ = {
	{&rna_Sculpt_use_automasking_view_occlusion, &rna_Sculpt_use_automasking_start_normal,
	-1, "use_automasking_view_normal", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "View Normal",
	"Affect only vertices with a normal that faces the viewer",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Sculpt_use_automasking_view_normal_get, Sculpt_use_automasking_view_normal_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Sculpt_use_automasking_view_normal = reinterpret_cast<PropertyRNA &>(rna_Sculpt_use_automasking_view_normal_);

static BoolPropertyRNA rna_Sculpt_use_automasking_view_occlusion_ = {
	{&rna_Sculpt_automasking_start_normal_limit, &rna_Sculpt_use_automasking_view_normal,
	-1, "use_automasking_view_occlusion", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Occlusion",
	"Only affect vertices that are not occluded by other faces (slower performance)",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Sculpt_use_automasking_view_occlusion_get, Sculpt_use_automasking_view_occlusion_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Sculpt_use_automasking_view_occlusion = reinterpret_cast<PropertyRNA &>(rna_Sculpt_use_automasking_view_occlusion_);

static FloatPropertyRNA rna_Sculpt_automasking_start_normal_limit_ = {
	{&rna_Sculpt_automasking_start_normal_falloff, &rna_Sculpt_use_automasking_view_occlusion,
	-1, "automasking_start_normal_limit", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Area Normal Limit",
	"The range of angles that will be affected",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_ANGLE) | int(PROP_UNIT_ROTATION)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(Sculpt, automasking_start_normal_limit), RawPropertyType(5), nullptr},
	Sculpt_automasking_start_normal_limit_get, Sculpt_automasking_start_normal_limit_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0001000000f, 3.1415927410f, 0.0001000000f, 3.1415927410f, 10.0f, 3, nullptr, nullptr, 0.3490658402f, nullptr
};
PropertyRNA &rna_Sculpt_automasking_start_normal_limit = reinterpret_cast<PropertyRNA &>(rna_Sculpt_automasking_start_normal_limit_);

static FloatPropertyRNA rna_Sculpt_automasking_start_normal_falloff_ = {
	{&rna_Sculpt_automasking_view_normal_limit, &rna_Sculpt_automasking_start_normal_limit,
	-1, "automasking_start_normal_falloff", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Area Normal Falloff",
	"Extend the angular range with a falloff gradient",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_FACTOR) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(Sculpt, automasking_start_normal_falloff), RawPropertyType(5), nullptr},
	Sculpt_automasking_start_normal_falloff_get, Sculpt_automasking_start_normal_falloff_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0001000000f, 1.0f, 0.0001000000f, 1.0f, 10.0f, 3, nullptr, nullptr, 0.2500000000f, nullptr
};
PropertyRNA &rna_Sculpt_automasking_start_normal_falloff = reinterpret_cast<PropertyRNA &>(rna_Sculpt_automasking_start_normal_falloff_);

static FloatPropertyRNA rna_Sculpt_automasking_view_normal_limit_ = {
	{&rna_Sculpt_automasking_view_normal_falloff, &rna_Sculpt_automasking_start_normal_falloff,
	-1, "automasking_view_normal_limit", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "View Normal Limit",
	"The range of angles that will be affected",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_ANGLE) | int(PROP_UNIT_ROTATION)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(Sculpt, automasking_view_normal_limit), RawPropertyType(5), nullptr},
	Sculpt_automasking_view_normal_limit_get, Sculpt_automasking_view_normal_limit_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0001000000f, 3.1415927410f, 0.0001000000f, 3.1415927410f, 10.0f, 3, nullptr, nullptr, 1.5707960129f, nullptr
};
PropertyRNA &rna_Sculpt_automasking_view_normal_limit = reinterpret_cast<PropertyRNA &>(rna_Sculpt_automasking_view_normal_limit_);

static FloatPropertyRNA rna_Sculpt_automasking_view_normal_falloff_ = {
	{&rna_Sculpt_symmetrize_direction, &rna_Sculpt_automasking_view_normal_limit,
	-1, "automasking_view_normal_falloff", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "View Normal Falloff",
	"Extend the angular range with a falloff gradient",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_FACTOR) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(Sculpt, automasking_view_normal_falloff), RawPropertyType(5), nullptr},
	Sculpt_automasking_view_normal_falloff_get, Sculpt_automasking_view_normal_falloff_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0001000000f, 1.0f, 0.0001000000f, 1.0f, 10.0f, 3, nullptr, nullptr, 0.2500000000f, nullptr
};
PropertyRNA &rna_Sculpt_automasking_view_normal_falloff = reinterpret_cast<PropertyRNA &>(rna_Sculpt_automasking_view_normal_falloff_);

static EnumPropertyRNA rna_Sculpt_symmetrize_direction_ = {
	{&rna_Sculpt_detail_refine_method, &rna_Sculpt_automasking_view_normal_falloff,
	-1, "symmetrize_direction", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Direction",
	"Source and destination for symmetrize operator",
	0, "*",
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(Sculpt, symmetrize_direction), RawPropertyType(0), nullptr},
	Sculpt_symmetrize_direction_get, Sculpt_symmetrize_direction_set, nullptr, nullptr, nullptr, nullptr, rna_enum_symmetrize_direction_items, 6, 0
};
PropertyRNA &rna_Sculpt_symmetrize_direction = reinterpret_cast<PropertyRNA &>(rna_Sculpt_symmetrize_direction_);

static const EnumPropertyItem rna_Sculpt_detail_refine_method_items[4] = {
	{4096, "SUBDIVIDE", 0, "Subdivide Edges", "Subdivide long edges to add mesh detail where needed"},
	{2048, "COLLAPSE", 0, "Collapse Edges", "Collapse short edges to remove mesh detail where possible"},
	{6144, "SUBDIVIDE_COLLAPSE", 0, "Subdivide Collapse", "Both subdivide long edges and collapse short edges to refine mesh detail"},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_Sculpt_detail_refine_method_ = {
	{&rna_Sculpt_detail_type_method, &rna_Sculpt_symmetrize_direction,
	-1, "detail_refine_method", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Detail Refine Method",
	"In dynamic-topology mode, how to add or remove mesh detail",
	0, "*",
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(Sculpt, flags), RawPropertyType(0), nullptr},
	Sculpt_detail_refine_method_get, Sculpt_detail_refine_method_set, nullptr, nullptr, nullptr, nullptr, rna_Sculpt_detail_refine_method_items, 3, 4096
};
PropertyRNA &rna_Sculpt_detail_refine_method = reinterpret_cast<PropertyRNA &>(rna_Sculpt_detail_refine_method_);

static const EnumPropertyItem rna_Sculpt_detail_type_method_items[5] = {
	{0, "RELATIVE", 0, "Relative Detail", "Mesh detail is relative to the brush size and detail size"},
	{8192, "CONSTANT", 0, "Constant Detail", "Mesh detail is constant in world space according to detail size"},
	{16384, "BRUSH", 0, "Brush Detail", "Mesh detail is relative to brush radius"},
	{65536, "MANUAL", 0, "Manual Detail", "Mesh detail does not change on each stroke, only when using Flood Fill"},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_Sculpt_detail_type_method_ = {
	{&rna_Sculpt_gravity, &rna_Sculpt_detail_refine_method,
	-1, "detail_type_method", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Detail Type Method",
	"In dynamic-topology mode, how mesh detail size is calculated",
	0, "*",
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(Sculpt, flags), RawPropertyType(0), nullptr},
	Sculpt_detail_type_method_get, Sculpt_detail_type_method_set, nullptr, nullptr, nullptr, nullptr, rna_Sculpt_detail_type_method_items, 4, 0
};
PropertyRNA &rna_Sculpt_detail_type_method = reinterpret_cast<PropertyRNA &>(rna_Sculpt_detail_type_method_);

static FloatPropertyRNA rna_Sculpt_gravity_ = {
	{&rna_Sculpt_transform_mode, &rna_Sculpt_detail_type_method,
	-1, "gravity", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Gravity",
	"Amount of gravity after each dab",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_FACTOR) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(Sculpt, gravity_factor), RawPropertyType(5), nullptr},
	Sculpt_gravity_get, Sculpt_gravity_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0f, 1.0f, 0.0f, 1.0f, 0.1000000015f, 3, nullptr, nullptr, 0.0f, nullptr
};
PropertyRNA &rna_Sculpt_gravity = reinterpret_cast<PropertyRNA &>(rna_Sculpt_gravity_);

static const EnumPropertyItem rna_Sculpt_transform_mode_items[3] = {
	{0, "ALL_VERTICES", 0, "All Vertices", "Applies the transformation to all vertices in the mesh"},
	{1, "RADIUS_ELASTIC", 0, "Elastic", "Applies the transformation simulating elasticity using the radius of the cursor"},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_Sculpt_transform_mode_ = {
	{&rna_Sculpt_gravity_object, &rna_Sculpt_gravity,
	-1, "transform_mode", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Transform Mode",
	"How the transformation is going to be applied to the target",
	0, "*",
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(Sculpt, transform_mode), RawPropertyType(0), nullptr},
	Sculpt_transform_mode_get, Sculpt_transform_mode_set, nullptr, nullptr, nullptr, nullptr, rna_Sculpt_transform_mode_items, 2, 0
};
PropertyRNA &rna_Sculpt_transform_mode = reinterpret_cast<PropertyRNA &>(rna_Sculpt_transform_mode_);

static PointerPropertyRNA rna_Sculpt_gravity_object_ = {
	{nullptr, &rna_Sculpt_transform_mode,
	-1, "gravity_object", 8388737, 0, 0, 0, 0, PropertyPathTemplateType(0), "Orientation",
	"Object whose Z axis defines orientation of gravity",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Sculpt_gravity_object_get, Sculpt_gravity_object_set, nullptr, nullptr,&RNA_Object
};
PropertyRNA &rna_Sculpt_gravity_object = reinterpret_cast<PropertyRNA &>(rna_Sculpt_gravity_object_);

StructRNA RNA_Sculpt = {
	{(ContainerRNA *)&RNA_UvSculpt, (ContainerRNA *)&RNA_Paint,
	nullptr,
	{&rna_Sculpt_radial_symmetry, &rna_Sculpt_gravity_object}},
	"Sculpt", nullptr, nullptr, 512, nullptr, "Sculpt",
	"",
	"*", 61,
	nullptr, &rna_Paint_rna_properties,
	&RNA_Paint,
	nullptr,
	nullptr,
	rna_Sculpt_path,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* UV Sculpting */
static CollectionPropertyRNA rna_UvSculpt_rna_properties_ = {
	{&rna_UvSculpt_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	UvSculpt_rna_properties_begin, UvSculpt_rna_properties_next, UvSculpt_rna_properties_end, UvSculpt_rna_properties_get, nullptr, nullptr, UvSculpt_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_UvSculpt_rna_properties = reinterpret_cast<PropertyRNA &>(rna_UvSculpt_rna_properties_);

static PointerPropertyRNA rna_UvSculpt_rna_type_ = {
	{&rna_UvSculpt_size, &rna_UvSculpt_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	UvSculpt_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_UvSculpt_rna_type = reinterpret_cast<PropertyRNA &>(rna_UvSculpt_rna_type_);

static IntPropertyRNA rna_UvSculpt_size_ = {
	{&rna_UvSculpt_strength, &rna_UvSculpt_rna_type,
	-1, "size", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Size",
	"",
	0, "*",
	PROP_INT, PropertySubType(int(PROP_PIXEL) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(UvSculpt, size), RawPropertyType(0), nullptr},
	UvSculpt_size_get, UvSculpt_size_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 1, 5000, 1, 5000, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_UvSculpt_size = reinterpret_cast<PropertyRNA &>(rna_UvSculpt_size_);

static FloatPropertyRNA rna_UvSculpt_strength_ = {
	{&rna_UvSculpt_strength_curve, &rna_UvSculpt_size,
	-1, "strength", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Strength",
	"",
	0, "Amount",
	PROP_FLOAT, PropertySubType(int(PROP_FACTOR) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(UvSculpt, strength), RawPropertyType(5), nullptr},
	UvSculpt_strength_get, UvSculpt_strength_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0f, 1.0f, 0.0f, 1.0f, 10.0f, 3, nullptr, nullptr, 0.0f, nullptr
};
PropertyRNA &rna_UvSculpt_strength = reinterpret_cast<PropertyRNA &>(rna_UvSculpt_strength_);

static PointerPropertyRNA rna_UvSculpt_strength_curve_ = {
	{&rna_UvSculpt_curve_preset, &rna_UvSculpt_strength,
	-1, "strength_curve", 8388608, 0, 0, 0, 0, PropertyPathTemplateType(0), "Strength Curve",
	"",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	UvSculpt_strength_curve_get, nullptr, nullptr, nullptr,&RNA_CurveMapping
};
PropertyRNA &rna_UvSculpt_strength_curve = reinterpret_cast<PropertyRNA &>(rna_UvSculpt_strength_curve_);

static EnumPropertyRNA rna_UvSculpt_curve_preset_ = {
	{nullptr, &rna_UvSculpt_strength_curve,
	-1, "curve_preset", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Strength Curve Preset",
	"",
	0, "Curve",
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	UvSculpt_curve_preset_get, UvSculpt_curve_preset_set, nullptr, nullptr, nullptr, nullptr, rna_enum_brush_curve_preset_items, 10, 0
};
PropertyRNA &rna_UvSculpt_curve_preset = reinterpret_cast<PropertyRNA &>(rna_UvSculpt_curve_preset_);

StructRNA RNA_UvSculpt = {
	{(ContainerRNA *)&RNA_GpPaint, (ContainerRNA *)&RNA_Sculpt,
	nullptr,
	{&rna_UvSculpt_rna_properties, &rna_UvSculpt_curve_preset}},
	"UvSculpt", nullptr, nullptr, 512, nullptr, "UV Sculpting",
	"",
	"*", 61,
	nullptr, &rna_UvSculpt_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	rna_UvSculpt_path,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Grease Pencil Paint */
static const EnumPropertyItem rna_GpPaint_color_mode_items[3] = {
	{0, "MATERIAL", 0, "Material", "Paint using the active material base color"},
	{1, "VERTEXCOLOR", 0, "Color Attribute", "Paint the material with a color attribute"},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_GpPaint_color_mode_ = {
	{nullptr, nullptr,
	-1, "color_mode", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Mode",
	"Paint Mode",
	0, "*",
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(GpPaint, mode), RawPropertyType(0), nullptr},
	GpPaint_color_mode_get, GpPaint_color_mode_set, nullptr, nullptr, nullptr, nullptr, rna_GpPaint_color_mode_items, 2, 0
};
PropertyRNA &rna_GpPaint_color_mode = reinterpret_cast<PropertyRNA &>(rna_GpPaint_color_mode_);

StructRNA RNA_GpPaint = {
	{(ContainerRNA *)&RNA_GpVertexPaint, (ContainerRNA *)&RNA_UvSculpt,
	nullptr,
	{&rna_GpPaint_color_mode, &rna_GpPaint_color_mode}},
	"GpPaint", nullptr, nullptr, 512, nullptr, "Grease Pencil Paint",
	"",
	"*", 61,
	nullptr, &rna_Paint_rna_properties,
	&RNA_Paint,
	nullptr,
	nullptr,
	rna_GpPaint_path,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Grease Pencil Vertex Paint */
StructRNA RNA_GpVertexPaint = {
	{(ContainerRNA *)&RNA_GpSculptPaint, (ContainerRNA *)&RNA_GpPaint,
	nullptr,
	{nullptr, nullptr}},
	"GpVertexPaint", nullptr, nullptr, 512, nullptr, "Grease Pencil Vertex Paint",
	"",
	"*", 61,
	nullptr, &rna_Paint_rna_properties,
	&RNA_Paint,
	nullptr,
	nullptr,
	rna_GpVertexPaint_path,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Grease Pencil Sculpt Paint */
StructRNA RNA_GpSculptPaint = {
	{(ContainerRNA *)&RNA_GpWeightPaint, (ContainerRNA *)&RNA_GpVertexPaint,
	nullptr,
	{nullptr, nullptr}},
	"GpSculptPaint", nullptr, nullptr, 512, nullptr, "Grease Pencil Sculpt Paint",
	"",
	"*", 61,
	nullptr, &rna_Paint_rna_properties,
	&RNA_Paint,
	nullptr,
	nullptr,
	rna_GpSculptPaint_path,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Grease Pencil Weight Paint */
StructRNA RNA_GpWeightPaint = {
	{(ContainerRNA *)&RNA_VertexPaint, (ContainerRNA *)&RNA_GpSculptPaint,
	nullptr,
	{nullptr, nullptr}},
	"GpWeightPaint", nullptr, nullptr, 512, nullptr, "Grease Pencil Weight Paint",
	"",
	"*", 61,
	nullptr, &rna_Paint_rna_properties,
	&RNA_Paint,
	nullptr,
	nullptr,
	rna_GpWeightPaint_path,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Vertex Paint */
static BoolPropertyRNA rna_VertexPaint_use_group_restrict_ = {
	{&rna_VertexPaint_radial_symmetry, nullptr,
	-1, "use_group_restrict", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Restrict",
	"Restrict painting to vertices in the group",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	VertexPaint_use_group_restrict_get, VertexPaint_use_group_restrict_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_VertexPaint_use_group_restrict = reinterpret_cast<PropertyRNA &>(rna_VertexPaint_use_group_restrict_);

static int rna_VertexPaint_radial_symmetry_default[3] = {
	1,
	1,
	1
};

static IntPropertyRNA rna_VertexPaint_radial_symmetry_ = {
	{nullptr, &rna_VertexPaint_use_group_restrict,
	-1, "radial_symmetry", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Radial Symmetry Count X Axis",
	"Number of times to copy strokes across the surface",
	0, "*",
	PROP_INT, PropertySubType(int(PROP_XYZ) | int(PROP_UNIT_NONE)), nullptr, 1, {3, 0, 0}, 3,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(VPaint, radial_symm), RawPropertyType(0), nullptr},
	nullptr, nullptr, VertexPaint_radial_symmetry_get, VertexPaint_radial_symmetry_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 1, 32, 1, 64, 1, nullptr, nullptr, 1, rna_VertexPaint_radial_symmetry_default
};
PropertyRNA &rna_VertexPaint_radial_symmetry = reinterpret_cast<PropertyRNA &>(rna_VertexPaint_radial_symmetry_);

StructRNA RNA_VertexPaint = {
	{(ContainerRNA *)&RNA_PaintModeSettings, (ContainerRNA *)&RNA_GpWeightPaint,
	nullptr,
	{&rna_VertexPaint_use_group_restrict, &rna_VertexPaint_radial_symmetry}},
	"VertexPaint", nullptr, nullptr, 512, nullptr, "Vertex Paint",
	"Properties of vertex and weight paint mode",
	"*", 61,
	nullptr, &rna_Paint_rna_properties,
	&RNA_Paint,
	nullptr,
	nullptr,
	rna_VertexPaint_path,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Paint Mode */
static CollectionPropertyRNA rna_PaintModeSettings_rna_properties_ = {
	{&rna_PaintModeSettings_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	PaintModeSettings_rna_properties_begin, PaintModeSettings_rna_properties_next, PaintModeSettings_rna_properties_end, PaintModeSettings_rna_properties_get, nullptr, nullptr, PaintModeSettings_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_PaintModeSettings_rna_properties = reinterpret_cast<PropertyRNA &>(rna_PaintModeSettings_rna_properties_);

static PointerPropertyRNA rna_PaintModeSettings_rna_type_ = {
	{&rna_PaintModeSettings_canvas_source, &rna_PaintModeSettings_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	PaintModeSettings_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_PaintModeSettings_rna_type = reinterpret_cast<PropertyRNA &>(rna_PaintModeSettings_rna_type_);

static const EnumPropertyItem rna_PaintModeSettings_canvas_source_items[4] = {
	{2, "COLOR_ATTRIBUTE", 0, "Color Attribute", ""},
	{0, "MATERIAL", 0, "Material", ""},
	{1, "IMAGE", 0, "Image", ""},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_PaintModeSettings_canvas_source_ = {
	{&rna_PaintModeSettings_canvas_image, &rna_PaintModeSettings_rna_type,
	-1, "canvas_source", 4194305, 0, 0, 4, 0, PropertyPathTemplateType(0), "Source",
	"Source to select canvas from",
	0, "*",
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	(UpdateFunc)(void *)rna_PaintModeSettings_canvas_source_update, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(PaintModeSettings, canvas_source), RawPropertyType(2), nullptr},
	PaintModeSettings_canvas_source_get, PaintModeSettings_canvas_source_set, nullptr, nullptr, nullptr, nullptr, rna_PaintModeSettings_canvas_source_items, 3, 0
};
PropertyRNA &rna_PaintModeSettings_canvas_source = reinterpret_cast<PropertyRNA &>(rna_PaintModeSettings_canvas_source_);

static PointerPropertyRNA rna_PaintModeSettings_canvas_image_ = {
	{nullptr, &rna_PaintModeSettings_canvas_source,
	-1, "canvas_image", 12583105, 0, 0, 0, 0, PropertyPathTemplateType(0), "Texture",
	"Image used as painting target",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	(UpdateFunc)(void *)nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	PaintModeSettings_canvas_image_get, PaintModeSettings_canvas_image_set, nullptr, rna_PaintModeSettings_canvas_image_poll,&RNA_Image
};
PropertyRNA &rna_PaintModeSettings_canvas_image = reinterpret_cast<PropertyRNA &>(rna_PaintModeSettings_canvas_image_);

StructRNA RNA_PaintModeSettings = {
	{(ContainerRNA *)&RNA_ImagePaint, (ContainerRNA *)&RNA_VertexPaint,
	nullptr,
	{&rna_PaintModeSettings_rna_properties, &rna_PaintModeSettings_canvas_image}},
	"PaintModeSettings", nullptr, nullptr, 512, nullptr, "Paint Mode",
	"Properties of paint mode",
	"*", 61,
	nullptr, &rna_PaintModeSettings_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	rna_PaintModeSettings_path,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Image Paint */
static BoolPropertyRNA rna_ImagePaint_use_occlude_ = {
	{&rna_ImagePaint_use_backface_culling, nullptr,
	-1, "use_occlude", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Occlude",
	"Only paint onto the faces directly under the brush (slower)",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ImagePaint_use_occlude_get, ImagePaint_use_occlude_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 1, nullptr
};
PropertyRNA &rna_ImagePaint_use_occlude = reinterpret_cast<PropertyRNA &>(rna_ImagePaint_use_occlude_);

static BoolPropertyRNA rna_ImagePaint_use_backface_culling_ = {
	{&rna_ImagePaint_use_normal_falloff, &rna_ImagePaint_use_occlude,
	-1, "use_backface_culling", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Cull",
	"Ignore faces pointing away from the view (faster)",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ImagePaint_use_backface_culling_get, ImagePaint_use_backface_culling_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 1, nullptr
};
PropertyRNA &rna_ImagePaint_use_backface_culling = reinterpret_cast<PropertyRNA &>(rna_ImagePaint_use_backface_culling_);

static BoolPropertyRNA rna_ImagePaint_use_normal_falloff_ = {
	{&rna_ImagePaint_use_stencil_layer, &rna_ImagePaint_use_backface_culling,
	-1, "use_normal_falloff", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Normal",
	"Paint most on faces pointing towards the view",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ImagePaint_use_normal_falloff_get, ImagePaint_use_normal_falloff_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 1, nullptr
};
PropertyRNA &rna_ImagePaint_use_normal_falloff = reinterpret_cast<PropertyRNA &>(rna_ImagePaint_use_normal_falloff_);

static BoolPropertyRNA rna_ImagePaint_use_stencil_layer_ = {
	{&rna_ImagePaint_invert_stencil, &rna_ImagePaint_use_normal_falloff,
	-1, "use_stencil_layer", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Stencil Layer",
	"Set the mask layer from the UV map buttons",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_ImaPaint_viewport_update, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ImagePaint_use_stencil_layer_get, ImagePaint_use_stencil_layer_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_ImagePaint_use_stencil_layer = reinterpret_cast<PropertyRNA &>(rna_ImagePaint_use_stencil_layer_);

static BoolPropertyRNA rna_ImagePaint_invert_stencil_ = {
	{&rna_ImagePaint_stencil_image, &rna_ImagePaint_use_stencil_layer,
	-1, "invert_stencil", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Invert",
	"Invert the stencil layer",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_ImaPaint_viewport_update, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ImagePaint_invert_stencil_get, ImagePaint_invert_stencil_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_ImagePaint_invert_stencil = reinterpret_cast<PropertyRNA &>(rna_ImagePaint_invert_stencil_);

static PointerPropertyRNA rna_ImagePaint_stencil_image_ = {
	{&rna_ImagePaint_canvas, &rna_ImagePaint_invert_stencil,
	-1, "stencil_image", 12583105, 0, 0, 0, 0, PropertyPathTemplateType(0), "Stencil Image",
	"Image used as stencil",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	(UpdateFunc)(void *)rna_ImaPaint_stencil_update, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ImagePaint_stencil_image_get, ImagePaint_stencil_image_set, nullptr, rna_ImaPaint_imagetype_poll,&RNA_Image
};
PropertyRNA &rna_ImagePaint_stencil_image = reinterpret_cast<PropertyRNA &>(rna_ImagePaint_stencil_image_);

static PointerPropertyRNA rna_ImagePaint_canvas_ = {
	{&rna_ImagePaint_clone_image, &rna_ImagePaint_stencil_image,
	-1, "canvas", 12583105, 0, 0, 0, 0, PropertyPathTemplateType(0), "Canvas",
	"Image used as canvas",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	(UpdateFunc)(void *)rna_ImaPaint_canvas_update, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ImagePaint_canvas_get, ImagePaint_canvas_set, nullptr, rna_ImaPaint_imagetype_poll,&RNA_Image
};
PropertyRNA &rna_ImagePaint_canvas = reinterpret_cast<PropertyRNA &>(rna_ImagePaint_canvas_);

static PointerPropertyRNA rna_ImagePaint_clone_image_ = {
	{&rna_ImagePaint_stencil_color, &rna_ImagePaint_canvas,
	-1, "clone_image", 8388801, 0, 0, 0, 0, PropertyPathTemplateType(0), "Clone Image",
	"Image used as clone source",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ImagePaint_clone_image_get, ImagePaint_clone_image_set, nullptr, rna_ImaPaint_imagetype_poll,&RNA_Image
};
PropertyRNA &rna_ImagePaint_clone_image = reinterpret_cast<PropertyRNA &>(rna_ImagePaint_clone_image_);

static float rna_ImagePaint_stencil_color_default[3] = {
	0.0f,
	0.0f,
	0.0f
};

static FloatPropertyRNA rna_ImagePaint_stencil_color_ = {
	{&rna_ImagePaint_dither, &rna_ImagePaint_clone_image,
	-1, "stencil_color", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Stencil Color",
	"Stencil color in the viewport",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_COLOR_GAMMA) | int(PROP_UNIT_NONE)), nullptr, 1, {3, 0, 0}, 3,
	rna_ImaPaint_viewport_update, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(ImagePaintSettings, stencil_col), RawPropertyType(5), nullptr},
	nullptr, nullptr, ImagePaint_stencil_color_get, ImagePaint_stencil_color_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0f, 1.0f, 0.0f, 1.0f, 10.0f, 3, nullptr, nullptr, 0.0f, rna_ImagePaint_stencil_color_default
};
PropertyRNA &rna_ImagePaint_stencil_color = reinterpret_cast<PropertyRNA &>(rna_ImagePaint_stencil_color_);

static FloatPropertyRNA rna_ImagePaint_dither_ = {
	{&rna_ImagePaint_use_clone_layer, &rna_ImagePaint_stencil_color,
	-1, "dither", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Dither",
	"Amount of dithering when painting on byte images",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(ImagePaintSettings, dither), RawPropertyType(5), nullptr},
	ImagePaint_dither_get, ImagePaint_dither_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0f, 2.0f, 0.0f, 2.0f, 10.0f, 3, nullptr, nullptr, 0.0f, nullptr
};
PropertyRNA &rna_ImagePaint_dither = reinterpret_cast<PropertyRNA &>(rna_ImagePaint_dither_);

static BoolPropertyRNA rna_ImagePaint_use_clone_layer_ = {
	{&rna_ImagePaint_seam_bleed, &rna_ImagePaint_dither,
	-1, "use_clone_layer", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Clone Map",
	"Use another UV map as clone source, otherwise use the 3D cursor as the source",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_ImaPaint_viewport_update, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ImagePaint_use_clone_layer_get, ImagePaint_use_clone_layer_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_ImagePaint_use_clone_layer = reinterpret_cast<PropertyRNA &>(rna_ImagePaint_use_clone_layer_);

static IntPropertyRNA rna_ImagePaint_seam_bleed_ = {
	{&rna_ImagePaint_normal_angle, &rna_ImagePaint_use_clone_layer,
	-1, "seam_bleed", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Bleed",
	"Extend paint beyond the faces\' UVs to reduce seams (in pixels, slower)",
	0, "*",
	PROP_INT, PropertySubType(int(PROP_PIXEL) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(ImagePaintSettings, seam_bleed), RawPropertyType(1), nullptr},
	ImagePaint_seam_bleed_get, ImagePaint_seam_bleed_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 0, 8, -32768, 32767, 1, nullptr, nullptr, 2, nullptr
};
PropertyRNA &rna_ImagePaint_seam_bleed = reinterpret_cast<PropertyRNA &>(rna_ImagePaint_seam_bleed_);

static IntPropertyRNA rna_ImagePaint_normal_angle_ = {
	{&rna_ImagePaint_screen_grab_size, &rna_ImagePaint_seam_bleed,
	-1, "normal_angle", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Angle",
	"Paint most on faces pointing towards the view according to this angle",
	0, "*",
	PROP_INT, PropertySubType(int(PROP_UNSIGNED) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(ImagePaintSettings, normal_angle), RawPropertyType(1), nullptr},
	ImagePaint_normal_angle_get, ImagePaint_normal_angle_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 0, 90, 0, 90, 1, nullptr, nullptr, 80, nullptr
};
PropertyRNA &rna_ImagePaint_normal_angle = reinterpret_cast<PropertyRNA &>(rna_ImagePaint_normal_angle_);

static int rna_ImagePaint_screen_grab_size_default[2] = {
	0,
	0
};

static IntPropertyRNA rna_ImagePaint_screen_grab_size_ = {
	{&rna_ImagePaint_mode, &rna_ImagePaint_normal_angle,
	-1, "screen_grab_size", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Screen Grab Size",
	"Size to capture the image for re-projecting",
	0, "*",
	PROP_INT, PropertySubType(int(PROP_PIXEL) | int(PROP_UNIT_NONE)), nullptr, 1, {2, 0, 0}, 2,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(ImagePaintSettings, screen_grab_size), RawPropertyType(1), nullptr},
	nullptr, nullptr, ImagePaint_screen_grab_size_get, ImagePaint_screen_grab_size_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 512, 16384, 512, 16384, 1, nullptr, nullptr, 0, rna_ImagePaint_screen_grab_size_default
};
PropertyRNA &rna_ImagePaint_screen_grab_size = reinterpret_cast<PropertyRNA &>(rna_ImagePaint_screen_grab_size_);

static const EnumPropertyItem rna_ImagePaint_mode_items[3] = {
	{0, "MATERIAL", 0, "Material", "Detect image slots from the material"},
	{1, "IMAGE", 0, "Single Image", "Set image for texture painting directly"},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_ImagePaint_mode_ = {
	{&rna_ImagePaint_interpolation, &rna_ImagePaint_screen_grab_size,
	-1, "mode", 4194305, 0, 0, 4, 0, PropertyPathTemplateType(0), "Mode",
	"Mode of operation for projection painting",
	0, "*",
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	(UpdateFunc)(void *)rna_ImaPaint_mode_update, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(ImagePaintSettings, mode), RawPropertyType(0), nullptr},
	ImagePaint_mode_get, ImagePaint_mode_set, nullptr, nullptr, nullptr, nullptr, rna_ImagePaint_mode_items, 2, 0
};
PropertyRNA &rna_ImagePaint_mode = reinterpret_cast<PropertyRNA &>(rna_ImagePaint_mode_);

static const EnumPropertyItem rna_ImagePaint_interpolation_items[3] = {
	{0, "LINEAR", 0, "Linear", "Linear interpolation"},
	{1, "CLOSEST", 0, "Closest", "No interpolation (sample closest texel)"},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_ImagePaint_interpolation_ = {
	{&rna_ImagePaint_missing_uvs, &rna_ImagePaint_mode,
	-1, "interpolation", 4194305, 0, 0, 4, 0, PropertyPathTemplateType(0), "Interpolation",
	"Texture filtering type",
	0, "*",
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	(UpdateFunc)(void *)rna_ImaPaint_mode_update, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(ImagePaintSettings, interp), RawPropertyType(0), nullptr},
	ImagePaint_interpolation_get, ImagePaint_interpolation_set, nullptr, nullptr, nullptr, nullptr, rna_ImagePaint_interpolation_items, 2, 0
};
PropertyRNA &rna_ImagePaint_interpolation = reinterpret_cast<PropertyRNA &>(rna_ImagePaint_interpolation_);

static BoolPropertyRNA rna_ImagePaint_missing_uvs_ = {
	{&rna_ImagePaint_missing_materials, &rna_ImagePaint_interpolation,
	-1, "missing_uvs", 0, 0, 0, 0, 0, PropertyPathTemplateType(0), "Missing UVs",
	"A UV layer is missing on the mesh",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ImagePaint_missing_uvs_get, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_ImagePaint_missing_uvs = reinterpret_cast<PropertyRNA &>(rna_ImagePaint_missing_uvs_);

static BoolPropertyRNA rna_ImagePaint_missing_materials_ = {
	{&rna_ImagePaint_missing_stencil, &rna_ImagePaint_missing_uvs,
	-1, "missing_materials", 0, 0, 0, 0, 0, PropertyPathTemplateType(0), "Missing Materials",
	"The mesh is missing materials",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ImagePaint_missing_materials_get, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_ImagePaint_missing_materials = reinterpret_cast<PropertyRNA &>(rna_ImagePaint_missing_materials_);

static BoolPropertyRNA rna_ImagePaint_missing_stencil_ = {
	{&rna_ImagePaint_missing_texture, &rna_ImagePaint_missing_materials,
	-1, "missing_stencil", 0, 0, 0, 0, 0, PropertyPathTemplateType(0), "Missing Stencil",
	"Image Painting does not have a stencil",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ImagePaint_missing_stencil_get, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_ImagePaint_missing_stencil = reinterpret_cast<PropertyRNA &>(rna_ImagePaint_missing_stencil_);

static BoolPropertyRNA rna_ImagePaint_missing_texture_ = {
	{&rna_ImagePaint_clone_alpha, &rna_ImagePaint_missing_stencil,
	-1, "missing_texture", 0, 0, 0, 0, 0, PropertyPathTemplateType(0), "Missing Texture",
	"Image Painting does not have a texture to paint on",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ImagePaint_missing_texture_get, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_ImagePaint_missing_texture = reinterpret_cast<PropertyRNA &>(rna_ImagePaint_missing_texture_);

static FloatPropertyRNA rna_ImagePaint_clone_alpha_ = {
	{&rna_ImagePaint_clone_offset, &rna_ImagePaint_missing_texture,
	-1, "clone_alpha", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Clone Alpha",
	"Opacity of clone image display",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_FACTOR) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(ImagePaintSettings, clone_alpha), RawPropertyType(5), nullptr},
	ImagePaint_clone_alpha_get, ImagePaint_clone_alpha_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0f, 1.0f, 0.0f, 1.0f, 10.0f, 3, nullptr, nullptr, 0.5000000000f, nullptr
};
PropertyRNA &rna_ImagePaint_clone_alpha = reinterpret_cast<PropertyRNA &>(rna_ImagePaint_clone_alpha_);

static float rna_ImagePaint_clone_offset_default[2] = {
	0.0f,
	0.0f
};

static FloatPropertyRNA rna_ImagePaint_clone_offset_ = {
	{nullptr, &rna_ImagePaint_clone_alpha,
	-1, "clone_offset", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Clone Offset",
	"",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_XYZ) | int(PROP_UNIT_NONE)), nullptr, 1, {2, 0, 0}, 2,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(ImagePaintSettings, clone_offset), RawPropertyType(5), nullptr},
	nullptr, nullptr, ImagePaint_clone_offset_get, ImagePaint_clone_offset_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, -1.0f, 1.0f, -FLT_MAX, FLT_MAX, 10.0f, 3, nullptr, nullptr, 0.0f, rna_ImagePaint_clone_offset_default
};
PropertyRNA &rna_ImagePaint_clone_offset = reinterpret_cast<PropertyRNA &>(rna_ImagePaint_clone_offset_);

static BoolPropertyRNA rna_ImagePaint_detect_data_ok_ = {
	{nullptr, nullptr,
	-1, "ok", 1, 0, 2, 0, 0, PropertyPathTemplateType(0), "",
	"",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 1, nullptr
};
PropertyRNA &rna_ImagePaint_detect_data_ok = reinterpret_cast<PropertyRNA &>(rna_ImagePaint_detect_data_ok_);

FunctionRNA rna_ImagePaint_detect_data_func = {
	{nullptr, nullptr,
	nullptr,
	{&rna_ImagePaint_detect_data_ok, &rna_ImagePaint_detect_data_ok}},
	"detect_data", 0, "Check if required texpaint data exist",
	ImagePaint_detect_data_call,
	&rna_ImagePaint_detect_data_ok
};

StructRNA RNA_ImagePaint = {
	{(ContainerRNA *)&RNA_ParticleEdit, (ContainerRNA *)&RNA_PaintModeSettings,
	nullptr,
	{&rna_ImagePaint_use_occlude, &rna_ImagePaint_clone_offset}},
	"ImagePaint", nullptr, nullptr, 512, nullptr, "Image Paint",
	"Properties of image and texture painting mode",
	"*", 61,
	nullptr, &rna_Paint_rna_properties,
	&RNA_Paint,
	nullptr,
	nullptr,
	rna_ImagePaintSettings_path,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{(FunctionRNA *)&rna_ImagePaint_detect_data_func, (FunctionRNA *)&rna_ImagePaint_detect_data_func}
};

/* Particle Edit */
static CollectionPropertyRNA rna_ParticleEdit_rna_properties_ = {
	{&rna_ParticleEdit_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ParticleEdit_rna_properties_begin, ParticleEdit_rna_properties_next, ParticleEdit_rna_properties_end, ParticleEdit_rna_properties_get, nullptr, nullptr, ParticleEdit_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_ParticleEdit_rna_properties = reinterpret_cast<PropertyRNA &>(rna_ParticleEdit_rna_properties_);

static PointerPropertyRNA rna_ParticleEdit_rna_type_ = {
	{&rna_ParticleEdit_tool, &rna_ParticleEdit_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ParticleEdit_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_ParticleEdit_rna_type = reinterpret_cast<PropertyRNA &>(rna_ParticleEdit_rna_type_);

static const EnumPropertyItem rna_ParticleEdit_tool_items[8] = {
	{0, "COMB", 0, "Comb", "Comb hairs"},
	{5, "SMOOTH", 0, "Smooth", "Smooth hairs"},
	{4, "ADD", 0, "Add", "Add hairs"},
	{2, "LENGTH", 0, "Length", "Make hairs longer or shorter"},
	{3, "PUFF", 0, "Puff", "Make hairs stand up"},
	{1, "CUT", 0, "Cut", "Cut hairs"},
	{6, "WEIGHT", 0, "Weight", "Weight hair particles"},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_ParticleEdit_tool_ = {
	{&rna_ParticleEdit_select_mode, &rna_ParticleEdit_rna_type,
	-1, "tool", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Tool",
	"",
	0, "Operator",
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ParticleEdit_tool_get, ParticleEdit_tool_set, rna_ParticleEdit_tool_itemf, nullptr, nullptr, nullptr, rna_ParticleEdit_tool_items, 7, 0
};
PropertyRNA &rna_ParticleEdit_tool = reinterpret_cast<PropertyRNA &>(rna_ParticleEdit_tool_);

static const EnumPropertyItem rna_ParticleEdit_select_mode_items[4] = {
	{1, "PATH", 547, "Path", "Path edit mode"},
	{2, "POINT", 548, "Point", "Point select mode"},
	{4, "TIP", 549, "Tip", "Tip select mode"},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_ParticleEdit_select_mode_ = {
	{&rna_ParticleEdit_use_preserve_length, &rna_ParticleEdit_tool,
	-1, "select_mode", 4194305, 0, 0, 4, 0, PropertyPathTemplateType(0), "Selection Mode",
	"Particle select and display mode",
	0, "*",
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	(UpdateFunc)(void *)rna_ParticleEdit_update, 102170624, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(ParticleEditSettings, selectmode), RawPropertyType(0), nullptr},
	ParticleEdit_select_mode_get, ParticleEdit_select_mode_set, nullptr, nullptr, nullptr, nullptr, rna_ParticleEdit_select_mode_items, 3, 1
};
PropertyRNA &rna_ParticleEdit_select_mode = reinterpret_cast<PropertyRNA &>(rna_ParticleEdit_select_mode_);

static BoolPropertyRNA rna_ParticleEdit_use_preserve_length_ = {
	{&rna_ParticleEdit_use_preserve_root, &rna_ParticleEdit_select_mode,
	-1, "use_preserve_length", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Keep Lengths",
	"Keep path lengths constant",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ParticleEdit_use_preserve_length_get, ParticleEdit_use_preserve_length_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 1, nullptr
};
PropertyRNA &rna_ParticleEdit_use_preserve_length = reinterpret_cast<PropertyRNA &>(rna_ParticleEdit_use_preserve_length_);

static BoolPropertyRNA rna_ParticleEdit_use_preserve_root_ = {
	{&rna_ParticleEdit_use_emitter_deflect, &rna_ParticleEdit_use_preserve_length,
	-1, "use_preserve_root", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Keep Root",
	"Keep root keys unmodified",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ParticleEdit_use_preserve_root_get, ParticleEdit_use_preserve_root_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 1, nullptr
};
PropertyRNA &rna_ParticleEdit_use_preserve_root = reinterpret_cast<PropertyRNA &>(rna_ParticleEdit_use_preserve_root_);

static BoolPropertyRNA rna_ParticleEdit_use_emitter_deflect_ = {
	{&rna_ParticleEdit_emitter_distance, &rna_ParticleEdit_use_preserve_root,
	-1, "use_emitter_deflect", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Deflect Emitter",
	"Keep paths from intersecting the emitter",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ParticleEdit_use_emitter_deflect_get, ParticleEdit_use_emitter_deflect_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 1, nullptr
};
PropertyRNA &rna_ParticleEdit_use_emitter_deflect = reinterpret_cast<PropertyRNA &>(rna_ParticleEdit_use_emitter_deflect_);

static FloatPropertyRNA rna_ParticleEdit_emitter_distance_ = {
	{&rna_ParticleEdit_use_fade_time, &rna_ParticleEdit_use_emitter_deflect,
	-1, "emitter_distance", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Emitter Distance",
	"Distance to keep particles away from the emitter",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_DISTANCE) | int(PROP_UNIT_LENGTH)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(ParticleEditSettings, emitterdist), RawPropertyType(5), nullptr},
	ParticleEdit_emitter_distance_get, ParticleEdit_emitter_distance_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0f, 10.0f, -FLT_MAX, FLT_MAX, 10.0f, 3, nullptr, nullptr, 0.2500000000f, nullptr
};
PropertyRNA &rna_ParticleEdit_emitter_distance = reinterpret_cast<PropertyRNA &>(rna_ParticleEdit_emitter_distance_);

static BoolPropertyRNA rna_ParticleEdit_use_fade_time_ = {
	{&rna_ParticleEdit_use_auto_velocity, &rna_ParticleEdit_emitter_distance,
	-1, "use_fade_time", 4194305, 0, 0, 0, 0, PropertyPathTemplateType(0), "Fade Time",
	"Fade paths and keys further away from current frame",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	(UpdateFunc)(void *)rna_ParticleEdit_update, 102170624, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ParticleEdit_use_fade_time_get, ParticleEdit_use_fade_time_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_ParticleEdit_use_fade_time = reinterpret_cast<PropertyRNA &>(rna_ParticleEdit_use_fade_time_);

static BoolPropertyRNA rna_ParticleEdit_use_auto_velocity_ = {
	{&rna_ParticleEdit_show_particles, &rna_ParticleEdit_use_fade_time,
	-1, "use_auto_velocity", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Auto Velocity",
	"Calculate point velocities automatically",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ParticleEdit_use_auto_velocity_get, ParticleEdit_use_auto_velocity_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 1, nullptr
};
PropertyRNA &rna_ParticleEdit_use_auto_velocity = reinterpret_cast<PropertyRNA &>(rna_ParticleEdit_use_auto_velocity_);

static BoolPropertyRNA rna_ParticleEdit_show_particles_ = {
	{&rna_ParticleEdit_use_default_interpolate, &rna_ParticleEdit_use_auto_velocity,
	-1, "show_particles", 4194305, 0, 0, 0, 0, PropertyPathTemplateType(0), "Display Particles",
	"Display actual particles",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	(UpdateFunc)(void *)rna_ParticleEdit_redo, 102170624, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ParticleEdit_show_particles_get, ParticleEdit_show_particles_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_ParticleEdit_show_particles = reinterpret_cast<PropertyRNA &>(rna_ParticleEdit_show_particles_);

static BoolPropertyRNA rna_ParticleEdit_use_default_interpolate_ = {
	{&rna_ParticleEdit_default_key_count, &rna_ParticleEdit_show_particles,
	-1, "use_default_interpolate", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Interpolate",
	"Interpolate new particles from the existing ones",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ParticleEdit_use_default_interpolate_get, ParticleEdit_use_default_interpolate_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_ParticleEdit_use_default_interpolate = reinterpret_cast<PropertyRNA &>(rna_ParticleEdit_use_default_interpolate_);

static IntPropertyRNA rna_ParticleEdit_default_key_count_ = {
	{&rna_ParticleEdit_brush, &rna_ParticleEdit_use_default_interpolate,
	-1, "default_key_count", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Keys",
	"How many keys to make new particles with",
	0, "*",
	PROP_INT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(ParticleEditSettings, totaddkey), RawPropertyType(1), nullptr},
	ParticleEdit_default_key_count_get, ParticleEdit_default_key_count_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 2, 20, 2, 32767, 10, nullptr, nullptr, 5, nullptr
};
PropertyRNA &rna_ParticleEdit_default_key_count = reinterpret_cast<PropertyRNA &>(rna_ParticleEdit_default_key_count_);

static PointerPropertyRNA rna_ParticleEdit_brush_ = {
	{&rna_ParticleEdit_display_step, &rna_ParticleEdit_default_key_count,
	-1, "brush", 8388608, 0, 0, 0, 0, PropertyPathTemplateType(0), "Brush",
	"",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {7, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ParticleEdit_brush_get, nullptr, nullptr, nullptr,&RNA_ParticleBrush
};
PropertyRNA &rna_ParticleEdit_brush = reinterpret_cast<PropertyRNA &>(rna_ParticleEdit_brush_);

static IntPropertyRNA rna_ParticleEdit_display_step_ = {
	{&rna_ParticleEdit_fade_frames, &rna_ParticleEdit_brush,
	-1, "display_step", 4194305, 0, 0, 4, 0, PropertyPathTemplateType(0), "Steps",
	"How many steps to display the path with",
	0, "*",
	PROP_INT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	(UpdateFunc)(void *)rna_ParticleEdit_redo, 102170624, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(ParticleEditSettings, draw_step), RawPropertyType(0), nullptr},
	ParticleEdit_display_step_get, ParticleEdit_display_step_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 1, 10, 1, 10, 1, nullptr, nullptr, 2, nullptr
};
PropertyRNA &rna_ParticleEdit_display_step = reinterpret_cast<PropertyRNA &>(rna_ParticleEdit_display_step_);

static IntPropertyRNA rna_ParticleEdit_fade_frames_ = {
	{&rna_ParticleEdit_type, &rna_ParticleEdit_display_step,
	-1, "fade_frames", 4194305, 0, 0, 4, 0, PropertyPathTemplateType(0), "Frames",
	"How many frames to fade",
	0, "*",
	PROP_INT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	(UpdateFunc)(void *)rna_ParticleEdit_update, 102170624, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(ParticleEditSettings, fade_frames), RawPropertyType(0), nullptr},
	ParticleEdit_fade_frames_get, ParticleEdit_fade_frames_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 1, 100, 1, 100, 1, nullptr, nullptr, 2, nullptr
};
PropertyRNA &rna_ParticleEdit_fade_frames = reinterpret_cast<PropertyRNA &>(rna_ParticleEdit_fade_frames_);

static const EnumPropertyItem rna_ParticleEdit_type_items[4] = {
	{0, "PARTICLES", 0, "Particles", ""},
	{1, "SOFT_BODY", 0, "Soft Body", ""},
	{2, "CLOTH", 0, "Cloth", ""},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_ParticleEdit_type_ = {
	{&rna_ParticleEdit_is_editable, &rna_ParticleEdit_fade_frames,
	-1, "type", 4194305, 0, 0, 4, 0, PropertyPathTemplateType(0), "Type",
	"",
	0, "*",
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	(UpdateFunc)(void *)rna_ParticleEdit_redo, 102170624, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(ParticleEditSettings, edittype), RawPropertyType(0), nullptr},
	ParticleEdit_type_get, ParticleEdit_type_set, nullptr, nullptr, nullptr, nullptr, rna_ParticleEdit_type_items, 3, 0
};
PropertyRNA &rna_ParticleEdit_type = reinterpret_cast<PropertyRNA &>(rna_ParticleEdit_type_);

static BoolPropertyRNA rna_ParticleEdit_is_editable_ = {
	{&rna_ParticleEdit_is_hair, &rna_ParticleEdit_type,
	-1, "is_editable", 0, 0, 0, 0, 0, PropertyPathTemplateType(0), "Editable",
	"A valid edit mode exists",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ParticleEdit_is_editable_get, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_ParticleEdit_is_editable = reinterpret_cast<PropertyRNA &>(rna_ParticleEdit_is_editable_);

static BoolPropertyRNA rna_ParticleEdit_is_hair_ = {
	{&rna_ParticleEdit_object, &rna_ParticleEdit_is_editable,
	-1, "is_hair", 0, 0, 0, 0, 0, PropertyPathTemplateType(0), "Hair",
	"Editing hair",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ParticleEdit_is_hair_get, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_ParticleEdit_is_hair = reinterpret_cast<PropertyRNA &>(rna_ParticleEdit_is_hair_);

static PointerPropertyRNA rna_ParticleEdit_object_ = {
	{&rna_ParticleEdit_shape_object, &rna_ParticleEdit_is_hair,
	-1, "object", 8388736, 0, 0, 0, 0, PropertyPathTemplateType(0), "Object",
	"The edited object",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ParticleEdit_object_get, nullptr, nullptr, nullptr,&RNA_Object
};
PropertyRNA &rna_ParticleEdit_object = reinterpret_cast<PropertyRNA &>(rna_ParticleEdit_object_);

static PointerPropertyRNA rna_ParticleEdit_shape_object_ = {
	{nullptr, &rna_ParticleEdit_object,
	-1, "shape_object", 12583041, 0, 0, 0, 0, PropertyPathTemplateType(0), "Shape Object",
	"Outer shape to use for tools",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	(UpdateFunc)(void *)rna_ParticleEdit_redo, 102170624, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ParticleEdit_shape_object_get, ParticleEdit_shape_object_set, nullptr, rna_Mesh_object_poll,&RNA_Object
};
PropertyRNA &rna_ParticleEdit_shape_object = reinterpret_cast<PropertyRNA &>(rna_ParticleEdit_shape_object_);

StructRNA RNA_ParticleEdit = {
	{(ContainerRNA *)&RNA_ParticleBrush, (ContainerRNA *)&RNA_ImagePaint,
	nullptr,
	{&rna_ParticleEdit_rna_properties, &rna_ParticleEdit_shape_object}},
	"ParticleEdit", nullptr, nullptr, 512, nullptr, "Particle Edit",
	"Properties of particle editing mode",
	"*", 61,
	nullptr, &rna_ParticleEdit_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	rna_ParticleEdit_path,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Particle Brush */
static CollectionPropertyRNA rna_ParticleBrush_rna_properties_ = {
	{&rna_ParticleBrush_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ParticleBrush_rna_properties_begin, ParticleBrush_rna_properties_next, ParticleBrush_rna_properties_end, ParticleBrush_rna_properties_get, nullptr, nullptr, ParticleBrush_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_ParticleBrush_rna_properties = reinterpret_cast<PropertyRNA &>(rna_ParticleBrush_rna_properties_);

static PointerPropertyRNA rna_ParticleBrush_rna_type_ = {
	{&rna_ParticleBrush_size, &rna_ParticleBrush_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ParticleBrush_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_ParticleBrush_rna_type = reinterpret_cast<PropertyRNA &>(rna_ParticleBrush_rna_type_);

static IntPropertyRNA rna_ParticleBrush_size_ = {
	{&rna_ParticleBrush_strength, &rna_ParticleBrush_rna_type,
	-1, "size", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Radius",
	"Radius of the brush in pixels",
	0, "*",
	PROP_INT, PropertySubType(int(PROP_PIXEL) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(ParticleBrushData, size), RawPropertyType(1), nullptr},
	ParticleBrush_size_get, ParticleBrush_size_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 1, 500, 1, 32767, 10, nullptr, nullptr, 50, nullptr
};
PropertyRNA &rna_ParticleBrush_size = reinterpret_cast<PropertyRNA &>(rna_ParticleBrush_size_);

static FloatPropertyRNA rna_ParticleBrush_strength_ = {
	{&rna_ParticleBrush_count, &rna_ParticleBrush_size,
	-1, "strength", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Strength",
	"Brush strength",
	0, "Amount",
	PROP_FLOAT, PropertySubType(int(PROP_FACTOR) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(ParticleBrushData, strength), RawPropertyType(5), nullptr},
	ParticleBrush_strength_get, ParticleBrush_strength_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0010000000f, 1.0f, 0.0010000000f, 1.0f, 10.0f, 3, nullptr, nullptr, 0.5000000000f, nullptr
};
PropertyRNA &rna_ParticleBrush_strength = reinterpret_cast<PropertyRNA &>(rna_ParticleBrush_strength_);

static IntPropertyRNA rna_ParticleBrush_count_ = {
	{&rna_ParticleBrush_steps, &rna_ParticleBrush_strength,
	-1, "count", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Count",
	"Particle count",
	0, "*",
	PROP_INT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(ParticleBrushData, count), RawPropertyType(1), nullptr},
	ParticleBrush_count_get, ParticleBrush_count_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 1, 100, 1, 1000, 10, nullptr, nullptr, 10, nullptr
};
PropertyRNA &rna_ParticleBrush_count = reinterpret_cast<PropertyRNA &>(rna_ParticleBrush_count_);

static IntPropertyRNA rna_ParticleBrush_steps_ = {
	{&rna_ParticleBrush_puff_mode, &rna_ParticleBrush_count,
	-1, "steps", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Steps",
	"Brush steps",
	0, "*",
	PROP_INT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(ParticleBrushData, step), RawPropertyType(1), nullptr},
	ParticleBrush_steps_get, ParticleBrush_steps_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 1, 50, 1, 32767, 10, nullptr, nullptr, 10, nullptr
};
PropertyRNA &rna_ParticleBrush_steps = reinterpret_cast<PropertyRNA &>(rna_ParticleBrush_steps_);

static const EnumPropertyItem rna_ParticleBrush_puff_mode_items[3] = {
	{0, "ADD", 0, "Add", "Make hairs more puffy"},
	{1, "SUB", 0, "Sub", "Make hairs less puffy"},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_ParticleBrush_puff_mode_ = {
	{&rna_ParticleBrush_use_puff_volume, &rna_ParticleBrush_steps,
	-1, "puff_mode", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Puff Mode",
	"",
	0, "*",
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(ParticleBrushData, invert), RawPropertyType(1), nullptr},
	ParticleBrush_puff_mode_get, ParticleBrush_puff_mode_set, nullptr, nullptr, nullptr, nullptr, rna_ParticleBrush_puff_mode_items, 2, 0
};
PropertyRNA &rna_ParticleBrush_puff_mode = reinterpret_cast<PropertyRNA &>(rna_ParticleBrush_puff_mode_);

static BoolPropertyRNA rna_ParticleBrush_use_puff_volume_ = {
	{&rna_ParticleBrush_length_mode, &rna_ParticleBrush_puff_mode,
	-1, "use_puff_volume", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Puff Volume",
	"Apply puff to unselected end-points (helps maintain hair volume when puffing root)",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ParticleBrush_use_puff_volume_get, ParticleBrush_use_puff_volume_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_ParticleBrush_use_puff_volume = reinterpret_cast<PropertyRNA &>(rna_ParticleBrush_use_puff_volume_);

static const EnumPropertyItem rna_ParticleBrush_length_mode_items[3] = {
	{0, "GROW", 0, "Grow", "Make hairs longer"},
	{1, "SHRINK", 0, "Shrink", "Make hairs shorter"},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_ParticleBrush_length_mode_ = {
	{&rna_ParticleBrush_curve, &rna_ParticleBrush_use_puff_volume,
	-1, "length_mode", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Length Mode",
	"",
	0, "*",
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(ParticleBrushData, invert), RawPropertyType(1), nullptr},
	ParticleBrush_length_mode_get, ParticleBrush_length_mode_set, nullptr, nullptr, nullptr, nullptr, rna_ParticleBrush_length_mode_items, 2, 0
};
PropertyRNA &rna_ParticleBrush_length_mode = reinterpret_cast<PropertyRNA &>(rna_ParticleBrush_length_mode_);

static PointerPropertyRNA rna_ParticleBrush_curve_ = {
	{nullptr, &rna_ParticleBrush_length_mode,
	-1, "curve", 8388608, 0, 0, 0, 0, PropertyPathTemplateType(0), "Curve",
	"",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	ParticleBrush_curve_get, nullptr, nullptr, nullptr,&RNA_CurveMapping
};
PropertyRNA &rna_ParticleBrush_curve = reinterpret_cast<PropertyRNA &>(rna_ParticleBrush_curve_);

StructRNA RNA_ParticleBrush = {
	{(ContainerRNA *)&RNA_GPencilSculptGuide, (ContainerRNA *)&RNA_ParticleEdit,
	nullptr,
	{&rna_ParticleBrush_rna_properties, &rna_ParticleBrush_curve}},
	"ParticleBrush", nullptr, nullptr, 516, nullptr, "Particle Brush",
	"Particle editing brush",
	"*", 61,
	nullptr, &rna_ParticleBrush_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	rna_ParticleBrush_path,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Grease Pencil Sculpt Guide */
static CollectionPropertyRNA rna_GPencilSculptGuide_rna_properties_ = {
	{&rna_GPencilSculptGuide_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilSculptGuide_rna_properties_begin, GPencilSculptGuide_rna_properties_next, GPencilSculptGuide_rna_properties_end, GPencilSculptGuide_rna_properties_get, nullptr, nullptr, GPencilSculptGuide_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_GPencilSculptGuide_rna_properties = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptGuide_rna_properties_);

static PointerPropertyRNA rna_GPencilSculptGuide_rna_type_ = {
	{&rna_GPencilSculptGuide_use_guide, &rna_GPencilSculptGuide_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilSculptGuide_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_GPencilSculptGuide_rna_type = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptGuide_rna_type_);

static BoolPropertyRNA rna_GPencilSculptGuide_use_guide_ = {
	{&rna_GPencilSculptGuide_use_snapping, &rna_GPencilSculptGuide_rna_type,
	-1, "use_guide", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Use Guides",
	"Enable speed guides",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(GP_Sculpt_Guide, use_guide), RawPropertyType(3), nullptr},
	GPencilSculptGuide_use_guide_get, GPencilSculptGuide_use_guide_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilSculptGuide_use_guide = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptGuide_use_guide_);

static BoolPropertyRNA rna_GPencilSculptGuide_use_snapping_ = {
	{&rna_GPencilSculptGuide_reference_object, &rna_GPencilSculptGuide_use_guide,
	-1, "use_snapping", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Use Snapping",
	"Enable snapping to guides angle or spacing options",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(GP_Sculpt_Guide, use_snapping), RawPropertyType(3), nullptr},
	GPencilSculptGuide_use_snapping_get, GPencilSculptGuide_use_snapping_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilSculptGuide_use_snapping = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptGuide_use_snapping_);

static PointerPropertyRNA rna_GPencilSculptGuide_reference_object_ = {
	{&rna_GPencilSculptGuide_reference_point, &rna_GPencilSculptGuide_use_snapping,
	-1, "reference_object", 9437313, 0, 0, 0, 0, PropertyPathTemplateType(0), "Object",
	"Object used for reference point",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_ImaPaint_viewport_update, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilSculptGuide_reference_object_get, GPencilSculptGuide_reference_object_set, nullptr, nullptr,&RNA_Object
};
PropertyRNA &rna_GPencilSculptGuide_reference_object = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptGuide_reference_object_);

static const EnumPropertyItem rna_GPencilSculptGuide_reference_point_items[4] = {
	{0, "CURSOR", 0, "Cursor", "Use cursor as reference point"},
	{1, "CUSTOM", 0, "Custom", "Use custom reference point"},
	{2, "OBJECT", 0, "Object", "Use object as reference point"},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_GPencilSculptGuide_reference_point_ = {
	{&rna_GPencilSculptGuide_type, &rna_GPencilSculptGuide_reference_object,
	-1, "reference_point", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Type",
	"Type of speed guide",
	0, "*",
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_ImaPaint_viewport_update, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(GP_Sculpt_Guide, reference_point), RawPropertyType(2), nullptr},
	GPencilSculptGuide_reference_point_get, GPencilSculptGuide_reference_point_set, nullptr, nullptr, nullptr, nullptr, rna_GPencilSculptGuide_reference_point_items, 3, 0
};
PropertyRNA &rna_GPencilSculptGuide_reference_point = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptGuide_reference_point_);

static const EnumPropertyItem rna_GPencilSculptGuide_type_items[6] = {
	{0, "CIRCULAR", 0, "Circular", "Use single point to create rings"},
	{1, "RADIAL", 0, "Radial", "Use single point as direction"},
	{2, "PARALLEL", 0, "Parallel", "Parallel lines"},
	{3, "GRID", 0, "Grid", "Grid allows horizontal and vertical lines"},
	{4, "ISO", 0, "Isometric", "Grid allows isometric and vertical lines"},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_GPencilSculptGuide_type_ = {
	{&rna_GPencilSculptGuide_angle, &rna_GPencilSculptGuide_reference_point,
	-1, "type", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Type",
	"Type of speed guide",
	0, "*",
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(GP_Sculpt_Guide, type), RawPropertyType(2), nullptr},
	GPencilSculptGuide_type_get, GPencilSculptGuide_type_set, nullptr, nullptr, nullptr, nullptr, rna_GPencilSculptGuide_type_items, 5, 0
};
PropertyRNA &rna_GPencilSculptGuide_type = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptGuide_type_);

static FloatPropertyRNA rna_GPencilSculptGuide_angle_ = {
	{&rna_GPencilSculptGuide_angle_snap, &rna_GPencilSculptGuide_type,
	-1, "angle", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Angle",
	"Direction of lines",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_ANGLE) | int(PROP_UNIT_ROTATION)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(GP_Sculpt_Guide, angle), RawPropertyType(5), nullptr},
	GPencilSculptGuide_angle_get, GPencilSculptGuide_angle_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, -6.2831854820f, 6.2831854820f, -6.2831854820f, 6.2831854820f, 10.0f, 3, nullptr, nullptr, 0.0f, nullptr
};
PropertyRNA &rna_GPencilSculptGuide_angle = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptGuide_angle_);

static FloatPropertyRNA rna_GPencilSculptGuide_angle_snap_ = {
	{&rna_GPencilSculptGuide_spacing, &rna_GPencilSculptGuide_angle,
	-1, "angle_snap", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Angle Snap",
	"Angle snapping",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_ANGLE) | int(PROP_UNIT_ROTATION)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(GP_Sculpt_Guide, angle_snap), RawPropertyType(5), nullptr},
	GPencilSculptGuide_angle_snap_get, GPencilSculptGuide_angle_snap_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, -6.2831854820f, 6.2831854820f, -6.2831854820f, 6.2831854820f, 10.0f, 3, nullptr, nullptr, 0.0f, nullptr
};
PropertyRNA &rna_GPencilSculptGuide_angle_snap = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptGuide_angle_snap_);

static FloatPropertyRNA rna_GPencilSculptGuide_spacing_ = {
	{&rna_GPencilSculptGuide_location, &rna_GPencilSculptGuide_angle_snap,
	-1, "spacing", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Spacing",
	"Guide spacing",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_DISTANCE) | int(PROP_UNIT_LENGTH)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(GP_Sculpt_Guide, spacing), RawPropertyType(5), nullptr},
	GPencilSculptGuide_spacing_get, GPencilSculptGuide_spacing_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0f, FLT_MAX, 0.0f, FLT_MAX, 1.0f, 3, nullptr, nullptr, 20.0f, nullptr
};
PropertyRNA &rna_GPencilSculptGuide_spacing = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptGuide_spacing_);

static float rna_GPencilSculptGuide_location_default[3] = {
	0.0f,
	0.0f,
	0.0f
};

static FloatPropertyRNA rna_GPencilSculptGuide_location_ = {
	{nullptr, &rna_GPencilSculptGuide_spacing,
	-1, "location", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Location",
	"Custom reference point for guides",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_DISTANCE) | int(PROP_UNIT_LENGTH)), nullptr, 1, {3, 0, 0}, 3,
	rna_ImaPaint_viewport_update, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(GP_Sculpt_Guide, location), RawPropertyType(5), nullptr},
	nullptr, nullptr, GPencilSculptGuide_location_get, GPencilSculptGuide_location_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, -FLT_MAX, FLT_MAX, -FLT_MAX, FLT_MAX, 1.0f, 3, nullptr, nullptr, 0.0f, rna_GPencilSculptGuide_location_default
};
PropertyRNA &rna_GPencilSculptGuide_location = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptGuide_location_);

StructRNA RNA_GPencilSculptGuide = {
	{(ContainerRNA *)&RNA_GPencilSculptSettings, (ContainerRNA *)&RNA_ParticleBrush,
	nullptr,
	{&rna_GPencilSculptGuide_rna_properties, &rna_GPencilSculptGuide_location}},
	"GPencilSculptGuide", nullptr, nullptr, 516, nullptr, "Grease Pencil Sculpt Guide",
	"Guides for drawing",
	"*", 61,
	nullptr, &rna_GPencilSculptGuide_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	rna_GPencilSculptGuide_path,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* GPencil Sculpt Settings */
static CollectionPropertyRNA rna_GPencilSculptSettings_rna_properties_ = {
	{&rna_GPencilSculptSettings_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilSculptSettings_rna_properties_begin, GPencilSculptSettings_rna_properties_next, GPencilSculptSettings_rna_properties_end, GPencilSculptSettings_rna_properties_get, nullptr, nullptr, GPencilSculptSettings_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_GPencilSculptSettings_rna_properties = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptSettings_rna_properties_);

static PointerPropertyRNA rna_GPencilSculptSettings_rna_type_ = {
	{&rna_GPencilSculptSettings_guide, &rna_GPencilSculptSettings_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilSculptSettings_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_GPencilSculptSettings_rna_type = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptSettings_rna_type_);

static PointerPropertyRNA rna_GPencilSculptSettings_guide_ = {
	{&rna_GPencilSculptSettings_use_multiframe_falloff, &rna_GPencilSculptSettings_rna_type,
	-1, "guide", 8388608, 0, 0, 0, 0, PropertyPathTemplateType(0), "Guide",
	"",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilSculptSettings_guide_get, nullptr, nullptr, nullptr,&RNA_GPencilSculptGuide
};
PropertyRNA &rna_GPencilSculptSettings_guide = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptSettings_guide_);

static BoolPropertyRNA rna_GPencilSculptSettings_use_multiframe_falloff_ = {
	{&rna_GPencilSculptSettings_use_thickness_curve, &rna_GPencilSculptSettings_guide,
	-1, "use_multiframe_falloff", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Use Falloff",
	"Use falloff effect when edit in multiframe mode to compute brush effect by frame",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilSculptSettings_use_multiframe_falloff_get, GPencilSculptSettings_use_multiframe_falloff_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilSculptSettings_use_multiframe_falloff = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptSettings_use_multiframe_falloff_);

static BoolPropertyRNA rna_GPencilSculptSettings_use_thickness_curve_ = {
	{&rna_GPencilSculptSettings_use_scale_thickness, &rna_GPencilSculptSettings_use_multiframe_falloff,
	-1, "use_thickness_curve", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Use Curve",
	"Use curve to define primitive stroke thickness",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilSculptSettings_use_thickness_curve_get, GPencilSculptSettings_use_thickness_curve_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilSculptSettings_use_thickness_curve = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptSettings_use_thickness_curve_);

static BoolPropertyRNA rna_GPencilSculptSettings_use_scale_thickness_ = {
	{&rna_GPencilSculptSettings_use_automasking_stroke, &rna_GPencilSculptSettings_use_thickness_curve,
	-1, "use_scale_thickness", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Scale Stroke Thickness",
	"Scale the stroke thickness when transforming strokes",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilSculptSettings_use_scale_thickness_get, GPencilSculptSettings_use_scale_thickness_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilSculptSettings_use_scale_thickness = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptSettings_use_scale_thickness_);

static BoolPropertyRNA rna_GPencilSculptSettings_use_automasking_stroke_ = {
	{&rna_GPencilSculptSettings_use_automasking_layer_stroke, &rna_GPencilSculptSettings_use_scale_thickness,
	-1, "use_automasking_stroke", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Auto-Masking Strokes",
	"Affect only strokes below the cursor",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilSculptSettings_use_automasking_stroke_get, GPencilSculptSettings_use_automasking_stroke_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilSculptSettings_use_automasking_stroke = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptSettings_use_automasking_stroke_);

static BoolPropertyRNA rna_GPencilSculptSettings_use_automasking_layer_stroke_ = {
	{&rna_GPencilSculptSettings_use_automasking_material_stroke, &rna_GPencilSculptSettings_use_automasking_stroke,
	-1, "use_automasking_layer_stroke", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Auto-Masking Layer",
	"Affect only strokes below the cursor",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilSculptSettings_use_automasking_layer_stroke_get, GPencilSculptSettings_use_automasking_layer_stroke_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilSculptSettings_use_automasking_layer_stroke = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptSettings_use_automasking_layer_stroke_);

static BoolPropertyRNA rna_GPencilSculptSettings_use_automasking_material_stroke_ = {
	{&rna_GPencilSculptSettings_use_automasking_layer_active, &rna_GPencilSculptSettings_use_automasking_layer_stroke,
	-1, "use_automasking_material_stroke", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Auto-Masking Material",
	"Affect only strokes below the cursor",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilSculptSettings_use_automasking_material_stroke_get, GPencilSculptSettings_use_automasking_material_stroke_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilSculptSettings_use_automasking_material_stroke = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptSettings_use_automasking_material_stroke_);

static BoolPropertyRNA rna_GPencilSculptSettings_use_automasking_layer_active_ = {
	{&rna_GPencilSculptSettings_use_automasking_material_active, &rna_GPencilSculptSettings_use_automasking_material_stroke,
	-1, "use_automasking_layer_active", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Auto-Masking Layer",
	"Affect only the Active Layer",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilSculptSettings_use_automasking_layer_active_get, GPencilSculptSettings_use_automasking_layer_active_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilSculptSettings_use_automasking_layer_active = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptSettings_use_automasking_layer_active_);

static BoolPropertyRNA rna_GPencilSculptSettings_use_automasking_material_active_ = {
	{&rna_GPencilSculptSettings_multiframe_falloff_curve, &rna_GPencilSculptSettings_use_automasking_layer_active,
	-1, "use_automasking_material_active", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Auto-Masking Material",
	"Affect only the Active Material",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilSculptSettings_use_automasking_material_active_get, GPencilSculptSettings_use_automasking_material_active_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilSculptSettings_use_automasking_material_active = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptSettings_use_automasking_material_active_);

static PointerPropertyRNA rna_GPencilSculptSettings_multiframe_falloff_curve_ = {
	{&rna_GPencilSculptSettings_thickness_primitive_curve, &rna_GPencilSculptSettings_use_automasking_material_active,
	-1, "multiframe_falloff_curve", 8388608, 0, 0, 0, 0, PropertyPathTemplateType(0), "Curve",
	"Custom curve to control falloff of brush effect by Grease Pencil frames",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilSculptSettings_multiframe_falloff_curve_get, nullptr, nullptr, nullptr,&RNA_CurveMapping
};
PropertyRNA &rna_GPencilSculptSettings_multiframe_falloff_curve = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptSettings_multiframe_falloff_curve_);

static PointerPropertyRNA rna_GPencilSculptSettings_thickness_primitive_curve_ = {
	{&rna_GPencilSculptSettings_lock_axis, &rna_GPencilSculptSettings_multiframe_falloff_curve,
	-1, "thickness_primitive_curve", 8388608, 0, 0, 0, 0, PropertyPathTemplateType(0), "Curve",
	"Custom curve to control primitive thickness",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 84869120, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilSculptSettings_thickness_primitive_curve_get, nullptr, nullptr, nullptr,&RNA_CurveMapping
};
PropertyRNA &rna_GPencilSculptSettings_thickness_primitive_curve = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptSettings_thickness_primitive_curve_);

static const EnumPropertyItem rna_GPencilSculptSettings_lock_axis_items[6] = {
	{0, "VIEW", 31, "View", "Align strokes to current view plane"},
	{2, "AXIS_Y", 604, "Front (X-Z)", "Project strokes to plane locked to Y"},
	{1, "AXIS_X", 605, "Side (Y-Z)", "Project strokes to plane locked to X"},
	{3, "AXIS_Z", 606, "Top (X-Y)", "Project strokes to plane locked to Z"},
	{4, "CURSOR", 552, "Cursor", "Align strokes to current 3D cursor orientation"},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_GPencilSculptSettings_lock_axis_ = {
	{&rna_GPencilSculptSettings_intersection_threshold, &rna_GPencilSculptSettings_thickness_primitive_curve,
	-1, "lock_axis", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Lock Axis",
	"",
	0, "*",
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 391839744, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(GP_Sculpt_Settings, lock_axis), RawPropertyType(0), nullptr},
	GPencilSculptSettings_lock_axis_get, GPencilSculptSettings_lock_axis_set, nullptr, nullptr, nullptr, nullptr, rna_GPencilSculptSettings_lock_axis_items, 5, 0
};
PropertyRNA &rna_GPencilSculptSettings_lock_axis = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptSettings_lock_axis_);

static FloatPropertyRNA rna_GPencilSculptSettings_intersection_threshold_ = {
	{nullptr, &rna_GPencilSculptSettings_lock_axis,
	-1, "intersection_threshold", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Threshold",
	"Threshold for stroke intersections",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(GP_Sculpt_Settings, isect_threshold), RawPropertyType(5), nullptr},
	GPencilSculptSettings_intersection_threshold_get, GPencilSculptSettings_intersection_threshold_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0f, 10.0f, 0.0f, 10.0f, 10.0f, 3, nullptr, nullptr, 0.1000000015f, nullptr
};
PropertyRNA &rna_GPencilSculptSettings_intersection_threshold = reinterpret_cast<PropertyRNA &>(rna_GPencilSculptSettings_intersection_threshold_);

StructRNA RNA_GPencilSculptSettings = {
	{(ContainerRNA *)&RNA_CurvesSculpt, (ContainerRNA *)&RNA_GPencilSculptGuide,
	nullptr,
	{&rna_GPencilSculptSettings_rna_properties, &rna_GPencilSculptSettings_intersection_threshold}},
	"GPencilSculptSettings", nullptr, nullptr, 512, nullptr, "GPencil Sculpt Settings",
	"General properties for Grease Pencil stroke sculpting tools",
	"*", 61,
	nullptr, &rna_GPencilSculptSettings_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	rna_GPencilSculptSettings_path,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Curves Sculpt Paint */
StructRNA RNA_CurvesSculpt = {
	{(ContainerRNA *)&RNA_StripColorBalanceData, (ContainerRNA *)&RNA_GPencilSculptSettings,
	nullptr,
	{nullptr, nullptr}},
	"CurvesSculpt", nullptr, nullptr, 512, nullptr, "Curves Sculpt Paint",
	"",
	"*", 61,
	nullptr, &rna_Paint_rna_properties,
	&RNA_Paint,
	nullptr,
	nullptr,
	rna_CurvesSculpt_path,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

