# Overview

As a member of the Sensu community, we ask that you keep the following in mind:

  * Be kind and welcoming to others.
  * Respect personal space and ask before you enter it. Remember not
    everyone likes to be touched or hugged or joked with.
  * Be mindful of language. Do not disparage others. Listen more than you talk.
  * Remember that harassment and sexist, racist comments or behavior are not
    appropriate in our Community.

Sensu in-person and online events are intended for networking and
collaboration in the monitoring community. Attendees violating these rules may
be asked to leave any event we host without a refund at the sole discretion of
the event organizers.

The same rules apply when participating in other Sensu-related forums and
mailing lists, contributing to code and documentation, and in private
correspondence in Sensu-related space.

Thank you for helping make this a welcoming place for all.


## Important numbers

Conference staff is happy to help participants contact venue security or local
law enforcement, provide escorts, or otherwise assist those experiencing
harassment to feel safe for the duration of the event. We value your
attendance.

If your physical safety or the physical safety of others is at risk, please
dial or text emergency number (911 in Americas, 112 in Europe, see [wiki][]
page for more numbers). For other needs, contact the relevant authorities
below:

   [wiki]:
      https://en.wikipedia.org/wiki/List_of_emergency_telephone_numbers
      (List of emergency numbers)

**Code of Conduct team**  
The Sensu Community team  
community@sensu.io  
[+1 855-997-3678 ext 510](tel:+18559973678,,510)


# Full Code of Conduct

In order to foster an inclusive, kind, harassment-free, and cooperative
community, Sensu enforces this code of conduct on our software projects and
events. To make clear what is expected, all delegates/attendees, speakers,
exhibitors, organizers, and volunteers at any Sensu activity are required to
read and follow this Code of Conduct. Same rules apply to online activities
such as opening pull requests, submitting issues, and posting content on Sensu
forums.


## Our Pledge

In the interest of fostering an open and welcoming environment, we, as
contributors and maintainers, pledge to making participation in our project
and our community a harassment-free experience for everyone, regardless of
age, body size, disability, ethnicity, gender identity and expression, level
of experience, nationality, personal appearance, race, religion, or sexual
identity and orientation.


## Enforcement

Participants asked to stop any harassing behavior are expected to comply
immediately.

At events, exhibitors in the expo hall, sponsor or vendor booths, or similar
activities are also subject to the anti-harassment policy. In particular,
exhibitors should never use sexualized images, activities, or other material.
Booth staff (including volunteers) should not use sexualized
clothing/uniforms/costumes, or otherwise create a sexualized environment.

If a participant engages in behavior that violates this code of conduct, the
event organizers, project maintainers, or forum administrators will take any
action they deem appropriate, including warning the offender, expulsion from
the event with no refund, or blocking access to repository.


## Our Standards

Examples of behavior that contributes to creating a positive environment
include:

  * Using welcoming and inclusive language
  * Being respectful of differing viewpoints and experiences
  * Gracefully accepting constructive criticism
  * Focusing on what is best for the community
  * Showing empathy towards other community members

Examples of behavior that contributes to creating a negative environment
include:

  * The use of sexualized language or imagery and unwelcome sexual attention
    or advances
  * Trolling, insulting/derogatory comments, and personal or political attacks
  * Public or private harassment
  * Publishing others' private information, such as a physical or electronic
    address, without explicit permission

Other conduct which could reasonably be considered inappropriate in a
professional setting All communication should be appropriate for a
professional audience, including people of many different backgrounds. Sexual
language and imagery is not appropriate at any time in our community,
including presentations.


## Our Responsibilities

Project contributors (including maintainers) are responsible for clarifying
the standards of acceptable behavior and are expected to take appropriate and
fair corrective action in response to any instances of unacceptable behavior.

Project contributors have the right and responsibility to remove, edit, or
reject comments, commits, code, wiki edits, issues, and other contributions
that are not aligned to this Code of Conduct, or to ban temporarily or
permanently any contributor for other behaviors that they deem inappropriate,
threatening, offensive, or harmful.


## Scope

This Code of Conduct applies both within project spaces and in public spaces
when an individual is representing the project or its community. Examples of
representing a project or community include using an official project e-mail
address, posting via an official social media account, or acting as an
appointed representative at an online or offline event. Representation of a
project may be further defined and clarified by project maintainers.


## Recommendations

The team leading the Sensu Community and enforcing its Code of Conduct
recognize that most participants mean well, but may not be familiar with
behaviors that can harm others unintentionally. The following includes
recommendations to be effective and thoughtful participants.


### Be kind to others

Kindness is about providing people what they need. It's best to start by
listening to others more than you speak. From there, it is all about providing
people with a sense that they are welcome. Here are some ideas of how to do
that: invite someone to your lunch table; smile at an attendee; introduce
yourself to someone new; and sit with folks you've never met; answer forum
questions politely and link to relevant documentation; help first time
contributors follow developer guides; say thank you when code contribution is
accepted. Encourage others to share.


### Respect personal space

Respect others' boundaries. Respect personal space and ask before you enter
it. Remember not everyone likes to be touched or hugged. If you are a hugger,
it is respectful to directly ask ("I'm a hugger. Would you like a hug?").


### Beware of gendered double standards

Be conscious of your behavior reinforcing one set of introductions for women
and a different set for men. If you shake people's hands when you meet them,
offer to do so consistently regardless of gender. If you hug people when you
meet them, offer to do so consistently regardless of gender.


### Be respectful

Not all of us will agree all the time, but disagreement is no excuse for poor
behavior and poor manners. This is doubly important in online communication
where it is easy to forget that we are interaction with another human being.
We do not tolerate harassment of event participants in any form.

Harassment includes: offensive verbal comments related to gender, gender
identity, sexual orientation, disability, physical appearance, body size,
race, religion; sexual images in public spaces; deliberate intimidation,
stalking, or following; harassing photography or recording; sustained
disruption of talks or other events; unwanted physical contact; and unwelcome
sexual attention.


### Choose your words

Be thoughtful with the words you choose. Remember that sexist, racist, and
other exclusionary jokes can be offensive to those around you. Excessive
swearing can be off-putting to those around you. When you want to bring up
topics that may relate to past trauma, mention the appropriate trigger/content
warnings (if necessary, read more about trigger warnings).


### Photography

It's always nice to ask before taking a photo. If someone does not want to be
photographed, video or audio recorded, please respect their wishes.


## License

This Code of Conduct began as an adaptation of Contributor Covenant, version
1.4, available at
https://www.contributor-covenant.org/version/1/4/code-of-conduct.html. It was
influenced by Geek Feminism wiki, created by the Ada Initiative under a
Creative Commons Zero license. We also used language about events from the
Conference Code of Conduct by 2017.djangocon.us/coc/.
