/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.management.HotspotThreadMBean;
import sun.management.VMManagement;
import sun.management.counter.Counter;

class HotspotThread
implements HotspotThreadMBean {
    private VMManagement jvm;
    private static final String JAVA_THREADS = "java.threads.";
    private static final String COM_SUN_THREADS = "com.sun.threads.";
    private static final String SUN_THREADS = "sun.threads.";
    private static final String THREADS_COUNTER_NAME_PATTERN = "java.threads.|com.sun.threads.|sun.threads.";

    HotspotThread(VMManagement vMManagement) {
        this.jvm = vMManagement;
    }

    @Override
    public native int getInternalThreadCount();

    @Override
    public Map<String, Long> getInternalThreadCpuTimes() {
        int n = this.getInternalThreadCount();
        if (n == 0) {
            return Collections.emptyMap();
        }
        String[] stringArray = new String[n];
        long[] lArray = new long[n];
        int n2 = this.getInternalThreadTimes0(stringArray, lArray);
        HashMap<String, Long> hashMap = new HashMap<String, Long>(n2);
        for (int i = 0; i < n2; ++i) {
            hashMap.put(stringArray[i], new Long(lArray[i]));
        }
        return hashMap;
    }

    public native int getInternalThreadTimes0(String[] var1, long[] var2);

    @Override
    public List<Counter> getInternalThreadingCounters() {
        return this.jvm.getInternalCounters(THREADS_COUNTER_NAME_PATTERN);
    }
}

