# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_acme_redirect_global_optspecs
	string join \n v/verbose q/quiet c/config= config-dir= chall-dir= data-dir= acme-url= acme-email= h/help V/version
end

function __fish_acme_redirect_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_acme_redirect_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_acme_redirect_using_subcommand
	set -l cmd (__fish_acme_redirect_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c acme-redirect -n "__fish_acme_redirect_needs_command" -s c -l config -r
complete -c acme-redirect -n "__fish_acme_redirect_needs_command" -l config-dir -r
complete -c acme-redirect -n "__fish_acme_redirect_needs_command" -l chall-dir -r
complete -c acme-redirect -n "__fish_acme_redirect_needs_command" -l data-dir -r
complete -c acme-redirect -n "__fish_acme_redirect_needs_command" -l acme-url -r
complete -c acme-redirect -n "__fish_acme_redirect_needs_command" -l acme-email -r
complete -c acme-redirect -n "__fish_acme_redirect_needs_command" -s v -l verbose -d 'Verbose logging output (Can be set multiple times)'
complete -c acme-redirect -n "__fish_acme_redirect_needs_command" -s q -l quiet -d 'Silent output (except errors)'
complete -c acme-redirect -n "__fish_acme_redirect_needs_command" -s h -l help -d 'Print help'
complete -c acme-redirect -n "__fish_acme_redirect_needs_command" -s V -l version -d 'Print version'
complete -c acme-redirect -n "__fish_acme_redirect_needs_command" -f -a "daemon" -d 'Run the redirect daemon'
complete -c acme-redirect -n "__fish_acme_redirect_needs_command" -f -a "status" -d 'Show the status of our certificates'
complete -c acme-redirect -n "__fish_acme_redirect_needs_command" -f -a "renew" -d 'Request new certificates if needed'
complete -c acme-redirect -n "__fish_acme_redirect_needs_command" -f -a "check" -d 'Check if the challenges could be completed'
complete -c acme-redirect -n "__fish_acme_redirect_needs_command" -f -a "dump-config" -d 'Load the configuration and dump it to stdout as json'
complete -c acme-redirect -n "__fish_acme_redirect_needs_command" -f -a "completions" -d 'Generate shell completions'
complete -c acme-redirect -n "__fish_acme_redirect_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand daemon" -s B -l bind-addr -d 'The address to listen on' -r
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand daemon" -l user -d 'Drop from root to this user' -r
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand daemon" -l chroot -d 'Chroot into the challenge directory'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand daemon" -s v -l verbose -d 'Verbose logging output (Can be set multiple times)'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand daemon" -s q -l quiet -d 'Silent output (except errors)'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand daemon" -s h -l help -d 'Print help'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand status" -s v -l verbose -d 'Verbose logging output (Can be set multiple times)'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand status" -s q -l quiet -d 'Silent output (except errors)'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand status" -s h -l help -d 'Print help'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand renew" -s n -l dry-run -d 'Do not actually do anything, just show what would happen'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand renew" -l force-renew -d 'Renew certificates even if they are not about to expire'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand renew" -l skip-restarts -d 'Do not execute the configured exec commands'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand renew" -l skip-cleanup -d 'Don\'t clean up old certs that are not live anymore'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand renew" -l hooks-only -d 'Only execute hooks without actually renewing certs'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand renew" -s v -l verbose -d 'Verbose logging output (Can be set multiple times)'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand renew" -s q -l quiet -d 'Silent output (except errors)'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand renew" -s h -l help -d 'Print help'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand check" -s v -l verbose -d 'Verbose logging output (Can be set multiple times)'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand check" -s q -l quiet -d 'Silent output (except errors)'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand check" -s h -l help -d 'Print help'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand dump-config" -s v -l verbose -d 'Verbose logging output (Can be set multiple times)'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand dump-config" -s q -l quiet -d 'Silent output (except errors)'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand dump-config" -s h -l help -d 'Print help'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand completions" -s v -l verbose -d 'Verbose logging output (Can be set multiple times)'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand completions" -s q -l quiet -d 'Silent output (except errors)'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand completions" -s h -l help -d 'Print help'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand help; and not __fish_seen_subcommand_from daemon status renew check dump-config completions help" -f -a "daemon" -d 'Run the redirect daemon'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand help; and not __fish_seen_subcommand_from daemon status renew check dump-config completions help" -f -a "status" -d 'Show the status of our certificates'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand help; and not __fish_seen_subcommand_from daemon status renew check dump-config completions help" -f -a "renew" -d 'Request new certificates if needed'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand help; and not __fish_seen_subcommand_from daemon status renew check dump-config completions help" -f -a "check" -d 'Check if the challenges could be completed'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand help; and not __fish_seen_subcommand_from daemon status renew check dump-config completions help" -f -a "dump-config" -d 'Load the configuration and dump it to stdout as json'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand help; and not __fish_seen_subcommand_from daemon status renew check dump-config completions help" -f -a "completions" -d 'Generate shell completions'
complete -c acme-redirect -n "__fish_acme_redirect_using_subcommand help; and not __fish_seen_subcommand_from daemon status renew check dump-config completions help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
