/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jpub.runtime.OracleDataUtil;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class OracleDataMutableArray {
    int length;
    Object[] elements;
    Object[] jdbcObjects;
    OracleArray pickled;
    boolean pickledCorrect;
    int sqlType;
    OracleDataFactory oracleDataFactory;
    boolean isNChar;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    public OracleDataMutableArray(int sqlType, OracleArray s, OracleDataFactory oracleDataFactory) {
        this.length = -1;
        this.elements = null;
        this.jdbcObjects = null;
        this.pickled = s;
        this.pickledCorrect = true;
        this.isNChar = false;
        this.sqlType = sqlType;
        this.oracleDataFactory = oracleDataFactory;
    }

    public OracleDataMutableArray(int sqlType, Object[] d, OracleDataFactory oracleDataFactory) {
        this.sqlType = sqlType;
        this.oracleDataFactory = oracleDataFactory;
        this.isNChar = false;
        this.setJDBCObjectArray(d);
    }

    public OracleDataMutableArray(int sqlType, double[] a, OracleDataFactory oracleDataFactory) {
        this.sqlType = sqlType;
        this.oracleDataFactory = oracleDataFactory;
        this.isNChar = false;
        this.setArray(a);
    }

    public OracleDataMutableArray(int sqlType, int[] a, OracleDataFactory oracleDataFactory) {
        this.sqlType = sqlType;
        this.oracleDataFactory = oracleDataFactory;
        this.isNChar = false;
        this.setArray(a);
    }

    public OracleDataMutableArray(int sqlType, float[] a, OracleDataFactory oracleDataFactory) {
        this.sqlType = sqlType;
        this.oracleDataFactory = oracleDataFactory;
        this.isNChar = false;
        this.setArray(a);
    }

    public OracleDataMutableArray(int sqlType, short[] a, OracleDataFactory oracleDataFactory) {
        this.sqlType = sqlType;
        this.oracleDataFactory = oracleDataFactory;
        this.isNChar = false;
        this.setArray(a);
    }

    public Object toJDBCObject(Connection c, String sqlTypeName) throws SQLException {
        if (!this.pickledCorrect) {
            this.pickled = (OracleArray)((oracle.jdbc.OracleConnection)c).createOracleArray(sqlTypeName, this.getJDBCObjectArray(c));
            this.pickledCorrect = true;
        }
        return this.pickled;
    }

    public Object[] getOracleArray() throws SQLException {
        return this.getOracleArray(0L, Integer.MAX_VALUE);
    }

    public Object[] getOracleArray(long index, int count) throws SQLException {
        int sliceLen = this.sliceLength(index, count);
        if (sliceLen < 0) {
            return null;
        }
        Object[] a = null;
        switch (this.sqlType) {
            case -13: {
                a = new BFILE[sliceLen];
                break;
            }
            case 2004: {
                a = new BLOB[sliceLen];
                break;
            }
            case 1: 
            case 12: {
                a = new CHAR[sliceLen];
                break;
            }
            case 2005: {
                a = new CLOB[sliceLen];
                break;
            }
            case 91: {
                a = new DATE[sliceLen];
                break;
            }
            case 93: {
                a = new TIMESTAMP[sliceLen];
                break;
            }
            case -101: {
                a = new TIMESTAMPTZ[sliceLen];
                break;
            }
            case -102: {
                a = new TIMESTAMPLTZ[sliceLen];
                break;
            }
            case -104: {
                a = new INTERVALDS[sliceLen];
                break;
            }
            case -103: {
                a = new INTERVALYM[sliceLen];
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                a = new NUMBER[sliceLen];
                break;
            }
            case -2: {
                a = new RAW[sliceLen];
                break;
            }
            case 100: {
                a = new BINARY_FLOAT[sliceLen];
                break;
            }
            case 101: {
                a = new BINARY_DOUBLE[sliceLen];
                break;
            }
            case 0: 
            case 2002: 
            case 2003: 
            case 2006: 
            case 2007: {
                a = new OracleData[sliceLen];
                break;
            }
            default: {
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 48);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        return this.getOracleArray(index, a);
    }

    public Object[] getOracleArray(long index, Object[] a) throws SQLException {
        block5: {
            int idx;
            int sliceLen;
            block4: {
                if (a == null) {
                    return null;
                }
                sliceLen = this.sliceLength(index, a.length);
                idx = (int)index;
                if (sliceLen != a.length) {
                    return null;
                }
                if (this.sqlType != 2002 && this.sqlType != 2007 && this.sqlType != 2003 && this.sqlType != 2006 && this.sqlType != 0) break block4;
                if (this.oracleDataFactory == null) break block5;
                for (int i = 0; i < sliceLen; ++i) {
                    a[i] = this.oracleDataFactory.create(this.getJDBCObjectElement(idx++, null), this.sqlType);
                }
                break block5;
            }
            for (int i = 0; i < sliceLen; ++i) {
                a[i] = this.getJDBCObjectElement(idx++, null);
            }
        }
        return a;
    }

    public Object[] getOracleArray(Object[] a) throws SQLException {
        return this.getOracleArray(0L, a);
    }

    public Object[] getObjectArray() throws SQLException {
        return this.getObjectArray(0L, Integer.MAX_VALUE);
    }

    public Object[] getObjectArray(long index, int count) throws SQLException {
        Object[] a;
        int sliceLen = this.sliceLength(index, count);
        if (sliceLen < 0) {
            return null;
        }
        switch (this.sqlType) {
            case 1: 
            case 12: {
                a = new String[sliceLen];
                break;
            }
            case 91: {
                a = new Date[sliceLen];
                break;
            }
            case 93: {
                a = new Timestamp[sliceLen];
                break;
            }
            case 2: 
            case 3: {
                a = new BigDecimal[sliceLen];
                break;
            }
            case 6: 
            case 8: {
                a = new Double[sliceLen];
                break;
            }
            case 4: 
            case 5: {
                a = new Integer[sliceLen];
                break;
            }
            case 7: {
                a = new Float[sliceLen];
                break;
            }
            case -2: {
                a = (Object[])new byte[sliceLen][];
                break;
            }
            default: {
                return this.getOracleArray(index, count);
            }
        }
        return this.getObjectArray(index, a);
    }

    public Object[] getObjectArray(long index, Object[] a) throws SQLException {
        if (a == null) {
            return null;
        }
        int sliceLen = this.sliceLength(index, a.length);
        int idx = (int)index;
        if (sliceLen != a.length) {
            return null;
        }
        switch (this.sqlType) {
            case -2: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 91: 
            case 93: {
                for (int i = 0; i < sliceLen; ++i) {
                    a[i] = this.getObjectElement(idx++);
                }
                return a;
            }
        }
        return this.getOracleArray(index, a);
    }

    public Object[] getObjectArray(Object[] a) throws SQLException {
        return this.getObjectArray(0L, a);
    }

    public Object getArray() throws SQLException {
        return this.getArray(0L, Integer.MAX_VALUE);
    }

    public Object getArray(long index, int count) throws SQLException {
        int sliceLen = this.sliceLength(index, count);
        int idx = (int)index;
        if (sliceLen < 0) {
            return null;
        }
        switch (this.sqlType) {
            case 6: 
            case 8: 
            case 101: {
                double[] a = new double[sliceLen];
                for (int i = 0; i < sliceLen; ++i) {
                    a[i] = (Double)this.getObjectElement(idx++);
                }
                return a;
            }
            case 100: {
                float[] a = new float[sliceLen];
                for (int i = 0; i < sliceLen; ++i) {
                    a[i] = ((Float)this.getObjectElement(idx++)).floatValue();
                }
                return a;
            }
            case 4: {
                int[] a = new int[sliceLen];
                for (int i = 0; i < sliceLen; ++i) {
                    a[i] = (Integer)this.getObjectElement(idx++);
                }
                return a;
            }
            case 5: {
                short[] a = new short[sliceLen];
                for (int i = 0; i < sliceLen; ++i) {
                    a[i] = (short)((Integer)this.getObjectElement(idx++)).intValue();
                }
                return a;
            }
            case 7: {
                float[] a = new float[sliceLen];
                for (int i = 0; i < sliceLen; ++i) {
                    a[i] = ((Float)this.getObjectElement(idx++)).floatValue();
                }
                return a;
            }
        }
        return this.getObjectArray(index, count);
    }

    public void setOracleArray(Object[] a) {
        if (this.oracleDataFactory == null) {
            this.setJDBCObjectArray(a);
        } else {
            this.setObjectArray(a);
        }
    }

    public void setOracleArray(Object[] a, long index) throws SQLException {
        if (this.oracleDataFactory == null) {
            this.setJDBCObjectArray(a, index);
        } else {
            this.setObjectArray(a, index);
        }
    }

    public void setObjectArray(Object[] a) {
        if (a == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(a.length);
            this.elements = new Object[this.length];
            for (int i = 0; i < this.length; ++i) {
                this.elements[i] = a[i];
            }
        }
    }

    public void setObjectArray(Object[] a, long index) throws SQLException {
        if (a == null) {
            return;
        }
        int sliceLen = this.sliceLength(index, a.length);
        int idx = (int)index;
        for (int i = 0; i < sliceLen; ++i) {
            this.setObjectElement(a[i], idx++);
        }
    }

    public void setArray(double[] a) {
        if (a == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(a.length);
            this.elements = new Object[this.length];
            for (int i = 0; i < this.length; ++i) {
                this.elements[i] = a[i];
            }
        }
    }

    public void setArray(double[] a, long index) throws SQLException {
        if (a == null) {
            return;
        }
        int sliceLen = this.sliceLength(index, a.length);
        int idx = (int)index;
        for (int i = 0; i < sliceLen; ++i) {
            this.setObjectElement(a[i], idx++);
        }
    }

    public void setArray(int[] a) {
        if (a == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(a.length);
            this.elements = new Object[this.length];
            for (int i = 0; i < this.length; ++i) {
                this.elements[i] = a[i];
            }
        }
    }

    public void setArray(int[] a, long index) throws SQLException {
        if (a == null) {
            return;
        }
        int sliceLen = this.sliceLength(index, a.length);
        int idx = (int)index;
        for (int i = 0; i < sliceLen; ++i) {
            this.setObjectElement(a[i], idx++);
        }
    }

    public void setArray(float[] a) {
        if (a == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(a.length);
            this.elements = new Object[this.length];
            for (int i = 0; i < this.length; ++i) {
                this.elements[i] = Float.valueOf(a[i]);
            }
        }
    }

    public void setArray(float[] a, long index) throws SQLException {
        if (a == null) {
            return;
        }
        int sliceLen = this.sliceLength(index, a.length);
        int idx = (int)index;
        for (int i = 0; i < sliceLen; ++i) {
            this.setObjectElement(Float.valueOf(a[i]), idx++);
        }
    }

    public void setArray(short[] a) {
        if (a == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(a.length);
            this.elements = new Object[this.length];
            for (int i = 0; i < this.length; ++i) {
                this.elements[i] = (int)a[i];
            }
        }
    }

    public void setArray(short[] a, long index) throws SQLException {
        if (a == null) {
            return;
        }
        int sliceLen = this.sliceLength(index, a.length);
        int idx = (int)index;
        for (int i = 0; i < sliceLen; ++i) {
            this.setObjectElement(a[i], idx++);
        }
    }

    public Object getObjectElement(long n) throws SQLException {
        Object element = this.getLazyArray()[(int)n];
        if (element == null && this.oracleDataFactory != null) {
            Object d = this.getLazyOracleArray()[(int)n];
            this.elements[(int)n] = element = OracleDataUtil.convertToObject(d, this.sqlType, this.oracleDataFactory);
            if (OracleDataUtil.isMutable(d, this.oracleDataFactory)) {
                this.resetOracleElement(n);
            }
        }
        return element;
    }

    public Object getOracleElement(long n) throws SQLException {
        if (this.oracleDataFactory == null) {
            Object d = this.getJDBCObjectElement(n, null);
            if (OracleDataUtil.isMutable(d, this.oracleDataFactory)) {
                this.pickledCorrect = false;
            }
            return d;
        }
        return this.getObjectElement(n);
    }

    public void setObjectElement(Object element, long n) throws SQLException {
        if (element == null) {
            this.getLazyOracleArray();
        }
        this.resetOracleElement(n);
        this.getLazyArray()[(int)n] = element;
    }

    public void setOracleElement(Object o, long n) throws SQLException {
        if (this.oracleDataFactory == null) {
            this.setJDBCObjectElement(o, n);
        } else {
            this.setObjectElement(o, n);
        }
    }

    public String getBaseTypeName() throws SQLException {
        return this.pickled.getBaseTypeName();
    }

    public int getBaseType() throws SQLException {
        return this.pickled.getBaseType();
    }

    Object[] getJDBCObjectArray(Connection c) throws SQLException {
        if (this.length < 0) {
            this.getLazyOracleArray();
        }
        if (this.jdbcObjects == null) {
            return null;
        }
        Object[] result = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            result[i] = this.getJDBCObjectElement(i, c);
        }
        return result;
    }

    void setJDBCObjectArray(Object[] d) {
        if (d == null) {
            this.setNullArray();
        } else {
            this.length = d.length;
            this.elements = null;
            this.jdbcObjects = (Object[])d.clone();
            this.pickled = null;
            this.pickledCorrect = false;
        }
    }

    void setJDBCObjectArray(Object[] d, long index) throws SQLException {
        if (d == null) {
            return;
        }
        int sliceLen = this.sliceLength(index, d.length);
        int idx = (int)index;
        for (int i = 0; i < sliceLen; ++i) {
            this.setJDBCObjectElement(d[i], idx++);
        }
    }

    Object getJDBCObjectElement(long n, Connection c) throws SQLException {
        Object jdbcObject = this.getLazyOracleArray()[(int)n];
        if (jdbcObject == null) {
            Object a = this.getLazyArray()[(int)n];
            this.jdbcObjects[(int)n] = jdbcObject = OracleDataUtil.convertToOracle(a, c, this.isNChar);
        }
        return jdbcObject;
    }

    void setJDBCObjectElement(Object jdbcObject, long n) throws SQLException {
        this.resetElement(n);
        this.getLazyOracleArray()[(int)n] = jdbcObject;
        this.pickledCorrect = false;
    }

    void resetElement(long n) throws SQLException {
        if (this.elements != null) {
            this.elements[(int)n] = null;
        }
    }

    void setNullArray() {
        this.length = -1;
        this.elements = null;
        this.jdbcObjects = null;
        this.pickled = null;
        this.pickledCorrect = false;
    }

    void setArrayGeneric(int length) {
        this.length = length;
        this.jdbcObjects = new Object[length];
        this.pickled = null;
        this.pickledCorrect = false;
    }

    public int length() throws SQLException {
        if (this.length < 0) {
            this.getLazyOracleArray();
        }
        return this.length;
    }

    public int sliceLength(long index, int reqLength) throws SQLException {
        if (this.length < 0) {
            this.getLazyOracleArray();
        }
        if (index < 0L) {
            return (int)index;
        }
        return Math.min(this.length - (int)index, reqLength);
    }

    void resetOracleElement(long n) throws SQLException {
        if (this.jdbcObjects != null) {
            this.jdbcObjects[(int)n] = null;
        }
        this.pickledCorrect = false;
    }

    Object[] getLazyArray() throws SQLException {
        if (this.length == -1) {
            this.getLazyOracleArray();
        }
        if (this.elements == null) {
            this.elements = new Object[this.length];
        }
        return this.elements;
    }

    Object[] getLazyOracleArray() throws SQLException {
        if (this.jdbcObjects == null) {
            if (this.pickled != null) {
                this.jdbcObjects = (Object[])this.pickled.getArray();
                this.length = this.jdbcObjects.length;
                this.pickledCorrect = true;
                if (this.elements != null) {
                    for (int x = 0; x < this.length; ++x) {
                        if (this.elements[x] == null) continue;
                        this.jdbcObjects[x] = null;
                        this.pickledCorrect = false;
                    }
                }
            } else if (this.length >= 0) {
                this.jdbcObjects = new Object[this.length];
            }
        }
        return this.jdbcObjects;
    }

    public void setNChar() {
        this.isNChar = true;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

